/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.vanilla;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.network.SoundAttractNetwork;
import com.example.soundattract.network.SoundMessage;
import com.example.soundattract.runtime.DynamicScanCooldownManager;
import com.example.soundattract.tracking.SoundTracker;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VanillaIntegrationEvents {
    private static boolean wasOnGround = true;
    private static int tickCounter = 0;
    private static boolean didLogInit = false;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean isCrawling;
        boolean isJumping;
        int cooldown;
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        if (!didLogInit && ((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            didLogInit = true;
            SoundAttractMod.LOGGER.info("[VanillaIntegration] PlayerTick handler active on server");
        }
        if (++tickCounter % (cooldown = Math.max(1, DynamicScanCooldownManager.currentScanCooldownTicks)) != 0) {
            return;
        }
        Player player = event.player;
        ResourceLocation dim = player.m_9236_().m_46472_().m_135782_();
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        Optional<UUID> uuid = Optional.of(player.m_20148_());
        if (player.m_20142_() && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaSprint", "minecraft:entity.player.sprint", x, y, z, dim, uuid, 10, 1.2, 1.0, 1.0);
        }
        if (!player.m_20142_() && !player.m_6047_() && player.m_20184_().m_165925_() > 0.01 && player.m_20096_() && !player.m_20089_().name().equalsIgnoreCase("SWIMMING") && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaWalk", "minecraft:entity.player.walk", x, y, z, dim, uuid, 6, 0.6, 0.8, 1.0);
        }
        boolean bl = isJumping = player.f_19789_ == 0.0f && player.m_20184_().f_82480_ > 0.1 && !wasOnGround;
        if (isJumping && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaJump", "minecraft:entity.player.jump", x, y, z, dim, uuid, 7, 0.7, 0.8, 1.0);
        }
        wasOnGround = player.m_20096_();
        if (player.m_6047_() && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaSneak", "minecraft:entity.player.sneak", x, y, z, dim, uuid, 3, 0.2, 0.4, 1.0);
        }
        boolean bl2 = isCrawling = player.m_20089_() == Pose.SWIMMING && !player.m_20069_();
        if (isCrawling && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaCrawl", "minecraft:block.wool.step", x, y, z, dim, uuid, 2, 0.1, 0.2, 1.0);
        }
    }

    private static void sendVanillaSound(String animatorClass, String soundId, double x, double y, double z, ResourceLocation dim, Optional<UUID> uuid, int range, double weight, double volume, double pitch) {
        SoundMessage msg = new SoundMessage(ResourceLocation.parse((String)soundId), x, y, z, dim, uuid, range, weight, animatorClass);
        boolean isServer = true;
        try {
            Class.forName("net.minecraft.server.level.ServerPlayer");
        }
        catch (Throwable t) {
            isServer = false;
        }
        if (isServer) {
            ResourceLocation baseId = ResourceLocation.fromNamespaceAndPath((String)"soundattract", (String)"virtual");
            if (!(SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() || baseId != null && SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(baseId))) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[VanillaIntegration] Skipping virtual sound because {} is not in whitelist (whitelistSize={})", (Object)baseId, (Object)SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.size());
                }
                return;
            }
            BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            String dimString = dim.toString();
            int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
            String meta = (uuid != null && uuid.isPresent() ? uuid.get().toString() : "unknown") + "/" + (animatorClass != null && !animatorClass.isEmpty() ? animatorClass : "unknown");
            String soundIdToUse = SoundTracker.buildIntegrationSoundId(baseId, meta);
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[VanillaIntegration] addSound: soundId={} | range={} | weight={} | pos=({}, {}, {}) | dim={}", new Object[]{soundIdToUse, range, weight, x, y, z, dim});
            }
            SoundTracker.addSound(null, pos, dimString, range, weight, lifetime, soundIdToUse);
            return;
        }
        SoundAttractNetwork.INSTANCE.sendToServer((Object)msg);
    }
}

