/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.smartbrainlib;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.sbl.MoveToSoundBehaviour;
import com.example.soundattract.integration.sbl.SoundAttractSensor;
import com.example.soundattract.runtime.DynamicScanCooldownManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraftforge.fml.ModList;
import net.tslat.smartbrainlib.util.BrainUtils;

public final class SmartBrainLibCompat {
    private static final boolean IS_SBL_LOADED = ModList.get().isLoaded("smartbrainlib");

    private SmartBrainLibCompat() {
    }

    public static boolean tryAttachSoundAttractBrain(Mob mob) {
        if (!IS_SBL_LOADED || mob == null) {
            return false;
        }
        try {
            return Proxy.tryAttach(mob);
        }
        catch (Throwable t) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[SmartBrainLibCompat] Failed to attach brain integration for {}", (Object)mob.m_20148_());
            }
            return false;
        }
    }

    private static final class Proxy {
        private static final String OLD_BEHAVIOUR_CLASS = "com.example.soundattract.integration.sbl.SoundAttractSblBehaviour";
        private static final String BEHAVIOUR_CLASS = "com.example.soundattract.integration.sbl.MoveToSoundBehaviour";

        private Proxy() {
        }

        private static boolean tryAttach(Mob mob) {
            if (!(mob instanceof PathfinderMob)) {
                return false;
            }
            PathfinderMob pathfinder = (PathfinderMob)mob;
            Brain brain = pathfinder.m_6274_();
            if (!Proxy.isSmartBrain(brain)) {
                return false;
            }
            boolean hasBehaviour = BrainUtils.getAllBehaviours((Brain)pathfinder.m_6274_()).anyMatch(b -> b != null && b.getClass().getName().equals(BEHAVIOUR_CLASS));
            if (hasBehaviour) {
                return true;
            }
            BrainUtils.removeBehaviour((LivingEntity)pathfinder, (priority, activity, behaviour, parent) -> behaviour != null && behaviour.getClass().getName().equals(OLD_BEHAVIOUR_CLASS));
            BrainUtils.addMemories((Brain)pathfinder.m_6274_(), (MemoryModuleType[])new MemoryModuleType[]{MemoryModuleType.f_26370_, MemoryModuleType.f_26371_, SoundAttractSensor.SOUND_ATTRACT_TARGET});
            Proxy.addSensor(brain, new SoundAttractSensor());
            MoveToSoundBehaviour behaviour2 = new MoveToSoundBehaviour();
            behaviour2.cooldownFor(e -> Math.max(1, DynamicScanCooldownManager.currentScanCooldownTicks));
            Proxy.addBehaviour(brain, 1, Activity.f_37979_, behaviour2);
            return true;
        }

        private static boolean isSmartBrain(Object brain) {
            if (brain == null) {
                return false;
            }
            try {
                Class<?> smartBrain = Class.forName("net.tslat.smartbrainlib.api.core.SmartBrain");
                return smartBrain.isInstance(brain);
            }
            catch (Throwable ignored) {
                return false;
            }
        }

        private static void addSensor(Object brain, Object sensor) {
            block2: {
                try {
                    Class<?> smartBrain = Class.forName("net.tslat.smartbrainlib.api.core.SmartBrain");
                    Class<?> sensorClass = Class.forName("net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor");
                    smartBrain.getMethod("addSensor", sensorClass).invoke(brain, sensor);
                }
                catch (Throwable t) {
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block2;
                    SoundAttractMod.LOGGER.warn("[SmartBrainLibCompat] Failed to add sensor: {}", (Object)t.getMessage());
                }
            }
        }

        private static void addBehaviour(Object brain, int priority, Object activity, Object behaviour) {
            block2: {
                try {
                    Class<?> smartBrain = Class.forName("net.tslat.smartbrainlib.api.core.SmartBrain");
                    Class<?> activityClass = Class.forName("net.minecraft.world.entity.schedule.Activity");
                    Class<?> behaviourClass = Class.forName("net.minecraft.world.entity.ai.behavior.BehaviorControl");
                    smartBrain.getMethod("addBehaviour", Integer.TYPE, activityClass, behaviourClass).invoke(brain, priority, activity, behaviour);
                }
                catch (Throwable t) {
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block2;
                    SoundAttractMod.LOGGER.warn("[SmartBrainLibCompat] Failed to add behaviour: {}", (Object)t.getMessage());
                }
            }
        }
    }
}

