/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.sbl;

import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.StealthDetectionEvents;
import com.example.soundattract.runtime.DynamicScanCooldownManager;
import com.example.soundattract.tracking.SoundTracker;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SoundAttractSensor<E extends PathfinderMob>
extends ExtendedSensor<E> {
    public static final MemoryModuleType<BlockPos> SOUND_ATTRACT_TARGET = new MemoryModuleType(Optional.of(BlockPos.f_121852_));
    private static final SensorType<SoundAttractSensor<?>> TYPE = new SensorType(SoundAttractSensor::new);
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{SOUND_ATTRACT_TARGET, MemoryModuleType.f_26370_});

    public SoundAttractSensor() {
        this.setScanRate(e -> 1);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public Set<MemoryModuleType<?>> m_7163_() {
        return new ObjectOpenHashSet(this.memoriesUsed());
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return TYPE;
    }

    protected void doTick(ServerLevel level, E entity) {
        if (!DynamicScanCooldownManager.shouldScanThisTick(entity.m_19879_(), level.m_46467_())) {
            return;
        }
        if (entity.m_5448_() != null) {
            BrainUtils.clearMemory(entity, SOUND_ATTRACT_TARGET);
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue() && StealthDetectionEvents.shouldSuppressTargeting(entity)) {
            BrainUtils.clearMemory(entity, SOUND_ATTRACT_TARGET);
            return;
        }
        SoundTracker.SoundRecord best = SoundTracker.findNearestSound(entity, (Level)level, entity.m_20183_(), entity.m_146892_(), null);
        if (best == null || best.pos == null) {
            BrainUtils.clearMemory(entity, SOUND_ATTRACT_TARGET);
            return;
        }
        int maxLifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
        int lifetime = best.ticksRemaining > 0 ? Math.min(best.ticksRemaining, maxLifetime) : maxLifetime;
        lifetime = Math.max(1, lifetime);
        BrainUtils.setForgettableMemory(entity, SOUND_ATTRACT_TARGET, (Object)best.pos.m_7949_(), (int)lifetime);
    }
}

