/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.sbl;

import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.StealthDetectionEvents;
import com.example.soundattract.integration.sbl.SoundAttractSensor;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class MoveToSoundBehaviour<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(SoundAttractSensor.SOUND_ATTRACT_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED)});
    private BlockPos target;

    public MoveToSoundBehaviour() {
        this.runFor(e -> 1);
        this.startCondition(e -> e != null && !e.m_20160_() && !e.m_5803_() && ((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get() == false || !StealthDetectionEvents.shouldSuppressTargeting((Mob)e)));
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (entity.m_5448_() != null) {
            BrainUtils.clearMemory(entity, SoundAttractSensor.SOUND_ATTRACT_TARGET);
            return false;
        }
        BlockPos pos = (BlockPos)BrainUtils.getMemory(entity, SoundAttractSensor.SOUND_ATTRACT_TARGET);
        if (pos == null) {
            return false;
        }
        double arrival = (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
        if (entity.m_20238_(Vec3.m_82512_((Vec3i)pos)) <= arrival * arrival) {
            BrainUtils.clearMemory(entity, SoundAttractSensor.SOUND_ATTRACT_TARGET);
            return false;
        }
        this.target = pos;
        return true;
    }

    protected void start(E entity) {
        BlockPos pos = this.target;
        this.target = null;
        if (pos == null) {
            return;
        }
        float speed = (float)((Double)SoundAttractConfig.COMMON.mobMoveSpeed.get()).doubleValue();
        int closeEnough = Math.max(1, (int)Math.round((Double)SoundAttractConfig.COMMON.arrivalDistance.get()));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pos));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget(Vec3.m_82512_((Vec3i)pos), speed, closeEnough));
    }
}

