/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.event;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.PlayerProfile;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.enchantment.ModEnchantments;
import com.example.soundattract.event.FovEvents;
import com.example.soundattract.integration.enhancedai.EnhancedAICompat;
import com.example.soundattract.quantified.QuantifiedCacheCompat;
import com.example.soundattract.util.CamoUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="soundattract", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StealthDetectionEvents {
    private static final Map<UUID, Integer> mobOutOfRangeTicks = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<UUID, Vec3> lastPlayerPositions = new ConcurrentHashMap<UUID, Vec3>();
    private static final Map<UUID, Vec3> lastMobPositions = new ConcurrentHashMap<UUID, Vec3>();
    private static long lastStealthCheckTick = -1L;
    private static final Map<UUID, GunshotInfo> playerGunshotInfo = new ConcurrentHashMap<UUID, GunshotInfo>();
    private static final Map<UUID, Double> XRAY_RANGE_CACHE = new ConcurrentHashMap<UUID, Double>();
    private static final Set<UUID> suppressedEdgeDetections = ConcurrentHashMap.newKeySet();
    private static volatile double lastEstimatedTps = 20.0;
    private static volatile long lastEstimatedTpsGameTime = -1L;

    private static void updateEstimatedTps(MinecraftServer server) {
        if (server == null) {
            return;
        }
        try {
            float avgMs = server.m_129903_();
            if (Float.isNaN(avgMs) || avgMs <= 0.0f) {
                return;
            }
            double tps = 1000.0 / Math.max(1.0, (double)avgMs);
            if (tps > 20.0) {
                tps = 20.0;
            }
            if (tps < 0.0) {
                tps = 0.0;
            }
            lastEstimatedTps = tps;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static StealthPerfTier getPerfTier(MinecraftServer server) {
        if (SoundAttractConfig.COMMON == null) {
            return StealthPerfTier.FULL;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableTieredStealthPerformance.get()).booleanValue()) {
            return StealthPerfTier.FULL;
        }
        double tps = lastEstimatedTps;
        double vanillaTps = (Double)SoundAttractConfig.COMMON.stealthTierVanillaTps.get();
        double shareTps = (Double)SoundAttractConfig.COMMON.stealthTierSharedRangeTps.get();
        double currentOnlyTps = (Double)SoundAttractConfig.COMMON.stealthTierCurrentTargetsOnlyTps.get();
        double skipExpensiveTps = (Double)SoundAttractConfig.COMMON.stealthTierSkipExpensiveChecksTps.get();
        if (vanillaTps > 0.0 && tps <= vanillaTps) {
            return StealthPerfTier.VANILLA;
        }
        if (shareTps > 0.0 && tps <= shareTps) {
            return StealthPerfTier.SHARE_NEARBY;
        }
        if (currentOnlyTps > 0.0 && tps <= currentOnlyTps) {
            return StealthPerfTier.CURRENT_TARGETS_ONLY;
        }
        if (skipExpensiveTps > 0.0 && tps <= skipExpensiveTps) {
            return StealthPerfTier.SKIP_EXPENSIVE;
        }
        return StealthPerfTier.FULL;
    }

    private static StealthPerfTier getPerfTier(Level level) {
        MinecraftServer server = null;
        try {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                server = sl.m_7654_();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return StealthDetectionEvents.getPerfTier(server);
    }

    private static boolean shouldSkipExpensiveChecks(Level level) {
        StealthPerfTier tier = StealthDetectionEvents.getPerfTier(level);
        return tier != StealthPerfTier.FULL;
    }

    private static boolean shouldUseVanillaTargeting(Level level) {
        return StealthDetectionEvents.getPerfTier(level) == StealthPerfTier.VANILLA;
    }

    private static boolean shouldInterceptNewTargeting(Level level) {
        StealthPerfTier tier = StealthDetectionEvents.getPerfTier(level);
        return tier == StealthPerfTier.FULL || tier == StealthPerfTier.SKIP_EXPENSIVE;
    }

    private static LivingEntity getAttackTargetCompat(Mob mob) {
        if (mob == null) {
            return null;
        }
        LivingEntity direct = mob.m_5448_();
        if (direct != null) {
            return direct;
        }
        try {
            return mob.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean isTargetingPlayerCompat(Mob mob) {
        return StealthDetectionEvents.getAttackTargetCompat(mob) instanceof Player;
    }

    public static void recordSuppressedEdgeDetection(Mob mob) {
        if (mob != null) {
            suppressedEdgeDetections.add(mob.m_20148_());
        }
    }

    public static boolean consumeSuppressedEdgeDetection(Mob mob) {
        if (mob == null) {
            return false;
        }
        UUID id = mob.m_20148_();
        return suppressedEdgeDetections.remove(id);
    }

    private static int getStealthCheckInterval() {
        return (Integer)SoundAttractConfig.COMMON.stealthCheckInterval.get();
    }

    private static boolean hasConcealmentEnchant(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41793_() || ModEnchantments.CONCEAL == null) {
            return false;
        }
        Enchantment concealEnchant = (Enchantment)ModEnchantments.CONCEAL.get();
        if (concealEnchant == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && !stack.m_41619_() && stack.m_41793_()) {
                SoundAttractMod.LOGGER.warn("[HasConceal] Conceal enchantment not resolved from ModEnchantments for item: {}", (Object)stack.m_41611_().getString());
            }
            return false;
        }
        return EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(concealEnchant, 0) > 0;
    }

    public static double getRealisticStealthDetectionRange(Mob target, Mob looker, Level level) {
        ArrayList camouflageItems;
        double moveThreshold;
        int i;
        int held;
        boolean isDay;
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get();
        }
        if (StealthDetectionEvents.shouldUseVanillaTargeting(level)) {
            return (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get();
        }
        boolean skipExpensive = StealthDetectionEvents.shouldSkipExpensiveChecks(level);
        double baseRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
        if (target.m_21023_(MobEffects.f_19609_)) {
            double invisFactor = (Double)SoundAttractConfig.COMMON.invisibilityStealthFactor.get();
            baseRange *= invisFactor;
        }
        int effectiveLight = 0;
        BlockPos feet = target.m_20183_();
        BlockPos eyes = feet.m_7494_();
        long dayTime = level.m_46468_() % 24000L;
        boolean bl = isDay = dayTime >= 0L && dayTime < 12000L;
        if (level.m_46749_(feet)) {
            effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.BLOCK, feet));
            if (isDay && level.m_45527_(feet)) {
                effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.SKY, feet));
            }
        }
        if (level.m_46749_(eyes)) {
            effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.BLOCK, eyes));
            if (isDay && level.m_45527_(eyes)) {
                effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.SKY, eyes));
            }
        }
        double neutral = ((Integer)SoundAttractConfig.COMMON.neutralLightLevel.get()).intValue();
        double sensitivity = (Double)SoundAttractConfig.COMMON.lightLevelSensitivity.get();
        double lightEffect = ((double)effectiveLight - neutral) * (sensitivity / 15.0);
        double lightFactor = 1.0 + lightEffect;
        lightFactor = Math.max((Double)SoundAttractConfig.COMMON.minLightFactor.get(), lightFactor);
        lightFactor = Math.min((Double)SoundAttractConfig.COMMON.maxLightFactor.get(), lightFactor);
        baseRange *= lightFactor;
        if (!skipExpensive) {
            if (level.m_46758_(feet)) {
                baseRange *= ((Double)SoundAttractConfig.COMMON.rainStealthFactor.get()).doubleValue();
            }
            if (level.m_46470_()) {
                baseRange *= ((Double)SoundAttractConfig.COMMON.thunderStealthFactor.get()).doubleValue();
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableHeldItemPenalty.get()).booleanValue() && (held = (target.m_21205_().m_41619_() ? 0 : 1) + (target.m_21206_().m_41619_() ? 0 : 1)) > 0) {
            double penaltyPerItem = (Double)SoundAttractConfig.COMMON.heldItemPenaltyFactor.get();
            for (i = 0; i < held; ++i) {
                baseRange *= penaltyPerItem;
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableEnchantmentPenalty.get()).booleanValue()) {
            int enchantedArmor = 0;
            for (ItemStack armor : target.m_6168_()) {
                if (armor.m_41619_() || !armor.m_41793_() || StealthDetectionEvents.hasConcealmentEnchant(armor)) continue;
                ++enchantedArmor;
            }
            if (enchantedArmor > 0) {
                double armorPenaltyFactor = (Double)SoundAttractConfig.COMMON.armorEnchantmentPenaltyFactor.get();
                for (i = 0; i < enchantedArmor; ++i) {
                    baseRange *= armorPenaltyFactor;
                }
            }
            int enchantedHeld = 0;
            if (!target.m_21205_().m_41619_() && target.m_21205_().m_41793_() && !StealthDetectionEvents.hasConcealmentEnchant(target.m_21205_())) {
                ++enchantedHeld;
            }
            if (!target.m_21206_().m_41619_() && target.m_21206_().m_41793_() && !StealthDetectionEvents.hasConcealmentEnchant(target.m_21206_())) {
                ++enchantedHeld;
            }
            if (enchantedHeld > 0) {
                double heldItemEnchantPenalty = (Double)SoundAttractConfig.COMMON.heldItemEnchantmentPenaltyFactor.get();
                for (int i2 = 0; i2 < enchantedHeld; ++i2) {
                    baseRange *= heldItemEnchantPenalty;
                }
            }
        }
        if (!skipExpensive && ((Boolean)SoundAttractConfig.COMMON.enableEnvironmentalCamouflage.get()).booleanValue()) {
            Optional<Integer> armorColorOpt = StealthDetectionEvents.getEffectiveArmorColorEntity((LivingEntity)target);
            Optional<Integer> envColorOpt = StealthDetectionEvents.getAverageEnvironmentalColorEntity((LivingEntity)target, level);
            if (armorColorOpt.isPresent() && envColorOpt.isPresent()) {
                int mismatchThreshold;
                int matchBonusThreshold;
                int armorColor = armorColorOpt.get();
                int envColor = envColorOpt.get();
                int rArmor = armorColor >> 16 & 0xFF;
                int gArmor = armorColor >> 8 & 0xFF;
                int bArmor = armorColor & 0xFF;
                int rEnv = envColor >> 16 & 0xFF;
                int gEnv = envColor >> 8 & 0xFF;
                int bEnv = envColor & 0xFF;
                int diff = Math.abs(rArmor - rEnv) + Math.abs(gArmor - gEnv) + Math.abs(bArmor - bEnv);
                if (diff <= (matchBonusThreshold = ((Integer)SoundAttractConfig.COMMON.environmentalCamouflageColorMatchThreshold.get()).intValue())) {
                    double maxBonusEffect = (Double)SoundAttractConfig.COMMON.environmentalCamouflageMaxEffectiveness.get();
                    double effectivenessRatio = matchBonusThreshold > 0 ? 1.0 - (double)diff / (double)matchBonusThreshold : (diff == 0 ? 1.0 : 0.0);
                    double actualBonus = maxBonusEffect * effectivenessRatio;
                    baseRange *= 1.0 - actualBonus;
                } else if (((Boolean)SoundAttractConfig.COMMON.enableEnvironmentalMismatchPenalty.get()).booleanValue() && diff > (mismatchThreshold = ((Integer)SoundAttractConfig.COMMON.environmentalMismatchThreshold.get()).intValue())) {
                    double penaltyFactor = (Double)SoundAttractConfig.COMMON.environmentalMismatchPenaltyFactor.get();
                    baseRange *= penaltyFactor;
                }
            }
        }
        baseRange = StealthDetectionEvents.isMobMoving(target, moveThreshold = ((Double)SoundAttractConfig.COMMON.movementThreshold.get()).doubleValue()) ? (baseRange *= ((Double)SoundAttractConfig.COMMON.movementStealthPenalty.get()).doubleValue()) : (baseRange *= ((Double)SoundAttractConfig.COMMON.stationaryStealthBonusFactor.get()).doubleValue());
        if (((Boolean)SoundAttractConfig.COMMON.enableCamouflage.get()).booleanValue() && !(camouflageItems = new ArrayList((Collection)SoundAttractConfig.COMMON.camouflageArmorItems.get())).isEmpty()) {
            boolean fullSet;
            double effectToApply = 0.0;
            int totalActualArmorPieces = 0;
            long wornListedCamouflagePieces = 0L;
            ArrayList armorItemsList = new ArrayList();
            target.m_6168_().forEach(armorItemsList::add);
            for (ItemStack stack : armorItemsList) {
                if (!stack.m_41619_()) {
                    ++totalActualArmorPieces;
                }
                if (!CamoUtil.isCamouflageArmorItem(stack.m_41720_())) continue;
                ++wornListedCamouflagePieces;
            }
            boolean bl2 = fullSet = totalActualArmorPieces == 4 && wornListedCamouflagePieces == (long)totalActualArmorPieces && totalActualArmorPieces > 0;
            if (((Boolean)SoundAttractConfig.COMMON.requireFullSetForCamouflageBonus.get()).booleanValue()) {
                if (fullSet) {
                    effectToApply = (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get();
                } else {
                    double totalEffectiveness = 0.0;
                    block17: for (int i3 = 0; i3 < armorItemsList.size(); ++i3) {
                        ItemStack stack = (ItemStack)armorItemsList.get(i3);
                        if (stack.m_41619_() || !CamoUtil.isCamouflageArmorItem(stack.m_41720_())) continue;
                        switch (i3) {
                            case 0: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                                continue block17;
                            }
                            case 1: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                                continue block17;
                            }
                            case 2: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                                continue block17;
                            }
                            case 3: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                            }
                        }
                    }
                    effectToApply = totalEffectiveness;
                }
            } else if (fullSet && (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get() > 0.0) {
                effectToApply = (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get();
            } else {
                double totalEffectiveness = 0.0;
                block18: for (int i4 = 0; i4 < armorItemsList.size(); ++i4) {
                    ItemStack stack = (ItemStack)armorItemsList.get(i4);
                    if (stack.m_41619_() || !CamoUtil.isCamouflageArmorItem(stack.m_41720_())) continue;
                    switch (i4) {
                        case 0: {
                            totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                            continue block18;
                        }
                        case 1: {
                            totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                            continue block18;
                        }
                        case 2: {
                            totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                            continue block18;
                        }
                        case 3: {
                            totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                        }
                    }
                }
                effectToApply = totalEffectiveness;
            }
            if (effectToApply > 0.0) {
                double itemCamoMultiplier = 1.0 - Math.min(effectToApply, 0.99);
                baseRange *= itemCamoMultiplier;
            }
        }
        double finalCalculatedRange = Math.max((Double)SoundAttractConfig.COMMON.minStealthDetectionRange.get(), Math.min(baseRange, (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get()));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR_MobTarget_End] Looker: {}, Target: {}, Final Range: {}", new Object[]{looker.m_7755_().getString(), target.m_7755_().getString(), String.format("%.2f", finalCalculatedRange)});
        }
        return finalCalculatedRange;
    }

    private static boolean isMobMoving(Mob mob, double threshold) {
        if (mob == null) {
            return false;
        }
        Vec3 current = mob.m_20182_();
        UUID id = mob.m_20148_();
        Vec3 last = lastMobPositions.get(id);
        boolean moved = false;
        if (last != null) {
            double distSq = current.m_82557_(last);
            moved = distSq > threshold * threshold;
        }
        lastMobPositions.put(id, current);
        return moved;
    }

    public static double getEffectiveXrayRange(Mob mob) {
        if (mob == null) {
            return 0.0;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableXrayTargeting.get()).booleanValue()) {
            return 0.0;
        }
        if (EnhancedAICompat.isEnhancedAiLoaded()) {
            double v = EnhancedAICompat.getXrayAttributeValue(mob);
            if (v > 0.0) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[XRAY] {} has EnhancedAI X-ray range: {}", (Object)mob.m_7755_().getString(), (Object)String.format("%.2f", v));
                }
                return v;
            }
            return 0.0;
        }
        try {
            String applyTagStr = (String)SoundAttractConfig.COMMON.xrayApplyTag.get();
            if (applyTagStr == null || applyTagStr.isBlank()) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.warn("[XRAY] xrayApplyTag is blank or null");
                }
                return 0.0;
            }
            TagKey applyTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.parse((String)applyTagStr));
            boolean inApplyTag = mob.m_6095_().m_204039_(applyTag);
            if (!inApplyTag) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[XRAY] {} not in apply_xray tag: {}", (Object)mob.m_7755_().getString(), (Object)applyTagStr);
                }
                return 0.0;
            }
            if (((Boolean)SoundAttractConfig.COMMON.xrayRequireBetterNearby.get()).booleanValue()) {
                String betterTagStr = (String)SoundAttractConfig.COMMON.xrayBetterNearbyTag.get();
                if (betterTagStr == null || betterTagStr.isBlank()) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.warn("[XRAY] xrayBetterNearbyTag is blank or null");
                    }
                    return 0.0;
                }
                TagKey betterTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.parse((String)betterTagStr));
                boolean inBetterTag = mob.m_6095_().m_204039_(betterTag);
                if (!inBetterTag) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[XRAY] {} not in better_nearby tag: {}", (Object)mob.m_7755_().getString(), (Object)betterTagStr);
                    }
                    return 0.0;
                }
            }
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[XRAY] {} passed tag checks, checking chance...", (Object)mob.m_7755_().getString());
            }
        }
        catch (Exception e) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[XRAY] Tag check failed for mob {}: {}", (Object)mob.m_7755_().getString(), (Object)e.getMessage());
            }
            return 0.0;
        }
        Double cached = XRAY_RANGE_CACHE.get(mob.m_20148_());
        if (cached != null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && cached > 0.0) {
                SoundAttractMod.LOGGER.info("[XRAY] {} has cached X-ray range: {}", (Object)mob.m_7755_().getString(), (Object)String.format("%.2f", cached));
            }
            return cached;
        }
        int max = (Integer)SoundAttractConfig.COMMON.xrayMaxRange.get();
        if (max <= 0) {
            XRAY_RANGE_CACHE.put(mob.m_20148_(), 0.0);
            return 0.0;
        }
        int min = (Integer)SoundAttractConfig.COMMON.xrayMinRange.get();
        min = Math.max(0, Math.min(min, max));
        double chance = (Double)SoundAttractConfig.COMMON.xrayChance.get();
        if (mob.m_217043_().m_188500_() >= chance) {
            XRAY_RANGE_CACHE.put(mob.m_20148_(), 0.0);
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[XRAY] {} failed X-ray chance check ({}%), cached as 0", (Object)mob.m_7755_().getString(), (Object)((int)(chance * 100.0)));
            }
            return 0.0;
        }
        int spread = max - min;
        int chosen = spread <= 0 ? max : min + mob.m_217043_().m_188503_(spread + 1);
        double result = chosen;
        XRAY_RANGE_CACHE.put(mob.m_20148_(), result);
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[XRAY] {} gained X-ray range: {} (chance passed)", (Object)mob.m_7755_().getString(), (Object)String.format("%.2f", result));
        }
        return result;
    }

    private static Optional<Integer> getEffectiveArmorColorEntity(LivingEntity entity) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        boolean onlyDyedLeather = (Boolean)SoundAttractConfig.COMMON.environmentalCamouflageOnlyDyedLeather.get();
        for (ItemStack itemStack : entity.m_6168_()) {
            Integer mapped;
            ResourceLocation itemIdRL;
            DyeableLeatherItem dyeableItem;
            ArmorItem armorItem;
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            boolean colorAdded = false;
            if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() == ArmorMaterials.LEATHER && item instanceof DyeableLeatherItem && (dyeableItem = (DyeableLeatherItem)item).m_41113_(itemStack)) {
                colors.add(dyeableItem.m_41121_(itemStack));
                colorAdded = true;
            }
            if (onlyDyedLeather && !colorAdded || colorAdded || (itemIdRL = ForgeRegistries.ITEMS.getKey((Object)item)) == null || (mapped = SoundAttractConfig.customArmorColors.get(itemIdRL)) == null) continue;
            colors.add(mapped);
        }
        if (colors.isEmpty()) {
            return Optional.empty();
        }
        long totalR = 0L;
        long totalG = 0L;
        long totalB = 0L;
        Iterator iterator = colors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            totalR += (long)(color >> 16 & 0xFF);
            totalG += (long)(color >> 8 & 0xFF);
            totalB += (long)(color & 0xFF);
        }
        int n = colors.size();
        int avgR = (int)(totalR / (long)n);
        int avgG = (int)(totalG / (long)n);
        int avgB = (int)(totalB / (long)n);
        int finalAvg = avgR << 16 | avgG << 8 | avgB;
        return Optional.of(finalAvg);
    }

    private static Optional<Integer> getAverageEnvironmentalColorEntity(LivingEntity entity, Level level) {
        if (entity == null || level == null) {
            return Optional.empty();
        }
        if (QuantifiedCacheCompat.isUsable()) {
            BlockPos base = entity.m_20183_();
            String key = new StringBuilder(96).append(level.m_46472_().m_135782_().toString()).append('|').append(base.m_123341_()).append(',').append(base.m_123342_()).append(',').append(base.m_123343_()).toString();
            return QuantifiedCacheCompat.getCached("soundattract_env_color_entity", key, () -> StealthDetectionEvents.soundattract$computeAverageEnvironmentalColorEntity(entity, level), 2L, 8192L);
        }
        return StealthDetectionEvents.soundattract$computeAverageEnvironmentalColorEntity(entity, level);
    }

    private static Optional<Integer> soundattract$computeAverageEnvironmentalColorEntity(LivingEntity entity, Level level) {
        ArrayList<Integer> blockColors = new ArrayList<Integer>();
        BlockPos base = entity.m_20183_();
        for (int y = 0; y >= -1; --y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int mapColor;
                    BlockState state;
                    BlockPos pos = base.m_7918_(x, y, z);
                    if (!level.m_46749_(pos) || (state = level.m_8055_(pos)).m_60795_()) continue;
                    try {
                        mapColor = state.m_284242_((BlockGetter)level, (BlockPos)pos).f_283871_;
                    }
                    catch (Throwable ignored) {
                        continue;
                    }
                    if (mapColor == 0) continue;
                    blockColors.add(mapColor);
                }
            }
        }
        if (blockColors.isEmpty()) {
            return Optional.empty();
        }
        long totalR = 0L;
        long totalG = 0L;
        long totalB = 0L;
        Iterator ignored = blockColors.iterator();
        while (ignored.hasNext()) {
            int color = (Integer)ignored.next();
            totalR += (long)(color >> 16 & 0xFF);
            totalG += (long)(color >> 8 & 0xFF);
            totalB += (long)(color & 0xFF);
        }
        int n = blockColors.size();
        int avgR = (int)(totalR / (long)n);
        int avgG = (int)(totalG / (long)n);
        int avgB = (int)(totalB / (long)n);
        int finalAvg = avgR << 16 | avgG << 8 | avgB;
        return Optional.of(finalAvg);
    }

    public static void recordPlayerGunshot(Player player, double detectionRange) {
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        long currentTime = player.m_9236_().m_46467_();
        playerGunshotInfo.put(player.m_20148_(), new GunshotInfo(currentTime, detectionRange));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[Gunshot] Recorded gunshot for {} with range {}. Effective until tick {}.", new Object[]{player.m_7755_().getString(), String.format("%.2f", detectionRange), currentTime + (long)((Integer)SoundAttractConfig.COMMON.gunshotDetectionDurationTicks.get()).intValue()});
        }
    }

    private static Optional<Double> getActiveGunshotRange(Player player) {
        long duration;
        GunshotInfo info = playerGunshotInfo.get(player.m_20148_());
        if (info == null) {
            return Optional.empty();
        }
        long currentTime = player.m_9236_().m_46467_();
        if (currentTime - info.timestamp < (duration = (long)((Integer)SoundAttractConfig.COMMON.gunshotDetectionDurationTicks.get()).intValue())) {
            return Optional.of(info.detectionRange);
        }
        playerGunshotInfo.remove(player.m_20148_());
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent
    public static void onMobAttemptTarget(LivingChangeTargetEvent event) {
        Mob targetMob;
        Mob mob;
        block19: {
            block17: {
                block18: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Mob)) return;
                    mob = (Mob)livingEntity;
                    if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
                        return;
                    }
                    if (!StealthDetectionEvents.shouldInterceptNewTargeting(mob.m_9236_())) {
                        return;
                    }
                    LivingEntity newTarget = event.getNewTarget();
                    if (newTarget instanceof Player) {
                        Player playerTarget = (Player)newTarget;
                        if (playerTarget.m_7500_() || playerTarget.m_5833_() || !playerTarget.m_6084_()) {
                            if ((Boolean)SoundAttractConfig.COMMON.debugLogging.get() == false) return;
                            SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Player {} is creative/spectator/dead. Allowing target by {}.", (Object)playerTarget.m_7755_().getString(), (Object)mob.m_7755_().getString());
                            return;
                        }
                        if (StealthDetectionEvents.canMobDetectPlayer(mob, playerTarget)) {
                            if ((Boolean)SoundAttractConfig.COMMON.debugLogging.get() == false) return;
                            SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} targeting of Player {} ALLOWED (passes stealth check).", (Object)mob.m_7755_().getString(), (Object)playerTarget.m_7755_().getString());
                            return;
                        }
                        event.setCanceled(true);
                        try {
                            LivingEntity mem = mob.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
                            if (mem == playerTarget) {
                                mob.m_6274_().m_21936_(MemoryModuleType.f_26372_);
                            }
                        }
                        catch (Throwable mem) {
                            // empty catch block
                        }
                        if ((Boolean)SoundAttractConfig.COMMON.debugLogging.get() == false) return;
                        SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} targeting of Player {} CANCELED due to stealth rules.", (Object)mob.m_7755_().getString(), (Object)playerTarget.m_7755_().getString());
                        return;
                    }
                    if (!(newTarget instanceof Mob)) return;
                    targetMob = (Mob)newTarget;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} attempting to target Mob {}", (Object)mob.m_7755_().getString(), (Object)targetMob.m_7755_().getString());
                    }
                    if (FovEvents.isTargetInFov(mob, (Entity)targetMob, true)) break block17;
                    double xrayRange = StealthDetectionEvents.getEffectiveXrayRange(mob);
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] FOV check failed for {} targeting {}. X-ray range: {}", new Object[]{mob.m_7755_().getString(), targetMob.m_7755_().getString(), String.format("%.2f", xrayRange)});
                    }
                    if (!(xrayRange > 0.0)) break block18;
                    double distSqXray = mob.m_20280_((Entity)targetMob);
                    if (distSqXray <= xrayRange * xrayRange) {
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[XRAY] Mob {} detects Mob {} within XRAY range {} (distSq {}).", new Object[]{mob.m_7755_().getString(), targetMob.m_7755_().getString(), String.format("%.2f", xrayRange), String.format("%.2f", distSqXray)});
                        }
                        break block19;
                    } else {
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} cannot see Mob {} (FOV). X-ray range too small: {} vs dist {}.", new Object[]{mob.m_7755_().getString(), targetMob.m_7755_().getString(), String.format("%.2f", xrayRange), String.format("%.2f", Math.sqrt(distSqXray))});
                        }
                        event.setCanceled(true);
                        return;
                    }
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} cannot see Mob {} (FOV). No X-ray capability.", (Object)mob.m_7755_().getString(), (Object)targetMob.m_7755_().getString());
                }
                event.setCanceled(true);
                return;
            }
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} can see Mob {} (FOV passed).", (Object)mob.m_7755_().getString(), (Object)targetMob.m_7755_().getString());
            }
        }
        double range = StealthDetectionEvents.getRealisticStealthDetectionRange(targetMob, mob, mob.m_9236_());
        double distSq = mob.m_20280_((Entity)targetMob);
        if (distSq > range * range) {
            event.setCanceled(true);
            if ((Boolean)SoundAttractConfig.COMMON.debugLogging.get() == false) return;
            SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} targeting of Mob {} CANCELED by stealth (distSq: {}, rangeSq: {}).", new Object[]{mob.m_7755_().getString(), targetMob.m_7755_().getString(), String.format("%.2f", distSq), String.format("%.2f", range * range)});
            return;
        }
        if ((Boolean)SoundAttractConfig.COMMON.debugLogging.get() == false) return;
        SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} targeting of Mob {} ALLOWED (passes stealth check).", (Object)mob.m_7755_().getString(), (Object)targetMob.m_7755_().getString());
    }

    public static boolean canMobDetectPlayer(Mob mob, Player player) {
        block18: {
            double distSqXray;
            if (mob == null || player == null) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.warn("[CanDetectPlayer] Called with null mob or player. Defaulting to detectable.");
                }
                return true;
            }
            if (StealthDetectionEvents.shouldUseVanillaTargeting(mob.m_9236_())) {
                return true;
            }
            if (player.m_7500_() || player.m_5833_() || !player.m_6084_()) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[CanDetectPlayer] Player {} is creative/spectator/dead. Bypassing stealth. Mob {}.", (Object)player.m_7755_().getString(), (Object)mob.m_7755_().getString());
                }
                return true;
            }
            if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
                return true;
            }
            Level level = mob.m_9236_();
            double xrayRange = StealthDetectionEvents.getEffectiveXrayRange(mob);
            if (xrayRange > 0.0 && (distSqXray = mob.m_20280_((Entity)player)) <= xrayRange * xrayRange) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[XRAY] Mob {} detects Player {} within XRAY range {} (distSq {}).", new Object[]{mob.m_7755_().getString(), player.m_7755_().getString(), String.format("%.2f", xrayRange), String.format("%.2f", distSqXray)});
                }
                return true;
            }
            double detectionRange = StealthDetectionEvents.getRealisticStealthDetectionRange(player, mob, level);
            double distSq = mob.m_20280_((Entity)player);
            if (distSq > detectionRange * detectionRange) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[StealthQuery] Player {} is OUT OF RANGE for mob {} (distSq: {}, rangeSq: {}).", new Object[]{player.m_7755_().getString(), mob.m_7755_().getString(), String.format("%.2f", distSq), String.format("%.2f", detectionRange * detectionRange)});
                }
                return false;
            }
            if (!FovEvents.isTargetInFov(mob, (Entity)player, true)) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[StealthQuery] Player {} is IN RANGE for mob {} but OUTSIDE FOV. Denying detection.", (Object)player.m_7755_().getString(), (Object)mob.m_7755_().getString());
                }
                return false;
            }
            if (((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue()) {
                try {
                    boolean isEdge = MobGroupManager.isEdgeMob(mob);
                    boolean isDeserter = MobGroupManager.isDeserter(mob);
                    if (isEdge && !isDeserter) {
                        StealthDetectionEvents.recordSuppressedEdgeDetection(mob);
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[CanDetectPlayer] Suppressing EDGE mob {} (non-deserter) despite detectability; signaling RAID.", (Object)mob.m_7755_().getString());
                        }
                        return false;
                    }
                }
                catch (Throwable t) {
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block18;
                    SoundAttractMod.LOGGER.warn("[CanDetectPlayer] Edge suppression check failed: {}", (Object)t.getMessage());
                }
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[StealthQuery] Player {} IS DETECTABLE by mob {} (in range and in FOV).", (Object)player.m_7755_().getString(), (Object)mob.m_7755_().getString());
        }
        return true;
    }

    private static boolean canMobDetectPlayerNoEdgeSuppression(Mob mob, Player player) {
        double distSqXray;
        if (mob == null || player == null) {
            return true;
        }
        if (player.m_7500_() || player.m_5833_() || !player.m_6084_()) {
            return true;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return true;
        }
        if (StealthDetectionEvents.shouldUseVanillaTargeting(mob.m_9236_())) {
            return true;
        }
        Level level = mob.m_9236_();
        double xrayRange = StealthDetectionEvents.getEffectiveXrayRange(mob);
        if (xrayRange > 0.0 && (distSqXray = mob.m_20280_((Entity)player)) <= xrayRange * xrayRange) {
            return true;
        }
        double detectionRange = StealthDetectionEvents.getRealisticStealthDetectionRange(player, mob, level);
        double distSq = mob.m_20280_((Entity)player);
        if (distSq > detectionRange * detectionRange) {
            return false;
        }
        return FovEvents.isTargetInFov(mob, (Entity)player, true);
    }

    public static boolean shouldSuppressTargeting(Mob mob) {
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return false;
        }
        LivingEntity target = StealthDetectionEvents.getAttackTargetCompat(mob);
        if (target == null) {
            return false;
        }
        if (!(target instanceof Player)) {
            return false;
        }
        Player player = (Player)target;
        return !StealthDetectionEvents.canMobDetectPlayer(mob, player);
    }

    public static boolean shouldSuppressTargeting(Mob mob, Player player) {
        return !StealthDetectionEvents.canMobDetectPlayer(mob, player);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        StealthPerfTier tier;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return;
        }
        long gameTime = event.getServer().m_129783_().m_46467_();
        if (gameTime != lastEstimatedTpsGameTime) {
            lastEstimatedTpsGameTime = gameTime;
            StealthDetectionEvents.updateEstimatedTps(event.getServer());
        }
        if ((tier = StealthDetectionEvents.getPerfTier(event.getServer())) == StealthPerfTier.VANILLA) {
            return;
        }
        int stealthCheckInterval = StealthDetectionEvents.getStealthCheckInterval();
        if (gameTime % (long)stealthCheckInterval != 0L || gameTime == lastStealthCheckTick) {
            return;
        }
        lastStealthCheckTick = gameTime;
        for (ServerLevel level : event.getServer().m_129785_()) {
            HashMap<Long, Boolean> sharedStealthCache = tier == StealthPerfTier.SHARE_NEARBY && (Double)SoundAttractConfig.COMMON.stealthShareTargetToNearbyMobsRadius.get() > 0.0 ? new HashMap<Long, Boolean>() : null;
            int scanningRadius = Math.max(32, (int)Math.ceil((Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get()) + 16);
            HashSet mobsToCheck = new HashSet();
            HashSet<UUID> seenPlayerIds = new HashSet<UUID>();
            HashSet<UUID> seenMobIds = new HashSet<UUID>();
            for (ServerPlayer serverPlayer : level.m_6907_()) {
                seenPlayerIds.add(serverPlayer.m_20148_());
                AABB scanArea = serverPlayer.m_20191_().m_82400_((double)scanningRadius);
                mobsToCheck.addAll(level.m_6443_(Mob.class, scanArea, entity -> entity.m_6084_() && StealthDetectionEvents.isTargetingPlayerCompat(entity)));
            }
            for (Mob mob : mobsToCheck) {
                boolean canCurrentlyDetect;
                seenMobIds.add(mob.m_20148_());
                LivingEntity rawTarget = StealthDetectionEvents.getAttackTargetCompat(mob);
                UUID mobId = mob.m_20148_();
                if (!(rawTarget instanceof Player)) {
                    mobOutOfRangeTicks.remove(mobId);
                    continue;
                }
                Player playerTarget = (Player)rawTarget;
                if (playerTarget.m_7500_() || playerTarget.m_5833_()) {
                    mobOutOfRangeTicks.remove(mobId);
                    continue;
                }
                if (sharedStealthCache != null) {
                    long pHash;
                    double radius = (Double)SoundAttractConfig.COMMON.stealthShareTargetToNearbyMobsRadius.get();
                    int cell = (int)Math.max(1.0, Math.floor(radius));
                    int cx = (int)Math.floor(mob.m_20185_() / (double)cell);
                    int cz = (int)Math.floor(mob.m_20189_() / (double)cell);
                    long key = pHash = playerTarget.m_20148_().getMostSignificantBits() ^ playerTarget.m_20148_().getLeastSignificantBits();
                    key = 31L * key + (long)cx;
                    Boolean cached = (Boolean)sharedStealthCache.get(key = 31L * key + (long)cz);
                    if (cached == null) {
                        cached = StealthDetectionEvents.canMobDetectPlayerNoEdgeSuppression(mob, playerTarget);
                        sharedStealthCache.put(key, cached);
                    }
                    canCurrentlyDetect = cached;
                    if (((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue()) {
                        try {
                            boolean isEdge = MobGroupManager.isEdgeMob(mob);
                            boolean isDeserter = MobGroupManager.isDeserter(mob);
                            if (isEdge && !isDeserter) {
                                StealthDetectionEvents.recordSuppressedEdgeDetection(mob);
                                canCurrentlyDetect = false;
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    canCurrentlyDetect = StealthDetectionEvents.canMobDetectPlayer(mob, playerTarget);
                }
                if (canCurrentlyDetect) {
                    if (mobOutOfRangeTicks.remove(mobId) == null || !((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                    SoundAttractMod.LOGGER.info("[TickCheck] Mob {} regained direct detection of {}. Grace period reset.", (Object)mob.m_7755_().getString(), (Object)playerTarget.m_7755_().getString());
                    continue;
                }
                int ticks = mobOutOfRangeTicks.getOrDefault(mobId, 0) + stealthCheckInterval;
                if (ticks >= (Integer)SoundAttractConfig.COMMON.stealthGracePeriodTicks.get()) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[TickCheck] Mob {} lost target {} due to stealth grace period timeout.", (Object)mob.m_7755_().getString(), (Object)playerTarget.m_7755_().getString());
                    }
                    if (mob.m_6274_().m_21874_(MemoryModuleType.f_26334_)) {
                        mob.m_6274_().m_21936_(MemoryModuleType.f_26334_);
                    }
                    try {
                        mob.m_6274_().m_21936_(MemoryModuleType.f_26372_);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    mob.m_6710_(null);
                    mobOutOfRangeTicks.remove(mobId);
                    continue;
                }
                mobOutOfRangeTicks.put(mobId, ticks);
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[TickCheck] Mob {} cannot detect {}. In grace period ({}/{}).", new Object[]{mob.m_7755_().getString(), playerTarget.m_7755_().getString(), ticks, SoundAttractConfig.COMMON.stealthGracePeriodTicks.get()});
            }
            if (gameTime % Math.max((long)stealthCheckInterval * 5L, 20L) != 0L) continue;
            mobOutOfRangeTicks.keySet().removeIf(id -> !seenMobIds.contains(id));
            XRAY_RANGE_CACHE.keySet().removeIf(id -> !seenMobIds.contains(id));
            lastMobPositions.keySet().removeIf(id -> !seenMobIds.contains(id));
            suppressedEdgeDetections.removeIf(id -> !seenMobIds.contains(id));
            lastPlayerPositions.keySet().removeIf(id -> !seenPlayerIds.contains(id));
            playerGunshotInfo.keySet().removeIf(id -> !seenPlayerIds.contains(id));
        }
    }

    public static boolean isPlayerMoving(Player player, double threshold) {
        if (player == null) {
            return false;
        }
        Vec3 currentPos = player.m_20182_();
        Vec3 lastPos = lastPlayerPositions.get(player.m_20148_());
        boolean moved = false;
        if (lastPos != null) {
            double distSq = currentPos.m_82557_(lastPos);
            moved = distSq > threshold * threshold;
        }
        lastPlayerPositions.put(player.m_20148_(), currentPos);
        return moved;
    }

    private static PlayerStance determinePlayerStance(Player player) {
        Pose currentPose = player.m_20089_();
        boolean isVisuallyCrawling = player.m_20143_();
        boolean isCrouching = player.m_6047_();
        float playerHeight = player.m_6972_((Pose)currentPose).f_20378_;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[DetermineStanceDetails] Player: {}, Pose: {}, isVisuallyCrawling: {}, isCrouching: {}, Height: {}", new Object[]{player.m_7755_().getString(), currentPose, isVisuallyCrawling, isCrouching, String.format("%.2f", Float.valueOf(playerHeight))});
        }
        if (isVisuallyCrawling || playerHeight <= 1.0f) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is CRAWLING (VisualCrawl: true, Pose: {}, Height: {})", new Object[]{player.m_7755_().getString(), currentPose, String.format("%.2f", Float.valueOf(playerHeight))});
            }
            return PlayerStance.CRAWLING;
        }
        if (isCrouching) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is SNEAKING (Pose: {}, Crouching: {}, Height: {})", new Object[]{player.m_7755_().getString(), currentPose, isCrouching, String.format("%.2f", Float.valueOf(playerHeight))});
            }
            return PlayerStance.SNEAKING;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is STANDING (Pose: {}, Height: {})", new Object[]{player.m_7755_().getString(), currentPose, String.format("%.2f", Float.valueOf(playerHeight))});
        }
        return PlayerStance.STANDING;
    }

    public static double getRealisticStealthDetectionRange(Player player, Mob mob, Level level) {
        double finalCalculatedRange;
        int i;
        double baseRange;
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get();
        }
        if (StealthDetectionEvents.shouldUseVanillaTargeting(level)) {
            return (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get();
        }
        boolean skipExpensive = StealthDetectionEvents.shouldSkipExpensiveChecks(level);
        Optional<Double> gunshotRangeOpt = StealthDetectionEvents.getActiveGunshotRange(player);
        PlayerStance currentStance = StealthDetectionEvents.determinePlayerStance(player);
        if (gunshotRangeOpt.isPresent()) {
            baseRange = gunshotRangeOpt.get();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_Update] Player {} has active gunshot flash. Initial range set to {}.", (Object)player.m_7755_().getString(), (Object)String.format("%.2f", baseRange));
            }
            double standingRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
            double poseReduction = Math.max(0.0, standingRange - (switch (currentStance) {
                case PlayerStance.CRAWLING -> (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                case PlayerStance.SNEAKING -> (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                default -> standingRange;
            }));
            baseRange -= poseReduction;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_Update] Gunshot range adjusted by pose {}. Reduction of {}. New range: {}.", new Object[]{currentStance, String.format("%.2f", poseReduction), String.format("%.2f", baseRange)});
            }
        } else {
            Optional override;
            MobProfile mobProfile = SoundAttractConfig.getMatchingProfile(mob);
            Optional<Object> optional = override = mobProfile != null ? mobProfile.getDetectionOverride(currentStance) : Optional.empty();
            if (override.isPresent()) {
                baseRange = (Double)override.get();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Mob {} using profile '{}' detection range for stance {}: {}", new Object[]{mob.m_7755_().getString(), mobProfile.getProfileName(), currentStance, baseRange});
                }
            } else {
                Optional playerOverride;
                PlayerProfile playerProfile = SoundAttractConfig.getMatchingPlayerProfile(player);
                Optional<Object> optional2 = playerOverride = playerProfile != null ? playerProfile.getDetectionOverride(currentStance) : Optional.empty();
                if (playerOverride.isPresent()) {
                    baseRange = (Double)playerOverride.get();
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update] Player {} matched player profile '{}' for stance {}: {}", new Object[]{player.m_7755_().getString(), playerProfile.getProfileName(), currentStance, baseRange});
                    }
                } else {
                    switch (currentStance) {
                        case CRAWLING: {
                            baseRange = (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                            break;
                        }
                        case SNEAKING: {
                            baseRange = (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                            break;
                        }
                        default: {
                            baseRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
                        }
                    }
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        if (mobProfile != null) {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update] Mob {} profile '{}' has no override for stance {}. No matching player profile override. Using default: {}", new Object[]{mob.m_7755_().getString(), mobProfile.getProfileName(), currentStance, baseRange});
                        } else {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update] No mob profile override and no player profile override for Mob {}. Using default for stance {}: {}", new Object[]{mob.m_7755_().getString(), currentStance, baseRange});
                        }
                    }
                }
            }
        }
        if (player.m_21023_(MobEffects.f_19609_)) {
            double invisFactor = (Double)SoundAttractConfig.COMMON.invisibilityStealthFactor.get();
            baseRange *= invisFactor;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_Update] Player {} is invisible, reducing baseRange to {}", (Object)player.m_7755_().getString(), (Object)String.format("%.2f", baseRange));
            }
        }
        BlockPos basePos = player.m_20183_();
        long dayTime = level.m_46468_() % 24000L;
        boolean isDay = dayTime >= 0L && dayTime < 12000L;
        int effectiveLight = 0;
        BlockPos playerFeetPos = player.m_20183_();
        BlockPos playerEyesPos = playerFeetPos.m_7494_();
        if (level.m_46749_(playerFeetPos)) {
            effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.BLOCK, playerFeetPos));
            if (isDay && level.m_45527_(playerFeetPos)) {
                effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.SKY, playerFeetPos));
            }
        }
        if (level.m_46749_(playerEyesPos)) {
            effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.BLOCK, playerEyesPos));
            if (isDay && level.m_45527_(playerEyesPos)) {
                effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.SKY, playerEyesPos));
            }
        }
        for (ItemStack s : List.of(player.m_21205_(), player.m_21206_())) {
            Item item = s.m_41720_();
            if (!(item instanceof BlockItem)) continue;
            BlockItem bi = (BlockItem)item;
            BlockState def = bi.m_40614_().m_49966_();
            if (!level.m_46749_(basePos)) continue;
            int emit = def.getLightEmission((BlockGetter)level, basePos);
            effectiveLight = Math.max(effectiveLight, emit);
        }
        double neutral = ((Integer)SoundAttractConfig.COMMON.neutralLightLevel.get()).intValue();
        double sensitivity = (Double)SoundAttractConfig.COMMON.lightLevelSensitivity.get();
        double lightEffect = ((double)effectiveLight - neutral) * (sensitivity / 15.0);
        double lightFactor = 1.0 + lightEffect;
        lightFactor = Math.max((Double)SoundAttractConfig.COMMON.minLightFactor.get(), lightFactor);
        lightFactor = Math.min((Double)SoundAttractConfig.COMMON.maxLightFactor.get(), lightFactor);
        baseRange *= lightFactor;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR_Update] Light - EffectiveLight: {}, LightFactor (clamped): {}, baseRange: {}", new Object[]{effectiveLight, String.format("%.2f", lightFactor), String.format("%.2f", baseRange)});
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableHeldItemPenalty.get()).booleanValue()) {
            int heldItemCount = 0;
            if (!player.m_21205_().m_41619_()) {
                ++heldItemCount;
            }
            if (!player.m_21206_().m_41619_()) {
                ++heldItemCount;
            }
            if (heldItemCount > 0) {
                double penaltyPerItem = (Double)SoundAttractConfig.COMMON.heldItemPenaltyFactor.get();
                for (i = 0; i < heldItemCount; ++i) {
                    baseRange *= penaltyPerItem;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Held Item Penalty: {} items, factor {:.2f} (applied {} times) -> {:.2f}", new Object[]{heldItemCount, penaltyPerItem, heldItemCount, baseRange});
                }
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableEnchantmentPenalty.get()).booleanValue()) {
            int visiblyEnchantedArmorPieces = 0;
            for (ItemStack armorStack : player.m_6168_()) {
                if (armorStack.m_41619_() || !armorStack.m_41793_() || StealthDetectionEvents.hasConcealmentEnchant(armorStack)) continue;
                ++visiblyEnchantedArmorPieces;
            }
            if (visiblyEnchantedArmorPieces > 0) {
                double armorPenaltyFactor = (Double)SoundAttractConfig.COMMON.armorEnchantmentPenaltyFactor.get();
                for (i = 0; i < visiblyEnchantedArmorPieces; ++i) {
                    baseRange *= armorPenaltyFactor;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Armor Enchant Penalty: {} pieces, factor {:.2f} (applied {} times) -> {:.2f}", new Object[]{visiblyEnchantedArmorPieces, armorPenaltyFactor, visiblyEnchantedArmorPieces, baseRange});
                }
            }
            int visiblyEnchantedHeldItems = 0;
            if (!player.m_21205_().m_41619_() && player.m_21205_().m_41793_() && !StealthDetectionEvents.hasConcealmentEnchant(player.m_21205_())) {
                ++visiblyEnchantedHeldItems;
            }
            if (!player.m_21206_().m_41619_() && player.m_21206_().m_41793_() && !StealthDetectionEvents.hasConcealmentEnchant(player.m_21206_())) {
                ++visiblyEnchantedHeldItems;
            }
            if (visiblyEnchantedHeldItems > 0) {
                double heldItemEnchantPenalty = (Double)SoundAttractConfig.COMMON.heldItemEnchantmentPenaltyFactor.get();
                for (int i2 = 0; i2 < visiblyEnchantedHeldItems; ++i2) {
                    baseRange *= heldItemEnchantPenalty;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Held Item Enchant Penalty: {} items, factor {:.2f} (applied {} times) -> {:.2f}", new Object[]{visiblyEnchantedHeldItems, heldItemEnchantPenalty, visiblyEnchantedHeldItems, baseRange});
                }
            }
        }
        ArrayList camouflageItems = new ArrayList((Collection)SoundAttractConfig.COMMON.camouflageArmorItems.get());
        if (!skipExpensive && ((Boolean)SoundAttractConfig.COMMON.enableEnvironmentalCamouflage.get()).booleanValue()) {
            Optional<Integer> armorColorOpt = StealthDetectionEvents.getEffectiveArmorColor(player);
            Optional<Integer> envColorOpt = StealthDetectionEvents.getAverageEnvironmentalColor(player, level);
            if (armorColorOpt.isPresent() && envColorOpt.isPresent()) {
                int matchBonusThreshold;
                int armorColor = armorColorOpt.get();
                int envColor = envColorOpt.get();
                int rArmor = armorColor >> 16 & 0xFF;
                int gArmor = armorColor >> 8 & 0xFF;
                int bArmor = armorColor & 0xFF;
                int rEnv = envColor >> 16 & 0xFF;
                int gEnv = envColor >> 8 & 0xFF;
                int bEnv = envColor & 0xFF;
                int diff = Math.abs(rArmor - rEnv) + Math.abs(gArmor - gEnv) + Math.abs(bArmor - bEnv);
                if (diff <= (matchBonusThreshold = ((Integer)SoundAttractConfig.COMMON.environmentalCamouflageColorMatchThreshold.get()).intValue())) {
                    double maxBonusEffect = (Double)SoundAttractConfig.COMMON.environmentalCamouflageMaxEffectiveness.get();
                    double effectivenessRatio = matchBonusThreshold > 0 ? 1.0 - (double)diff / (double)matchBonusThreshold : (diff == 0 ? 1.0 : 0.0);
                    double actualBonusEffectiveness = maxBonusEffect * effectivenessRatio;
                    baseRange *= 1.0 - actualBonusEffectiveness;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[EnvCamo] Player {} BONUS: armor=0x{}, env=0x{}, diff={}, matchThold={}, ratio={}, effect={}, newRange={}", new Object[]{player.m_7755_().getString(), String.format("%06X", armorColor), String.format("%06X", envColor), diff, matchBonusThreshold, String.format("%.2f", effectivenessRatio), String.format("%.2f", actualBonusEffectiveness), String.format("%.2f", baseRange)});
                    }
                } else if (((Boolean)SoundAttractConfig.COMMON.enableEnvironmentalMismatchPenalty.get()).booleanValue()) {
                    int mismatchPenaltyThreshold = (Integer)SoundAttractConfig.COMMON.environmentalMismatchThreshold.get();
                    if (diff > mismatchPenaltyThreshold) {
                        double penaltyFactor = (Double)SoundAttractConfig.COMMON.environmentalMismatchPenaltyFactor.get();
                        baseRange *= penaltyFactor;
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[EnvCamo] Player {} PENALTY: armor=0x{}, env=0x{}, diff={}, mismatchThold={}, penaltyFactor={}, newRange={}", new Object[]{player.m_7755_().getString(), String.format("%06X", armorColor), String.format("%06X", envColor), diff, mismatchPenaltyThreshold, String.format("%.2f", penaltyFactor), String.format("%.2f", baseRange)});
                        }
                    } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[EnvCamo] Player {} NEUTRAL: armor=0x{}, env=0x{}, diff={}, no bonus or penalty from env camo.", new Object[]{player.m_7755_().getString(), String.format("%06X", armorColor), String.format("%06X", envColor), diff});
                    }
                }
            } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[EnvCamo] Player {} - Could not get armor or environment color. Skipping.", (Object)player.m_7755_().getString());
            }
        }
        if (!skipExpensive) {
            if (level.m_46758_(player.m_20183_())) {
                baseRange *= ((Double)SoundAttractConfig.COMMON.rainStealthFactor.get()).doubleValue();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Raining. Factor applied. baseRange: {}", (Object)String.format("%.2f", baseRange));
                }
            }
            if (level.m_46470_()) {
                baseRange *= ((Double)SoundAttractConfig.COMMON.thunderStealthFactor.get()).doubleValue();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Thundering. Factor applied. baseRange: {}", (Object)String.format("%.2f", baseRange));
                }
            }
        }
        if (currentStance != PlayerStance.SNEAKING && currentStance != PlayerStance.CRAWLING) {
            if (StealthDetectionEvents.isPlayerMoving(player, (Double)SoundAttractConfig.COMMON.movementThreshold.get())) {
                baseRange *= ((Double)SoundAttractConfig.COMMON.movementStealthPenalty.get()).doubleValue();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Player moving (not sneak/crawl). Penalty applied. baseRange: {}", (Object)String.format("%.2f", baseRange));
                }
            } else {
                baseRange *= ((Double)SoundAttractConfig.COMMON.stationaryStealthBonusFactor.get()).doubleValue();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Player stationary (not sneak/crawl). Bonus applied. baseRange: {}", (Object)String.format("%.2f", baseRange));
                }
            }
        } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR_Update] Player sneaking/crawling. Movement penalty/bonus not applied here (handled by stance base range). baseRange: {}", (Object)String.format("%.2f", baseRange));
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableCamouflage.get()).booleanValue()) {
            if (!camouflageItems.isEmpty()) {
                boolean isActuallyWearingFullSetOfListedItems;
                double effectToApply = 0.0;
                int totalActualArmorPieces = 0;
                long wornListedCamouflagePieces = 0L;
                for (ItemStack armorStack : player.m_6168_()) {
                    if (armorStack.m_41619_()) continue;
                    ++totalActualArmorPieces;
                    ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)armorStack.m_41720_());
                    if (itemId == null || !camouflageItems.contains(itemId.toString())) continue;
                    ++wornListedCamouflagePieces;
                }
                boolean bl = isActuallyWearingFullSetOfListedItems = totalActualArmorPieces == 4 && wornListedCamouflagePieces == (long)totalActualArmorPieces && totalActualArmorPieces > 0;
                if (((Boolean)SoundAttractConfig.COMMON.requireFullSetForCamouflageBonus.get()).booleanValue()) {
                    if (isActuallyWearingFullSetOfListedItems) {
                        effectToApply = (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get();
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} wearing full set of listed items (requireFullSet=true). Applying fullArmorStealthBonus: {}", (Object)player.m_7755_().getString(), (Object)effectToApply);
                        }
                    } else {
                        double totalEffectiveness = 0.0;
                        ArrayList armorItemsList = new ArrayList();
                        player.m_6168_().forEach(armorItemsList::add);
                        block26: for (i = 0; i < armorItemsList.size(); ++i) {
                            Item item;
                            ResourceLocation itemId;
                            ItemStack stack = (ItemStack)armorItemsList.get(i);
                            if (stack.m_41619_() || (itemId = ForgeRegistries.ITEMS.getKey((Object)(item = stack.m_41720_()))) == null || !camouflageItems.contains(itemId.toString())) continue;
                            switch (i) {
                                case 0: {
                                    totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                                    continue block26;
                                }
                                case 1: {
                                    totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                                    continue block26;
                                }
                                case 2: {
                                    totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                                    continue block26;
                                }
                                case 3: {
                                    totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                                }
                            }
                        }
                        effectToApply = totalEffectiveness;
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} wearing partial listed camo (requireFullSet=true). Applying summed per-piece effectiveness: {}", (Object)player.m_7755_().getString(), (Object)effectToApply);
                        }
                    }
                } else if (isActuallyWearingFullSetOfListedItems && (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get() > 0.0) {
                    effectToApply = (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get();
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} wearing full set of listed items (requireFullSet=false, using full bonus). Applying fullArmorStealthBonus: {}", (Object)player.m_7755_().getString(), (Object)effectToApply);
                    }
                } else {
                    double totalEffectiveness = 0.0;
                    ArrayList armorItemsList = new ArrayList();
                    player.m_6168_().forEach(armorItemsList::add);
                    block27: for (i = 0; i < armorItemsList.size(); ++i) {
                        Item item;
                        ResourceLocation itemId;
                        ItemStack stack = (ItemStack)armorItemsList.get(i);
                        if (stack.m_41619_() || (itemId = ForgeRegistries.ITEMS.getKey((Object)(item = stack.m_41720_()))) == null || !camouflageItems.contains(itemId.toString())) continue;
                        switch (i) {
                            case 0: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                                continue block27;
                            }
                            case 1: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                                continue block27;
                            }
                            case 2: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                                continue block27;
                            }
                            case 3: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                            }
                        }
                    }
                    effectToApply = totalEffectiveness;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} (requireFullSet=false). Applying summed per-piece effectiveness: {}", (Object)player.m_7755_().getString(), (Object)effectToApply);
                    }
                }
                if (effectToApply > 0.0) {
                    double itemCamoMultiplier = 1.0 - Math.min(effectToApply, 0.99);
                    baseRange *= itemCamoMultiplier;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} range after general item camouflage: {}. Applied multiplier: {} (Effect: {})", new Object[]{player.m_7755_().getString(), String.format("%.2f", baseRange), String.format("%.2f", itemCamoMultiplier), String.format("%.2f", effectToApply)});
                    }
                }
                double finalCalculatedRange2 = Math.max((Double)SoundAttractConfig.COMMON.minStealthDetectionRange.get(), Math.min(baseRange, (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get()));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_End] Mob: {}, Player: {}, Final Calculated Range (camo items processed): {}", new Object[]{mob.m_7755_().getString(), player.m_7755_().getString(), String.format("%.2f", finalCalculatedRange2)});
                }
                return finalCalculatedRange2;
            }
            finalCalculatedRange = Math.max((Double)SoundAttractConfig.COMMON.minStealthDetectionRange.get(), Math.min(baseRange, (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get()));
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_End] Mob: {}, Player: {}, Item Camo enabled but no items configured. Final Range: {}", new Object[]{mob.m_7755_().getString(), player.m_7755_().getString(), String.format("%.2f", finalCalculatedRange)});
            }
            return finalCalculatedRange;
        }
        finalCalculatedRange = Math.max((Double)SoundAttractConfig.COMMON.minStealthDetectionRange.get(), Math.min(baseRange, (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get()));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR_End] Mob: {}, Player: {}, Item Camo system disabled. Final Range: {}", new Object[]{mob.m_7755_().getString(), player.m_7755_().getString(), String.format("%.2f", finalCalculatedRange)});
        }
        return finalCalculatedRange;
    }

    private static Optional<Integer> getEffectiveArmorColor(Player player) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        boolean onlyDyedLeather = (Boolean)SoundAttractConfig.COMMON.environmentalCamouflageOnlyDyedLeather.get();
        for (ItemStack itemStack : player.m_6168_()) {
            ResourceLocation itemIdRL;
            DyeableLeatherItem dyeableItem;
            ArmorItem armorItem;
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            boolean colorAdded = false;
            if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() == ArmorMaterials.LEATHER && item instanceof DyeableLeatherItem && (dyeableItem = (DyeableLeatherItem)item).m_41113_(itemStack)) {
                colors.add(dyeableItem.m_41121_(itemStack));
                colorAdded = true;
            }
            if (onlyDyedLeather && !colorAdded || colorAdded || (itemIdRL = ForgeRegistries.ITEMS.getKey((Object)item)) == null) continue;
            Integer mappedColorValue = SoundAttractConfig.customArmorColors.get(itemIdRL);
            if (mappedColorValue != null) {
                colors.add(mappedColorValue);
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[GetArmorColor] Using MAPPED color for {}: 0x{}", (Object)itemIdRL, (Object)String.format("%06X", mappedColorValue));
                continue;
            }
            if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
            SoundAttractMod.LOGGER.info("[GetArmorColor] Item {} not found in custom_armor_color_map.", (Object)itemIdRL);
        }
        if (colors.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GetArmorColor] No determinable armor colors found.");
            }
            return Optional.empty();
        }
        long totalR = 0L;
        long totalG = 0L;
        long totalB = 0L;
        Iterator iterator = colors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            totalR += (long)(color >> 16 & 0xFF);
            totalG += (long)(color >> 8 & 0xFF);
            totalB += (long)(color & 0xFF);
        }
        int numColors = colors.size();
        if (numColors == 0) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[GetArmorColor] numColors is 0 after processing, this should not happen if colors list was not empty.");
            }
            return Optional.empty();
        }
        int avgR = (int)(totalR / (long)numColors);
        int avgG = (int)(totalG / (long)numColors);
        int avgB = (int)(totalB / (long)numColors);
        int finalAvgColor = avgR << 16 | avgG << 8 | avgB;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GetArmorColor] Average armor color: 0x{} from {} pieces.", (Object)String.format("%06X", finalAvgColor), (Object)numColors);
        }
        return Optional.of(finalAvgColor);
    }

    private static Optional<Integer> getAverageEnvironmentalColor(Player player, Level level) {
        if (player == null || level == null) {
            return Optional.empty();
        }
        if (QuantifiedCacheCompat.isUsable()) {
            BlockPos playerPos = player.m_20183_();
            String key = new StringBuilder(96).append(level.m_46472_().m_135782_().toString()).append('|').append(playerPos.m_123341_()).append(',').append(playerPos.m_123342_()).append(',').append(playerPos.m_123343_()).toString();
            return QuantifiedCacheCompat.getCached("soundattract_env_color_player", key, () -> StealthDetectionEvents.soundattract$computeAverageEnvironmentalColor(player, level), 2L, 8192L);
        }
        return StealthDetectionEvents.soundattract$computeAverageEnvironmentalColor(player, level);
    }

    private static Optional<Integer> soundattract$computeAverageEnvironmentalColor(Player player, Level level) {
        ArrayList<Integer> blockColors = new ArrayList<Integer>();
        BlockPos playerPos = player.m_20183_();
        for (int yOffset = 0; yOffset >= -1; --yOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    int mapColor;
                    BlockState blockState;
                    BlockPos currentPos = playerPos.m_7918_(xOffset, yOffset, zOffset);
                    if (!level.m_46749_(currentPos) || (blockState = level.m_8055_(currentPos)).m_60795_()) continue;
                    try {
                        mapColor = blockState.m_284242_((BlockGetter)level, (BlockPos)currentPos).f_283871_;
                    }
                    catch (Throwable ignored) {
                        continue;
                    }
                    if (mapColor == 0) continue;
                    blockColors.add(mapColor);
                }
            }
        }
        if (blockColors.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GetEnvColor] No block map colors found in sampling area.");
            }
            return Optional.empty();
        }
        long totalR = 0L;
        long totalG = 0L;
        long totalB = 0L;
        Iterator ignored = blockColors.iterator();
        while (ignored.hasNext()) {
            int color = (Integer)ignored.next();
            totalR += (long)(color >> 16 & 0xFF);
            totalG += (long)(color >> 8 & 0xFF);
            totalB += (long)(color & 0xFF);
        }
        int numColors = blockColors.size();
        if (numColors == 0) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[GetEnvColor] numColors is 0 after processing, this should not happen if blockColors list was not empty.");
            }
            return Optional.empty();
        }
        int avgR = (int)(totalR / (long)numColors);
        int avgG = (int)(totalG / (long)numColors);
        int avgB = (int)(totalB / (long)numColors);
        int finalAvgColor = avgR << 16 | avgG << 8 | avgB;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GetEnvColor] Average environment color: 0x{} from {} blocks.", (Object)String.format("%06X", finalAvgColor), (Object)numColors);
        }
        return Optional.of(finalAvgColor);
    }

    private static enum StealthPerfTier {
        FULL,
        SKIP_EXPENSIVE,
        CURRENT_TARGETS_ONLY,
        SHARE_NEARBY,
        VANILLA;

    }

    public static class GunshotInfo {
        public final long timestamp;
        public final double detectionRange;

        public GunshotInfo(long timestamp, double detectionRange) {
            this.timestamp = timestamp;
            this.detectionRange = detectionRange;
        }
    }
}

