/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.event;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.FollowLeaderGoal;
import com.example.soundattract.ai.FollowerEdgeRelayGoal;
import com.example.soundattract.ai.LeaderAttractionGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.PickUpAndThrowToSoundGoal;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.ai.SoundClimbGoal;
import com.example.soundattract.ai.TeleportToSoundGoal;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.data.DataDrivenTags;
import com.example.soundattract.integration.RelentlessUndeadIntegration;
import com.example.soundattract.integration.smartbrainlib.SmartBrainLibCompat;
import com.example.soundattract.runtime.DynamicScanCooldownManager;
import com.example.soundattract.tracking.SoundTracker;
import com.example.soundattract.worker.WorkSchedulerManager;
import com.example.soundattract.worker.WorkerScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="soundattract", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoundAttractionEvents {
    private static final Map<Mob, List<GoalDefinition>> PENDING_GOAL_ADDITIONS = new ConcurrentHashMap<Mob, List<GoalDefinition>>();
    private static long serverTickCounter = 0L;
    private static boolean initialDelayHasPassed = false;
    private static long lastMobCountUpdateTime_ServerTick = -1L;
    private static int cachedAttractedMobCount_ServerTick = 0;
    private static Set<EntityType<?>> CACHED_ATTRACTED_ENTITY_TYPES = null;
    private static Set<EntityType<?>> CACHED_BLACKLISTED_ENTITY_TYPES = null;

    public static boolean isCustomNpcsMob(Mob mob) {
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] isCustomNpcsMob called for {} with class: {}", (Object)(mob != null ? mob.m_7755_().getString() : "null"), (Object)(mob != null ? mob.getClass().getName() : "null"));
        }
        if (mob == null) {
            return false;
        }
        if (SoundAttractConfig.COMMON == null || !((Boolean)SoundAttractConfig.COMMON.enableCustomNpcsIntegration.get()).booleanValue()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] CustomNPCs integration disabled");
            }
            return false;
        }
        try {
            for (Class<?> c = mob.getClass(); c != null; c = c.getSuperclass()) {
                String className = c.getName();
                if (!className.contains("EntityNPCInterface") && !className.contains("EntityCustomNpc") && !className.contains("EntityNPCFlying") && !className.contains("noppes.npcs.entity")) continue;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Detected CustomNPCs by class: {}", (Object)className);
                }
                return true;
            }
            ResourceLocation entityTypeKey = EntityType.m_20613_((EntityType)mob.m_6095_());
            if (entityTypeKey != null && "customnpcs".equals(entityTypeKey.m_135827_())) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Detected CustomNPCs by namespace: {}", (Object)entityTypeKey);
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void scheduleAddGoal(Mob mob, int priority, Goal goal) {
        PENDING_GOAL_ADDITIONS.computeIfAbsent(mob, k -> new ArrayList()).add(new GoalDefinition(priority, goal));
    }

    public static void invalidateCachedEntityTypes() {
        CACHED_ATTRACTED_ENTITY_TYPES = null;
        CACHED_BLACKLISTED_ENTITY_TYPES = null;
    }

    private static Set<EntityType<?>> getEntityTypesForTag(TagKey<EntityType<?>> tagKey) {
        HashSet result = new HashSet();
        for (EntityType type : ForgeRegistries.ENTITY_TYPES.getValues()) {
            if (type == null) continue;
            try {
                if (!type.m_204039_(tagKey)) continue;
                result.add(type);
            }
            catch (Exception e) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Error checking tag {} for entity type {}", new Object[]{tagKey.f_203868_(), ForgeRegistries.ENTITY_TYPES.getKey((Object)type), e});
            }
        }
        return result;
    }

    public static Set<EntityType<?>> getCachedAttractedEntityTypes() {
        if (CACHED_ATTRACTED_ENTITY_TYPES != null) {
            return CACHED_ATTRACTED_ENTITY_TYPES;
        }
        HashSet<EntityType> configSet = new HashSet<EntityType>();
        boolean shouldRetryLater = false;
        for (String idStr : (List)SoundAttractConfig.COMMON.attractedEntities.get()) {
            try {
                ResourceLocation id = ResourceLocation.parse((String)idStr);
                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
                if (type != null) {
                    configSet.add(type);
                    continue;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Unknown attracted entity type in config: {}", (Object)idStr);
                }
                if (id == null || "minecraft".equals(id.m_135827_()) || !ModList.get().isLoaded(id.m_135827_())) continue;
                shouldRetryLater = true;
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Invalid ResourceLocation for attracted entity type in config: {}", (Object)idStr, (Object)e);
            }
        }
        boolean enableDataDriven = (Boolean)SoundAttractConfig.COMMON.enableDataDriven.get();
        Set<Object> tagSet = enableDataDriven ? SoundAttractionEvents.getEntityTypesForTag(DataDrivenTags.ATTRACTED_MOBS) : Collections.emptySet();
        HashSet result = new HashSet();
        if (!enableDataDriven || tagSet.isEmpty()) {
            result.addAll(configSet);
        } else {
            String priority = (String)SoundAttractConfig.COMMON.datapackPriority.get();
            boolean datapackOverConfig = "datapack_over_config".equalsIgnoreCase(priority);
            if (datapackOverConfig) {
                result.addAll(tagSet);
            } else {
                result.addAll(configSet);
                result.addAll(tagSet);
            }
        }
        if (shouldRetryLater) {
            return result;
        }
        CACHED_ATTRACTED_ENTITY_TYPES = result;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            String resultingTypes = result.stream().map(et -> ForgeRegistries.ENTITY_TYPES.getKey(et).toString()).collect(Collectors.joining(", "));
            SoundAttractMod.LOGGER.info("[DIAGNOSTIC] Final attracted EntityType cache contains: [{}]", (Object)resultingTypes);
        }
        return CACHED_ATTRACTED_ENTITY_TYPES;
    }

    public static Set<EntityType<?>> getCachedBlacklistedEntityTypes() {
        if (CACHED_BLACKLISTED_ENTITY_TYPES != null) {
            return CACHED_BLACKLISTED_ENTITY_TYPES;
        }
        HashSet<EntityType> configSet = new HashSet<EntityType>();
        boolean shouldRetryLater = false;
        for (String idStr : (List)SoundAttractConfig.COMMON.mobBlacklist.get()) {
            try {
                ResourceLocation id = ResourceLocation.parse((String)idStr);
                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
                if (type != null) {
                    configSet.add(type);
                    continue;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Unknown blacklisted entity type in config: {}", (Object)idStr);
                }
                if (id == null || "minecraft".equals(id.m_135827_()) || !ModList.get().isLoaded(id.m_135827_())) continue;
                shouldRetryLater = true;
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Invalid ResourceLocation for blacklisted entity type in config: {}", (Object)idStr, (Object)e);
            }
        }
        boolean enableDataDriven = (Boolean)SoundAttractConfig.COMMON.enableDataDriven.get();
        Set<Object> tagSet = enableDataDriven ? SoundAttractionEvents.getEntityTypesForTag(DataDrivenTags.BLACKLISTED_MOBS) : Collections.emptySet();
        HashSet result = new HashSet();
        if (!enableDataDriven || tagSet.isEmpty()) {
            result.addAll(configSet);
        } else {
            String priority = (String)SoundAttractConfig.COMMON.datapackPriority.get();
            boolean datapackOverConfig = "datapack_over_config".equalsIgnoreCase(priority);
            if (datapackOverConfig) {
                result.addAll(tagSet);
            } else {
                result.addAll(configSet);
                result.addAll(tagSet);
            }
        }
        if (shouldRetryLater) {
            return result;
        }
        CACHED_BLACKLISTED_ENTITY_TYPES = result;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            String resultingTypes = result.stream().map(et -> ForgeRegistries.ENTITY_TYPES.getKey(et).toString()).collect(Collectors.joining(", "));
            SoundAttractMod.LOGGER.info("[DIAGNOSTIC] Final blacklisted EntityType cache contains: [{}]", (Object)resultingTypes);
        }
        return CACHED_BLACKLISTED_ENTITY_TYPES;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            int delay;
            if (!initialDelayHasPassed && ++serverTickCounter >= (long)(delay = ((Integer)SoundAttractConfig.COMMON.initialGroupComputationDelay.get()).intValue())) {
                initialDelayHasPassed = true;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Initial group computation delay of {} ticks has passed. Enabling group updates.", (Object)delay);
                }
            }
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            block19: {
                if (!initialDelayHasPassed) {
                    return;
                }
                if (ServerLifecycleHooks.getCurrentServer() == null || ServerLifecycleHooks.getCurrentServer().m_129783_() == null) {
                    return;
                }
                ServerLevel serverLevel = ServerLifecycleHooks.getCurrentServer().m_129783_();
                long currentTime = serverLevel.m_46467_();
                int mobCountUpdateInterval = (Integer)SoundAttractConfig.COMMON.groupUpdateInterval.get();
                if (currentTime - lastMobCountUpdateTime_ServerTick >= (long)(mobCountUpdateInterval = Math.max(20, mobCountUpdateInterval)) || lastMobCountUpdateTime_ServerTick == -1L) {
                    int currentMobCount = 0;
                    HashSet countedMobsInTick = new HashSet();
                    Set<EntityType<?>> attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
                    if (!attractedEntityTypes.isEmpty()) {
                        for (ServerPlayer player : serverLevel.m_6907_()) {
                            int simDistanceBlocks = player.f_8924_.m_6846_().m_11312_() * 16;
                            AABB playerSimArea = player.m_20191_().m_82400_((double)simDistanceBlocks);
                            List mobsNearPlayer = serverLevel.m_45976_(Mob.class, playerSimArea);
                            for (Mob mob : mobsNearPlayer) {
                                boolean eligible;
                                boolean bl = eligible = attractedEntityTypes.contains(mob.m_6095_()) || SoundAttractConfig.getMatchingProfile(mob) != null || SoundAttractionEvents.isCustomNpcsMob(mob);
                                if (!mob.m_6084_() || mob.m_213877_() || !eligible || !countedMobsInTick.add(mob)) continue;
                                ++currentMobCount;
                            }
                        }
                    }
                    cachedAttractedMobCount_ServerTick = currentMobCount;
                    lastMobCountUpdateTime_ServerTick = currentTime;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Updated attracted mob count for DynamicScanCooldownManager: {}", (Object)cachedAttractedMobCount_ServerTick);
                    }
                }
                int mobCountForCooldownManager = cachedAttractedMobCount_ServerTick;
                DynamicScanCooldownManager.update(currentTime, mobCountForCooldownManager);
                SoundTracker.tick();
                BlockBreakerManager.processPendingActions();
                try {
                    List<WorkerScheduler.GroupComputeResult> results = WorkSchedulerManager.get().drainGroupResults();
                    if (!results.isEmpty()) {
                        for (WorkerScheduler.GroupComputeResult r : results) {
                            ServerLevel level;
                            if (r.dimension() == null || (level = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)r.dimension()))) == null) continue;
                            MobGroupManager.applyGroupResult(level, r);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block19;
                    SoundAttractMod.LOGGER.error("[SoundAttractionEvents] Applying group results failed", t);
                }
            }
            if (!PENDING_GOAL_ADDITIONS.isEmpty()) {
                Iterator<Map.Entry<Mob, List<GoalDefinition>>> iterator = PENDING_GOAL_ADDITIONS.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Mob, List<GoalDefinition>> entry = iterator.next();
                    Mob mob = entry.getKey();
                    List<GoalDefinition> goalsToAdd = entry.getValue();
                    if (mob.m_6084_() && mob.m_9236_() != null && !mob.m_213877_()) {
                        for (GoalDefinition def : goalsToAdd) {
                            boolean goalExists = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> def.goalClass.isInstance(wrappedGoal.m_26015_()));
                            if (goalExists) continue;
                            mob.f_21345_.m_25352_(def.priority, def.goalInstance);
                            if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Added goal {} to mob {}", (Object)def.goalClass.getSimpleName(), (Object)mob.m_7755_().getString());
                        }
                    }
                    iterator.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && !event.level.m_5776_() && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (initialDelayHasPassed) {
                MobGroupManager.updateGroups(serverLevel);
                RaidManager.tick(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onMobJoinLevel(EntityJoinLevelEvent event) {
        Level level;
        double moveSpeed;
        Mob mob;
        block29: {
            block28: {
                Set<EntityType<?>> blacklistedEntityTypes;
                Entity entity = event.getEntity();
                if (!(entity instanceof Mob)) {
                    return;
                }
                mob = (Mob)entity;
                if (event.getLevel().m_5776_()) {
                    return;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] CustomNPCs integration enabled: {}", SoundAttractConfig.COMMON.enableCustomNpcsIntegration.get());
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Mob joined: {} of type {}, isCustomNpcs: {}", new Object[]{mob.m_7755_().getString(), EntityType.m_20613_((EntityType)mob.m_6095_()), SoundAttractionEvents.isCustomNpcsMob(mob)});
                }
                if ((blacklistedEntityTypes = SoundAttractionEvents.getCachedBlacklistedEntityTypes()).contains(mob.m_6095_())) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Mob {} is on the blacklist, ignoring.", (Object)EntityType.m_20613_((EntityType)mob.m_6095_()));
                    }
                    return;
                }
                Set<EntityType<?>> attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
                boolean isAttractedByType = attractedEntityTypes.contains(mob.m_6095_());
                boolean hasMatchingprofile = SoundAttractConfig.getMatchingProfile(mob) != null;
                boolean isCustomNpcs = SoundAttractionEvents.isCustomNpcsMob(mob);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] {} eligibility - type:{}, profile:{}, customNpcs:{}", new Object[]{mob.m_7755_().getString(), isAttractedByType, hasMatchingprofile, isCustomNpcs});
                }
                if (!(isAttractedByType || hasMatchingprofile || isCustomNpcs)) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Mob {} not eligible - type:{}, profile:{}, customNpcs:{}", new Object[]{mob.m_7755_().getString(), isAttractedByType, hasMatchingprofile, isCustomNpcs});
                    }
                    return;
                }
                if (isCustomNpcs && ((Boolean)SoundAttractConfig.COMMON.enableCustomNpcsIntegration.get()).booleanValue()) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Adding CustomNPCs goals immediately for {}", (Object)mob.m_7755_().getString());
                    }
                    SoundAttractionEvents.addCustomNpcsGoals(mob);
                    return;
                }
                if (((Boolean)SoundAttractConfig.COMMON.enableSmartBrainLibIntegration.get()).booleanValue() && SmartBrainLibCompat.tryAttachSoundAttractBrain(mob)) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Using SmartBrainLib integration for mob {} of type {}", (Object)mob.m_7755_().getString(), (Object)EntityType.m_20613_((EntityType)mob.m_6095_()));
                    }
                    return;
                }
                moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
                if (((Boolean)SoundAttractConfig.COMMON.enableTeleportToSound.get()).booleanValue()) {
                    try {
                        TagKey canTeleportTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.parse((String)((String)SoundAttractConfig.COMMON.teleportCanTeleportTag.get())));
                        if (mob.m_6095_().m_204039_(canTeleportTag)) {
                            SoundAttractionEvents.scheduleAddGoal(mob, 2, new TeleportToSoundGoal(mob));
                        }
                    }
                    catch (Exception e) {
                        if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block28;
                        SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Failed to apply TeleportToSoundGoal tag check for mob {}: {}", (Object)EntityType.m_20613_((EntityType)mob.m_6095_()), (Object)e.getMessage());
                    }
                }
            }
            if (((Boolean)SoundAttractConfig.COMMON.enablePickUpAndThrowToSound.get()).booleanValue()) {
                try {
                    TagKey canPickUpTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.parse((String)((String)SoundAttractConfig.COMMON.pickUpCanPickUpTag.get())));
                    if (mob.m_6095_().m_204039_(canPickUpTag)) {
                        SoundAttractionEvents.scheduleAddGoal(mob, 2, new PickUpAndThrowToSoundGoal(mob));
                    }
                }
                catch (Exception e) {
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block29;
                    SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Failed to apply PickUpAndThrowToSoundGoal tag check for mob {}: {}", (Object)EntityType.m_20613_((EntityType)mob.m_6095_()), (Object)e.getMessage());
                }
            }
        }
        if (RelentlessUndeadIntegration.isMobEligibleForClimbing(mob)) {
            SoundAttractionEvents.scheduleAddGoal(mob, 0, new SoundClimbGoal(mob));
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Scheduled SoundClimbGoal for mob {}", (Object)mob.m_7755_().getString());
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue()) {
            SoundAttractionEvents.scheduleAddGoal(mob, 3, new LeaderAttractionGoal(mob, moveSpeed));
            SoundAttractionEvents.scheduleAddGoal(mob, 1, new FollowerEdgeRelayGoal(mob, moveSpeed));
        } else {
            SoundAttractionEvents.scheduleAddGoal(mob, 3, new AttractionGoal(mob, moveSpeed));
        }
        SoundAttractionEvents.scheduleAddGoal(mob, 4, new FollowLeaderGoal(mob, moveSpeed));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Scheduled goals for mob {} of type {}", (Object)mob.m_7755_().getString(), (Object)EntityType.m_20613_((EntityType)mob.m_6095_()));
        }
        if ((level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (initialDelayHasPassed) {
                MobGroupManager.updateGroups(serverLevel);
            }
        }
    }

    private static void addCustomNpcsGoals(final Mob mob) {
        if (mob.f_21345_ == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] CustomNPCs {} has null goalSelector", (Object)mob.m_7755_().getString());
            }
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] CustomNPCs {} existing goals:", (Object)mob.m_7755_().getString());
            mob.f_21345_.m_148105_().forEach(wrapped -> SoundAttractMod.LOGGER.info("  - Priority {}: {}", (Object)wrapped.m_26012_(), (Object)wrapped.m_26015_().getClass().getSimpleName()));
        }
        double moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        boolean hasAttractionGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof AttractionGoal);
        boolean hasLeaderAttractionGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof LeaderAttractionGoal);
        boolean hasFollowerEdgeRelayGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof FollowerEdgeRelayGoal);
        boolean hasFollowLeaderGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof FollowLeaderGoal);
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        int attractionPriority = 0;
        if (smartEdge) {
            if (!hasFollowerEdgeRelayGoal) {
                mob.f_21345_.m_25352_(attractionPriority, (Goal)new FollowerEdgeRelayGoal(mob, moveSpeed));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Added FollowerEdgeRelayGoal to CustomNPCs {}", (Object)mob.m_7755_().getString());
                }
            }
            if (!hasLeaderAttractionGoal) {
                mob.f_21345_.m_25352_(attractionPriority + 1, (Goal)new LeaderAttractionGoal(mob, moveSpeed));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Added LeaderAttractionGoal to CustomNPCs {}", (Object)mob.m_7755_().getString());
                }
            }
        } else {
            if (!hasAttractionGoal) {
                mob.f_21345_.m_25352_(attractionPriority, (Goal)new AttractionGoal(mob, moveSpeed){

                    @Override
                    public boolean m_8036_() {
                        boolean result;
                        boolean bl = result = (mob.m_5448_() == null || !mob.m_5448_().m_6084_()) && super.m_8036_();
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && result) {
                            SoundAttractMod.LOGGER.info("[CustomNPCs] AttractionGoal.canUse() returning true for {}", (Object)mob.m_7755_().getString());
                        }
                        return result;
                    }

                    @Override
                    public boolean m_8045_() {
                        boolean result;
                        boolean bl = result = (mob.m_5448_() == null || !mob.m_5448_().m_6084_()) && super.m_8045_();
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && result) {
                            SoundAttractMod.LOGGER.info("[CustomNPCs] AttractionGoal.canContinueToUse() returning true for {}", (Object)mob.m_7755_().getString());
                        }
                        return result;
                    }
                });
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Added AttractionGoal to CustomNPCs {} at priority {}", (Object)mob.m_7755_().getString(), (Object)attractionPriority);
                }
            }
            if (!hasFollowLeaderGoal) {
                mob.f_21345_.m_25352_(attractionPriority + 2, (Goal)new FollowLeaderGoal(mob, moveSpeed));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Added FollowLeaderGoal to CustomNPCs {}", (Object)mob.m_7755_().getString());
                }
            }
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] CustomNPCs {} goals after adding:", (Object)mob.m_7755_().getString());
                mob.f_21345_.m_148105_().forEach(wrapped -> SoundAttractMod.LOGGER.info("  - Priority {}: {}", (Object)wrapped.m_26012_(), (Object)wrapped.m_26015_().getClass().getSimpleName()));
            }
        }
    }

    private static class GoalDefinition {
        final int priority;
        final Goal goalInstance;
        final Class<? extends Goal> goalClass;

        GoalDefinition(int priority, Goal goalInstance) {
            this.priority = priority;
            this.goalInstance = goalInstance;
            this.goalClass = goalInstance.getClass();
        }
    }
}

