/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.event;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.data.DataDrivenTags;
import com.example.soundattract.event.StealthDetectionEvents;
import com.example.soundattract.los.OptimizedLOS;
import com.example.soundattract.quantified.QuantifiedCacheCompat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="soundattract")
public class FovEvents {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final double BACKSTAB_DAMAGE_MULTIPLIER = 1.2;
    private static FovData CONFIG_DEFAULT_FOV = null;
    private static final Set<EntityType<?>> DEVELOPER_EXCLUSIONS = Set.of(EntityType.f_217015_, EntityType.f_20565_, EntityType.f_20496_);
    private static Map<ResourceLocation, FovData> CONFIG_FOV_CACHE = null;
    private static Set<ResourceLocation> USER_EXCLUSION_CACHE = null;
    private static final ConcurrentHashMap<LosCacheKey, LosCacheEntry> LOS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<LosPairKey, LosPairEntry> LOS_PAIR_CACHE = new ConcurrentHashMap();

    private static void buildCaches() {
        double defaultH = (Double)SoundAttractConfig.COMMON.defaultHorizontalFov.get();
        double defaultV = (Double)SoundAttractConfig.COMMON.defaultVerticalFov.get();
        CONFIG_DEFAULT_FOV = new FovData(defaultH, defaultV);
        LOGGER.info("[FOV Config] Loaded default FOV: {} horizontal, {} vertical.", (Object)defaultH, (Object)defaultV);
        USER_EXCLUSION_CACHE = new HashSet<ResourceLocation>();
        List exclusionList = (List)SoundAttractConfig.COMMON.fovExclusionList.get();
        for (String entry : exclusionList) {
            try {
                ResourceLocation loc = ResourceLocation.m_135820_((String)entry.trim());
                if (loc != null) {
                    USER_EXCLUSION_CACHE.add(loc);
                    continue;
                }
                LOGGER.warn("[FOV Config] Malformed exclusion entry, skipping: " + entry);
            }
            catch (Exception e) {
                LOGGER.error("[FOV Config] Failed to parse exclusion entry: " + entry, (Throwable)e);
            }
        }
        LOGGER.info("[FOV Config] Loaded {} user-defined exclusions.", (Object)USER_EXCLUSION_CACHE.size());
        CONFIG_FOV_CACHE = new HashMap<ResourceLocation, FovData>();
        List overrideList = (List)SoundAttractConfig.COMMON.fovOverrides.get();
        for (String entry : overrideList) {
            try {
                String[] parts = entry.split(",");
                if (parts.length != 3) {
                    LOGGER.warn("[FOV Config] Malformed FOV override, skipping: " + entry);
                    continue;
                }
                ResourceLocation mobId = ResourceLocation.m_135820_((String)parts[0].trim());
                if (mobId == null) {
                    LOGGER.warn("[FOV Config] Malformed mob identifier in override, skipping: " + entry);
                    continue;
                }
                double h = Double.parseDouble(parts[1].trim());
                double v = Double.parseDouble(parts[2].trim());
                CONFIG_FOV_CACHE.put(mobId, new FovData(h, v));
            }
            catch (Exception e) {
                LOGGER.error("[FOV Config] Failed to parse FOV override entry: " + entry, (Throwable)e);
            }
        }
        LOGGER.info("[FOV Config] Loaded {} custom FOV overrides.", (Object)CONFIG_FOV_CACHE.size());
    }

    @SubscribeEvent
    public static void onLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        double distSq;
        double xrayRange;
        if (event.getVisibilityModifier() <= 0.0) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob looker = (Mob)livingEntity;
        Entity target = event.getLookingEntity();
        if (target == null) {
            return;
        }
        boolean debug = (Boolean)SoundAttractConfig.COMMON.debugLogging.get();
        if (debug) {
            SoundAttractMod.LOGGER.info("[LivingVisibilityEvent] {} looking at {} with visibility modifier {}", new Object[]{looker.m_7755_().getString(), target.m_7755_().getString(), event.getVisibilityModifier()});
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableXrayTargeting.get()).booleanValue() && (xrayRange = StealthDetectionEvents.getEffectiveXrayRange(looker)) > 0.0 && (distSq = looker.m_20280_(target)) <= xrayRange * xrayRange) {
            if (debug) {
                SoundAttractMod.LOGGER.info("[XRAY] {} can see {} through walls (range: {}, distSq: {})", new Object[]{looker.m_7755_().getString(), target.m_7755_().getString(), String.format("%.2f", xrayRange), String.format("%.2f", distSq)});
            }
            return;
        }
        if (!FovEvents.isTargetInFov(looker, target, false)) {
            if (debug) {
                SoundAttractMod.LOGGER.info("[LivingVisibilityEvent] {} cannot see {} (FOV check failed)", (Object)looker.m_7755_().getString(), (Object)target.m_7755_().getString());
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onMobHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        Entity attacker = event.getSource().m_7639_();
        if (attacker == null || attacker == mob) {
            return;
        }
        if (!FovEvents.isTargetInFov(mob, attacker, true)) {
            float originalDamage = event.getAmount();
            float newDamage = (float)((double)originalDamage * 1.2);
            event.setAmount(newDamage);
            if (attacker instanceof Player) {
                mob.m_9236_().m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_12313_, mob.m_5720_(), 1.0f, 1.2f);
            }
        }
    }

    public static boolean isTargetInFov(Mob looker, Entity target, boolean checkObstructions) {
        if (CONFIG_FOV_CACHE == null) {
            FovEvents.buildCaches();
        }
        ResourceLocation lookerId = EntityType.m_20613_((EntityType)looker.m_6095_());
        if (DEVELOPER_EXCLUSIONS.contains(looker.m_6095_())) {
            return true;
        }
        if (USER_EXCLUSION_CACHE.contains(lookerId)) {
            return true;
        }
        FovData fov = CONFIG_FOV_CACHE.getOrDefault(lookerId, CONFIG_DEFAULT_FOV);
        if (fov.horizontal() >= 360.0) {
            return true;
        }
        if (checkObstructions && !FovEvents.hasSmartLineOfSight(looker, target)) {
            return false;
        }
        return FovEvents.isWithinFieldOfView(looker, target, fov.horizontal(), fov.vertical());
    }

    public static boolean hasSmartLineOfSight(Mob looker, Entity target) {
        boolean enableOptimized = true;
        try {
            enableOptimized = (Boolean)SoundAttractConfig.COMMON.enableOptimizedLos.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (enableOptimized) {
            return OptimizedLOS.canSee(looker, target);
        }
        return FovEvents.hasSmartLineOfSightLegacy(looker, target);
    }

    private static boolean hasSmartLineOfSightLegacy(Mob looker, Entity target) {
        boolean result;
        LosPairKey pairKey;
        LosPairEntry existing;
        Level level = looker.m_9236_();
        boolean useCache = false;
        int maxEntries = 0;
        try {
            useCache = (Boolean)SoundAttractConfig.COMMON.enableRaycastCache.get();
            maxEntries = (Integer)SoundAttractConfig.COMMON.raycastCacheMaxEntries.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int maxEntriesFinal = maxEntries;
        long now = level.m_46467_();
        String dim = level.m_46472_().m_135782_().toString();
        if (useCache && (existing = LOS_PAIR_CACHE.get(pairKey = new LosPairKey(dim, looker.m_19879_(), target.m_19879_()))) != null && now - existing.gameTime() <= 1L) {
            return existing.result();
        }
        Vec3 eyeToEye = target.m_146892_();
        Vec3 center = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 feet = target.m_20182_().m_82520_(0.0, Math.max(0.1, (double)target.m_20206_() * 0.15), 0.0);
        Vec3 start = looker.m_146892_();
        boolean bl = result = FovEvents.raycastIgnoringNonBlockingCached(level, start, eyeToEye, looker) || FovEvents.raycastIgnoringNonBlockingCached(level, start, center, looker) || FovEvents.raycastIgnoringNonBlockingCached(level, start, feet, looker);
        if (useCache) {
            LosPairKey pairKey2 = new LosPairKey(dim, looker.m_19879_(), target.m_19879_());
            LOS_PAIR_CACHE.put(pairKey2, new LosPairEntry(result, now));
            if (maxEntriesFinal > 0 && LOS_PAIR_CACHE.size() > maxEntriesFinal) {
                Iterator<Map.Entry<LosPairKey, LosPairEntry>> it = LOS_PAIR_CACHE.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<LosPairKey, LosPairEntry> e = it.next();
                    if (now - e.getValue().gameTime() <= 1L) continue;
                    it.remove();
                }
                if (LOS_PAIR_CACHE.size() > maxEntriesFinal) {
                    int toRemove = LOS_PAIR_CACHE.size() - maxEntriesFinal;
                    Iterator<Map.Entry<LosPairKey, LosPairEntry>> it2 = LOS_PAIR_CACHE.entrySet().iterator();
                    for (int i = 0; i < toRemove && it2.hasNext(); ++i) {
                        it2.next();
                        it2.remove();
                    }
                }
            }
        }
        return result;
    }

    private static boolean raycastIgnoringNonBlockingCached(Level level, Vec3 start, Vec3 end, Mob looker) {
        boolean useCache = false;
        long ttlTicks = 2L;
        int maxEntries = 0;
        try {
            useCache = (Boolean)SoundAttractConfig.COMMON.enableRaycastCache.get();
            long cfgTtl = ((Integer)SoundAttractConfig.COMMON.raycastCacheTtlTicks.get()).intValue();
            ttlTicks = Math.max(1L, Math.min(ttlTicks, cfgTtl));
            maxEntries = (Integer)SoundAttractConfig.COMMON.raycastCacheMaxEntries.get();
        }
        catch (Throwable cfgTtl) {
            // empty catch block
        }
        long ttlTicksFinal = ttlTicks;
        int maxEntriesFinal = maxEntries;
        if (!useCache || level == null || start == null || end == null) {
            return FovEvents.raycastIgnoringNonBlockingUncached(level, start, end, looker);
        }
        String dim = level.m_46472_().m_135782_().toString();
        if (QuantifiedCacheCompat.isUsable()) {
            String key = new StringBuilder(96).append(dim).append('|').append(FovEvents.q(start.f_82479_)).append(',').append(FovEvents.q(start.f_82480_)).append(',').append(FovEvents.q(start.f_82481_)).append('|').append(FovEvents.q(end.f_82479_)).append(',').append(FovEvents.q(end.f_82480_)).append(',').append(FovEvents.q(end.f_82481_)).toString();
            Boolean cached = QuantifiedCacheCompat.getCached("soundattract_los_raycast", key, () -> FovEvents.raycastIgnoringNonBlockingUncached(level, start, end, looker), ttlTicksFinal, maxEntriesFinal);
            return cached != null && cached != false;
        }
        long now = level.m_46467_();
        LosCacheKey cacheKey = new LosCacheKey(dim, FovEvents.q(start.f_82479_), FovEvents.q(start.f_82480_), FovEvents.q(start.f_82481_), FovEvents.q(end.f_82479_), FovEvents.q(end.f_82480_), FovEvents.q(end.f_82481_));
        LosCacheEntry existing = LOS_CACHE.get(cacheKey);
        if (existing != null && now - existing.gameTime() <= ttlTicksFinal) {
            return existing.result();
        }
        boolean computed = FovEvents.raycastIgnoringNonBlockingUncached(level, start, end, looker);
        LOS_CACHE.put(cacheKey, new LosCacheEntry(computed, now));
        if (maxEntriesFinal > 0 && LOS_CACHE.size() > maxEntriesFinal) {
            Iterator<Map.Entry<LosCacheKey, LosCacheEntry>> it = LOS_CACHE.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<LosCacheKey, LosCacheEntry> e = it.next();
                if (now - e.getValue().gameTime() <= ttlTicksFinal) continue;
                it.remove();
            }
            if (LOS_CACHE.size() > maxEntriesFinal) {
                int toRemove = LOS_CACHE.size() - maxEntriesFinal;
                Iterator<Map.Entry<LosCacheKey, LosCacheEntry>> it2 = LOS_CACHE.entrySet().iterator();
                for (int i = 0; i < toRemove && it2.hasNext(); ++i) {
                    it2.next();
                    it2.remove();
                }
            }
        }
        return computed;
    }

    private static int q(double v) {
        return (int)Math.round(v * 4.0);
    }

    public static boolean isNonBlockingVisionForLos(BlockState state, Level level, BlockPos pos) {
        return FovEvents.isNonBlockingVision(state, level, pos);
    }

    private static boolean raycastIgnoringNonBlockingUncached(Level level, Vec3 start, Vec3 end, Mob looker) {
        if (level == null || start == null || end == null) {
            return false;
        }
        return OptimizedLOS.hasLineOfSight(level, start, end, looker);
    }

    private static boolean isNonBlockingVision(BlockState state, Level level, BlockPos pos) {
        ResourceLocation id2;
        Boolean open2;
        if (state == null || level == null || pos == null) {
            return false;
        }
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60734_() instanceof DoorBlock) {
            try {
                open2 = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
                if (open2 != null && open2.booleanValue()) {
                    return true;
                }
            }
            catch (Throwable open2) {
                // empty catch block
            }
        }
        if (state.m_60734_() instanceof TrapDoorBlock) {
            try {
                open2 = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
                if (open2 != null && open2.booleanValue()) {
                    return true;
                }
            }
            catch (Throwable open3) {
                // empty catch block
            }
        }
        try {
            if (state.m_204336_(BlockTags.f_13032_) || state.m_60734_() instanceof IronBarsBlock) {
                return false;
            }
        }
        catch (Throwable open3) {
            // empty catch block
        }
        try {
            id2 = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
            boolean inConfig = false;
            if (id2 != null) {
                if (SoundAttractConfig.NON_BLOCKING_VISION_ALLOW_CACHE.isEmpty()) {
                    List list;
                    List list2 = list = SoundAttractConfig.COMMON != null ? (List)SoundAttractConfig.COMMON.nonBlockingVisionAllowList.get() : Collections.emptyList();
                    if (list != null && !list.isEmpty()) {
                        SoundAttractConfig.parseAndCacheNonBlockingVisionAllowList();
                    }
                }
                inConfig = SoundAttractConfig.NON_BLOCKING_VISION_ALLOW_CACHE.contains(id2);
            }
            boolean enableDataDriven = SoundAttractConfig.COMMON != null && (Boolean)SoundAttractConfig.COMMON.enableDataDriven.get() != false;
            boolean inTag = false;
            if (enableDataDriven) {
                try {
                    inTag = state.m_204336_(DataDrivenTags.NON_BLOCKING_VISION);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!enableDataDriven) {
                if (inConfig) {
                    return true;
                }
            } else {
                String priority = (String)SoundAttractConfig.COMMON.datapackPriority.get();
                boolean datapackOverConfig = "datapack_over_config".equalsIgnoreCase(priority);
                if (datapackOverConfig) {
                    if (inTag) {
                        return true;
                    }
                    if (inConfig) {
                        return true;
                    }
                } else {
                    if (inConfig) {
                        return true;
                    }
                    if (inTag) {
                        return true;
                    }
                }
            }
        }
        catch (Throwable id2) {
            // empty catch block
        }
        try {
            String path;
            id2 = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
            String string = path = id2 != null ? id2.m_135815_() : "";
            if (path.contains("glass") && !path.contains("tinted")) {
                return true;
            }
        }
        catch (Throwable id3) {
            // empty catch block
        }
        if (state.m_60734_() instanceof IceBlock || state.m_60713_(Blocks.f_50354_) || state.m_60713_(Blocks.f_50568_)) {
            return true;
        }
        if (state.m_60734_() instanceof FenceBlock || state.m_204336_(BlockTags.f_13039_)) {
            return true;
        }
        try {
            VoxelShape shape = state.m_60742_((BlockGetter)level, pos, CollisionContext.m_82749_());
            if (shape.m_83281_()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!state.m_60831_((BlockGetter)level, pos)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isWithinFieldOfView(Mob looker, Entity target, double horizontalFovDegrees, double verticalFovDegrees) {
        Vec3 targetHorizontal;
        Vec3 lookVector = looker.m_20154_();
        Vec3 toTargetVector = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() / 2.0, 0.0).m_82546_(looker.m_146892_()).m_82541_();
        Vec3 lookHorizontal = new Vec3(lookVector.f_82479_, 0.0, lookVector.f_82481_).m_82541_();
        double dotHorizontal = lookHorizontal.m_82526_(targetHorizontal = new Vec3(toTargetVector.f_82479_, 0.0, toTargetVector.f_82481_).m_82541_());
        double angleHorizontal = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotHorizontal))));
        if (angleHorizontal > horizontalFovDegrees / 2.0) {
            return false;
        }
        double pitchLook = Math.toDegrees(Math.asin(lookVector.f_82480_));
        double pitchTarget = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, toTargetVector.f_82480_))));
        double angleVertical = Math.abs(pitchTarget - pitchLook);
        return angleVertical <= verticalFovDegrees / 2.0;
    }

    private record FovData(double horizontal, double vertical) {
    }

    private record LosPairKey(String dim, int lookerId, int targetId) {
    }

    private record LosPairEntry(boolean result, long gameTime) {
    }

    private record LosCacheKey(String dim, int sx, int sy, int sz, int ex, int ey, int ez) {
    }

    private record LosCacheEntry(boolean result, long gameTime) {
    }
}

