/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.async;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import java.lang.reflect.Method;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="soundattract", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class AsyncManager {
    private static final Queue<Runnable> MAIN_THREAD_QUEUE = new ConcurrentLinkedQueue<Runnable>();
    private static final AtomicBoolean DRAIN_SCHEDULED = new AtomicBoolean(false);
    private static volatile MinecraftServer serverRef;
    private static final ExecutorService FALLBACK_EXECUTOR;
    private static final ScheduledExecutorService TIMER;

    private AsyncManager() {
    }

    public static boolean isQuantifiedAvailable() {
        if (!ModList.get().isLoaded("quantified")) {
            return false;
        }
        try {
            return (Boolean)SoundAttractConfig.COMMON.enableQuantifiedIntegration.get();
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    public static <T> CompletableFuture<T> submit(String taskName, Supplier<T> supplier, Priority priority, boolean threadSafe) {
        if (supplier == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (AsyncManager.isQuantifiedAvailable()) {
            CompletableFuture<T> quantifiedFuture = QuantifiedAsyncBridge.trySubmit(taskName, supplier, priority, threadSafe);
            if (quantifiedFuture != null) {
                return quantifiedFuture;
            }
            SoundAttractMod.LOGGER.debug("[AsyncManager] Quantified submit bridge unavailable or failed for '{}'", (Object)taskName);
        }
        return CompletableFuture.supplyAsync(supplier, FALLBACK_EXECUTOR);
    }

    public static CompletableFuture<Void> submit(String taskName, Runnable task, Priority priority, boolean threadSafe) {
        return AsyncManager.submit(taskName, () -> {
            task.run();
            return null;
        }, priority, threadSafe);
    }

    public static <T> CompletableFuture<T> runLater(String taskName, Supplier<T> supplier, long delayMs, Priority priority, boolean threadSafe) {
        CompletableFuture future = new CompletableFuture();
        long effectiveDelay = Math.max(0L, delayMs);
        TIMER.schedule(() -> {
            try {
                AsyncManager.submit(taskName, supplier, priority, threadSafe).whenComplete((value, throwable) -> {
                    if (throwable != null) {
                        future.completeExceptionally((Throwable)throwable);
                    } else {
                        future.complete(value);
                    }
                });
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }, effectiveDelay, TimeUnit.MILLISECONDS);
        return future;
    }

    public static void syncToMain(Runnable action) {
        if (action == null) {
            return;
        }
        MAIN_THREAD_QUEUE.add(action);
        MinecraftServer server = serverRef;
        if (server != null) {
            AsyncManager.scheduleBudgetedDrain(server);
        }
    }

    public static <T> CompletableFuture<T> callOnMain(Supplier<T> supplier) {
        CompletableFuture future = new CompletableFuture();
        AsyncManager.syncToMain(() -> {
            try {
                future.complete(supplier.get());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        serverRef = event.getServer();
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (MAIN_THREAD_QUEUE.isEmpty()) {
            return;
        }
        AsyncManager.drainBudgeted(event.getServer());
    }

    private static void scheduleBudgetedDrain(MinecraftServer server) {
        if (server == null) {
            return;
        }
        if (!DRAIN_SCHEDULED.compareAndSet(false, true)) {
            return;
        }
        try {
            server.execute(() -> {
                DRAIN_SCHEDULED.set(false);
                AsyncManager.drainBudgeted(server);
                if (!MAIN_THREAD_QUEUE.isEmpty()) {
                    AsyncManager.scheduleBudgetedDrain(server);
                }
            });
        }
        catch (Throwable ignored) {
            DRAIN_SCHEDULED.set(false);
        }
    }

    private static void drainBudgeted(MinecraftServer server) {
        Runnable action;
        if (server == null) {
            return;
        }
        if (MAIN_THREAD_QUEUE.isEmpty()) {
            return;
        }
        long budgetNs = TimeUnit.MICROSECONDS.toNanos(Long.getLong("soundattract.mainqueue.budget_us", 500L));
        int maxTasks = Math.max(1, Integer.getInteger("soundattract.mainqueue.max_tasks", 8));
        long start = System.nanoTime();
        for (int ran = 0; ran < maxTasks && (action = MAIN_THREAD_QUEUE.poll()) != null; ++ran) {
            try {
                action.run();
                continue;
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.error("[AsyncManager] Main thread action failed", t);
            }
            if (System.nanoTime() - start < budgetNs) continue;
            break;
        }
    }

    private static ThreadFactory newNamedDaemonFactory(String prefix) {
        AtomicInteger idx = new AtomicInteger(1);
        return runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName(prefix + "-" + idx.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        };
    }

    static {
        FALLBACK_EXECUTOR = Executors.newFixedThreadPool(Math.max(2, Integer.getInteger("soundattract.async.fallbackThreads", Math.max(2, Runtime.getRuntime().availableProcessors() / 2))), AsyncManager.newNamedDaemonFactory("SoundAttract-Async"));
        TIMER = Executors.newSingleThreadScheduledExecutor(AsyncManager.newNamedDaemonFactory("SoundAttract-Timer"));
    }

    private static final class QuantifiedAsyncBridge {
        private static final Object INIT_LOCK = new Object();
        private static boolean initialized = false;
        private static Class<?> taskClass;
        private static Class<?> builderClass;
        private static Method builderFactory;
        private static Method submitMethod;
        private static Method threadSafeMethod;
        private static Method priorityForegroundMethod;
        private static Method priorityBackgroundMethod;

        private QuantifiedAsyncBridge() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean ensureInit() {
            if (initialized) {
                return submitMethod != null;
            }
            Object object = INIT_LOCK;
            synchronized (object) {
                if (initialized) {
                    return submitMethod != null;
                }
                try {
                    Class<?> apiClass = Class.forName("org.admany.quantified.api.QuantifiedAPI");
                    taskClass = Class.forName("org.admany.quantified.api.model.QuantifiedTask");
                    builderClass = Class.forName("org.admany.quantified.api.model.QuantifiedTask$Builder");
                    builderFactory = taskClass.getMethod("builder", String.class, String.class, Supplier.class);
                    submitMethod = apiClass.getMethod("submit", builderClass);
                    threadSafeMethod = builderClass.getMethod("threadSafe", Boolean.TYPE);
                    priorityForegroundMethod = builderClass.getMethod("priorityForeground", new Class[0]);
                    priorityBackgroundMethod = builderClass.getMethod("priorityBackground", new Class[0]);
                }
                catch (Throwable t) {
                    submitMethod = null;
                }
                initialized = true;
                return submitMethod != null;
            }
        }

        private static <T> CompletableFuture<T> trySubmit(String taskName, Supplier<T> supplier, Priority priority, boolean threadSafe) {
            if (!QuantifiedAsyncBridge.ensureInit()) {
                return null;
            }
            try {
                Object builder = builderFactory.invoke(null, "soundattract", taskName, supplier);
                threadSafeMethod.invoke(builder, threadSafe);
                if (priority == Priority.HIGH) {
                    priorityForegroundMethod.invoke(builder, new Object[0]);
                } else {
                    priorityBackgroundMethod.invoke(builder, new Object[0]);
                }
                return (CompletableFuture)submitMethod.invoke(null, builder);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    public static enum Priority {
        HIGH,
        LOW;

    }
}

