/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.enhancedai.EnhancedAICompat;
import com.example.soundattract.tracking.SoundTracker;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;

public class PickUpAndThrowToSoundGoal
extends Goal {
    private final Mob mob;
    private final TargetingConditions targetingConditions;
    private Mob pickUp;
    private int unreachableTime;
    private int cooldown;
    private SoundTracker.SoundRecord targetSound;

    public PickUpAndThrowToSoundGoal(Mob mob) {
        this.mob = mob;
        this.targetingConditions = TargetingConditions.m_148353_().m_26883_(this.getFollowDistance()).m_26888_(livingEntity -> !livingEntity.m_20159_());
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!((Boolean)SoundAttractConfig.COMMON.enablePickUpAndThrowToSound.get()).booleanValue()) {
            return false;
        }
        if (this.mob.m_20160_()) {
            return false;
        }
        if (--this.cooldown > 0) {
            return false;
        }
        double chance = EnhancedAICompat.getPickUpAndThrowChance(this.mob.m_9236_());
        if (this.mob.m_217043_().m_188500_() >= chance) {
            return false;
        }
        this.targetSound = SoundTracker.findNearestSound(this.mob, this.mob.m_9236_(), this.mob.m_20183_(), this.mob.m_146892_());
        if (this.targetSound == null) {
            return false;
        }
        String canPickUpTagStr = (String)SoundAttractConfig.COMMON.pickUpCanPickUpTag.get();
        if (canPickUpTagStr == null || canPickUpTagStr.isBlank()) {
            return false;
        }
        TagKey canPickUpTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.parse((String)canPickUpTagStr));
        if (!this.mob.m_6095_().m_204039_(canPickUpTag)) {
            return false;
        }
        int minDist = EnhancedAICompat.getPickUpMinDistanceToPickUp();
        double distToSound = Math.sqrt(this.mob.m_20183_().m_123331_((Vec3i)this.targetSound.pos));
        if (distToSound < (double)minDist) {
            return false;
        }
        String canBePickedUpTagStr = (String)SoundAttractConfig.COMMON.pickUpCanBePickedUpTag.get();
        if (canBePickedUpTagStr == null || canBePickedUpTagStr.isBlank()) {
            return false;
        }
        TagKey canBePickedUpTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.parse((String)canBePickedUpTagStr));
        this.targetingConditions.m_26883_(this.getFollowDistance());
        this.pickUp = (Mob)this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(Mob.class, this.mob.m_20191_().m_82400_(this.getFollowDistance()), living -> living.m_6095_().m_204039_(canBePickedUpTag)), this.targetingConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        return this.pickUp != null && this.pickUp.m_6084_();
    }

    public boolean m_8045_() {
        return this.pickUp != null && this.pickUp.m_6084_() && this.targetSound != null && this.targetSound.ticksRemaining > 0;
    }

    public void m_8056_() {
        this.mob.m_21563_().m_148051_((Entity)this.pickUp);
        this.mob.m_21573_().m_26573_();
        this.mob.m_21573_().m_5624_((Entity)this.pickUp, EnhancedAICompat.getPickUpSpeedModifier());
        this.pickUp.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.pickUp = null;
        this.unreachableTime = 0;
        this.targetSound = null;
    }

    protected double getFollowDistance() {
        return this.mob.m_21133_(Attributes.f_22277_);
    }

    public void m_8037_() {
        if (this.targetSound == null || this.targetSound.ticksRemaining <= 0) {
            this.targetSound = SoundTracker.findNearestSound(this.mob, this.mob.m_9236_(), this.mob.m_20183_(), this.mob.m_146892_());
            if (this.targetSound == null) {
                this.m_8041_();
                return;
            }
        }
        if (!this.mob.m_20160_()) {
            this.pickUp.m_21573_().m_26573_();
            if (this.mob.m_21573_().m_26571_()) {
                this.mob.m_21573_().m_5624_((Entity)this.pickUp, EnhancedAICompat.getPickUpSpeedModifier());
            }
            if (this.mob.m_20280_((Entity)this.pickUp) <= 4.0) {
                this.pickUp.m_7998_((Entity)this.mob, false);
                this.cooldown = this.m_183277_(20);
            }
        } else {
            BlockPos soundPos = this.targetSound.pos;
            int maxThrow = EnhancedAICompat.getPickUpMaxDistanceToThrow();
            double distToSoundSq = this.mob.m_20183_().m_123331_((Vec3i)soundPos);
            if (--this.cooldown <= 0 && distToSoundSq <= (double)(maxThrow * maxThrow)) {
                double distanceY = (double)soundPos.m_123342_() + 0.5 - this.pickUp.m_20186_();
                double distanceX = (double)soundPos.m_123341_() + 0.5 - this.pickUp.m_20185_();
                double distanceZ = (double)soundPos.m_123343_() + 0.5 - this.pickUp.m_20189_();
                double distanceXZ = Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
                Vec3 motion = new Vec3(distanceX * 0.1, Mth.m_14008_((double)distanceY, (double)4.0, (double)40.0) / 10.0 + distanceXZ / 100.0, distanceZ * 0.1);
                this.pickUp.m_8127_();
                this.pickUp.m_20256_(motion);
                this.mob.m_5496_(SoundEvents.f_11688_, 3.0f, 1.5f);
                this.cooldown = this.m_183277_(EnhancedAICompat.getPickUpCooldownTicks());
                this.m_8041_();
                return;
            }
        }
        if (++this.unreachableTime > this.m_183277_(120)) {
            this.cooldown = this.m_183277_(EnhancedAICompat.getPickUpCooldownTicks());
            this.m_8041_();
        }
    }
}

