/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.SoundAttractionEvents;
import com.example.soundattract.runtime.DynamicScanCooldownManager;
import com.example.soundattract.worker.WorkSchedulerManager;
import com.example.soundattract.worker.WorkerScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;

public class MobGroupManager {
    private static final Map<ResourceLocation, PerWorldData> worldData = new ConcurrentHashMap<ResourceLocation, PerWorldData>();
    private static final int RELAY_SOUND_TTL = 40;
    private static final int RELAY_SOUND_RATE_LIMIT = 20;

    private static PerWorldData getData(ResourceLocation dimension) {
        return worldData.computeIfAbsent(dimension, k -> new PerWorldData());
    }

    private static boolean submitGroupComputeSnapshot(ServerLevel level) {
        try {
            Set<EntityType<?>> attractedEntityTypes;
            PerWorldData data = MobGroupManager.getData(level.m_46472_().m_135782_());
            Future<?> inFlight = data.inFlightGroupCompute;
            if (inFlight != null) {
                try {
                    if (!inFlight.isDone()) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                data.inFlightGroupCompute = null;
            }
            if ((attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes()) == null || attractedEntityTypes.isEmpty()) {
                return false;
            }
            int simDistChunks = level.m_7654_().m_6846_().m_11312_();
            int simDistBlocks = simDistChunks * 16;
            HashSet mobsSet = new HashSet();
            for (Object player : level.m_6907_()) {
                AABB box = player.m_20191_().m_82400_((double)simDistBlocks);
                List nearbyMobs = level.m_6443_(Mob.class, box, m -> m.m_6084_() && !m.m_213877_() && (attractedEntityTypes.contains(m.m_6095_()) || SoundAttractConfig.getMatchingProfile(m) != null || SoundAttractionEvents.isCustomNpcsMob(m)));
                mobsSet.addAll(nearbyMobs);
            }
            if (mobsSet.isEmpty()) {
                return false;
            }
            ArrayList<WorkerScheduler.MobSnapshot> snapshots = new ArrayList<WorkerScheduler.MobSnapshot>(mobsSet.size());
            for (Mob m2 : mobsSet) {
                snapshots.add(new WorkerScheduler.MobSnapshot(m2.m_20148_(), m2.m_20185_(), m2.m_20186_(), m2.m_20189_(), m2.m_21223_(), m2.m_6084_()));
            }
            WorkerScheduler.ConfigSnapshot cfg = new WorkerScheduler.ConfigSnapshot((Double)SoundAttractConfig.COMMON.leaderGroupRadius.get(), (Integer)SoundAttractConfig.COMMON.maxLeaders.get(), (Integer)SoundAttractConfig.COMMON.maxGroupSize.get(), (Double)SoundAttractConfig.COMMON.leaderSpacingMultiplier.get(), (Integer)SoundAttractConfig.COMMON.numEdgeSectors.get(), (Integer)SoundAttractConfig.COMMON.edgeMobsPerSector.get());
            data.inFlightGroupCompute = WorkSchedulerManager.get().submitGroupCompute(snapshots, cfg, level.m_46472_().m_135782_());
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[MobGroupManager] Submitted async group compute for {} mobs in dimension {}", (Object)snapshots.size(), (Object)level.m_46472_().m_135782_());
            }
            return true;
        }
        catch (Throwable t) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.error("[MobGroupManager] submitGroupComputeSnapshot failed for dimension " + level.m_46472_().m_135782_(), t);
            }
            return false;
        }
    }

    public static void applyGroupResult(ServerLevel level, WorkerScheduler.GroupComputeResult result) {
        if (result == null) {
            return;
        }
        PerWorldData data = MobGroupManager.getData(level.m_46472_().m_135782_());
        HashMap<UUID, Mob> uuidToMob = new HashMap<UUID, Mob>();
        int simDistBlocks = level.m_7654_().m_6846_().m_11312_() * 16;
        for (ServerPlayer player : level.m_6907_()) {
            AABB aABB = player.m_20191_().m_82400_((double)simDistBlocks);
            for (Mob m : level.m_45976_(Mob.class, aABB)) {
                uuidToMob.put(m.m_20148_(), m);
            }
        }
        data.uuidToLeader.clear();
        data.leaders.clear();
        data.deserterUuids.clear();
        data.lastEdgeMobMap.clear();
        HashSet<UUID> leaderUuids = new HashSet<UUID>();
        for (Map.Entry<UUID, UUID> entry : result.mobUuidToLeaderUuid().entrySet()) {
            UUID mobId = entry.getKey();
            UUID leaderId = entry.getValue();
            Mob mob = (Mob)uuidToMob.get(mobId);
            Mob leader = (Mob)uuidToMob.get(leaderId);
            if (mob == null || leader == null) continue;
            data.uuidToLeader.put(mob.m_20148_(), leader);
            if (!leaderId.equals(mobId)) continue;
            leaderUuids.add(leaderId);
        }
        for (UUID uUID : leaderUuids) {
            Mob leader = (Mob)uuidToMob.get(uUID);
            if (leader == null) continue;
            data.leaders.add(new WeakReference<Mob>(leader));
        }
        for (Map.Entry<UUID, Object> entry : result.edgeMobsByLeaderUuid().entrySet()) {
            UUID lid = entry.getKey();
            Mob leader = (Mob)uuidToMob.get(lid);
            if (leader == null) continue;
            HashSet<Mob> edges = new HashSet<Mob>();
            for (UUID mid : (Set)entry.getValue()) {
                Mob mm = (Mob)uuidToMob.get(mid);
                if (mm == null) continue;
                edges.add(mm);
            }
            data.lastEdgeMobMap.put(leader, edges);
        }
        data.deserterUuids.addAll(result.deserterUuids());
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] Applied group result for dimension {}: leaders={}, deserters={}", new Object[]{level.m_46472_().m_135782_(), leaderUuids.size(), data.deserterUuids.size()});
        }
    }

    public static boolean isEdgeMob(Mob mob) {
        PerWorldData data = MobGroupManager.getData(mob.m_9236_().m_46472_().m_135782_());
        Mob leader = MobGroupManager.getLeader(mob);
        if (leader == mob) {
            return false;
        }
        Set<Mob> edgeSet = data.lastEdgeMobMap.get(leader);
        return edgeSet != null && edgeSet.contains(mob);
    }

    private static void cleanupStaleEntries(ServerLevel level) {
        PerWorldData data = MobGroupManager.getData(level.m_46472_().m_135782_());
        data.leaders.removeIf(ref -> {
            Mob mob = (Mob)ref.get();
            return mob == null || mob.m_213877_();
        });
        data.uuidToLeader.values().removeIf(mob -> mob == null || mob.m_213877_());
        data.mobToRelayedSounds.keySet().removeIf(mob -> mob == null || mob.m_213877_());
        data.mobLastRelayTime.keySet().removeIf(mob -> mob == null || mob.m_213877_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateGroups(ServerLevel level) {
        int scanCooldown;
        PerWorldData data = MobGroupManager.getData(level.m_46472_().m_135782_());
        long time = level.m_46467_();
        if (time - data.lastGroupUpdateTime < (long)((Integer)SoundAttractConfig.COMMON.groupUpdateInterval.get()).intValue()) {
            return;
        }
        data.lastGroupUpdateTime = time;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && time % 100L == 0L) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] Updating groups for dimension: {}", (Object)level.m_46472_().m_135782_());
        }
        if ((scanCooldown = DynamicScanCooldownManager.currentScanCooldownTicks) > 0 && (data.lastCleanupTime == -1L || time - data.lastCleanupTime > 10L * (long)scanCooldown)) {
            MobGroupManager.cleanupStaleEntries(level);
            data.lastCleanupTime = time;
        }
        if (MobGroupManager.submitGroupComputeSnapshot(level)) {
            return;
        }
        Set<EntityType<?>> attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        int simDistChunks = level.m_7654_().m_6846_().m_11312_();
        int simDistBlocks = simDistChunks * 16;
        HashSet mobsSet = new HashSet();
        for (Object player : level.m_6907_()) {
            AABB box = player.m_20191_().m_82400_((double)simDistBlocks);
            List nearbyMobs = level.m_45976_(Mob.class, box);
            mobsSet.addAll(nearbyMobs);
        }
        ArrayList<Mob> attractedMobs = new ArrayList<Mob>();
        for (Mob mob : mobsSet) {
            boolean byType = attractedEntityTypes.contains(mob.m_6095_());
            boolean hasProfile = SoundAttractConfig.getMatchingProfile(mob) != null;
            boolean isCustomNpcs = SoundAttractionEvents.isCustomNpcsMob(mob);
            if (!byType && !hasProfile && !isCustomNpcs) continue;
            attractedMobs.add(mob);
        }
        data.uuidToLeader.clear();
        data.leaders.clear();
        data.lastEdgeMobMap.clear();
        data.deserterUuids.clear();
        if (attractedMobs.isEmpty()) {
            return;
        }
        for (Mob m2 : attractedMobs) {
            if (SoundAttractConfig.getMatchingProfile(m2) == null) continue;
            data.leaders.add(new WeakReference<Mob>(m2));
            data.uuidToLeader.put(m2.m_20148_(), m2);
        }
        Collections.shuffle(attractedMobs, new Random(level.m_46467_()));
        double groupRadius = (Double)SoundAttractConfig.COMMON.leaderGroupRadius.get();
        int maxLeaders = (Integer)SoundAttractConfig.COMMON.maxLeaders.get();
        int maxGroupSize = (Integer)SoundAttractConfig.COMMON.maxGroupSize.get();
        double leaderSpacing = groupRadius * (Double)SoundAttractConfig.COMMON.leaderSpacingMultiplier.get();
        HashSet<Mob> assigned = new HashSet<Mob>();
        ArrayList<Mob> leaderList = new ArrayList<Mob>();
        List<WeakReference<Mob>> list = data.leaders;
        synchronized (list) {
            data.leaders.removeIf(ref -> ref.get() == null || ((Mob)ref.get()).m_213877_());
            attractedMobs.sort(Comparator.comparingDouble(m -> -m.m_21223_()));
            for (Mob potentialLeader : attractedMobs) {
                if (data.leaders.size() >= maxLeaders) break;
                if (data.leaders.stream().anyMatch(ref -> ref.get() == potentialLeader)) continue;
                boolean tooCloseToExistingLeader = false;
                for (WeakReference<Mob> leaderRef : data.leaders) {
                    Mob existingLeader = (Mob)leaderRef.get();
                    if (existingLeader == null || !(potentialLeader.m_20280_((Entity)existingLeader) < leaderSpacing * leaderSpacing)) continue;
                    tooCloseToExistingLeader = true;
                    break;
                }
                if (tooCloseToExistingLeader) continue;
                data.leaders.add(new WeakReference<Mob>(potentialLeader));
                data.uuidToLeader.put(potentialLeader.m_20148_(), potentialLeader);
                leaderList.add(potentialLeader);
            }
        }
        HashMap leaderToGroup = new HashMap();
        for (Mob leader : leaderList) {
            ArrayList<Mob> group = new ArrayList<Mob>();
            group.add(leader);
            for (Mob mob : attractedMobs) {
                if (mob == leader || assigned.contains(mob) || !((double)mob.m_20270_((Entity)leader) <= groupRadius) || group.size() >= maxGroupSize) continue;
                group.add(mob);
                assigned.add(mob);
            }
            for (Mob mob : group) {
                data.uuidToLeader.put(mob.m_20148_(), leader);
            }
            leaderToGroup.put(leader, group);
        }
        for (Mob mob : attractedMobs) {
            if (assigned.contains(mob)) continue;
            data.deserterUuids.add(mob.m_20148_());
        }
        for (Mob leader : leaderList) {
            List group = (List)leaderToGroup.get(leader);
            if (group == null) continue;
            int sectors = (Integer)SoundAttractConfig.COMMON.numEdgeSectors.get();
            HashMap<Integer, List> sectorToFarthestList = new HashMap<Integer, List>();
            double leaderX = leader.m_20185_();
            double leaderZ = leader.m_20189_();
            for (Mob m3 : group) {
                if (m3 == leader) continue;
                double dx = m3.m_20185_() - leaderX;
                double dz = m3.m_20189_() - leaderZ;
                double angle = Math.atan2(dz, dx);
                int sector = (int)Math.floor((angle + Math.PI) / (Math.PI * 2) * (double)sectors) % sectors;
                sectorToFarthestList.computeIfAbsent(sector, k -> new ArrayList()).add(m3);
            }
            HashSet<Mob> edgeMobs = new HashSet<Mob>();
            for (Map.Entry entry : sectorToFarthestList.entrySet()) {
                List mobsInSector = (List)entry.getValue();
                mobsInSector.sort((a, b) -> Double.compare(b.m_20270_((Entity)leader), a.m_20270_((Entity)leader)));
                int perSector = (Integer)SoundAttractConfig.COMMON.edgeMobsPerSector.get();
                int edgeCount = Math.min(perSector, mobsInSector.size());
                for (int i = 0; i < edgeCount; ++i) {
                    edgeMobs.add((Mob)mobsInSector.get(i));
                }
            }
            data.lastEdgeMobMap.put(leader, edgeMobs);
        }
    }

    public static void relaySoundToLeader(Mob mob, String soundId, double x, double y, double z, double range, double weight, long timestamp) {
        PerWorldData data = MobGroupManager.getData(mob.m_9236_().m_46472_().m_135782_());
        Mob leader = MobGroupManager.getLeader(mob);
        if (leader == mob) {
            return;
        }
        Long lastRelay = data.mobLastRelayTime.get(mob);
        if (lastRelay != null && timestamp - lastRelay < 20L) {
            return;
        }
        data.mobLastRelayTime.put(mob, timestamp);
        SoundRelay relay = new SoundRelay(soundId, x, y, z, range, weight, timestamp);
        List relays = data.mobToRelayedSounds.computeIfAbsent(leader, k -> new ArrayList());
        if (!relays.contains(relay)) {
            relays.add(relay);
        }
    }

    public static List<SoundRelay> consumeRelayedSounds(Mob leader) {
        PerWorldData data = MobGroupManager.getData(leader.m_9236_().m_46472_().m_135782_());
        List<SoundRelay> relays = data.mobToRelayedSounds.remove(leader);
        if (relays == null) {
            return Collections.emptyList();
        }
        long now = leader.m_9236_().m_46467_();
        relays.removeIf(r -> now - r.timestamp > 40L);
        return relays;
    }

    public static Mob getLeader(Mob mob) {
        PerWorldData data = MobGroupManager.getData(mob.m_9236_().m_46472_().m_135782_());
        return data.uuidToLeader.getOrDefault(mob.m_20148_(), mob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mob getNearestLeader(Mob mob) {
        PerWorldData data = MobGroupManager.getData(mob.m_9236_().m_46472_().m_135782_());
        Mob best = null;
        double bestDistSq = Double.MAX_VALUE;
        List<WeakReference<Mob>> list = data.leaders;
        synchronized (list) {
            data.leaders.removeIf(ref -> ref.get() == null || ((Mob)ref.get()).m_213877_());
            for (WeakReference<Mob> ref2 : data.leaders) {
                double d;
                Mob candidate = (Mob)ref2.get();
                if (candidate == null || candidate == mob || candidate.m_213877_() || !candidate.m_6084_() || !((d = mob.m_20280_((Entity)candidate)) < bestDistSq)) continue;
                bestDistSq = d;
                best = candidate;
            }
        }
        return best;
    }

    public static void promoteToDeserter(Mob mob) {
        PerWorldData data = MobGroupManager.getData(mob.m_9236_().m_46472_().m_135782_());
        data.deserterUuids.add(mob.m_20148_());
    }

    public static boolean isDeserter(Mob mob) {
        PerWorldData data = MobGroupManager.getData(mob.m_9236_().m_46472_().m_135782_());
        return data.deserterUuids.contains(mob.m_20148_());
    }

    private static class PerWorldData {
        final Map<UUID, Mob> uuidToLeader = Collections.synchronizedMap(new HashMap());
        final List<WeakReference<Mob>> leaders = Collections.synchronizedList(new ArrayList());
        final Map<Mob, List<SoundRelay>> mobToRelayedSounds = Collections.synchronizedMap(new WeakHashMap());
        final Map<Mob, Long> mobLastRelayTime = Collections.synchronizedMap(new WeakHashMap());
        final Set<UUID> deserterUuids = Collections.synchronizedSet(new HashSet());
        final Map<Mob, Set<Mob>> lastEdgeMobMap = Collections.synchronizedMap(new HashMap());
        long lastGroupUpdateTime = -1L;
        long lastCleanupTime = -1L;
        volatile Future<?> inFlightGroupCompute;

        private PerWorldData() {
        }
    }

    public static class SoundRelay {
        public final String soundId;
        public final double x;
        public final double y;
        public final double z;
        public final double range;
        public final double weight;
        public final long timestamp;
        public final int hash;

        public SoundRelay(String soundId, double x, double y, double z, double range, double weight, long timestamp) {
            this.soundId = soundId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.range = range;
            this.weight = weight;
            this.timestamp = timestamp;
            this.hash = Objects.hash(soundId, (int)x, (int)y, (int)z, (int)range, (int)(weight * 100.0));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SoundRelay)) {
                return false;
            }
            SoundRelay other = (SoundRelay)o;
            return this.hash == other.hash && Objects.equals(this.soundId, other.soundId) && Math.abs(this.x - other.x) < 0.1 && Math.abs(this.y - other.y) < 0.1 && Math.abs(this.z - other.z) < 0.1 && Math.abs(this.range - other.range) < 0.1 && Math.abs(this.weight - other.weight) < 0.01 && Math.abs(this.timestamp - other.timestamp) < 40L;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

