/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.SoundAttractionEvents;
import com.example.soundattract.event.StealthDetectionEvents;
import com.example.soundattract.runtime.DynamicScanCooldownManager;
import com.example.soundattract.tracking.SoundTracker;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FollowerEdgeRelayGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private BlockPos targetSoundPos;
    private double currentTargetWeight = -1.0;
    private int scanCooldownCounter = 0;
    private long lastSeenSoundSequence = -1L;
    private BlockPos lastPos = null;
    private int stuckTicks = 0;
    private SoundTracker.SoundRecord cachedSound = null;
    private BlockBreakerPosGoal blockBreakerGoal = null;
    private long cacheTick = -1L;
    private SoundTracker.SoundRecord soundResultCache = null;
    private EdgeMobState edgeMobState = null;
    private boolean foundPlayerOrHit = false;
    private int edgeArrivalTicks = 0;
    private static final int EDGE_WAIT_TICKS = 15;
    private Mob cachedReturnLeader = null;
    private int returnLogCooldown = 0;
    private boolean raidScheduled = false;
    private BlockPos lastIssuedNavTarget = null;
    private int repathCooldown = 0;
    private static final int REPATH_COOLDOWN_TICKS = 6;

    public FollowerEdgeRelayGoal(Mob mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private int scanCooldownTicks() {
        return DynamicScanCooldownManager.currentScanCooldownTicks;
    }

    private boolean isMobEligible() {
        Set<EntityType<?>> attractedTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        boolean byType = attractedTypes.contains(this.mob.m_6095_());
        boolean hasProfile = SoundAttractConfig.getMatchingProfile(this.mob) != null;
        boolean isCustomNpcs = SoundAttractionEvents.isCustomNpcsMob(this.mob);
        return byType || hasProfile || isCustomNpcs;
    }

    private void refreshScanCooldownOnNewSoundForCustomNpcs() {
        if (!SoundAttractionEvents.isCustomNpcsMob(this.mob)) {
            return;
        }
        long seq = SoundTracker.getSoundSequence();
        if (seq != this.lastSeenSoundSequence) {
            this.lastSeenSoundSequence = seq;
            this.scanCooldownCounter = 0;
        }
    }

    private double getArrivalDistance() {
        return (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
    }

    private SoundTracker.SoundRecord getCachedNearestSound() {
        long currentTick = this.mob.m_9236_().m_46467_();
        if (this.cacheTick == currentTick) {
            return this.soundResultCache;
        }
        this.cacheTick = currentTick;
        this.soundResultCache = SoundTracker.findNearestSound(this.mob, this.mob.m_9236_(), this.mob.m_20183_(), this.mob.m_146892_(), this.cachedSound != null ? this.cachedSound.soundId : null);
        return this.soundResultCache;
    }

    private void moveToThrottled(BlockPos dest, double speed, boolean force) {
        boolean navDoneOrStuck;
        if (dest == null) {
            return;
        }
        if (force) {
            this.mob.m_21573_().m_26519_((double)dest.m_123341_(), (double)dest.m_123342_(), (double)dest.m_123343_(), speed);
            this.lastIssuedNavTarget = dest;
            this.repathCooldown = 6;
            return;
        }
        boolean destChanged = this.lastIssuedNavTarget == null || !this.lastIssuedNavTarget.equals((Object)dest);
        boolean bl = navDoneOrStuck = this.mob.m_21573_().m_26571_() || this.mob.m_21573_().m_26577_();
        if (this.repathCooldown > 0 && !destChanged && !navDoneOrStuck) {
            --this.repathCooldown;
            return;
        }
        double distSq = dest.m_123331_((Vec3i)this.mob.m_20183_());
        double thresholdSq = 4.0;
        if (destChanged || navDoneOrStuck || distSq > thresholdSq) {
            this.mob.m_21573_().m_26519_((double)dest.m_123341_(), (double)dest.m_123342_(), (double)dest.m_123343_(), speed);
            this.lastIssuedNavTarget = dest;
            this.repathCooldown = 6;
        }
    }

    public boolean m_8036_() {
        if (this.mob.m_20160_() || this.mob.m_5803_()) {
            return false;
        }
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return false;
        }
        if (!this.isMobEligible()) {
            return false;
        }
        this.refreshScanCooldownOnNewSoundForCustomNpcs();
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        if (!smartEdge) {
            return false;
        }
        Mob leader = MobGroupManager.getLeader(this.mob);
        boolean isDeserter = MobGroupManager.isDeserter(this.mob);
        if (leader == this.mob && !isDeserter) {
            return false;
        }
        if (!MobGroupManager.isEdgeMob(this.mob) && !isDeserter) {
            return false;
        }
        if (this.scanCooldownCounter > 0) {
            --this.scanCooldownCounter;
            return false;
        }
        this.scanCooldownCounter = this.scanCooldownTicks();
        SoundTracker.SoundRecord newSound = this.getCachedNearestSound();
        if (newSound == null) {
            return false;
        }
        this.targetSoundPos = newSound.pos;
        this.currentTargetWeight = newSound.weight;
        this.cachedSound = newSound;
        this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
        this.foundPlayerOrHit = false;
        this.edgeArrivalTicks = 0;
        this.cachedReturnLeader = null;
        this.returnLogCooldown = 0;
        this.raidScheduled = false;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] START GOING_TO_SOUND: mob={} leader={} edgeMob={} deserter={} soundPos={} weight={}", new Object[]{this.mob.m_7755_().getString(), leader != null ? leader.m_7755_().getString() : "null", MobGroupManager.isEdgeMob(this.mob), isDeserter, this.targetSoundPos, String.format("%.2f", this.currentTargetWeight)});
        }
        return true;
    }

    public boolean m_8045_() {
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return false;
        }
        if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER) {
            return true;
        }
        if (!this.isMobEligible() || this.mob.m_20160_() || this.mob.m_5803_()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] canContinueToUse -> FALSE (suppressed or ineligible) for mob {}.", (Object)this.mob.m_7755_().getString());
            }
            return false;
        }
        if (this.targetSoundPos == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] canContinueToUse -> FALSE (targetSoundPos null) for mob {}.", (Object)this.mob.m_7755_().getString());
            }
            return false;
        }
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        Mob leader = MobGroupManager.getLeader(this.mob);
        if (leader != this.mob && smartEdge && this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance()) {
            boolean isDeserterHere = MobGroupManager.isDeserter(this.mob);
            if (isDeserterHere) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] Arrived at sound; deserter will NOT return. Ending goal for mob {}.", (Object)this.mob.m_7755_().getString());
                }
                return false;
            }
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] Arrived at sound; holding to return for mob {}.", (Object)this.mob.m_7755_().getString());
            }
            return true;
        }
        SoundTracker.SoundRecord bestSoundNow = this.getCachedNearestSound();
        if (bestSoundNow == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] canContinueToUse -> FALSE (no best sound now) for mob {}.", (Object)this.mob.m_7755_().getString());
            }
            return false;
        }
        if (bestSoundNow.pos.equals((Object)this.targetSoundPos)) {
            this.cachedSound = bestSoundNow;
            this.currentTargetWeight = bestSoundNow.weight;
            return true;
        }
        double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
        if (bestSoundNow.weight > this.currentTargetWeight * switchRatio) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] canContinueToUse -> FALSE (switching to stronger sound {} > {}) for mob {}.", new Object[]{String.format("%.2f", bestSoundNow.weight), String.format("%.2f", this.currentTargetWeight), this.mob.m_7755_().getString()});
            }
            return false;
        }
        return true;
    }

    public void m_8041_() {
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        Mob leader = MobGroupManager.getLeader(this.mob);
        this.mob.m_21573_().m_26573_();
        if (this.mob.m_20142_()) {
            this.mob.m_6858_(false);
        }
        if (leader != this.mob && smartEdge && this.edgeMobState == EdgeMobState.GOING_TO_SOUND) {
            this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] stop(): follower {} transitioning to RETURNING_TO_LEADER.", (Object)this.mob.m_7755_().getString());
            }
            this.edgeArrivalTicks = 0;
        } else {
            this.edgeMobState = null;
        }
        this.foundPlayerOrHit = false;
        this.edgeArrivalTicks = 0;
        this.cachedReturnLeader = null;
        this.returnLogCooldown = 0;
        this.raidScheduled = false;
        this.lastIssuedNavTarget = null;
        this.repathCooldown = 0;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] stop(): mob {} cleanup complete (state reset).", (Object)this.mob.m_7755_().getString());
        }
    }

    public void m_8037_() {
        if (this.blockBreakerGoal != null && this.mob.f_21345_.m_25386_().anyMatch(g -> g.m_26015_() == this.blockBreakerGoal)) {
            double switchRatio;
            SoundTracker.SoundRecord bestPossibleSound = this.getCachedNearestSound();
            if (bestPossibleSound != null && this.cachedSound != null && !this.areSoundsEffectivelySame(bestPossibleSound, this.cachedSound) && bestPossibleSound.weight > this.cachedSound.weight * (switchRatio = ((Double)SoundAttractConfig.COMMON.soundSwitchRatio.get()).doubleValue())) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} found a better sound ({} > {}). Stopping block breaking.", new Object[]{this.mob.m_7755_().getString(), bestPossibleSound.weight, this.cachedSound.weight});
                }
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
                this.m_8041_();
                return;
            }
            if (this.lastPos != null && this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.lastPos)) >= 1.0) {
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
                this.stuckTicks = 0;
                this.lastPos = this.mob.m_20183_();
            }
            return;
        }
        if (this.edgeMobState != EdgeMobState.RETURNING_TO_LEADER) {
            SoundTracker.SoundRecord fresh = this.getCachedNearestSound();
            double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
            if (fresh != null) {
                if (this.targetSoundPos != null && fresh.pos.equals((Object)this.targetSoundPos)) {
                    this.cachedSound = fresh;
                    this.currentTargetWeight = fresh.weight;
                } else {
                    boolean isBetterByWeight = fresh.weight > this.currentTargetWeight * switchRatio;
                    boolean isTieButCloser = false;
                    if (!isBetterByWeight && this.targetSoundPos != null && Math.abs(fresh.weight - this.currentTargetWeight) < 0.001) {
                        double currentDistSq;
                        double freshDistSq = fresh.pos.m_123331_((Vec3i)this.mob.m_20183_());
                        boolean bl = isTieButCloser = freshDistSq < (currentDistSq = this.targetSoundPos.m_123331_((Vec3i)this.mob.m_20183_()));
                    }
                    if (isBetterByWeight || isTieButCloser) {
                        this.targetSoundPos = fresh.pos;
                        this.cachedSound = fresh;
                        this.currentTargetWeight = fresh.weight;
                        this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
                        this.foundPlayerOrHit = false;
                        this.mob.m_21573_().m_26573_();
                        this.lastIssuedNavTarget = null;
                    }
                }
            }
        }
        if (this.targetSoundPos == null && this.edgeMobState != EdgeMobState.RETURNING_TO_LEADER) {
            return;
        }
        if (this.scanCooldownCounter > 0) {
            --this.scanCooldownCounter;
        }
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        Mob leader = MobGroupManager.getLeader(this.mob);
        if (this.lastPos != null && this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.lastPos)) < 1.0) {
            ++this.stuckTicks;
        } else {
            this.stuckTicks = 0;
            if (this.blockBreakerGoal != null) {
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
            }
        }
        if (this.stuckTicks == 0) {
            this.lastPos = this.mob.m_20183_();
        }
        if (this.stuckTicks >= 40 && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && this.stuckTicks == 40) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal DEBUG] {} truly stuck. isStuck(): {}", (Object)this.mob.m_7755_().getString(), (Object)this.mob.m_21573_().m_26577_());
            }
            if (this.blockBreakerGoal == null) {
                BlockPos destination;
                Mob destLeader = this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER ? (this.cachedReturnLeader != null ? this.cachedReturnLeader : leader) : null;
                BlockPos blockPos = destination = this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER && destLeader != null ? destLeader.m_20183_() : this.targetSoundPos;
                if (this.mob.m_21573_().m_26571_()) {
                    if (destination != null && this.mob.m_20183_().m_123331_((Vec3i)destination) > 4.0) {
                        ++this.stuckTicks;
                        if (this.stuckTicks >= 20 && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue() && this.blockBreakerGoal == null) {
                            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER && destLeader != null) {
                                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} returning to leader {} but stuck. Deploying BlockBreakerPosGoal toward leader.", (Object)this.mob.m_7755_().getString(), (Object)destLeader.m_7755_().getString());
                                } else {
                                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} navigation DONE and far from goal. Deploying BlockBreakerPosGoal.", (Object)this.mob.m_7755_().getString());
                                }
                            }
                            double timeMultiplier = (Double)SoundAttractConfig.COMMON.blockBreakingTimeMultiplier.get();
                            boolean toolOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakingToolOnly.get();
                            boolean properTool = (Boolean)SoundAttractConfig.COMMON.blockBreakingProperToolOnly.get();
                            BlockBreakerPosGoal newGoal = new BlockBreakerPosGoal(this.mob, destination, timeMultiplier, toolOnly, properTool, properTool);
                            BlockBreakerManager.scheduleAdd(this.mob, newGoal, 1);
                            this.blockBreakerGoal = newGoal;
                        }
                    } else {
                        this.stuckTicks = 0;
                    }
                } else {
                    this.stuckTicks = 0;
                    if (this.blockBreakerGoal != null) {
                        BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                        this.blockBreakerGoal = null;
                    }
                }
            }
        }
        boolean isDeserter = MobGroupManager.isDeserter(this.mob);
        if (this.edgeMobState != EdgeMobState.RETURNING_TO_LEADER && (!smartEdge || leader == this.mob && !isDeserter)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal DEBUG] Fallback direct move to sound for {} (leader==mob: {}, smartEdge: {}, deserter: {}).", new Object[]{this.mob.m_7755_().getString(), leader == this.mob, smartEdge, isDeserter});
            }
            this.moveToThrottled(this.targetSoundPos, this.moveSpeed, false);
            return;
        }
        if (this.edgeMobState == null) {
            this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
            this.moveToThrottled(this.targetSoundPos, this.moveSpeed, true);
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("Follower {} (leader: {}) starting to move to sound at {} (EdgeMobState: GOING_TO_SOUND)", new Object[]{this.mob.m_7755_().getString(), leader.m_7755_().getString(), this.targetSoundPos});
            }
        }
        if (this.edgeMobState == EdgeMobState.GOING_TO_SOUND) {
            this.moveToThrottled(this.targetSoundPos, this.moveSpeed, false);
            if (StealthDetectionEvents.consumeSuppressedEdgeDetection(this.mob)) {
                Mob chosenLeaderSupp;
                this.foundPlayerOrHit = true;
                if (!MobGroupManager.isDeserter(this.mob) && !this.raidScheduled) {
                    Mob raidLeader = MobGroupManager.getLeader(this.mob);
                    boolean usedFallback = false;
                    if (raidLeader == this.mob) {
                        raidLeader = MobGroupManager.getNearestLeader(this.mob);
                        usedFallback = true;
                    }
                    if (raidLeader != null && !RaidManager.isRaidTicking(raidLeader) && !RaidManager.isRaidAdvancing(raidLeader)) {
                        RaidManager.scheduleRaid(raidLeader, this.targetSoundPos, this.mob.m_9236_().m_46467_());
                        this.raidScheduled = true;
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            if (usedFallback) {
                                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} consumed suppression signal and scheduled RAID for nearest leader {} at {} (fallback, no immediate relay).", new Object[]{this.mob.m_7755_().getString(), raidLeader.m_7755_().getString(), this.targetSoundPos});
                            } else {
                                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} consumed suppression signal and scheduled RAID for leader {} at {} (no immediate relay).", new Object[]{this.mob.m_7755_().getString(), raidLeader.m_7755_().getString(), this.targetSoundPos});
                            }
                        }
                    } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} suppression signal but no suitable leader found to schedule RAID.", (Object)this.mob.m_7755_().getString());
                    }
                }
                this.mob.m_21573_().m_26573_();
                if (this.blockBreakerGoal != null) {
                    BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                    this.blockBreakerGoal = null;
                }
                if ((chosenLeaderSupp = MobGroupManager.getLeader(this.mob)) == this.mob) {
                    chosenLeaderSupp = MobGroupManager.getNearestLeader(this.mob);
                }
                this.cachedReturnLeader = chosenLeaderSupp;
                this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
                this.lastIssuedNavTarget = null;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    if (this.cachedReturnLeader != null) {
                        SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} suppression signal -> RETURNING_TO_LEADER (leader: {}).", (Object)this.mob.m_7755_().getString(), (Object)this.cachedReturnLeader.m_7755_().getString());
                    } else {
                        SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} suppression signal but no leader to return to.", (Object)this.mob.m_7755_().getString());
                    }
                }
                this.edgeArrivalTicks = 0;
                this.returnLogCooldown = 0;
                return;
            }
            if (this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance()) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("Follower {} arrived at sound location {}. Waiting for {} ticks.", new Object[]{this.mob.m_7755_().getString(), this.targetSoundPos, 15});
                }
                ++this.edgeArrivalTicks;
                if (this.edgeArrivalTicks >= 15 || this.foundPlayerOrHit) {
                    Mob chosenLeader;
                    if (this.foundPlayerOrHit && !MobGroupManager.isDeserter(this.mob)) {
                        Mob raidLeader = MobGroupManager.getLeader(this.mob);
                        boolean usedFallbackArr = false;
                        if (raidLeader == this.mob) {
                            raidLeader = MobGroupManager.getNearestLeader(this.mob);
                            usedFallbackArr = true;
                        }
                        if (!(raidLeader == null || this.raidScheduled || RaidManager.isRaidTicking(raidLeader) || RaidManager.isRaidAdvancing(raidLeader))) {
                            RaidManager.scheduleRaid(raidLeader, this.targetSoundPos, this.mob.m_9236_().m_46467_());
                            this.raidScheduled = true;
                            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                if (usedFallbackArr) {
                                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} scheduled RAID for nearest leader {} at {} (arrival-phase, no immediate relay).", new Object[]{this.mob.m_7755_().getString(), raidLeader.m_7755_().getString(), this.targetSoundPos});
                                } else {
                                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} scheduled RAID for leader {} at {} (arrival-phase, no immediate relay).", new Object[]{this.mob.m_7755_().getString(), raidLeader.m_7755_().getString(), this.targetSoundPos});
                                }
                            }
                        } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} arrival-phase but no suitable leader found to schedule RAID.", (Object)this.mob.m_7755_().getString());
                        }
                    }
                    if (MobGroupManager.isDeserter(this.mob)) {
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} is a deserter; will NOT return after arrival. Ending goal.", (Object)this.mob.m_7755_().getString());
                        }
                        this.targetSoundPos = null;
                        this.edgeMobState = null;
                        this.cachedReturnLeader = null;
                        return;
                    }
                    this.mob.m_21573_().m_26573_();
                    if (this.blockBreakerGoal != null) {
                        BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                        this.blockBreakerGoal = null;
                    }
                    if ((chosenLeader = MobGroupManager.getLeader(this.mob)) == this.mob) {
                        chosenLeader = MobGroupManager.getNearestLeader(this.mob);
                    }
                    this.cachedReturnLeader = chosenLeader;
                    this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
                    this.lastIssuedNavTarget = null;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        if (this.cachedReturnLeader != null) {
                            SoundAttractMod.LOGGER.info("Follower {} transitioning to RETURNING_TO_LEADER (leader: {}).", (Object)this.mob.m_7755_().getString(), (Object)this.cachedReturnLeader.m_7755_().getString());
                        } else {
                            SoundAttractMod.LOGGER.info("Follower {} attempted to return but no leader found (deserter with no leaders in world).", (Object)this.mob.m_7755_().getString());
                        }
                    }
                    this.edgeArrivalTicks = 0;
                    this.returnLogCooldown = 0;
                    return;
                }
            }
        } else if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER) {
            Mob returnLeader;
            if (MobGroupManager.isDeserter(this.mob)) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} is a deserter but entered RETURNING_TO_LEADER; aborting return.", (Object)this.mob.m_7755_().getString());
                }
                if (this.mob.m_20142_()) {
                    this.mob.m_6858_(false);
                }
                this.targetSoundPos = null;
                this.edgeMobState = null;
                this.cachedReturnLeader = null;
                this.lastIssuedNavTarget = null;
                return;
            }
            Mob mob = this.cachedReturnLeader != null ? this.cachedReturnLeader : (returnLeader = leader != this.mob ? leader : MobGroupManager.getNearestLeader(this.mob));
            if (returnLeader != null && !returnLeader.m_213877_() && !returnLeader.m_21224_()) {
                if (!this.mob.m_20142_()) {
                    this.mob.m_6858_(true);
                }
                double sprintMult = (Double)SoundAttractConfig.COMMON.groupSprintMultiplier.get();
                this.moveToThrottled(returnLeader.m_20183_(), this.moveSpeed * sprintMult, false);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    if (this.returnLogCooldown <= 0) {
                        double distSq = this.mob.m_20280_((Entity)returnLeader);
                        boolean navDone = this.mob.m_21573_().m_26571_();
                        boolean navStuck = this.mob.m_21573_().m_26577_();
                        SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal DEBUG] Returning: mob={} pos=({}, {}, {}) leader={} leaderPos=({}, {}, {}) distSq={} navDone={} navStuck={} cachedLeader={}", new Object[]{this.mob.m_7755_().getString(), String.format("%.1f", this.mob.m_20185_()), String.format("%.1f", this.mob.m_20186_()), String.format("%.1f", this.mob.m_20189_()), returnLeader.m_7755_().getString(), String.format("%.1f", returnLeader.m_20185_()), String.format("%.1f", returnLeader.m_20186_()), String.format("%.1f", returnLeader.m_20189_()), String.format("%.1f", distSq), navDone, navStuck, this.cachedReturnLeader != null});
                        this.returnLogCooldown = 20;
                    } else {
                        --this.returnLogCooldown;
                    }
                }
                double returnArrive = (Double)SoundAttractConfig.COMMON.leaderReturnArrivalDistance.get();
                if (this.mob.m_20280_((Entity)returnLeader) < returnArrive * returnArrive) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("Follower {} reached leader {}. Stopping edge relay goal (will re-evaluate).", (Object)this.mob.m_7755_().getString(), (Object)returnLeader.m_7755_().getString());
                    }
                    if (this.mob.m_20142_()) {
                        this.mob.m_6858_(false);
                    }
                    this.targetSoundPos = null;
                    this.edgeMobState = null;
                    this.cachedReturnLeader = null;
                    this.lastIssuedNavTarget = null;
                    this.returnLogCooldown = 0;
                    return;
                }
            } else {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("Follower {} lost its leader while returning. Stopping edge relay goal.", (Object)this.mob.m_7755_().getString());
                }
                if (this.mob.m_20142_()) {
                    this.mob.m_6858_(false);
                }
                this.targetSoundPos = null;
                this.edgeMobState = null;
                this.cachedReturnLeader = null;
                this.lastIssuedNavTarget = null;
                return;
            }
        }
        if (this.edgeMobState != EdgeMobState.RETURNING_TO_LEADER && this.mob.m_20142_()) {
            this.mob.m_6858_(false);
        }
    }

    private boolean areSoundsEffectivelySame(SoundTracker.SoundRecord s1, SoundTracker.SoundRecord s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.pos.equals((Object)s2.pos) && s1.soundId != null && s1.soundId.equals(s2.soundId) && Math.abs(s1.range - s2.range) < 0.1 && Math.abs(s1.weight - s2.weight) < 0.01;
    }

    private static enum EdgeMobState {
        GOING_TO_SOUND,
        RETURNING_TO_LEADER;

    }
}

