/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.LeaderAttractionGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.config.SoundAttractConfig;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Random;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class FollowLeaderGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private Mob leader;
    private AttractionGoal leaderAttractionGoal = null;
    private Goal leaderPursuitGoal = null;
    private Vec3 lastPos = null;
    private int stuckTicks = 0;
    private int stuckThreshold;
    private int dynamicTickCounter;
    private Vec3 lastRandomDest;
    private boolean hasPickedDest;
    private boolean isSpreadingOut;
    private BlockPos lastAnchorPos;

    public FollowLeaderGoal(Mob mob, double moveSpeed) {
        this.stuckThreshold = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
        this.dynamicTickCounter = 0;
        this.lastRandomDest = null;
        this.hasPickedDest = false;
        this.isSpreadingOut = false;
        this.lastAnchorPos = null;
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private double getGroupDistance() {
        return (Double)SoundAttractConfig.COMMON.groupDistance.get();
    }

    public boolean m_8036_() {
        AttractionGoal ag;
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return false;
        }
        this.leader = MobGroupManager.getLeader(this.mob);
        if (this.leader == null || this.leader == this.mob) {
            return false;
        }
        if (!this.leader.m_6084_()) {
            return false;
        }
        if (RaidManager.isRaidTicking(this.leader)) {
            return true;
        }
        if (RaidManager.isRaidAdvancing(this.leader)) {
            return true;
        }
        if (this.mob.m_20280_((Entity)this.leader) > this.getGroupDistance() * this.getGroupDistance()) {
            return false;
        }
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        if (smartEdge && MobGroupManager.isEdgeMob(this.mob)) {
            return false;
        }
        this.leaderAttractionGoal = null;
        this.leaderPursuitGoal = null;
        this.leader.f_21345_.m_25386_().forEach(goal -> {
            if (this.leaderPursuitGoal == null) {
                Goal patt2283$temp = goal.m_26015_();
                if (patt2283$temp instanceof AttractionGoal) {
                    AttractionGoal ag;
                    this.leaderAttractionGoal = ag = (AttractionGoal)patt2283$temp;
                    this.leaderPursuitGoal = ag;
                } else {
                    Goal patt2451$temp = goal.m_26015_();
                    if (patt2451$temp instanceof LeaderAttractionGoal) {
                        LeaderAttractionGoal lag = (LeaderAttractionGoal)patt2451$temp;
                        this.leaderPursuitGoal = lag;
                    }
                }
            }
        });
        if (this.leaderPursuitGoal == null) {
            return false;
        }
        Goal goal2 = this.leaderPursuitGoal;
        return !(goal2 instanceof AttractionGoal) || (ag = (AttractionGoal)goal2).isPursuingSound();
    }

    public boolean m_8045_() {
        AttractionGoal ag;
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return false;
        }
        if (this.leader == null || !this.leader.m_6084_()) {
            return false;
        }
        if (RaidManager.isRaidTicking(this.leader)) {
            return true;
        }
        if (RaidManager.isRaidAdvancing(this.leader)) {
            BlockPos raidTarget = RaidManager.getRaidTarget(this.leader);
            if (raidTarget == null) {
                return false;
            }
            double arrivalDistance = (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
            return !(this.mob.m_20183_().m_123331_((Vec3i)raidTarget) < (arrivalDistance + 2.0) * (arrivalDistance + 2.0));
        }
        if (this.mob.m_20280_((Entity)this.leader) > this.getGroupDistance() * this.getGroupDistance()) {
            return false;
        }
        this.leaderAttractionGoal = null;
        this.leaderPursuitGoal = StreamSupport.stream(this.leader.f_21345_.m_25386_().spliterator(), false).map(WrappedGoal::m_26015_).filter(g -> g instanceof AttractionGoal || g instanceof LeaderAttractionGoal).findFirst().orElse(null);
        if (this.leaderPursuitGoal == null) {
            return false;
        }
        Goal goal = this.leaderPursuitGoal;
        return !(goal instanceof AttractionGoal) || (ag = (AttractionGoal)goal).isPursuingSound();
    }

    public void m_8037_() {
        double distToSound;
        AttractionGoal ag;
        if (this.leader == null) {
            return;
        }
        boolean debug = (Boolean)SoundAttractConfig.COMMON.debugLogging.get();
        if (RaidManager.isRaidTicking(this.leader)) {
            if (debug) {
                SoundAttractMod.LOGGER.info("[FollowLeaderGoal][RAID Rally] Mob {} rallying to leader {}", (Object)this.mob.m_7755_().getString(), (Object)this.leader.m_7755_().getString());
            }
            if (!this.mob.m_20142_()) {
                this.mob.m_6858_(true);
            }
            double sprintMult = (Double)SoundAttractConfig.COMMON.groupSprintMultiplier.get();
            this.mob.m_21573_().m_26519_(this.leader.m_20185_(), this.leader.m_20186_(), this.leader.m_20189_(), this.moveSpeed * sprintMult);
            return;
        }
        if (RaidManager.isRaidAdvancing(this.leader)) {
            int scanCooldown = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
            int updateInterval = Math.max(1, scanCooldown / 2);
            this.dynamicTickCounter = (this.dynamicTickCounter + 1) % updateInterval;
            if (this.dynamicTickCounter != 0) {
                return;
            }
            BlockPos raidTarget = RaidManager.getRaidTarget(this.leader);
            if (raidTarget == null) {
                return;
            }
            double arrivalDistance = (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
            if (!this.mob.m_20142_()) {
                this.mob.m_6858_(true);
            }
            if (!this.hasPickedDest) {
                Random rand = new Random(this.mob.m_20148_().hashCode() ^ raidTarget.hashCode());
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double radius = arrivalDistance * Math.sqrt(rand.nextDouble());
                double offsetX = Math.cos(angle) * radius;
                double offsetZ = Math.sin(angle) * radius;
                int destX = raidTarget.m_123341_() + (int)Math.floor(offsetX);
                int destZ = raidTarget.m_123343_() + (int)Math.floor(offsetZ);
                int groundY = this.mob.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destX, destZ);
                double finalX = (double)destX + 0.5;
                double finalY = groundY;
                double finalZ = (double)destZ + 0.5;
                this.lastRandomDest = new Vec3(finalX, finalY, finalZ);
                this.hasPickedDest = true;
                if (debug) {
                    SoundAttractMod.LOGGER.info("[FollowLeaderGoal][RAID Advance] Mob {} advancing to raid target area near {}", (Object)this.mob.m_7755_().getString(), (Object)raidTarget);
                }
            }
            if (this.lastRandomDest != null) {
                Vec3 curPos = this.mob.m_20182_();
                if (curPos.m_82557_(this.lastRandomDest) > 2.25) {
                    double sprintMult = (Double)SoundAttractConfig.COMMON.groupSprintMultiplier.get();
                    this.mob.m_21573_().m_26519_(this.lastRandomDest.f_82479_, this.lastRandomDest.f_82480_, this.lastRandomDest.f_82481_, this.moveSpeed * sprintMult);
                }
                if (this.lastPos != null && curPos.m_82557_(this.lastPos) < 0.04) {
                    ++this.stuckTicks;
                    if (this.stuckTicks > this.stuckThreshold) {
                        this.hasPickedDest = false;
                        this.stuckTicks = 0;
                    }
                } else {
                    this.stuckTicks = 0;
                }
                this.lastPos = curPos;
            }
            return;
        }
        if (this.leaderPursuitGoal == null) {
            return;
        }
        Goal updateInterval = this.leaderPursuitGoal;
        if (updateInterval instanceof AttractionGoal && !(ag = (AttractionGoal)updateInterval).isPursuingSound()) {
            return;
        }
        if (debug) {
            SoundAttractMod.LOGGER.info("[FollowLeaderGoal] Mob {} following leader {} (leader is pursuing sound)", (Object)this.mob.m_7755_().getString(), (Object)this.leader.m_7755_().getString());
        }
        int scanCooldown = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
        int updateInterval2 = Math.max(1, scanCooldown / 2);
        this.dynamicTickCounter = (this.dynamicTickCounter + 1) % updateInterval2;
        if (this.dynamicTickCounter != 0) {
            return;
        }
        BlockPos soundPos = null;
        double soundWeight = -1.0;
        try {
            Goal pursuit;
            Object object = pursuit = this.leaderPursuitGoal != null ? this.leaderPursuitGoal : this.leaderAttractionGoal;
            if (pursuit == null) {
                return;
            }
            Field f = pursuit.getClass().getDeclaredField("targetSoundPos");
            f.setAccessible(true);
            soundPos = (BlockPos)f.get(pursuit);
            try {
                Field w = pursuit.getClass().getDeclaredField("currentTargetWeight");
                w.setAccessible(true);
                Object val = w.get(pursuit);
                if (val instanceof Number) {
                    Number n = (Number)val;
                    soundWeight = n.doubleValue();
                }
            }
            catch (Exception w) {}
        }
        catch (Exception pursuit) {
            // empty catch block
        }
        if (soundPos == null) {
            return;
        }
        double arrivalDistance = (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
        if (this.lastAnchorPos == null || !this.lastAnchorPos.equals(soundPos)) {
            this.lastAnchorPos = soundPos;
            this.hasPickedDest = false;
            this.lastRandomDest = null;
            this.isSpreadingOut = false;
            this.stuckTicks = 0;
        }
        double minWeightToSpreadOut = (Double)SoundAttractConfig.COMMON.followLeaderMinSoundWeightToSpreadOut.get();
        if (!this.isSpreadingOut && soundPos != null && (distToSound = this.mob.m_20275_((double)soundPos.m_123341_() + 0.5, (double)soundPos.m_123342_(), (double)soundPos.m_123343_() + 0.5)) <= (arrivalDistance + 2.0) * (arrivalDistance + 2.0) && soundWeight >= minWeightToSpreadOut) {
            this.isSpreadingOut = true;
            this.hasPickedDest = false;
            this.lastRandomDest = null;
            if (debug) {
                SoundAttractMod.LOGGER.info("[FollowLeaderGoal] Mob {} reached sound location at {}, starting to spread", (Object)this.mob.m_7755_().getString(), (Object)soundPos);
            }
        }
        if (!this.isSpreadingOut && this.lastRandomDest != null && this.mob.m_20182_().m_82557_(this.lastRandomDest) <= 2.25 && soundWeight >= minWeightToSpreadOut) {
            this.isSpreadingOut = true;
            this.hasPickedDest = false;
            this.lastRandomDest = null;
        }
        if (!this.hasPickedDest) {
            if (this.isSpreadingOut) {
                int dirIdx = Math.floorMod(this.mob.m_20148_().hashCode() ^ soundPos.hashCode(), 4);
                int dx = 0;
                int dz = 0;
                switch (dirIdx) {
                    case 0: {
                        dx = 1;
                        break;
                    }
                    case 1: {
                        dx = -1;
                        break;
                    }
                    case 2: {
                        dz = 1;
                        break;
                    }
                    default: {
                        dz = -1;
                    }
                }
                double spreadDistance = (Double)SoundAttractConfig.COMMON.followLeaderSpreadOutDistance.get();
                if (spreadDistance <= 0.0) {
                    spreadDistance = Math.max(8.0, arrivalDistance * 2.0);
                }
                int step = (int)Math.round(spreadDistance);
                int destX = soundPos.m_123341_() + dx * step;
                int destZ = soundPos.m_123343_() + dz * step;
                int groundY = this.mob.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destX, destZ);
                this.lastRandomDest = new Vec3((double)destX + 0.5, (double)groundY, (double)destZ + 0.5);
                this.hasPickedDest = true;
            } else {
                Random rand = new Random(this.mob.m_20148_().hashCode() ^ soundPos.hashCode());
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double radius = arrivalDistance * Math.sqrt(rand.nextDouble());
                double offsetX = Math.cos(angle) * radius;
                double offsetZ = Math.sin(angle) * radius;
                int destX = soundPos.m_123341_() + (int)Math.floor(offsetX);
                int destZ = soundPos.m_123343_() + (int)Math.floor(offsetZ);
                int groundY = this.mob.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destX, destZ);
                double finalX = (double)destX + 0.5;
                double finalY = groundY;
                double finalZ = (double)destZ + 0.5;
                this.lastRandomDest = new Vec3(finalX, finalY, finalZ);
                this.hasPickedDest = true;
            }
        }
        if (this.lastRandomDest != null) {
            Vec3 curPos = this.mob.m_20182_();
            if (curPos.m_82557_(this.lastRandomDest) > 2.25) {
                this.mob.m_21573_().m_26519_(this.lastRandomDest.f_82479_, this.lastRandomDest.f_82480_, this.lastRandomDest.f_82481_, this.moveSpeed);
            }
            if (this.lastPos != null && curPos.m_82557_(this.lastPos) < 0.04) {
                ++this.stuckTicks;
                if (this.stuckTicks > this.stuckThreshold) {
                    this.hasPickedDest = false;
                    this.stuckTicks = 0;
                }
            } else {
                this.stuckTicks = 0;
            }
            this.lastPos = curPos;
        }
        if (!RaidManager.isRaidTicking(this.leader) && !RaidManager.isRaidAdvancing(this.leader) && this.mob.m_20142_()) {
            this.mob.m_6858_(false);
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        if (this.mob.m_20142_()) {
            this.mob.m_6858_(false);
        }
        this.leader = null;
        this.hasPickedDest = false;
        this.lastRandomDest = null;
        this.isSpreadingOut = false;
        this.lastAnchorPos = null;
    }

    public BlockPos getTargetSoundPos() {
        return this.lastAnchorPos;
    }
}

