/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.config.ConfigHelper;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.enchantment.ModEnchantments;
import com.example.soundattract.event.FovEvents;
import com.example.soundattract.event.StealthDetectionEvents;
import com.example.soundattract.event.client.SoundAttractClientEvents;
import com.example.soundattract.integration.tacz.TaczIntegrationHandler;
import com.example.soundattract.integration.vanilla.VanillaIntegrationEvents;
import com.example.soundattract.integration.voicechat.PlasmoVoiceBootstrap;
import com.example.soundattract.loot.ModLootModifiers;
import com.example.soundattract.network.SoundAttractNetwork;
import com.example.soundattract.quantified.QuantifiedIntegration;
import com.example.soundattract.worker.WorkSchedulerManager;
import com.mojang.logging.LogUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="soundattract")
public class SoundAttractMod {
    public static final String MOD_ID = "soundattract";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SoundAttractMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModEnchantments.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(SoundAttractMod::onClientSetup);
        ConfigHelper.register();
        MinecraftForge.EVENT_BUS.register((Object)new FovEvents());
        MinecraftForge.EVENT_BUS.register((Object)new StealthDetectionEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlasmoVoiceBootstrap());
        MinecraftForge.EVENT_BUS.register((Object)new VanillaIntegrationEvents());
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SoundAttractConfig.bakeConfig();
            WorkSchedulerManager.refresh();
            SoundAttractNetwork.register();
            QuantifiedIntegration.bootstrap();
        });
        event.enqueueWork(this::handleTaczIntegration);
    }

    private void handleTaczIntegration() {
        if (ModList.get().isLoaded("tacz") && SoundAttractConfig.TACZ_ENABLED_CACHE) {
            LOGGER.info("Tacz mod found and integration is enabled. Registering event listeners.");
            try {
                TaczIntegrationHandler.register();
            }
            catch (NoClassDefFoundError e) {
                LOGGER.error("Failed to register Tacz integration events. The Tacz API might be missing or has changed.", (Throwable)e);
            }
        } else {
            LOGGER.info("Tacz integration is disabled or mod not found.");
        }
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (ModList.get().isLoaded("voicechat")) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    LOGGER.info("[SoundAttractMod] Registering VoiceChat integration on client setup");
                }
                SoundAttractClientEvents.registerVoiceChatIntegration();
            } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                LOGGER.info("[SoundAttractMod] VoiceChat mod not present; skipping integration");
            }
        });
    }
}

