/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.sound;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.util.sound.SoundScape;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010 \u001a\u00020\u001f\u0012\u0006\u0010&\u001a\u00020\u0011\u00a2\u0006\u0004\b)\u0010*B1\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010 \u001a\u00020\u001f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010&\u001a\u00020\u0011\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b)\u0010+J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u0013\u001a\u0004\b'\u0010\u0015\"\u0004\b(\u0010\u0017\u00a8\u0006,"}, d2={"Lorg/valkyrienskies/clockwork/util/sound/RepeatingSound;", "", "", "tick", "()V", "Lnet/minecraft/sounds/SoundEvent;", "soundEvent", "Lnet/minecraft/sounds/SoundEvent;", "getSoundEvent", "()Lnet/minecraft/sounds/SoundEvent;", "setSoundEvent", "(Lnet/minecraft/sounds/SoundEvent;)V", "Lnet/minecraft/sounds/SoundSource;", "soundSource", "Lnet/minecraft/sounds/SoundSource;", "getSoundSource", "()Lnet/minecraft/sounds/SoundSource;", "", "sharedPitch", "F", "getSharedPitch", "()F", "setSharedPitch", "(F)V", "", "repeatDelay", "I", "getRepeatDelay", "()I", "setRepeatDelay", "(I)V", "Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "scape", "Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "getScape", "()Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "setScape", "(Lorg/valkyrienskies/clockwork/util/sound/SoundScape;)V", "relativeVolume", "getRelativeVolume", "setRelativeVolume", "<init>", "(Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FILorg/valkyrienskies/clockwork/util/sound/SoundScape;F)V", "(Lnet/minecraft/sounds/SoundEvent;Lorg/valkyrienskies/clockwork/util/sound/SoundScape;FFI)V", "clockwork"})
public final class RepeatingSound {
    @NotNull
    private SoundEvent soundEvent;
    @NotNull
    private final SoundSource soundSource;
    private float sharedPitch;
    private int repeatDelay;
    @NotNull
    private SoundScape scape;
    private float relativeVolume;

    public RepeatingSound(@NotNull SoundEvent soundEvent, @NotNull SoundSource soundSource, float sharedPitch, int repeatDelay, @NotNull SoundScape scape, float relativeVolume) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"soundEvent");
        Intrinsics.checkNotNullParameter((Object)soundSource, (String)"soundSource");
        Intrinsics.checkNotNullParameter((Object)scape, (String)"scape");
        this.soundEvent = soundEvent;
        this.soundSource = soundSource;
        this.sharedPitch = sharedPitch;
        this.repeatDelay = repeatDelay;
        this.scape = scape;
        this.relativeVolume = relativeVolume;
    }

    @NotNull
    public final SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public final void setSoundEvent(@NotNull SoundEvent soundEvent) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"<set-?>");
        this.soundEvent = soundEvent;
    }

    @NotNull
    public final SoundSource getSoundSource() {
        return this.soundSource;
    }

    public final float getSharedPitch() {
        return this.sharedPitch;
    }

    public final void setSharedPitch(float f) {
        this.sharedPitch = f;
    }

    public final int getRepeatDelay() {
        return this.repeatDelay;
    }

    public final void setRepeatDelay(int n) {
        this.repeatDelay = n;
    }

    @NotNull
    public final SoundScape getScape() {
        return this.scape;
    }

    public final void setScape(@NotNull SoundScape soundScape) {
        Intrinsics.checkNotNullParameter((Object)soundScape, (String)"<set-?>");
        this.scape = soundScape;
    }

    public final float getRelativeVolume() {
        return this.relativeVolume;
    }

    public final void setRelativeVolume(float f) {
        this.relativeVolume = f;
    }

    public RepeatingSound(@NotNull SoundEvent soundEvent, @NotNull SoundScape scape, float sharedPitch, float relativeVolume, int repeatDelay) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"soundEvent");
        Intrinsics.checkNotNullParameter((Object)scape, (String)"scape");
        this(soundEvent, SoundSource.AMBIENT, sharedPitch, Math.max(1, repeatDelay), scape, relativeVolume);
    }

    public final void tick() {
        if (AnimationTickHolder.getTicks() % this.repeatDelay != 0) {
            return;
        }
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel == null) {
            return;
        }
        ClientLevel world = clientLevel;
        Vec3 vec3 = this.scape.getMeanPos();
        if (vec3 == null) {
            return;
        }
        Vec3 meanPos = vec3;
        world.m_7785_(meanPos.f_82479_, meanPos.f_82480_, meanPos.f_82481_, this.soundEvent, SoundSource.AMBIENT, this.scape.getVolume() * this.relativeVolume, this.sharedPitch, true);
    }
}

