/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.render;

import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4ic;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.util.render.Bolt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0015J9\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J-\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000b2\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0019j\b\u0012\u0004\u0012\u00020\u000b`\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/valkyrienskies/clockwork/util/render/BoltUtil;", "", "Lorg/joml/Vector3dc;", "start", "end", "Lorg/joml/Vector4ic;", "color", "", "width", "", "segments", "Lorg/valkyrienskies/clockwork/util/render/Bolt;", "addBolt", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Vector4ic;FLjava/lang/Integer;)Lorg/valkyrienskies/clockwork/util/render/Bolt;", "bolt", "", "delBolt", "(Lorg/valkyrienskies/clockwork/util/render/Bolt;)V", "retargetBolt", "(Lorg/valkyrienskies/clockwork/util/render/Bolt;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)V", "tick", "()V", "Lkotlin/random/Random;", "rand", "Lkotlin/random/Random;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "bolts", "Ljava/util/ArrayList;", "<init>", "clockwork"})
public final class BoltUtil {
    @NotNull
    public static final BoltUtil INSTANCE = new BoltUtil();
    @NotNull
    private static final Random rand = (Random)Random.Default;
    @NotNull
    private static final ArrayList<Bolt> bolts = new ArrayList();

    private BoltUtil() {
    }

    @NotNull
    public final Bolt addBolt(@NotNull Vector3dc start, @NotNull Vector3dc end, @NotNull Vector4ic color, float width, @Nullable Integer segments) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Integer n = segments;
        int seg = n != null ? n : (int)(start.distance(end) / 0.5);
        ArrayList<Vector3dc> segList = new ArrayList<Vector3dc>();
        segList.add(start);
        int i = 0;
        if (i <= seg) {
            while (true) {
                Vector3d segment;
                Intrinsics.checkNotNullExpressionValue((Object)start.lerp(end, (double)i, new Vector3d()), (String)"lerp(...)");
                segList.add((Vector3dc)segment);
                if (i == seg) break;
                ++i;
            }
        }
        segList.add(end);
        Bolt bolt = new Bolt(segList);
        bolts.add(bolt);
        int n2 = bolt.getSegments().size() - 1;
        for (int b = 0; b < n2; ++b) {
            Vector3dc nextSegment;
            Vector3dc segment;
            Intrinsics.checkNotNullExpressionValue((Object)bolt.getSegments().get(b), (String)"get(...)");
            Intrinsics.checkNotNullExpressionValue((Object)bolt.getSegments().get(b + 1), (String)"get(...)");
            ClockworkModClient.getOUTLINER().showLine((Object)segment, VectorConversionsMCKt.toMinecraft((Vector3dc)segment), VectorConversionsMCKt.toMinecraft((Vector3dc)nextSegment));
            ClockworkModClient.getOUTLINER().edit((Object)segment).ifPresent(arg_0 -> BoltUtil.addBolt$lambda$1(arg_0 -> BoltUtil.addBolt$lambda$0(color, width, arg_0), arg_0));
        }
        return bolt;
    }

    public static /* synthetic */ Bolt addBolt$default(BoltUtil boltUtil, Vector3dc vector3dc, Vector3dc vector3dc2, Vector4ic vector4ic, float f, Integer n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        return boltUtil.addBolt(vector3dc, vector3dc2, vector4ic, f, n);
    }

    public final void delBolt(@NotNull Bolt bolt) {
        Intrinsics.checkNotNullParameter((Object)bolt, (String)"bolt");
        bolts.remove(bolt);
        Iterator<Vector3dc> iterator = bolt.getSegments().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Vector3dc> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Vector3dc segment;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            ClockworkModClient.getOUTLINER().remove((Object)segment);
        }
    }

    public final void retargetBolt(@NotNull Bolt bolt, @Nullable Vector3dc start, @Nullable Vector3dc end) {
        Intrinsics.checkNotNullParameter((Object)bolt, (String)"bolt");
        if (bolts.contains(bolt)) {
            bolts.remove(bolt);
            if (start != null) {
                bolt.getSegments().set(0, start);
            }
            if (end != null) {
                bolt.getSegments().set(bolt.getSegments().size() - 1, end);
            }
            bolts.add(bolt);
        }
    }

    public static /* synthetic */ void retargetBolt$default(BoltUtil boltUtil, Bolt bolt, Vector3dc vector3dc, Vector3dc vector3dc2, int n, Object object) {
        if ((n & 2) != 0) {
            vector3dc = null;
        }
        if ((n & 4) != 0) {
            vector3dc2 = null;
        }
        boltUtil.retargetBolt(bolt, vector3dc, vector3dc2);
    }

    public final void tick() {
        if (bolts.isEmpty()) {
            return;
        }
        ArrayList boltsCopied = new ArrayList(bolts);
        Iterator iterator = boltsCopied.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Vector3dc prevSegmentEnd;
            Bolt bolt = (Bolt)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)bolt.getSegments().get(1), (String)"get(...)");
            Outliner outliner = ClockworkModClient.getOUTLINER();
            Vector3dc vector3dc = bolt.getSegments().get(0);
            Vector3dc vector3dc2 = bolt.getSegments().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)vector3dc2, (String)"get(...)");
            outliner.showLine((Object)vector3dc, VectorConversionsMCKt.toMinecraft((Vector3dc)vector3dc2), VectorConversionsMCKt.toMinecraft((Vector3dc)prevSegmentEnd));
            int n = bolt.getSegments().size() - 1;
            for (int i = 1; i < n; ++i) {
                Vector3dc vector3dc3 = bolt.getSegments().get(i);
                Intrinsics.checkNotNull((Object)vector3dc3, (String)"null cannot be cast to non-null type org.joml.Vector3d");
                Vector3d segment = (Vector3d)vector3dc3;
                Vector3dc vector3dc4 = bolt.getSegments().get(i + 1);
                Intrinsics.checkNotNull((Object)vector3dc4, (String)"null cannot be cast to non-null type org.joml.Vector3d");
                Vector3d nextSegment = (Vector3d)vector3dc4;
                double xOffset = rand.nextDouble(-0.5, 0.5);
                double yOffset = rand.nextDouble(-0.5, 0.5);
                double zOffset = rand.nextDouble(-0.5, 0.5);
                nextSegment.add(xOffset, yOffset, zOffset);
                ClockworkModClient.getOUTLINER().showLine((Object)segment, VectorConversionsMCKt.toMinecraft((Vector3dc)prevSegmentEnd), VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)nextSegment)));
                prevSegmentEnd = (Vector3dc)nextSegment;
            }
            Outliner outliner2 = ClockworkModClient.getOUTLINER();
            Vec3 vec3 = VectorConversionsMCKt.toMinecraft((Vector3dc)prevSegmentEnd);
            Vector3dc vector3dc5 = bolt.getSegments().get(bolt.getSegments().size() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)vector3dc5, (String)"get(...)");
            outliner2.showLine((Object)prevSegmentEnd, vec3, VectorConversionsMCKt.toMinecraft((Vector3dc)vector3dc5));
        }
    }

    private static final Unit addBolt$lambda$0(Vector4ic $color, float $width, Outline.OutlineParams it) {
        Intrinsics.checkNotNullParameter((Object)$color, (String)"$color");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.colored(new Color($color.x(), $color.y(), $color.z(), $color.w()));
        it.lineWidth($width);
        return Unit.INSTANCE;
    }

    private static final void addBolt$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

