/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.builder;

import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.CustomRenderedItems;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Supplier;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.valkyrienskies.clockwork.platform.PlatformUtils;
import org.valkyrienskies.clockwork.platform.SharedValues;

public class ClockworkRegistrate {
    public static <T extends Item, P> NonNullUnaryOperator<ItemBuilder<T, P>> customRenderedItem(Supplier<Supplier<CustomRenderedItemModelRenderer>> supplier) {
        return b -> {
            ClockworkRegistrate.onClient(() -> ClockworkRegistrate.lambda$customRenderedItem$1(b, (Supplier)supplier));
            return b;
        };
    }

    public static <T extends BlockItem, P> NonNullFunction<ItemBuilder<T, P>, P> customRenderedBlockItem(Supplier<Supplier<CustomRenderedItemModelRenderer>> supplier) {
        return b -> {
            ClockworkRegistrate.onClient(() -> ClockworkRegistrate.lambda$customRenderedBlockItem$4(b, (Supplier)supplier));
            return b.build();
        };
    }

    public static <T extends Block> NonNullConsumer<? super T> blockModel(Supplier<NonNullFunction<BakedModel, ? extends BakedModel>> func) {
        return entry -> ClockworkRegistrate.onClient(() -> ClockworkRegistrate.lambda$blockModel$7(entry, (Supplier)func));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerBlockModel(Block entry, Supplier<NonNullFunction<BakedModel, ? extends BakedModel>> func) {
        CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(CatnipServices.REGISTRIES.getKeyOrThrow(entry), func.get());
    }

    static void onClient(Supplier<Runnable> toRun) {
        PlatformUtils.getEnvExecutor(toRun);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <T extends Item, P> void customRenderedItem(ItemBuilder<T, P> b, Supplier<Supplier<CustomRenderedItemModelRenderer>> supplier) {
        b.onRegister((NonNullConsumer)new CustomRendererRegistrationHelper(supplier));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <T extends BlockItem, P> void customRenderedBlockItem(ItemBuilder<T, P> b, Supplier<Supplier<CustomRenderedItemModelRenderer>> supplier) {
        b.onRegister((NonNullConsumer)new CustomBlockItemRendererRegistrationHelper(supplier));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerItemModel(Item entry, Supplier<NonNullFunction<BakedModel, ? extends BakedModel>> func) {
        CreateClient.MODEL_SWAPPER.getCustomItemModels().register(CatnipServices.REGISTRIES.getKeyOrThrow(entry), func.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerCustomRenderedBlockItem(BlockItem entry, Supplier<NonNullFunction<BakedModel, ? extends BakedModel>> func) {
        CreateClient.MODEL_SWAPPER.getCustomItemModels().register(CatnipServices.REGISTRIES.getKeyOrThrow((Item)entry), func.get());
    }

    private static /* synthetic */ Runnable lambda$blockModel$7(Block entry, Supplier func) {
        return () -> ClockworkRegistrate.lambda$blockModel$6(entry, (Supplier)func);
    }

    private static /* synthetic */ void lambda$blockModel$6(Block entry, Supplier func) {
        ClockworkRegistrate.registerBlockModel(entry, func);
    }

    private static /* synthetic */ Runnable lambda$customRenderedBlockItem$4(ItemBuilder b, Supplier supplier) {
        return () -> ClockworkRegistrate.lambda$customRenderedBlockItem$3(b, (Supplier)supplier);
    }

    private static /* synthetic */ void lambda$customRenderedBlockItem$3(ItemBuilder b, Supplier supplier) {
        ClockworkRegistrate.customRenderedBlockItem(b, supplier);
    }

    private static /* synthetic */ Runnable lambda$customRenderedItem$1(ItemBuilder b, Supplier supplier) {
        return () -> ClockworkRegistrate.lambda$customRenderedItem$0(b, (Supplier)supplier);
    }

    private static /* synthetic */ void lambda$customRenderedItem$0(ItemBuilder b, Supplier supplier) {
        ClockworkRegistrate.customRenderedItem(b, supplier);
    }

    @OnlyIn(value=Dist.CLIENT)
    private record CustomRendererRegistrationHelper(Supplier<Supplier<CustomRenderedItemModelRenderer>> supplier) implements NonNullConsumer<Item>
    {
        public void accept(Item entry) {
            CustomRenderedItemModelRenderer renderer = this.supplier.get().get();
            SharedValues.customRenderedRegisterer().accept(entry, renderer);
            CustomRenderedItems.register((Item)entry);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private record CustomBlockItemRendererRegistrationHelper(Supplier<Supplier<CustomRenderedItemModelRenderer>> supplier) implements NonNullConsumer<BlockItem>
    {
        public void accept(BlockItem entry) {
            CustomRenderedItemModelRenderer renderer = this.supplier.get().get();
            SharedValues.customBlockItemRenderedRegisterer().accept(entry, renderer);
            CustomRenderedItems.register((Item)entry);
        }
    }
}

