/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4d;
import org.joml.Matrix4d;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.networking.simple.SimplePacket;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworking;
import org.valkyrienskies.core.internal.world.VsiPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.networking.PacketRestartChunkUpdates;
import org.valkyrienskies.mod.common.networking.PacketStopChunkUpdates;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.RelocationUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/valkyrienskies/clockwork/util/ShipDestroyer;", "", "", "number", "multiple", "roundToNearestMultipleOf", "(DD)D", "Lorg/joml/AxisAngle4d;", "direction", "snapRotation", "(Lorg/joml/AxisAngle4d;)Lorg/joml/AxisAngle4d;", "axis", "Lnet/minecraft/world/level/block/Rotation;", "rotationFromAxisAngle", "(Lorg/joml/AxisAngle4d;)Lnet/minecraft/world/level/block/Rotation;", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "", "unfillShip", "(Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/ships/ServerShip;)V", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nShipDestroyer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipDestroyer.kt\norg/valkyrienskies/clockwork/util/ShipDestroyer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1#2:160\n1368#3:161\n1454#3,5:162\n1557#3:167\n1628#3,3:168\n1863#3,2:171\n1734#3,3:173\n1863#3,2:176\n*S KotlinDebug\n*F\n+ 1 ShipDestroyer.kt\norg/valkyrienskies/clockwork/util/ShipDestroyer\n*L\n96#1:161\n96#1:162,5\n97#1:167\n97#1:168,3\n101#1:171,2\n148#1:173,3\n151#1:176,2\n*E\n"})
public final class ShipDestroyer {
    @NotNull
    public static final ShipDestroyer INSTANCE = new ShipDestroyer();

    private ShipDestroyer() {
    }

    private final double roundToNearestMultipleOf(double number, double multiple) {
        return multiple * Math.rint(number / multiple);
    }

    private final AxisAngle4d snapRotation(AxisAngle4d direction) {
        AxisAngle4d axisAngle4d;
        double x = Math.abs(direction.x);
        double y = Math.abs(direction.y);
        double z = Math.abs(direction.z);
        double angle = this.roundToNearestMultipleOf(direction.angle, 1.5707963267948966);
        if (x > y && x > z) {
            AxisAngle4d axisAngle4d2 = direction.set(angle, Math.signum(direction.x), 0.0, 0.0);
            Intrinsics.checkNotNull((Object)axisAngle4d2);
            axisAngle4d = axisAngle4d2;
        } else if (y > x && y > z) {
            AxisAngle4d axisAngle4d3 = direction.set(angle, 0.0, Math.signum(direction.y), 0.0);
            Intrinsics.checkNotNull((Object)axisAngle4d3);
            axisAngle4d = axisAngle4d3;
        } else {
            AxisAngle4d axisAngle4d4 = direction.set(angle, 0.0, 0.0, Math.signum(direction.z));
            Intrinsics.checkNotNull((Object)axisAngle4d4);
            axisAngle4d = axisAngle4d4;
        }
        return axisAngle4d;
    }

    private final Rotation rotationFromAxisAngle(AxisAngle4d axis) {
        double eps;
        if (Math.abs(axis.y) < 0.1) {
            return Rotation.NONE;
        }
        if (Math.signum(axis.y) < 0.0) {
            axis.y = 1.0;
            axis.angle = Math.PI * 2 - axis.angle;
            axis.angle %= Math.PI * 2;
        }
        return axis.angle < (eps = 0.001) ? Rotation.NONE : (Math.abs(axis.angle - 1.5707963267948966) < eps ? Rotation.COUNTERCLOCKWISE_90 : (Math.abs(axis.angle - Math.PI) < eps ? Rotation.CLOCKWISE_180 : (Math.abs(axis.angle - 4.71238898038469) < eps ? Rotation.CLOCKWISE_90 : Rotation.NONE)));
    }

    /*
     * WARNING - void declaration
     */
    public final void unfillShip(@NotNull ServerLevel level, @NotNull ServerShip ship) {
        Iterator $this$mapTo$iv$iv;
        Object element$iv$iv2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        ship.setStatic(true);
        Object p0 = ship.getTransform().getShipToWorldRotation();
        boolean bl = false;
        AxisAngle4d axisAngle4d = new AxisAngle4d((Quaterniondc)p0);
        p0 = INSTANCE;
        AxisAngle4d p02 = axisAngle4d;
        boolean bl2 = false;
        p0 = super.snapRotation(p02);
        boolean bl3 = false;
        Rotation rotation = this.rotationFromAxisAngle((AxisAngle4d)p0);
        ShipTransform $this$unfillShip_u24lambda_u242 = ship.getTransform();
        boolean bl4 = false;
        Matrix4d shipToWorld = new Matrix4d().translate($this$unfillShip_u24lambda_u242.getPositionInWorld()).rotate(INSTANCE.snapRotation(new AxisAngle4d($this$unfillShip_u24lambda_u242.getShipToWorldRotation()))).scale($this$unfillShip_u24lambda_u242.getShipToWorldScaling()).translate(-$this$unfillShip_u24lambda_u242.getPositionInShip().x(), -$this$unfillShip_u24lambda_u242.getPositionInShip().y(), -$this$unfillShip_u24lambda_u242.getPositionInShip().z());
        Vector3d alloc0 = new Vector3d();
        Map chunksToBeUpdated = new LinkedHashMap();
        ship.getActiveChunksSet().forEach((arg_0, arg_1) -> ShipDestroyer.unfillShip$lambda$3(chunksToBeUpdated, arg_0, arg_1));
        List chunkPairs = CollectionsKt.toList((Iterable)chunksToBeUpdated.values());
        Iterable $this$flatMap$iv = chunkPairs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            Pair it = (Pair)element$iv$iv2;
            boolean bl5 = false;
            Iterable list$iv$iv = TuplesKt.toList((Pair)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List chunkPoses = (List)destination$iv$iv;
        Iterable $this$map$iv = chunkPoses;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        element$iv$iv2 = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            void it;
            Object item$iv$iv = element$iv$iv2.next();
            ChunkPos bl5 = (ChunkPos)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl6 = false;
            collection.add(VectorConversionsMCKt.toJOML((ChunkPos)it));
        }
        List chunkPosesJOML = (List)destination$iv$iv2;
        List list = level.m_6907_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl7 = false;
            SimplePacketNetworking $this$unfillShip_u24lambda_u247_u24lambda_u246 = ValkyrienSkiesMod.getVsCore().getSimplePacketNetworking();
            boolean bl8 = false;
            SimplePacket simplePacket = (SimplePacket)new PacketStopChunkUpdates(chunkPosesJOML);
            Intrinsics.checkNotNull((Object)player);
            MinecraftPlayer minecraftPlayer = VSGameUtilsKt.getPlayerWrapper((Player)((Player)player));
            Intrinsics.checkNotNullExpressionValue((Object)minecraftPlayer, (String)"<get-playerWrapper>(...)");
            $this$unfillShip_u24lambda_u247_u24lambda_u246.sendToClient1(simplePacket, (VsiPlayer)minecraftPlayer);
        }
        HashSet toUpdate = Sets.newHashSet();
        ship.getActiveChunksSet().forEach((arg_0, arg_1) -> ShipDestroyer.unfillShip$lambda$8(level, shipToWorld, alloc0, toUpdate, rotation, arg_0, arg_1));
        Iterator iterator = toUpdate.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Triple triple = (Triple)iterator2.next();
            RelocationUtilKt.updateBlock((Level)((Level)level), (BlockPos)((BlockPos)triple.getFirst()), (BlockPos)((BlockPos)triple.getSecond()), (BlockState)((BlockState)triple.getThird()));
        }
        MinecraftServer minecraftServer = level.m_7654_();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        VSGameUtilsKt.executeIf((MinecraftServer)minecraftServer, () -> ShipDestroyer.unfillShip$lambda$10(chunkPoses, level), () -> ShipDestroyer.unfillShip$lambda$13(level, chunkPosesJOML));
    }

    private static final void unfillShip$lambda$3(Map $chunksToBeUpdated, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$chunksToBeUpdated, (String)"$chunksToBeUpdated");
        $chunksToBeUpdated.put(new ChunkPos(chunkX, chunkZ), new Pair((Object)new ChunkPos(chunkX, chunkZ), (Object)new ChunkPos(chunkX, chunkZ)));
    }

    private static final void unfillShip$lambda$8(ServerLevel $level, Matrix4d $shipToWorld, Vector3d $alloc0, HashSet $toUpdate, Rotation $rotation, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$alloc0, (String)"$alloc0");
        Intrinsics.checkNotNullParameter((Object)$rotation, (String)"$rotation");
        LevelChunk chunk = $level.m_6325_(chunkX, chunkZ);
        int n = chunk.m_7103_().length;
        for (int sectionIndex = 0; sectionIndex < n; ++sectionIndex) {
            LevelChunkSection section = chunk.m_7103_()[sectionIndex];
            if (section == null || section.m_188008_()) continue;
            int bottomY = sectionIndex << 4;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState state = section.m_62982_(x, y, z);
                        if (state.m_60795_()) continue;
                        int realX = (chunkX << 4) + x;
                        int realY = bottomY + y + $level.m_141937_();
                        int realZ = (chunkZ << 4) + z;
                        Vector3d inWorldPos = $shipToWorld.transformPosition($alloc0.set((double)realX + 0.5, (double)realY + 0.5, (double)realZ + 0.5)).floor();
                        BlockPos inWorldBlockPos = new BlockPos((int)inWorldPos.x, (int)inWorldPos.y, (int)inWorldPos.z);
                        BlockPos inShipPos = new BlockPos(realX, realY, realZ);
                        $toUpdate.add(new Triple((Object)inShipPos, (Object)inWorldBlockPos, (Object)state));
                        RelocationUtilKt.relocateBlock((Level)((Level)$level), (BlockPos)inShipPos, (BlockPos)inWorldBlockPos, (boolean)false, null, (Rotation)$rotation);
                    }
                }
            }
        }
    }

    private static final boolean unfillShip$lambda$10(List $chunkPoses, ServerLevel $level) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$chunkPoses, (String)"$chunkPoses");
            Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
            Iterable $this$all$iv = $chunkPoses;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ChunkPos p0 = (ChunkPos)element$iv;
                    boolean bl2 = false;
                    if (VSGameUtilsKt.isTickingChunk((Level)((Level)$level), (ChunkPos)p0)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final void unfillShip$lambda$13(ServerLevel $level, List $chunkPosesJOML) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$chunkPosesJOML, (String)"$chunkPosesJOML");
        List list = $level.m_6907_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            SimplePacketNetworking $this$unfillShip_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411 = ValkyrienSkiesMod.getVsCore().getSimplePacketNetworking();
            boolean bl2 = false;
            SimplePacket simplePacket = (SimplePacket)new PacketRestartChunkUpdates($chunkPosesJOML);
            Intrinsics.checkNotNull((Object)player);
            MinecraftPlayer minecraftPlayer = VSGameUtilsKt.getPlayerWrapper((Player)((Player)player));
            Intrinsics.checkNotNullExpressionValue((Object)minecraftPlayer, (String)"<get-playerWrapper>(...)");
            $this$unfillShip_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.sendToClient1(simplePacket, (VsiPlayer)minecraftPlayer);
        }
    }
}

