/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0017\u001a\u00020\b\u0012\b\b\u0002\u0010\u001b\u001a\u00020\b\u0012\b\b\u0002\u0010\u001d\u001a\u00020\b\u0012\b\b\u0002\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b'\u0010(J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004JC\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u001aR\u0017\u0010\u001d\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001aR\u0017\u0010\u001f\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b \u0010\u001aR\u0014\u0010!\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\"R\u0011\u0010%\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lorg/valkyrienskies/clockwork/util/PIDQuaternion;", "", "", "resetIntegral", "()V", "Lorg/joml/Quaternionf;", "target", "current", "", "dtSeconds", "Kp", "Ki", "Kd", "Lorg/joml/Vector3f;", "control", "(Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;FFFF)Lorg/joml/Vector3f;", "q", "quatToAxisAngleVector", "(Lorg/joml/Quaternionf;)Lorg/joml/Vector3f;", "v", "maxMag", "clampMagnitude", "(Lorg/joml/Vector3f;F)V", "p", "F", "getP", "()F", "i", "getI", "d", "getD", "integralLimit", "getIntegralLimit", "integral", "Lorg/joml/Vector3f;", "lastError", "", "isIntegralReset", "()Z", "<init>", "(FFFF)V", "clockwork"})
public final class PIDQuaternion {
    private final float p;
    private final float i;
    private final float d;
    private final float integralLimit;
    @NotNull
    private final Vector3f integral;
    @NotNull
    private final Vector3f lastError;

    public PIDQuaternion(float p, float i, float d, float integralLimit) {
        this.p = p;
        this.i = i;
        this.d = d;
        this.integralLimit = integralLimit;
        this.integral = new Vector3f();
        this.lastError = new Vector3f();
    }

    public /* synthetic */ PIDQuaternion(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.1f;
        }
        if ((n & 4) != 0) {
            f3 = 0.05f;
        }
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public final float getP() {
        return this.p;
    }

    public final float getI() {
        return this.i;
    }

    public final float getD() {
        return this.d;
    }

    public final float getIntegralLimit() {
        return this.integralLimit;
    }

    public final boolean isIntegralReset() {
        return this.integral.lengthSquared() == 0.0f;
    }

    public final void resetIntegral() {
        this.integral.zero();
    }

    @NotNull
    public final Vector3f control(@NotNull Quaternionf target, @NotNull Quaternionf current, float dtSeconds, float Kp, float Ki, float Kd) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Quaternionf qInv = new Quaternionf((Quaternionfc)current).conjugate();
        Quaternionf qErr = new Quaternionf((Quaternionfc)target).mul((Quaternionfc)qInv);
        if (qErr.w < 0.0f) {
            qErr.invert();
        }
        Intrinsics.checkNotNull((Object)qErr);
        Vector3f errVec = this.quatToAxisAngleVector(qErr);
        Vector3f proportional = new Vector3f((Vector3fc)errVec).mul(Kp);
        this.integral.fma(dtSeconds, (Vector3fc)errVec);
        this.clampMagnitude(this.integral, this.integralLimit);
        Vector3f integralTerm = new Vector3f((Vector3fc)this.integral).mul(Ki);
        Vector3f derivative = new Vector3f((Vector3fc)errVec).sub((Vector3fc)this.lastError).div(RangesKt.coerceAtLeast((float)dtSeconds, (float)1.0E-6f));
        Vector3f derivativeTerm = derivative.mul(Kd);
        this.lastError.set((Vector3fc)errVec);
        Vector3f vector3f = proportional.add((Vector3fc)integralTerm).add((Vector3fc)derivativeTerm);
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"add(...)");
        return vector3f;
    }

    public static /* synthetic */ Vector3f control$default(PIDQuaternion pIDQuaternion, Quaternionf quaternionf, Quaternionf quaternionf2, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 8) != 0) {
            f2 = pIDQuaternion.p;
        }
        if ((n & 0x10) != 0) {
            f3 = pIDQuaternion.i;
        }
        if ((n & 0x20) != 0) {
            f4 = pIDQuaternion.d;
        }
        return pIDQuaternion.control(quaternionf, quaternionf2, f, f2, f3, f4);
    }

    private final Vector3f quatToAxisAngleVector(Quaternionf q) {
        Quaternionf qq = new Quaternionf((Quaternionfc)q).normalize();
        float vx = qq.x;
        float vy = qq.y;
        float vz = qq.z;
        float w = qq.w;
        float sinHalf = (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
        float angle = 2.0f * (float)Math.atan2(sinHalf, w);
        if (sinHalf < 1.0E-6f || angle == 0.0f) {
            Vector3f vector3f = new Vector3f(vx, vy, vz).mul(2.0f);
            Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"mul(...)");
            return vector3f;
        }
        float invSinHalf = 1.0f / sinHalf;
        Vector3f axis = new Vector3f(vx * invSinHalf, vy * invSinHalf, vz * invSinHalf);
        Vector3f vector3f = axis.mul(angle);
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"mul(...)");
        return vector3f;
    }

    private final void clampMagnitude(Vector3f v, float maxMag) {
        float max2;
        float len2 = v.lengthSquared();
        if (len2 > (max2 = maxMag * maxMag) && len2 > 0.0f) {
            v.mul(maxMag / (float)Math.sqrt(len2));
        }
    }

    public PIDQuaternion() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }
}

