/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bC\u0010DJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000e\u001a\u00020\r*\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0013\u001a\u00020\u0012*\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0016\u001a\u00020\u0015*\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020 \u00a2\u0006\u0004\b\u001e\u0010!J\u001d\u0010\"\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\"\u0010\u001fJ%\u0010&\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010*\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010-\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b-\u0010.J\u001d\u0010/\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b/\u0010.J\u001d\u00102\u001a\u00020\t2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001c\u00a2\u0006\u0004\b2\u00103J\u0015\u00104\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001c\u00a2\u0006\u0004\b4\u00105J\u0015\u00106\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001c\u00a2\u0006\u0004\b6\u00105J%\u00108\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\t\u00a2\u0006\u0004\b8\u00109J%\u0010:\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\t\u00a2\u0006\u0004\b:\u00109J\u001d\u0010?\u001a\u00020>2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020\u001c\u00a2\u0006\u0004\b?\u0010@J\u0015\u0010A\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020;\u00a2\u0006\u0004\bA\u0010B\u00a8\u0006E"}, d2={"Lorg/valkyrienskies/clockwork/util/MathFunctions;", "", "Lnet/minecraft/core/Direction$Axis;", "axis", "Lnet/minecraft/world/phys/Vec3;", "vec", "Lorg/joml/Vector2f;", "removeAxis", "(Lnet/minecraft/core/Direction$Axis;Lnet/minecraft/world/phys/Vec3;)Lorg/joml/Vector2f;", "", "x1", "y1", "difference", "", "isWithin", "(Lorg/joml/Vector2f;FFF)Z", "Lkotlin/Triple;", "", "Lorg/joml/Vector3i;", "toVector3i", "(Lkotlin/Triple;)Lorg/joml/Vector3i;", "Lnet/minecraft/world/level/ChunkPos;", "chunkPos", "(Lkotlin/Triple;)Lnet/minecraft/world/level/ChunkPos;", "Lorg/joml/Vector3ic;", "toTriple", "(Lorg/joml/Vector3ic;)Lkotlin/Triple;", "vector", "Lorg/joml/Quaternionf;", "quaternion", "rotateVecWithQuat", "(Lnet/minecraft/world/phys/Vec3;Lorg/joml/Quaternionf;)Lnet/minecraft/world/phys/Vec3;", "Lorg/joml/Quaterniond;", "(Lnet/minecraft/world/phys/Vec3;Lorg/joml/Quaterniond;)Lnet/minecraft/world/phys/Vec3;", "reverseRotateVecWithQuat", "coneAxis", "", "coneAngle", "clampVecIntoCone", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;D)Lnet/minecraft/world/phys/Vec3;", "startVec", "endVec", "quatFromVecRot", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)Lorg/joml/Quaternionf;", "Lorg/joml/Vector3d;", "rotateVectorByInverseQuaternion", "(Lorg/joml/Vector3d;Lorg/joml/Quaternionf;)Lorg/joml/Vector3d;", "rotateVectorByQuaternion", "a", "b", "dot", "(Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;)F", "negate", "(Lorg/joml/Quaternionf;)Lorg/joml/Quaternionf;", "normalize", "t", "lerp", "(Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;F)Lorg/joml/Quaternionf;", "nlerp", "Lio/netty/buffer/ByteBuf;", "byteBuf", "q", "", "writeQuatf", "(Lio/netty/buffer/ByteBuf;Lorg/joml/Quaternionf;)V", "readQuatf", "(Lio/netty/buffer/ByteBuf;)Lorg/joml/Quaternionf;", "<init>", "()V", "clockwork"})
public final class MathFunctions {
    @NotNull
    public static final MathFunctions INSTANCE = new MathFunctions();

    private MathFunctions() {
    }

    @NotNull
    public final Vector2f removeAxis(@NotNull Direction.Axis axis, @NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Vector2f out = null;
        switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1: {
                out = new Vector2f((float)vec.f_82480_, (float)vec.f_82481_);
                break;
            }
            case 2: {
                out = new Vector2f((float)vec.f_82479_, (float)vec.f_82481_);
                break;
            }
            case 3: {
                out = new Vector2f((float)vec.f_82479_, (float)vec.f_82480_);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + axis);
            }
        }
        return out;
    }

    public final boolean isWithin(@NotNull Vector2f $this$isWithin, float x1, float y1, float difference) {
        Intrinsics.checkNotNullParameter((Object)$this$isWithin, (String)"<this>");
        return Math.abs(x1 - $this$isWithin.x) < difference && Math.abs(y1 - $this$isWithin.y) < difference;
    }

    @NotNull
    public final Vector3i toVector3i(@NotNull Triple<Integer, Integer, Integer> $this$toVector3i) {
        Intrinsics.checkNotNullParameter($this$toVector3i, (String)"<this>");
        return new Vector3i(((Number)$this$toVector3i.getFirst()).intValue(), ((Number)$this$toVector3i.getSecond()).intValue(), ((Number)$this$toVector3i.getThird()).intValue());
    }

    @NotNull
    public final ChunkPos chunkPos(@NotNull Triple<Integer, Integer, Integer> $this$chunkPos) {
        Intrinsics.checkNotNullParameter($this$chunkPos, (String)"<this>");
        return new ChunkPos(((Number)$this$chunkPos.getFirst()).intValue() >> 4, ((Number)$this$chunkPos.getThird()).intValue() >> 4);
    }

    @NotNull
    public final Triple<Integer, Integer, Integer> toTriple(@NotNull Vector3ic $this$toTriple) {
        Intrinsics.checkNotNullParameter((Object)$this$toTriple, (String)"<this>");
        return new Triple((Object)$this$toTriple.x(), (Object)$this$toTriple.y(), (Object)$this$toTriple.z());
    }

    @NotNull
    public final Vec3 rotateVecWithQuat(@NotNull Vec3 vector, @NotNull Quaternionf quaternion) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)quaternion, (String)"quaternion");
        Quaternionf vecQuat = new Quaternionf((float)vector.f_82479_, (float)vector.f_82480_, (float)vector.f_82481_, 0.0f);
        Quaternionf quatCopy = new Quaternionf((Quaternionfc)quaternion);
        vecQuat.mul((Quaternionfc)quatCopy);
        quatCopy.conjugate();
        quatCopy.mul((Quaternionfc)vecQuat);
        return new Vec3((double)quatCopy.x(), (double)quatCopy.y(), (double)quatCopy.z());
    }

    @NotNull
    public final Vec3 rotateVecWithQuat(@NotNull Vec3 vector, @NotNull Quaterniond quaternion) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)quaternion, (String)"quaternion");
        Quaternionf vecQuat = new Quaternionf((float)vector.f_82479_, (float)vector.f_82480_, (float)vector.f_82481_, 0.0f);
        Quaternionf quatCopy = new Quaternionf((Quaterniondc)quaternion);
        vecQuat.mul((Quaternionfc)quatCopy);
        quatCopy.conjugate();
        quatCopy.mul((Quaternionfc)vecQuat);
        return new Vec3((double)quatCopy.x(), (double)quatCopy.y(), (double)quatCopy.z());
    }

    @NotNull
    public final Vec3 reverseRotateVecWithQuat(@NotNull Vec3 vector, @NotNull Quaternionf quaternion) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)quaternion, (String)"quaternion");
        Quaternionf vecQuat = new Quaternionf((float)vector.f_82479_, (float)vector.f_82480_, (float)vector.f_82481_, 0.0f);
        Quaternionf quatCopy = new Quaternionf((Quaternionfc)quaternion);
        quatCopy.conjugate();
        vecQuat.mul((Quaternionfc)quatCopy);
        quatCopy.conjugate();
        quatCopy.mul((Quaternionfc)vecQuat);
        return new Vec3((double)quatCopy.x(), (double)quatCopy.y(), (double)quatCopy.z());
    }

    @NotNull
    public final Vec3 clampVecIntoCone(@NotNull Vec3 vector, @NotNull Vec3 coneAxis, double coneAngle) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)coneAxis, (String)"coneAxis");
        double dotVV = vector.m_82526_(vector);
        double dotVN = vector.m_82526_(coneAxis);
        double dotNN = coneAxis.m_82526_(coneAxis);
        double discriminant = dotNN * dotVV * 1.005 - dotVN * dotVN;
        double offsetDistance = (-dotVN + Math.sqrt(discriminant) / Math.tan(coneAngle)) / dotNN;
        if (offsetDistance < 0.0) {
            return vector;
        }
        Vec3 vec3 = vector.m_82549_(coneAxis.m_82490_(offsetDistance)).m_82541_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
        return vec3;
    }

    @NotNull
    public final Quaternionf quatFromVecRot(@NotNull Vec3 startVec, @NotNull Vec3 endVec) {
        Intrinsics.checkNotNullParameter((Object)startVec, (String)"startVec");
        Intrinsics.checkNotNullParameter((Object)endVec, (String)"endVec");
        Vec3 crossProduct = startVec.m_82537_(endVec);
        Vec3 cross = new Vec3(crossProduct.f_82479_, crossProduct.f_82480_, crossProduct.f_82481_);
        Quaternionf quaternion = new Quaternionf((float)cross.m_7096_(), (float)cross.m_7098_(), (float)cross.m_7094_(), 1.0f + (float)startVec.m_82526_(endVec));
        quaternion.normalize();
        return quaternion;
    }

    @NotNull
    public final Vector3d rotateVectorByInverseQuaternion(@NotNull Vector3d vector, @NotNull Quaternionf quaternion) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)quaternion, (String)"quaternion");
        Quaternionf invertedQuaternion = new Quaternionf((Quaternionfc)quaternion);
        Quaternionf q = new Quaternionf((float)vector.x, (float)vector.y, (float)vector.z, 0.0f);
        invertedQuaternion.conjugate();
        q.mul((Quaternionfc)invertedQuaternion);
        invertedQuaternion.conjugate();
        invertedQuaternion.mul((Quaternionfc)q);
        return new Vector3d(-((double)invertedQuaternion.x()), (double)invertedQuaternion.y(), -((double)invertedQuaternion.z()));
    }

    @NotNull
    public final Vector3d rotateVectorByQuaternion(@NotNull Vector3d vector, @NotNull Quaternionf quaternion) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)quaternion, (String)"quaternion");
        Quaternionf invertedQuaternion = new Quaternionf((Quaternionfc)quaternion);
        return new Vector3d((double)invertedQuaternion.x(), (double)invertedQuaternion.y(), (double)invertedQuaternion.z());
    }

    public final float dot(@NotNull Quaternionf a, @NotNull Quaternionf b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
    }

    @NotNull
    public final Quaternionf negate(@NotNull Quaternionf a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return new Quaternionf(-a.x, -a.y, -a.z, -a.w);
    }

    @NotNull
    public final Quaternionf normalize(@NotNull Quaternionf a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        float l = 1.0f / (float)Math.sqrt(this.dot(a, a));
        return new Quaternionf(l * a.x, l * a.y, l * a.z, l * a.w);
    }

    @NotNull
    public final Quaternionf lerp(@NotNull Quaternionf a, @NotNull Quaternionf b, float t) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Quaternionf bb = b;
        float l2 = this.dot(a, b);
        if (l2 < 0.0f) {
            bb = this.negate(b);
        }
        float cX = a.x - t * (a.x - bb.x);
        float cY = a.y - t * (a.y - bb.y);
        float cZ = a.z - t * (a.z - bb.z);
        float cW = a.w - t * (a.w - bb.w);
        return new Quaternionf(cX, cY, cZ, cW);
    }

    @NotNull
    public final Quaternionf nlerp(@NotNull Quaternionf a, @NotNull Quaternionf b, float t) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.normalize(this.lerp(a, b, t));
    }

    public final void writeQuatf(@NotNull ByteBuf byteBuf, @NotNull Quaternionf q) {
        Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        byteBuf.writeFloat(q.x());
        byteBuf.writeFloat(q.y());
        byteBuf.writeFloat(q.z());
        byteBuf.writeFloat(q.w());
    }

    @NotNull
    public final Quaternionf readQuatf(@NotNull ByteBuf byteBuf) {
        Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
        return new Quaternionf(byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.Axis.values().length];
            try {
                nArray[Direction.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

