/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.mixin.content.gas;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.clockwork.ClockworkGasses;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.util.gui.IHaveDuctStats;
import org.valkyrienskies.clockwork.util.gui.ProductionInfo;
import org.valkyrienskies.clockwork.util.gui.ProductionMethod;
import org.valkyrienskies.clockwork.util.gui.ProductionType;
import org.valkyrienskies.kelvin.api.DuctNode;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.NodeBehaviorType;
import org.valkyrienskies.kelvin.api.nodes.PipeDuctNode;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.util.INodeBlock;
import org.valkyrienskies.kelvin.util.KelvinExtensions;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mixin(value={ComposterBlock.class})
public class MixinComposterBlock
extends Block
implements INodeBlock,
IHaveDuctStats {
    @Unique
    Double vs_clockwork$$maxPressure = 100000.0;

    public MixinComposterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void vs_clockwork$$tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if ((Integer)state.m_61143_((Property)ComposterBlock.f_51913_) == 7) {
            DuctNetworkServer kelvin = ClockworkMod.getKelvin();
            ResourceLocation location = VSGameUtilsKt.getResourceKey((String)VSGameUtilsKt.getDimensionId((Level)level)).m_135782_();
            DuctNodePos ductNodePos = new DuctNodePos((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), location);
            double pressure = kelvin.getPressureAt(ductNodePos);
            if (pressure <= this.vs_clockwork$$maxPressure) {
                kelvin.addGasAtTemperature(ductNodePos, ClockworkGasses.INSTANCE.getMETHANE(), 0.05, 305.0);
            }
        }
    }

    @NotNull
    public DuctNode createNode(@NotNull DuctNodePos pos) {
        return new PipeDuctNode(pos, NodeBehaviorType.PIPE, new HashSet(), 1.0, 1.6375049E7, 1478.0);
    }

    public boolean canConnectTo(@NotNull BlockPos self, @NotNull BlockPos other, @NotNull Direction direction, @NotNull BlockGetter level) {
        return self.m_123331_((Vec3i)other) <= 1.0 && direction != Direction.UP;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        this.nodeRemove(pState, pLevel, pPos, pState, pIsMoving);
        super.m_6810_(pState, pLevel, pPos, pState, pIsMoving);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        this.nodePlace(pState, pLevel, pPos, pState, pIsMoving);
        super.m_6807_(pState, pLevel, pPos, pState, pIsMoving);
    }

    public void nodePlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.m_5776_()) {
            if (state.m_60795_() || !(state.m_60734_() instanceof INodeBlock)) {
                return;
            }
            ClockworkMod.getKelvin().addNode(KelvinExtensions.INSTANCE.toDuctNodePos(pos, level.m_46472_().m_135782_()), this.createNode(KelvinExtensions.INSTANCE.toDuctNodePos(pos, level.m_46472_().m_135782_())));
        }
    }

    public void nodeRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.m_5776_()) {
            if (newState.m_60795_() || !(newState.m_60734_() instanceof INodeBlock)) {
                ClockworkMod.getKelvin().removeNode(KelvinExtensions.INSTANCE.toDuctNodePos(pos, level.m_46472_().m_135782_()));
            }
        } else {
            ClockworkModClient.getKelvin().removeNode(KelvinExtensions.INSTANCE.toDuctNodePos(pos, level.m_46472_().m_135782_()));
        }
    }

    public void nodeAddClient(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos) {
    }

    public void nodeRemoveClient(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos) {
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull ResourceLocation, @NotNull ProductionInfo> getProductionStats() {
        HashMap<ResourceLocation, ProductionInfo> stats = new HashMap<ResourceLocation, ProductionInfo>();
        ResourceLocation methaneLocation = ClockworkGasses.INSTANCE.getMETHANE().getResourceLocation();
        stats.put(methaneLocation, new ProductionInfo(ProductionMethod.OTHER, ProductionType.CONDITIONAL, (Component)Component.m_237115_((String)"vs_clockwork.production_condition.composter_methane")));
        return stats;
    }
}

