/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.propulsion.sugar_rocket;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.content.forces.SugarRocketController;
import org.valkyrienskies.clockwork.content.propulsion.sugar_rocket.SugarRocketBlock;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\f\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u000107\u0012\b\u0010:\u001a\u0004\u0018\u000109\u0012\b\u0010<\u001a\u0004\u0018\u00010;\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010\u0006\u001a\u00020\u00052\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\rJ!\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\rJ\u001f\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u0019R\"\u0010\u001b\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010\u000bR\"\u0010 \u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u001c\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010\u000bR\"\u0010#\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u001c\u001a\u0004\b$\u0010\u001e\"\u0004\b%\u0010\u000bR\"\u0010&\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\"\u0010,\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010'\u001a\u0004\b,\u0010)\"\u0004\b-\u0010+R\"\u0010.\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010\u001c\u001a\u0004\b/\u0010\u001e\"\u0004\b0\u0010\u000bR\u001f\u00103\u001a\n 2*\u0004\u0018\u000101018\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106\u00a8\u0006?"}, d2={"Lorg/valkyrienskies/clockwork/content/propulsion/sugar_rocket/SugarRocketBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "", "amount", "addSugar", "(I)V", "tick", "()V", "induceIgnition", "time", "power", "ignite", "(II)V", "burn", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "burnProgress", "I", "getBurnProgress", "()I", "setBurnProgress", "burnTime", "getBurnTime", "setBurnTime", "burnPower", "getBurnPower", "setBurnPower", "hasNextBlock", "Z", "getHasNextBlock", "()Z", "setHasNextBlock", "(Z)V", "isBurning", "setBurning", "sugarCooldown", "getSugarCooldown", "setSugarCooldown", "Lnet/createmod/catnip/animation/LerpedFloat;", "kotlin.jvm.PlatformType", "clientBurnProgress", "Lnet/createmod/catnip/animation/LerpedFloat;", "getClientBurnProgress", "()Lnet/createmod/catnip/animation/LerpedFloat;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class SugarRocketBlockEntity
extends SmartBlockEntity {
    private int burnProgress;
    private int burnTime = 20;
    private int burnPower = 1;
    private boolean hasNextBlock;
    private boolean isBurning;
    private int sugarCooldown;
    private final LerpedFloat clientBurnProgress = LerpedFloat.linear().chase(0.0, 0.05, LerpedFloat.Chaser.LINEAR);

    public SugarRocketBlockEntity(@Nullable BlockEntityType<?> type, @Nullable BlockPos pos, @Nullable BlockState state) {
        super(type, pos, state);
        this.clientBurnProgress.setValue(0.0);
    }

    public final int getBurnProgress() {
        return this.burnProgress;
    }

    public final void setBurnProgress(int n) {
        this.burnProgress = n;
    }

    public final int getBurnTime() {
        return this.burnTime;
    }

    public final void setBurnTime(int n) {
        this.burnTime = n;
    }

    public final int getBurnPower() {
        return this.burnPower;
    }

    public final void setBurnPower(int n) {
        this.burnPower = n;
    }

    public final boolean getHasNextBlock() {
        return this.hasNextBlock;
    }

    public final void setHasNextBlock(boolean bl) {
        this.hasNextBlock = bl;
    }

    public final boolean isBurning() {
        return this.isBurning;
    }

    public final void setBurning(boolean bl) {
        this.isBurning = bl;
    }

    public final int getSugarCooldown() {
        return this.sugarCooldown;
    }

    public final void setSugarCooldown(int n) {
        this.sugarCooldown = n;
    }

    public final LerpedFloat getClientBurnProgress() {
        return this.clientBurnProgress;
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    public final void addSugar(int amount) {
        this.burnTime += 20 * amount;
        this.burnPower += amount;
        this.sugarCooldown = 4;
        this.sendData();
    }

    public void tick() {
        super.tick();
        if (this.sugarCooldown > 0) {
            int n = this.sugarCooldown;
            this.sugarCooldown = n + -1;
        }
        if (this.f_58857_ == null) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            if (this.isBurning) {
                this.burn();
            }
        } else {
            this.clientBurnProgress.tickChaser();
            if (this.isBurning) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
                ClientLevel clientLevel = (ClientLevel)level2;
                BlockPos blockPos = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)((Vec3i)blockPos));
                BlockPos blockPos2 = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
                Vec3 realWorldPosition = VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos2).m_82520_(0.5, 0.5, 0.5);
                Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_().m_122436_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
                Vector3d realDirection = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
                if (ship != null) {
                    realDirection = ship.getTransform().getRotation().transform((Vector3dc)realDirection, new Vector3d()).normalize();
                }
                Vector3d fireVelocity = realDirection.mul((double)this.burnPower * 0.5, new Vector3d());
                Vector3d smokeVelocity = realDirection.mul((double)this.burnPower, new Vector3d());
                Random random = new Random();
                for (int i = 0; i < 5; ++i) {
                    double fireRandomX = random.nextDouble(-0.15, 0.15);
                    double fireRandomY = random.nextDouble(-0.15, 0.15);
                    double fireRandomZ = random.nextDouble(-0.15, 0.15);
                    Vector3d thisFireVelocity = new Vector3d(fireVelocity.x + fireRandomX, fireVelocity.y + fireRandomY, fireVelocity.z + fireRandomZ);
                    clientLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, realWorldPosition.f_82479_, realWorldPosition.f_82480_, realWorldPosition.f_82481_, thisFireVelocity.x, thisFireVelocity.y, thisFireVelocity.z);
                }
                for (int j = 0; j < 13; ++j) {
                    double sparkRandomX = random.nextDouble(-0.5, 0.5);
                    double sparkRandomY = random.nextDouble(-0.5, 0.5);
                    double sparkRandomZ = random.nextDouble(-0.5, 0.5);
                    Vector3d thisSparkVelocity = new Vector3d(fireVelocity.x + sparkRandomX, fireVelocity.y + sparkRandomY, fireVelocity.z + sparkRandomZ);
                    clientLevel.m_7106_((ParticleOptions)ParticleTypes.f_175834_, realWorldPosition.f_82479_, realWorldPosition.f_82480_, realWorldPosition.f_82481_, thisSparkVelocity.x, thisSparkVelocity.y, thisSparkVelocity.z);
                }
                clientLevel.m_7106_((ParticleOptions)ParticleTypes.f_123777_, realWorldPosition.f_82479_, realWorldPosition.f_82480_, realWorldPosition.f_82481_, smokeVelocity.x, smokeVelocity.y, smokeVelocity.z);
            }
        }
    }

    public final void induceIgnition() {
        block6: {
            block5: {
                if (this.f_58857_ == null) break block5;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!level.f_46443_) break block6;
            }
            return;
        }
        if (this.isBurning) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        ServerLevel slevel = (ServerLevel)level;
        Block block = slevel.m_8055_(this.f_58858_).m_60734_();
        if (!(block instanceof SugarRocketBlock)) {
            return;
        }
        SugarRocketBlock sugarRocketBlock = (SugarRocketBlock)block;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        BlockState blockState = slevel.m_8055_(this.f_58858_);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        sugarRocketBlock.triggerAdjacent(slevel, blockPos, blockState);
    }

    public final void ignite(int time, int power) {
        this.isBurning = true;
        this.burnTime = time;
        this.burnPower = power;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        Vec3 realWorldPosition = VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos).m_82520_(0.5, 0.5, 0.5);
        serverLevel.m_6263_(null, realWorldPosition.f_82479_, realWorldPosition.f_82480_, realWorldPosition.f_82481_, SoundEvents.f_11932_, SoundSource.BLOCKS, 1.0f, 0.05f);
        BlockPos blockPos2 = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos2));
        if (ship != null) {
            SugarRocketController sugarRocketController = SugarRocketController.Companion.getOrCreate(ship);
            BlockPos blockPos3 = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"worldPosition");
            double d = (double)this.burnPower * ClockworkConfig.SERVER.getSugarRocketBlockThrust();
            Comparable comparable = this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            sugarRocketController.addRocket(blockPos3, d, (Direction)comparable);
        }
        this.sendData();
    }

    public static /* synthetic */ void ignite$default(SugarRocketBlockEntity sugarRocketBlockEntity, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = sugarRocketBlockEntity.burnTime;
        }
        if ((n3 & 2) != 0) {
            n2 = sugarRocketBlockEntity.burnPower;
        }
        sugarRocketBlockEntity.ignite(n, n2);
    }

    public final void burn() {
        int n = this.burnProgress;
        this.burnProgress = n + 1;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
        BlockPos blockPos2 = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
        Vec3 realWorldPosition = VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos2).m_82520_(0.5, 0.5, 0.5);
        if (this.burnProgress >= this.burnTime) {
            this.isBurning = false;
            serverLevel.m_6263_(null, realWorldPosition.f_82479_, realWorldPosition.f_82480_, realWorldPosition.f_82481_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.4f, 0.35f);
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            BlockEntity nextBlock = level2.m_7702_(this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)));
            if (nextBlock instanceof SugarRocketBlockEntity && !((SugarRocketBlockEntity)nextBlock).isBurning) {
                ((SugarRocketBlockEntity)nextBlock).ignite(this.burnTime, this.burnPower);
            }
            if (ship != null) {
                SugarRocketController sugarRocketController = SugarRocketController.Companion.getOrCreate(ship);
                BlockPos blockPos3 = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"worldPosition");
                sugarRocketController.removeRocket(blockPos3);
            }
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            level3.m_46961_(this.f_58858_, false);
        }
        this.sendData();
    }

    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.write(tag, clientPacket);
        tag.m_128379_("burning", this.isBurning);
        tag.m_128405_("burnProgress", this.burnProgress);
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("burnPower", this.burnPower);
    }

    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.read(tag, clientPacket);
        boolean wasBurning = this.isBurning;
        this.isBurning = tag.m_128471_("burning");
        this.burnProgress = tag.m_128451_("burnProgress");
        this.burnTime = tag.m_128451_("burnTime");
        this.burnPower = tag.m_128451_("burnPower");
        if (clientPacket && this.isBurning) {
            this.clientBurnProgress.updateChaseTarget((float)((double)this.burnProgress / (double)this.burnTime));
            if (!wasBurning && this.f_58857_ != null) {
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                BlockPos blockPos = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                Vec3 realWorldPos = VSGameUtilsKt.toWorldCoordinates((Level)level, (BlockPos)blockPos).m_82520_(0.5, 0.5, 0.5);
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                level2.m_7106_((ParticleOptions)ParticleTypes.f_123747_, realWorldPos.f_82479_, realWorldPos.f_82480_, realWorldPos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }
}

