/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.propulsion.sugar_rocket;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.data.UniqueLinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkBlockEntities;
import org.valkyrienskies.clockwork.content.forces.SugarRocketController;
import org.valkyrienskies.clockwork.content.propulsion.sugar_rocket.SugarRocketBlockEntity;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u000f\u0012\u0006\u0010A\u001a\u00020@\u00a2\u0006\u0004\bB\u0010CJ\u0015\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0018\u001a\u00020\u00172\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000b0\u0014H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J7\u0010\"\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J#\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0&2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b'\u0010(J/\u0010-\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020)2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b-\u0010.J%\u00100\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\u0004\b0\u00101J?\u00105\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020 H\u0016\u00a2\u0006\u0004\b5\u00106J7\u00108\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u000b2\u0006\u00104\u001a\u00020 H\u0016\u00a2\u0006\u0004\b8\u0010#J?\u0010>\u001a\u00020=2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010:\u001a\u0002092\u0006\u0010<\u001a\u00020;2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b>\u0010?\u00a8\u0006D"}, d2={"Lorg/valkyrienskies/clockwork/content/propulsion/sugar_rocket/SugarRocketBlock;", "Lnet/minecraft/world/level/block/DirectionalBlock;", "Lcom/simibubi/create/foundation/block/IBE;", "Lorg/valkyrienskies/clockwork/content/propulsion/sugar_rocket/SugarRocketBlockEntity;", "Lcom/simibubi/create/content/equipment/wrench/IWrenchable;", "Ljava/lang/Class;", "getBlockEntityClass", "()Ljava/lang/Class;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getBlockEntityType", "()Lnet/minecraft/world/level/block/entity/BlockEntityType;", "Lnet/minecraft/world/level/block/state/BlockState;", "pState", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "context", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "state", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "newState", "", "movedByPiston", "onRemove", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/core/Direction$Axis;", "ignoreAxis", "", "getAxialPositions", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)Ljava/util/List;", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/entity/projectile/Projectile;", "projectile", "onProjectileHit", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/phys/BlockHitResult;Lnet/minecraft/world/entity/projectile/Projectile;)V", "Lnet/minecraft/server/level/ServerLevel;", "triggerAdjacent", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "block", "fromPos", "isMoving", "neighborChanged", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "oldState", "onPlace", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResult;", "use", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "clockwork"})
public final class SugarRocketBlock
extends DirectionalBlock
implements IBE<SugarRocketBlockEntity>,
IWrenchable {
    public SugarRocketBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.UP));
    }

    @NotNull
    public Class<SugarRocketBlockEntity> getBlockEntityClass() {
        return SugarRocketBlockEntity.class;
    }

    @NotNull
    public BlockEntityType<? extends SugarRocketBlockEntity> getBlockEntityType() {
        Object object = ClockworkBlockEntities.SUGAR_ROCKET.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (BlockEntityType)object;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)context.m_7820_().m_122424_());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{DirectionalBlock.f_52588_};
        super.m_7926_(builder.m_61104_(propertyArray));
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (level.f_46443_) {
            super.m_6810_(state, level, pos, newState, movedByPiston);
            return;
        }
        LoadedServerShip ship = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)((ServerLevel)level), (Vec3i)((Vec3i)pos));
        if (ship != null) {
            SugarRocketController.Companion.getOrCreate(ship).removeRocket(pos);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    public final List<BlockPos> getAxialPositions(@NotNull BlockPos pos, @NotNull Direction.Axis ignoreAxis) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)ignoreAxis, (String)"ignoreAxis");
        List list = new ArrayList();
        for (Direction.Axis axis : EntriesMappings.entries$0) {
            if (axis == ignoreAxis) continue;
            BlockPos blockPos = pos.m_121945_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
            list.add(blockPos);
            BlockPos blockPos2 = pos.m_121945_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"relative(...)");
            list.add(blockPos2);
        }
        return list;
    }

    public void m_5581_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockHitResult hit, @NotNull Projectile projectile) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        Intrinsics.checkNotNullParameter((Object)projectile, (String)"projectile");
        super.m_5581_(level, state, hit, projectile);
        if ((projectile.m_6060_() || projectile instanceof Fireball) && !projectile.m_20070_()) {
            if (level.f_46443_) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = hit.m_82425_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.triggerAdjacent(serverLevel, blockPos, state);
        }
    }

    public final boolean triggerAdjacent(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Direction.Axis ignoreAxis = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_();
        UniqueLinkedList triggerPositions = new UniqueLinkedList();
        triggerPositions.add((Object)pos);
        Direction.Axis axis = ignoreAxis;
        Intrinsics.checkNotNull((Object)axis);
        triggerPositions.addAll((Collection)this.getAxialPositions(pos, axis));
        Direction referenceFacing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        Set visited = new LinkedHashSet();
        List toTrigger = new ArrayList();
        int highestSugarPower = 0;
        while (!((Collection)triggerPositions).isEmpty()) {
            SugarRocketBlockEntity blockEntity;
            BlockPos newpos = (BlockPos)triggerPositions.poll();
            if (visited.contains(newpos)) continue;
            Intrinsics.checkNotNull((Object)newpos);
            visited.add(newpos);
            BlockEntity blockEntity2 = level.m_7702_(newpos);
            if ((blockEntity2 instanceof SugarRocketBlockEntity ? (SugarRocketBlockEntity)blockEntity2 : null) == null) continue;
            blockEntity = blockEntity;
            BlockState blockState = level.m_8055_(newpos);
            if (referenceFacing != blockState.m_61143_((Property)DirectionalBlock.f_52588_)) continue;
            if (blockEntity.getBurnPower() > highestSugarPower) {
                highestSugarPower = blockEntity.getBurnPower();
            }
            toTrigger.add(newpos);
            blockEntity2 = ignoreAxis;
            Intrinsics.checkNotNull((Object)blockEntity2);
            triggerPositions.addAll((Collection)this.getAxialPositions(newpos, (Direction.Axis)blockEntity2));
        }
        for (BlockPos triggerPos : toTrigger) {
            if (!(level.m_7702_(triggerPos) instanceof SugarRocketBlockEntity)) continue;
            BlockEntity blockEntity = level.m_7702_(triggerPos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.propulsion.sugar_rocket.SugarRocketBlockEntity");
            SugarRocketBlockEntity blockEntity3 = (SugarRocketBlockEntity)blockEntity;
            blockEntity3.ignite(20 * highestSugarPower, highestSugarPower);
        }
        return visited.size() > 0;
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        if (!(level.m_7702_(pos.m_121945_((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_))) instanceof SugarRocketBlockEntity) || level.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_))).m_61143_((Property)DirectionalBlock.f_52588_) != state.m_61143_((Property)DirectionalBlock.f_52588_)) {
            this.withBlockEntityDo((BlockGetter)level, pos, SugarRocketBlock::neighborChanged$lambda$0);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        super.m_6807_(state, level, pos, oldState, isMoving);
        boolean hasNextBlock = level.m_7702_(pos.m_121945_((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_))) instanceof SugarRocketBlockEntity && level.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_))).m_61143_((Property)DirectionalBlock.f_52588_) == state.m_61143_((Property)DirectionalBlock.f_52588_);
        BlockEntity blockEntity = level.m_7702_(pos);
        SugarRocketBlockEntity sugarRocketBlockEntity = blockEntity instanceof SugarRocketBlockEntity ? (SugarRocketBlockEntity)blockEntity : null;
        if (sugarRocketBlockEntity == null) {
            return;
        }
        SugarRocketBlockEntity blockEntity2 = sugarRocketBlockEntity;
        blockEntity2.setHasNextBlock(hasNextBlock);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (!level.f_46443_) {
            BlockEntity blockEntity = level.m_7702_(pos);
            SugarRocketBlockEntity sugarRocketBlockEntity = blockEntity instanceof SugarRocketBlockEntity ? (SugarRocketBlockEntity)blockEntity : null;
            if (sugarRocketBlockEntity == null) {
                return InteractionResult.FAIL;
            }
            SugarRocketBlockEntity be = sugarRocketBlockEntity;
            if (be.isBurning()) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_150930_(Items.f_42501_)) {
                BlockEntity blockEntity2 = level.m_7702_(pos);
                SugarRocketBlockEntity sugarRocketBlockEntity2 = blockEntity2 instanceof SugarRocketBlockEntity ? (SugarRocketBlockEntity)blockEntity2 : null;
                if (sugarRocketBlockEntity2 == null) {
                    return InteractionResult.FAIL;
                }
                SugarRocketBlockEntity blockEntity3 = sugarRocketBlockEntity2;
                if (blockEntity3.getSugarCooldown() == 0) {
                    blockEntity3.addSugar(1);
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.m_150930_(Items.f_42409_)) {
                this.triggerAdjacent((ServerLevel)level, pos, state);
                stack.m_41622_(1, (LivingEntity)player, arg_0 -> SugarRocketBlock.use$lambda$1(stack, arg_0));
                ((ServerLevel)level).m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_150930_(Items.f_42613_)) {
                this.triggerAdjacent((ServerLevel)level, pos, state);
                stack.m_41774_(1);
                ((ServerLevel)level).m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        InteractionResult interactionResult = super.m_6227_(state, level, pos, player, hand, hit);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"use(...)");
        return interactionResult;
    }

    private static final void neighborChanged$lambda$0(SugarRocketBlockEntity blockEntity) {
        blockEntity.setHasNextBlock(false);
    }

    private static final void use$lambda$1(ItemStack $stack, Player it) {
        $stack.m_41774_(1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction.Axis> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.Axis.values()));
        }
    }
}

