/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.physicalities.gyro;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.attachment.AttachmentHolder;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerTickListener;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0001=B\u0007\u00a2\u0006\u0004\b<\u0010\u0010J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\"\u0010\u001e\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001c\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u001c\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R*\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020&8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010/\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b/\u0010\u0019\u001a\u0004\b0\u00101R$\u00103\u001a\u0004\u0018\u0001028\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u0010\u000b\u001a\u00020\n8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u0019\u001a\u0004\b9\u00101\"\u0004\b:\u0010;\u00a8\u0006>"}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/ServerTickListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "", "speed", "", "speedToForce", "(F)D", "deleteIfEmpty", "()V", "Lorg/joml/Vector3dc;", "shipUp", "power", "pointTowards", "(Lorg/joml/Vector3dc;F)V", "onServerTick", "Lorg/joml/Vector3dc;", "targetStrength", "F", "physConsumption", "extraForceLinear", "D", "extraForceAngular", "powerLinear", "getPowerLinear", "()D", "setPowerLinear", "(D)V", "powerAngular", "getPowerAngular", "setPowerAngular", "", "v", "gyros", "I", "getGyros", "()I", "setGyros", "(I)V", "value", "consumed", "getConsumed", "()F", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShip$clockwork", "()Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "setShip$clockwork", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)V", "getSpeed$clockwork", "setSpeed$clockwork", "(F)V", "<init>", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nGyroShipControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GyroShipControl.kt\norg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl\n+ 2 AttachmentHolder.kt\norg/valkyrienskies/core/api/attachment/AttachmentHolderKt\n*L\n1#1,101:1\n80#2:102\n*S KotlinDebug\n*F\n+ 1 GyroShipControl.kt\norg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl\n*L\n72#1:102\n*E\n"})
public final class GyroShipControl
implements ShipPhysicsListener,
ServerTickListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vector3dc shipUp = (Vector3dc)new Vector3d(0.0, 1.0, 0.0);
    private float targetStrength = 1.0f;
    private float physConsumption;
    private double extraForceLinear;
    private double extraForceAngular;
    private double powerLinear;
    private double powerAngular;
    private int gyros;
    private float consumed;
    @JsonIgnore
    @Nullable
    private LoadedServerShip ship;
    private float speed;

    public final double getPowerLinear() {
        return this.powerLinear;
    }

    public final void setPowerLinear(double d) {
        this.powerLinear = d;
    }

    public final double getPowerAngular() {
        return this.powerAngular;
    }

    public final void setPowerAngular(double d) {
        this.powerAngular = d;
    }

    public final int getGyros() {
        return this.gyros;
    }

    public final void setGyros(int v) {
        this.gyros = v;
        this.deleteIfEmpty();
    }

    public final float getConsumed() {
        return this.consumed;
    }

    @Nullable
    public final LoadedServerShip getShip$clockwork() {
        return this.ship;
    }

    public final void setShip$clockwork(@Nullable LoadedServerShip loadedServerShip) {
        this.ship = loadedServerShip;
    }

    public final float getSpeed$clockwork() {
        return this.speed;
    }

    public final void setSpeed$clockwork(float f) {
        this.speed = f;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        if (this.gyros < 1) {
            return;
        }
        Vector3d vector3d = physShip.getTransform().getShipToWorldRotation().transform(this.shipUp, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transform(...)");
        Vector3dc shipWorldUp = (Vector3dc)vector3d;
        Vector3d offAxisOmega = physShip.getAngularVelocity().sub((Vector3dc)shipWorldUp.normalize(physShip.getAngularVelocity().dot(shipWorldUp), new Vector3d()), new Vector3d());
        Vector3d idealOmega = shipWorldUp.cross((Vector3dc)new Vector3d(0.0, 1.0, 0.0), new Vector3d()).sub((Vector3dc)offAxisOmega);
        Vector3d idealTorque = physShip.getTransform().getShipToWorldRotation().transform(physShip.getMomentOfInertia().transform(physShip.getTransform().getShipToWorldRotation().transformInverse((Vector3dc)idealOmega, new Vector3d())));
        idealTorque.mul(Math.abs(this.speedToForce(this.speed)));
        Intrinsics.checkNotNull((Object)idealTorque);
        physShip.applyWorldTorque((Vector3dc)idealTorque);
    }

    private final double speedToForce(float speed) {
        double y = 128.0 / (1.0 + Math.exp((double)6 - (double)speed * 0.05));
        return RangesKt.coerceIn((double)y, (double)0.0, (double)100.0);
    }

    private final void deleteIfEmpty() {
        block1: {
            if (this.gyros > 0) break block1;
            LoadedServerShip loadedServerShip = this.ship;
            if (loadedServerShip != null) {
                AttachmentHolder $this$removeAttachment$iv = (AttachmentHolder)loadedServerShip;
                boolean $i$f$removeAttachment = false;
                GyroShipControl cfr_ignored_0 = (GyroShipControl)$this$removeAttachment$iv.removeAttachment(GyroShipControl.class);
            }
        }
    }

    public final void pointTowards(@NotNull Vector3dc shipUp, float power) {
        Intrinsics.checkNotNullParameter((Object)shipUp, (String)"shipUp");
        this.shipUp = shipUp;
        this.targetStrength = power;
    }

    public void onServerTick() {
        this.extraForceLinear = this.powerLinear;
        this.powerLinear = 0.0;
        this.extraForceAngular = this.powerAngular;
        this.powerAngular = 0.0;
        this.consumed = this.physConsumption * 0.1f;
        this.physConsumption = 0.0f;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl;", "<init>", "()V", "clockwork"})
    @SourceDebugExtension(value={"SMAP\nGyroShipControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GyroShipControl.kt\norg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl$Companion\n+ 2 AttachmentHolder.kt\norg/valkyrienskies/core/api/attachment/AttachmentHolderKt\n*L\n1#1,101:1\n66#2:102\n*S KotlinDebug\n*F\n+ 1 GyroShipControl.kt\norg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl$Companion\n*L\n94#1:102\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GyroShipControl getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            AttachmentHolder $this$getAttachment$iv = (AttachmentHolder)ship;
            boolean $i$f$getAttachment = false;
            GyroShipControl gyroShipControl = (GyroShipControl)$this$getAttachment$iv.getAttachment(GyroShipControl.class);
            if (gyroShipControl == null) {
                GyroShipControl gyroShipControl2;
                GyroShipControl it = gyroShipControl2 = new GyroShipControl();
                boolean bl = false;
                ship.setAttachment((Object)it);
                gyroShipControl = gyroShipControl2;
            }
            return gyroShipControl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

