/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.solid.delivery.chute;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.depot.EjectorBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.ActiveChutes;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.frequency_slot.FrequencySlotBehaviour;
import org.valkyrienskies.clockwork.platform.SolidDeliveryMethods;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00015B%\u0012\f\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010-\u0012\u0006\u00100\u001a\u00020/\u0012\u0006\u00102\u001a\u000201\u00a2\u0006\u0004\b3\u00104J\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000b\u0010\tJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010$\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010\u000e\"\u0004\b'\u0010(R\u0011\u0010,\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00066"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "tick", "()V", "remove", "destroy", "", "isOnShip", "()Z", "Lorg/joml/Vector3dc;", "getVelocity", "()Lorg/joml/Vector3dc;", "Lnet/minecraft/world/item/ItemStack;", "newStack", "simulate", "receiveItem", "(Lnet/minecraft/world/item/ItemStack;Z)Z", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotBehaviour;", "frequencySlotBehaviour", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotBehaviour;", "getFrequencySlotBehaviour", "()Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotBehaviour;", "setFrequencySlotBehaviour", "(Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotBehaviour;)V", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "getItemStack", "()Lnet/minecraft/world/item/ItemStack;", "setItemStack", "(Lnet/minecraft/world/item/ItemStack;)V", "busy", "Z", "getBusy", "setBusy", "(Z)V", "Lorg/joml/Vector3d;", "getRealPos", "()Lorg/joml/Vector3d;", "realPos", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "FrequencySlot", "clockwork"})
public final class DeliveryChuteBlockEntity
extends SmartBlockEntity {
    public FrequencySlotBehaviour frequencySlotBehaviour;
    @NotNull
    private ItemStack itemStack;
    private boolean busy;

    public DeliveryChuteBlockEntity(@Nullable BlockEntityType<?> typeIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(typeIn, pos, state);
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.itemStack = itemStack;
    }

    @NotNull
    public final FrequencySlotBehaviour getFrequencySlotBehaviour() {
        FrequencySlotBehaviour frequencySlotBehaviour = this.frequencySlotBehaviour;
        if (frequencySlotBehaviour != null) {
            return frequencySlotBehaviour;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"frequencySlotBehaviour");
        return null;
    }

    public final void setFrequencySlotBehaviour(@NotNull FrequencySlotBehaviour frequencySlotBehaviour) {
        Intrinsics.checkNotNullParameter((Object)((Object)frequencySlotBehaviour), (String)"<set-?>");
        this.frequencySlotBehaviour = frequencySlotBehaviour;
    }

    @NotNull
    public final ItemStack getItemStack() {
        return this.itemStack;
    }

    public final void setItemStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.itemStack = itemStack;
    }

    public final boolean getBusy() {
        return this.busy;
    }

    public final void setBusy(boolean bl) {
        this.busy = bl;
    }

    @NotNull
    public final Vector3d getRealPos() {
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return ClockworkUtils.INSTANCE.getRealPos(this.f_58857_, blockPos);
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        this.setFrequencySlotBehaviour(new FrequencySlotBehaviour(this, (ValueBoxTransform)new FrequencySlot()));
        behaviours.add(this.getFrequencySlotBehaviour());
    }

    public void tick() {
        block6: {
            block5: {
                if (this.f_58857_ == null) break block5;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!level.f_46443_) break block6;
            }
            return;
        }
        if (ActiveChutes.INSTANCE.getActives().get(this.f_58858_) == null) {
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            ActiveChutes.INSTANCE.addChute(blockPos, this);
        }
        if (!this.itemStack.m_41619_()) {
            SolidDeliveryMethods.pushTo(this.f_58857_, this);
        }
    }

    public void remove() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        ActiveChutes.INSTANCE.removeChute(blockPos);
        super.remove();
    }

    public void destroy() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        ActiveChutes.INSTANCE.removeChute(blockPos);
        super.destroy();
    }

    public final boolean isOnShip() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return false;
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        ServerLevel serverLevel = (ServerLevel)level2;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos)) != null;
    }

    @Nullable
    public final Vector3dc getVelocity() {
        Vector3dc vector3dc;
        if (this.isOnShip()) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
            Intrinsics.checkNotNull((Object)loadedServerShip);
            vector3dc = loadedServerShip.getVelocity();
        } else {
            vector3dc = null;
        }
        return vector3dc;
    }

    public final boolean receiveItem(@NotNull ItemStack newStack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)newStack, (String)"newStack");
        if (this.itemStack.m_41619_()) {
            if (!simulate) {
                this.itemStack = newStack;
            }
            return true;
        }
        if (this.itemStack.m_150930_(newStack.m_41720_()) && this.itemStack.m_41613_() + newStack.m_41613_() <= this.itemStack.m_41741_()) {
            if (!simulate) {
                newStack.m_41764_(newStack.m_41613_() + this.itemStack.m_41613_());
            }
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean receiveItem$default(DeliveryChuteBlockEntity deliveryChuteBlockEntity, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return deliveryChuteBlockEntity.receiveItem(itemStack, bl);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity$FrequencySlot;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform$Sided;", "Lnet/minecraft/world/level/LevelAccessor;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/phys/Vec3;", "getLocalOffset", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/phys/Vec3;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "", "rotate", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/mojang/blaze3d/vertex/PoseStack;)V", "", "angle", "(Lnet/minecraft/world/level/block/state/BlockState;)F", "Lnet/minecraft/core/Direction;", "direction", "", "isSideActive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z", "getSouthLocation", "()Lnet/minecraft/world/phys/Vec3;", "<init>", "()V", "clockwork"})
    private static final class FrequencySlot
    extends ValueBoxTransform.Sided {
        @NotNull
        public Vec3 getLocalOffset(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
            Vec3 vec3;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (this.direction != Direction.UP) {
                Vec3 vec32 = super.getLocalOffset(level, pos, state);
                vec3 = vec32;
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getLocalOffset(...)");
            } else {
                Vec3 vec33 = new Vec3(0.5, 0.65625, 0.5).m_82549_(VecHelper.rotate((Vec3)VecHelper.voxelSpace((double)0.0, (double)0.0, (double)-5.0), (double)this.angle(state), (Direction.Axis)Direction.Axis.Y));
                vec3 = vec33;
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
            }
            return vec3;
        }

        public void rotate(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull PoseStack ms) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
            if (this.direction != Direction.UP) {
                super.rotate(level, pos, state, ms);
                return;
            }
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(this.angle(state))).rotateXDegrees(90.0f);
        }

        private final float angle(BlockState state) {
            return AllBlocks.WEIGHTED_EJECTOR.has(state) ? AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_(EjectorBlock.HORIZONTAL_FACING))) : 0.0f;
        }

        protected boolean isSideActive(@NotNull BlockState state, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            return direction != Direction.UP && direction != Direction.DOWN;
        }

        @NotNull
        protected Vec3 getSouthLocation() {
            Vec3 vec3;
            if (this.direction == Direction.UP) {
                Vec3 vec32 = Vec3.f_82478_;
                vec3 = vec32;
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
            } else {
                Vec3 vec33 = VecHelper.voxelSpace((double)8.0, (double)6.0, (double)15.5);
                vec3 = vec33;
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"voxelSpace(...)");
            }
            return vec3;
        }
    }
}

