/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.solid.delivery.cannon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.Affine;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.cannon.DeliveryCannonBlockEntity;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.frequency_slot.FrequencySlotRenderer;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.clockwork.util.EaseHelper;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00014B\u0011\u0012\b\u00101\u001a\u0004\u0018\u000100\u00a2\u0006\u0004\b2\u00103J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J=\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u001d\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001d\u0010\u001bJE\u0010$\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b(\u0010)R\u0017\u0010*\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b.\u0010+\u001a\u0004\b/\u0010-\u00a8\u00065"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonRenderer;", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotRenderer;", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity;", "be", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "handleShootingAnim", "(Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity;F)V", "Lnet/minecraft/world/phys/Vec3;", "launchedItemPos", "renderItem", "(Lnet/minecraft/world/phys/Vec3;Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity;IILnet/minecraft/client/renderer/MultiBufferSource;Lcom/mojang/blaze3d/vertex/PoseStack;)V", "Lnet/createmod/catnip/render/SuperByteBuffer;", "superByteBuffer", "", "angle", "rotateToAngle", "(Lnet/createmod/catnip/render/SuperByteBuffer;D)Lnet/createmod/catnip/render/SuperByteBuffer;", "rotateCentered", "rotateAntenna", "mount", "base", "barrel", "antenna", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vb", "render", "(Lnet/createmod/catnip/render/SuperByteBuffer;Lnet/createmod/catnip/render/SuperByteBuffer;Lnet/createmod/catnip/render/SuperByteBuffer;Lnet/createmod/catnip/render/SuperByteBuffer;Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;I)V", "blockEntity", "", "shouldRenderOffScreen", "(Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity;)Z", "pivot", "Lnet/minecraft/world/phys/Vec3;", "getPivot", "()Lnet/minecraft/world/phys/Vec3;", "antennaPivot", "getAntennaPivot", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "Companion", "clockwork"})
public final class DeliveryCannonRenderer
extends FrequencySlotRenderer<DeliveryCannonBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vec3 pivot = new Vec3(0.0, 1.0, 0.5);
    @NotNull
    private final Vec3 antennaPivot = new Vec3(0.75, 1.3125, 0.75);

    public DeliveryCannonRenderer(@Nullable BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public final Vec3 getPivot() {
        return this.pivot;
    }

    @NotNull
    public final Vec3 getAntennaPivot() {
        return this.antennaPivot;
    }

    @Override
    protected void renderSafe(@NotNull DeliveryCannonBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        SuperByteBuffer antenna = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCANNON_ANTENNA(), (BlockState)be.m_58900_());
        SuperByteBuffer base = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCANNON_BASE(), (BlockState)be.m_58900_());
        SuperByteBuffer mount = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCANNON_MOUNT(), (BlockState)be.m_58900_());
        SuperByteBuffer barrel = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCANNON_BARREL(), (BlockState)be.m_58900_());
        double xCurrentRotation = be.getXRot().getValue(partialTicks);
        double yCurrentRotation = be.getYRot().getValue(partialTicks);
        this.handleShootingAnim(be, partialTicks);
        SuperByteBuffer superByteBuffer = mount;
        Intrinsics.checkNotNull((Object)superByteBuffer);
        mount = this.rotateCentered(superByteBuffer, xCurrentRotation);
        superByteBuffer = base;
        Intrinsics.checkNotNull((Object)superByteBuffer);
        base = this.rotateCentered(superByteBuffer, xCurrentRotation);
        superByteBuffer = barrel;
        Intrinsics.checkNotNull((Object)superByteBuffer);
        barrel = this.rotateCentered(superByteBuffer, xCurrentRotation);
        superByteBuffer = antenna;
        Intrinsics.checkNotNull((Object)superByteBuffer);
        antenna = this.rotateCentered(superByteBuffer, xCurrentRotation);
        double clientCannonRotOffsetRad = (double)be.getClientCannonRotationOffset() * 15.0;
        double clientAntennaRotOffsetRad = (double)be.getClientAntennaRotationOffset() * 25.0;
        base = this.rotateToAngle(base, yCurrentRotation + clientCannonRotOffsetRad);
        antenna = this.rotateToAngle(antenna, yCurrentRotation + clientCannonRotOffsetRad);
        barrel = this.rotateToAngle(barrel, yCurrentRotation + clientCannonRotOffsetRad);
        antenna = this.rotateAntenna(antenna, yCurrentRotation + clientAntennaRotOffsetRad);
        barrel.translate(new Vec3(0.0, 0.0, (double)be.getClientBarrelOffset() * 2.0 / 16.0));
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110463_());
        Intrinsics.checkNotNull((Object)vb);
        this.render(mount, base, barrel, antenna, ms, vb, light);
        if (!be.getMidAirStack().m_41619_() && be.getShootingAtChute() != null) {
            if (!be.getFired()) {
                Level level = be.m_58904_();
                BlockPos blockPos = be.getShootingAtChute();
                Intrinsics.checkNotNull((Object)blockPos);
                Vector3d chutePosition = ClockworkUtils.INSTANCE.getRealPos(level, blockPos);
                Vector3d middlePosition = DeliveryCannonBlockEntity.Companion.getThirdPoint(be.getRealPos(), chutePosition);
                Vector3d lookDir = middlePosition.sub((Vector3dc)be.getRealPos(), new Vector3d()).normalize();
                for (int i = 0; i < 10; ++i) {
                    Random r = new Random();
                    double pV = 0.25;
                    Vector3d particlePosition = be.getRealPos().add((Vector3dc)lookDir.mul(2.0, new Vector3d())).add(r.nextDouble() * pV - pV / (double)2, r.nextDouble() * pV - pV / (double)2, r.nextDouble() * pV - pV / (double)2);
                    double sV = 0.05;
                    Vector3d particleSpeed = lookDir.mul(0.05, new Vector3d()).add(r.nextDouble() * sV - sV / (double)2, r.nextDouble() * sV - sV / (double)2, r.nextDouble() * sV - sV / (double)2);
                    Level level2 = be.m_58904_();
                    Intrinsics.checkNotNull((Object)level2);
                    level2.m_7106_((ParticleOptions)ParticleTypes.f_123796_, particlePosition.x, particlePosition.y, particlePosition.z, particleSpeed.x, particleSpeed.y, particleSpeed.z);
                }
                be.setFired(true);
            }
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            Intrinsics.checkNotNull((Object)clientLevel);
            Level level = (Level)clientLevel;
            BlockPos blockPos = be.getShootingAtChute();
            Intrinsics.checkNotNull((Object)blockPos);
            Vector3d realChute = ClockworkUtils.INSTANCE.getRealPos(level, blockPos);
            Vector3d og = be.getRealPos().lerp((Vector3dc)realChute, (double)(be.getDistance().getValue(partialTicks) / be.getDistance().getChaseTarget()));
            Intrinsics.checkNotNull((Object)og);
            double y = be.getParabolaY(og);
            be.setClientItemRotation(be.getClientItemRotation() + (double)partialTicks * (be.getGunpowderedCoefficient() + 1.0));
            this.renderItem(new Vec3(og.x, y, og.z), be, light, overlay, buffer, ms);
        } else {
            be.setFired(false);
            be.setClientItemRotation(0.0);
        }
    }

    public final void handleShootingAnim(@NotNull DeliveryCannonBlockEntity be, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        if (!be.getMidAirStack().m_41619_()) {
            be.setClientShotProgress(Mth.m_14008_((double)(be.getClientShotProgress() + (double)partialTicks), (double)0.0, (double)12.0));
            if (be.getClientShotProgress() <= 4.0) {
                be.setClientAntennaRotationOffset(EaseHelper.INSTANCE.easeOutElastic((float)be.getClientShotProgress() / 4.0f));
                be.setClientCannonRotationOffset(EaseHelper.INSTANCE.easeOutQuad((float)be.getClientShotProgress() / 4.0f));
            } else if (be.getClientShotProgress() <= 8.0) {
                be.setClientAntennaRotationOffset(0.5f - EaseHelper.INSTANCE.easeOutElastic(((float)be.getClientShotProgress() - 5.0f) / 7.0f));
                be.setClientCannonRotationOffset(1.0f - EaseHelper.INSTANCE.easeInOutSine(((float)be.getClientShotProgress() - 5.0f) / 7.0f));
            } else {
                be.setClientAntennaRotationOffset(Mth.m_14179_((float)(partialTicks / 2.0f), (float)be.getClientAntennaRotationOffset(), (float)0.0f));
                be.setClientCannonRotationOffset(1.0f - EaseHelper.INSTANCE.easeInOutSine(((float)be.getClientShotProgress() - 5.0f) / 7.0f));
            }
            if (be.getClientShotProgress() <= 3.0) {
                be.setClientBarrelOffset(EaseHelper.INSTANCE.easeOutOvershoot((float)be.getClientShotProgress() / 3.0f));
            } else {
                be.setClientBarrelOffset(1.0f - EaseHelper.INSTANCE.easeInOutQuad(((float)be.getClientShotProgress() - 4.0f) / 8.0f));
            }
        } else {
            be.setClientShotProgress(0.0);
            be.setClientBarrelOffset(0.0f);
            be.setClientAntennaRotationOffset(0.0f);
            be.setClientCannonRotationOffset(0.0f);
        }
    }

    public final void renderItem(@NotNull Vec3 launchedItemPos, @NotNull DeliveryCannonBlockEntity be, int light, int overlay, @NotNull MultiBufferSource buffer, @NotNull PoseStack ms) {
        Intrinsics.checkNotNullParameter((Object)launchedItemPos, (String)"launchedItemPos");
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        PoseStack poseStack = null;
        poseStack = be.isVirtual() ? ms : new PoseStack();
        PoseTransformStack msr = TransformStack.of((PoseStack)poseStack);
        Camera cam = Minecraft.m_91087_().f_91063_.m_109153_();
        poseStack.m_85836_();
        if (be.isVirtual()) {
            v0 = (PoseTransformStack)msr.translate(launchedItemPos.m_82546_(VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)be.getRealPos()))).m_82520_(0.5, 1.25, 0.5));
        } else {
            msr.rotate((Quaternionfc)new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)cam.m_90589_()), 1.0f, 0.0f, 0.0f)));
            msr.rotate((Quaternionfc)new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)((double)cam.m_90590_() + 180.0)), 0.0f, 1.0f, 0.0f)));
            msr.translate(-cam.m_90583_().f_82479_, -cam.m_90583_().f_82480_, -cam.m_90583_().f_82481_);
            v0 = (PoseTransformStack)msr.translate(launchedItemPos.f_82479_, launchedItemPos.f_82480_ + 0.25, launchedItemPos.f_82481_);
        }
        Vec3 itemRotOffset = VecHelper.voxelSpace((double)0.0, (double)3.0, (double)0.0);
        msr.translate(itemRotOffset);
        msr.rotateYDegrees((float)be.getClientItemRotation() * 3.0f);
        msr.rotateXDegrees((float)be.getClientItemRotation() * 3.0f);
        msr.translateBack(itemRotOffset);
        Minecraft.m_91087_().m_91291_().m_269128_(be.getMidAirStack(), ItemDisplayContext.GROUND, light, overlay, poseStack, buffer, be.m_58904_(), 0);
        poseStack.m_85849_();
    }

    @NotNull
    public final SuperByteBuffer rotateToAngle(@NotNull SuperByteBuffer superByteBuffer, double angle) {
        Intrinsics.checkNotNullParameter((Object)superByteBuffer, (String)"superByteBuffer");
        SuperByteBuffer buffer = (SuperByteBuffer)superByteBuffer.translate(this.pivot);
        buffer = (SuperByteBuffer)buffer.rotate(AngleHelper.rad((double)angle), Direction.EAST);
        SuperByteBuffer superByteBuffer2 = buffer = (SuperByteBuffer)buffer.translate(this.pivot.m_82490_(-1.0));
        Intrinsics.checkNotNull((Object)superByteBuffer2);
        return superByteBuffer2;
    }

    @NotNull
    public final SuperByteBuffer rotateCentered(@NotNull SuperByteBuffer buffer, double angle) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Affine affine = buffer.rotateCentered((float)((-angle - 90.0) / 180.0 * Math.PI), Direction.UP);
        Intrinsics.checkNotNullExpressionValue((Object)affine, (String)"rotateCentered(...)");
        return (SuperByteBuffer)affine;
    }

    @NotNull
    public final SuperByteBuffer rotateAntenna(@NotNull SuperByteBuffer superByteBuffer, double angle) {
        Intrinsics.checkNotNullParameter((Object)superByteBuffer, (String)"superByteBuffer");
        SuperByteBuffer buffer = (SuperByteBuffer)superByteBuffer.translate(this.antennaPivot);
        buffer = (SuperByteBuffer)buffer.rotate(AngleHelper.rad((double)angle), Direction.WEST);
        SuperByteBuffer superByteBuffer2 = buffer = (SuperByteBuffer)buffer.translate(this.antennaPivot.m_82490_(-1.0));
        Intrinsics.checkNotNull((Object)superByteBuffer2);
        return superByteBuffer2;
    }

    public final void render(@NotNull SuperByteBuffer mount, @NotNull SuperByteBuffer base, @NotNull SuperByteBuffer barrel, @NotNull SuperByteBuffer antenna, @NotNull PoseStack ms, @NotNull VertexConsumer vb, int light) {
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)barrel, (String)"barrel");
        Intrinsics.checkNotNullParameter((Object)antenna, (String)"antenna");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)vb, (String)"vb");
        mount.light(light).renderInto(ms, vb);
        base.light(light).renderInto(ms, vb);
        barrel.light(light).renderInto(ms, vb);
        antenna.light(light).renderInto(ms, vb);
    }

    public boolean shouldRenderOffScreen(@NotNull DeliveryCannonBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJE\u0010\n\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J1\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonRenderer$Companion;", "", "", "x1", "y1", "x2", "y2", "x3", "y3", "z", "parabola", "(DDDDDDD)D", "Lorg/joml/Vector3d;", "start", "end", "getThirdPoint", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "x", "y", "euler_angle", "(DD)D", "currentRotation", "targetRotation", "turnSpeed", "Lkotlin/Pair;", "", "turn", "(DDD)Lkotlin/Pair;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public final double parabola(double x1, double y1, double x2, double y2, double x3, double y3, double z) {
            double denom = (x1 - x2) * (x1 - x3) * (x2 - x3);
            double A = (x3 * (y2 - y1) + x2 * (y1 - y3) + x1 * (y3 - y2)) / denom;
            double B = (x3 * x3 * (y1 - y2) + x2 * x2 * (y3 - y1) + x1 * x1 * (y2 - y3)) / denom;
            double C = (x2 * x3 * (x2 - x3) * y1 + x3 * x1 * (x3 - x1) * y2 + x1 * x2 * (x1 - x2) * y3) / denom;
            return A * Math.pow(z, 2) + B * z + C;
        }

        @NotNull
        public final Vector3d getThirdPoint(@NotNull Vector3d start, @NotNull Vector3d end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Vector3d lerped = start.lerp((Vector3dc)end, 0.5);
            return new Vector3d(lerped.x, end.y + (double)5, lerped.z);
        }

        public final double euler_angle(double x, double y) {
            double rad = Math.atan(y / x);
            double deg = rad * (double)180 / Math.PI;
            if (x < 0.0) {
                deg += (double)180;
            }
            double eul = ((double)270 + deg) % (double)360;
            return eul;
        }

        @NotNull
        public final Pair<Double, Boolean> turn(double currentRotation, double targetRotation, double turnSpeed) {
            boolean shouldLerp = true;
            double rotation = currentRotation;
            if ((double)360 + rotation - targetRotation < Math.abs(targetRotation - rotation)) {
                if ((rotation -= turnSpeed) < 0.0) {
                    rotation += (double)360;
                    shouldLerp = false;
                }
            } else if ((double)360 - rotation + targetRotation < Math.abs(targetRotation - rotation)) {
                if ((rotation += turnSpeed) >= 360.0) {
                    rotation -= (double)360;
                    shouldLerp = false;
                }
            } else {
                rotation += Mth.m_14008_((double)(targetRotation - rotation), (double)(-turnSpeed), (double)turnSpeed);
            }
            return new Pair((Object)rotation, (Object)shouldLerp);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

