/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.valve;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.ShaftVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.logistics.gas.valve.ValveDuctBlock;
import org.valkyrienskies.clockwork.content.logistics.gas.valve.ValveDuctBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u00100\u001a\u00020/\u0012\u0006\u00101\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b2\u00103J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00062\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020#8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b(\u0010%\u001a\u0004\b)\u0010'R\u001a\u0010+\u001a\u00020*8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\u00a8\u00064"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/valve/ValveDuctVisual;", "Lcom/simibubi/create/content/kinetics/base/ShaftVisual;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/valve/ValveDuctBlockEntity;", "Ldev/engine_room/flywheel/lib/visual/SimpleDynamicVisual;", "Ldev/engine_room/flywheel/api/visual/DynamicVisual$Context;", "ctx", "", "beginFrame", "(Ldev/engine_room/flywheel/api/visual/DynamicVisual$Context;)V", "", "partialTick", "transformPointer", "(F)V", "updateLight", "_delete", "()V", "Ljava/util/function/Consumer;", "Ldev/engine_room/flywheel/api/instance/Instance;", "consumer", "collectCrumblingInstances", "(Ljava/util/function/Consumer;)V", "Ldev/engine_room/flywheel/lib/instance/TransformedInstance;", "pointer", "Ldev/engine_room/flywheel/lib/instance/TransformedInstance;", "getPointer", "()Ldev/engine_room/flywheel/lib/instance/TransformedInstance;", "setPointer", "(Ldev/engine_room/flywheel/lib/instance/TransformedInstance;)V", "", "settled", "Z", "getSettled", "()Z", "setSettled", "(Z)V", "", "xRot", "D", "getXRot", "()D", "yRot", "getYRot", "", "pointerRotationOffset", "I", "getPointerRotationOffset", "()I", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "dispatcher", "blockEntity", "<init>", "(Ldev/engine_room/flywheel/api/visualization/VisualizationContext;Lorg/valkyrienskies/clockwork/content/logistics/gas/valve/ValveDuctBlockEntity;F)V", "clockwork"})
public class ValveDuctVisual
extends ShaftVisual<ValveDuctBlockEntity>
implements SimpleDynamicVisual {
    @NotNull
    private TransformedInstance pointer;
    private boolean settled;
    private final double xRot;
    private final double yRot;
    private final int pointerRotationOffset;

    public ValveDuctVisual(@NotNull VisualizationContext dispatcher, @NotNull ValveDuctBlockEntity blockEntity, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        super(dispatcher, (KineticBlockEntity)blockEntity, partialTick);
        Direction facing = (Direction)this.blockState.m_61143_((Property)DirectionalBlock.f_52588_);
        this.yRot = AngleHelper.horizontalAngle((Direction)facing);
        this.xRot = facing == Direction.UP ? 0 : (facing == Direction.DOWN ? 180 : 90);
        BlockState blockState = this.blockState;
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"blockState");
        Direction.Axis ductAxis = ValveDuctBlock.Companion.getDuctAxis(blockState);
        Direction.Axis shaftAxis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)blockEntity);
        boolean twist = ductAxis.m_122479_() && shaftAxis == Direction.Axis.X || ductAxis.m_122478_();
        this.pointerRotationOffset = twist ? 90 : 0;
        this.settled = false;
        this.pointer = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)ClockworkPartials.INSTANCE.getVALVE_DUCT_POINTER())).createInstance();
        this.transformPointer(partialTick);
    }

    @NotNull
    protected final TransformedInstance getPointer() {
        return this.pointer;
    }

    protected final void setPointer(@NotNull TransformedInstance transformedInstance) {
        Intrinsics.checkNotNullParameter((Object)transformedInstance, (String)"<set-?>");
        this.pointer = transformedInstance;
    }

    protected final boolean getSettled() {
        return this.settled;
    }

    protected final void setSettled(boolean bl) {
        this.settled = bl;
    }

    protected final double getXRot() {
        return this.xRot;
    }

    protected final double getYRot() {
        return this.yRot;
    }

    protected final int getPointerRotationOffset() {
        return this.pointerRotationOffset;
    }

    public void beginFrame(@NotNull DynamicVisual.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (((ValveDuctBlockEntity)this.blockEntity).getPointer().settled() && this.settled) {
            return;
        }
        this.transformPointer(ctx.partialTick());
    }

    private final void transformPointer(float partialTick) {
        float value = ((ValveDuctBlockEntity)this.blockEntity).getPointer().getValue(partialTick);
        float pointerRotation = Mth.m_14179_((float)value, (float)0.0f, (float)-90.0f);
        this.settled = (value == 0.0f || value == 1.0f) && ((ValveDuctBlockEntity)this.blockEntity).getPointer().settled();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.pointer.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees((float)this.yRot)).rotateXDegrees((float)this.xRot)).rotateYDegrees((float)this.pointerRotationOffset + pointerRotation)).uncenter()).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        FlatLit[] flatLitArray = new FlatLit[]{this.pointer};
        this.relight(flatLitArray);
    }

    protected void _delete() {
        super._delete();
        this.pointer.delete();
    }

    public void collectCrumblingInstances(@NotNull Consumer<Instance> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.pointer);
    }
}

