/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.heater;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkBlockEntities;
import org.valkyrienskies.clockwork.content.logistics.gas.heater.GasHeaterBlockEntity;
import org.valkyrienskies.clockwork.util.gui.IHaveDuctStats;
import org.valkyrienskies.kelvin.KelvinMod;
import org.valkyrienskies.kelvin.api.DuctNetwork;
import org.valkyrienskies.kelvin.api.DuctNode;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.util.INodeBlock;
import org.valkyrienskies.kelvin.util.KelvinDamageSources;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005B\u000f\u0012\u0006\u00103\u001a\u000202\u00a2\u0006\u0004\b4\u00105J'\u0010\u000b\u001a\u00020\n2\u0016\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J7\u0010 \u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J7\u0010#\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b#\u0010!J\u0017\u0010&\u001a\u00020\b2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'J/\u0010,\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0015\u00100\u001a\b\u0012\u0004\u0012\u00020/0.H\u0016\u00a2\u0006\u0004\b0\u00101\u00a8\u00066"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/heater/GasHeaterBlock;", "Lnet/minecraft/world/level/block/HorizontalDirectionalBlock;", "Lcom/simibubi/create/foundation/block/IBE;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/heater/GasHeaterBlockEntity;", "Lorg/valkyrienskies/kelvin/util/INodeBlock;", "Lorg/valkyrienskies/clockwork/util/gui/IHaveDuctStats;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Ljava/lang/Class;", "getBlockEntityClass", "()Ljava/lang/Class;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getBlockEntityType", "()Lnet/minecraft/world/level/block/entity/BlockEntityType;", "Lnet/minecraft/world/level/BlockGetter;", "level", "Lnet/minecraft/world/entity/Entity;", "entity", "updateEntityAfterFallOn", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;)V", "state", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/core/BlockPos;", "pos", "oldState", "", "isMoving", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "newState", "onRemove", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "context", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "self", "other", "Lnet/minecraft/core/Direction;", "direction", "canConnectTo", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/BlockGetter;)Z", "", "Lnet/minecraft/network/chat/Component;", "getAdditionalInfoLines", "()Ljava/util/List;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "clockwork"})
public final class GasHeaterBlock
extends HorizontalDirectionalBlock
implements IBE<GasHeaterBlockEntity>,
INodeBlock,
IHaveDuctStats {
    public GasHeaterBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE)).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlazeBurnerBlock.HEAT_LEVEL};
        builder.m_61104_(propertyArray);
        propertyArray = new Property[]{HorizontalDirectionalBlock.f_54117_};
        builder.m_61104_(propertyArray);
        super.m_7926_(builder);
    }

    @NotNull
    public Class<GasHeaterBlockEntity> getBlockEntityClass() {
        return GasHeaterBlockEntity.class;
    }

    @NotNull
    public BlockEntityType<? extends GasHeaterBlockEntity> getBlockEntityType() {
        Object object = ClockworkBlockEntities.GAS_HEATER.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (BlockEntityType)object;
    }

    public void m_5548_(@NotNull BlockGetter level, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.m_5548_(level, entity);
        BlockPos blockPos = entity.m_20183_().m_7495_();
        DuctNetwork ductNetwork = KelvinMod.INSTANCE.getKelvinByPlatform();
        if (ductNetwork == null) {
            return;
        }
        DuctNetwork kelvin = ductNetwork;
        Intrinsics.checkNotNull((Object)blockPos);
        Level level2 = entity.m_9236_();
        Intrinsics.checkNotNull((Object)level2);
        ResourceLocation resourceLocation = level2.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        double heatK = kelvin.getTemperatureAt(KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation));
        if (heatK < 350.0) {
            return;
        }
        double hurtAmount = (heatK - (double)350) / 25.0;
        RegistryAccess registryAccess = entity.m_9236_().m_9598_();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        entity.m_6469_(KelvinDamageSources.INSTANCE.gasExplosion(registryAccess, entity), (float)hurtAmount);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        super.m_6807_(state, level, pos, oldState, isMoving);
        this.nodePlace(state, level, pos, oldState, isMoving);
        if (level.f_46443_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos.m_7494_());
        BasinBlockEntity basinBlockEntity = blockEntity instanceof BasinBlockEntity ? (BasinBlockEntity)blockEntity : null;
        if (basinBlockEntity == null) {
            return;
        }
        BasinBlockEntity blockEntity2 = basinBlockEntity;
        blockEntity2.notifyChangeOfContents();
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.nodeRemove(state, level, pos, newState, isMoving);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.m_49966_().m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    public boolean canConnectTo(@NotNull BlockPos self, @NotNull BlockPos other, @NotNull Direction direction, @NotNull BlockGetter level) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (direction.m_122434_() != ((Direction)level.m_8055_(self).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_() && direction != Direction.DOWN) {
            return false;
        }
        return INodeBlock.DefaultImpls.canConnectTo((INodeBlock)this, (BlockPos)self, (BlockPos)other, (Direction)direction, (BlockGetter)level);
    }

    @Override
    @NotNull
    public List<Component> getAdditionalInfoLines() {
        Object[] objectArray = new MutableComponent[]{Component.m_237115_((String)"vs_clockwork.gas_heater.function1").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC), Component.m_237115_((String)"vs_clockwork.gas_heater.function2").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void nodePlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        INodeBlock.DefaultImpls.nodePlace((INodeBlock)this, (BlockState)state, (Level)level, (BlockPos)pos, (BlockState)oldState, (boolean)isMoving);
    }

    public void nodeAddClient(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        INodeBlock.DefaultImpls.nodeAddClient((INodeBlock)this, (BlockState)state, (Level)level, (BlockPos)pos);
    }

    public void nodeRemoveClient(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        INodeBlock.DefaultImpls.nodeRemoveClient((INodeBlock)this, (BlockState)state, (Level)level, (BlockPos)pos);
    }

    public void nodeRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        INodeBlock.DefaultImpls.nodeRemove((INodeBlock)this, (BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState, (boolean)isMoving);
    }

    @NotNull
    public DuctNode createNode(@NotNull DuctNodePos pos) {
        return INodeBlock.DefaultImpls.createNode((INodeBlock)this, (DuctNodePos)pos);
    }
}

