/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.engine;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.clockwork.util.KelvinParticleHelper;
import org.valkyrienskies.kelvin.KelvinMod;
import org.valkyrienskies.kelvin.api.DuctNetwork;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 32\u00020\u0001:\u00013B#\u0012\n\u0010-\u001a\u0006\u0012\u0002\b\u00030,\u0012\u0006\u0010\u0011\u001a\u00020.\u0012\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b1\u00102J\u001f\u0010\u0006\u001a\u00020\u00052\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001aR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010'\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010\r\"\u0004\b*\u0010+\u00a8\u00064"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/engine/GasEngineBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "lazyTick", "()V", "tick", "", "getEngineEfficiency", "()F", "Lnet/minecraft/world/level/Level;", "level", "Lorg/joml/Vector3dc;", "pos", "speed", "spawnParticles", "(Lnet/minecraft/world/level/Level;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "", "getHeatLoss", "()D", "heatLoss", "", "attachedEngines", "I", "getAttachedEngines", "()I", "setAttachedEngines", "(I)V", "totalEfficiency", "F", "getTotalEfficiency", "setTotalEfficiency", "(F)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "clockwork"})
public final class GasEngineBlockEntity
extends KNodeBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int attachedEngines;
    private float totalEfficiency;

    public GasEngineBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    public final double getHeatLoss() {
        return (double)this.totalEfficiency * 1000.0;
    }

    public final int getAttachedEngines() {
        return this.attachedEngines;
    }

    public final void setAttachedEngines(int n) {
        this.attachedEngines = n;
    }

    public final float getTotalEfficiency() {
        return this.totalEfficiency;
    }

    public final void setTotalEfficiency(float f) {
        this.totalEfficiency = f;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        DuctNetwork network = KelvinMod.INSTANCE.getKelvin();
        double temperature = network.getTemperatureAt(this.getDuctNodePosition());
        this.totalEfficiency = Companion.tempToEfficiency(temperature);
    }

    public void tick() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            super.tick();
            return;
        }
        KelvinMod.INSTANCE.getKelvin().modHeatEnergy(this.getDuctNodePosition(), -this.getHeatLoss() * (double)this.totalEfficiency);
        super.tick();
    }

    public final float getEngineEfficiency() {
        return this.attachedEngines == 0 ? 0.0f : Math.min(this.totalEfficiency / (float)this.attachedEngines, 1.0f);
    }

    public final void spawnParticles(@NotNull Level level, @NotNull Vector3dc pos, @NotNull Vector3dc speed) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        KelvinParticleHelper.INSTANCE.spawnParticleWithRatio((ClientLevel)level, this.getDuctNodePosition(), pos, speed);
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128405_("AttachedEngines", this.attachedEngines);
        tag.m_128350_("TotalEfficiency", this.totalEfficiency);
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.attachedEngines = tag.m_128451_("AttachedEngines");
        this.totalEfficiency = tag.m_128457_("TotalEfficiency");
        super.read(tag, clientPacket);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/engine/GasEngineBlockEntity$Companion;", "", "", "temperature", "", "tempToEfficiency", "(D)F", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public final float tempToEfficiency(double temperature) {
            int n = (int)temperature - 80;
            int n2 = 290;
            int n3 = n / n2;
            if ((n ^ n2) < 0 && n3 * n2 != n) {
                --n3;
            }
            return (float)n3 / 4.0f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

