/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.duct;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctBlock;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctBlockEntity;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctConnectionType;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctEdgeType;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.IDuct;
import org.valkyrienskies.kelvin.impl.client.DuctNetworkClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SmartBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctBlockEntity;", "blockEntity", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class DuctRenderer
extends SmartBlockEntityRenderer<DuctBlockEntity> {
    public DuctRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    protected void renderSafe(@NotNull DuctBlockEntity blockEntity, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        PartialModel connection = ClockworkPartials.INSTANCE.getDUCT_CONN();
        PartialModel leak = ClockworkPartials.INSTANCE.getDUCT_LEAK();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110463_());
        DuctNetworkClient kelvin = ClockworkModClient.getKelvin();
        for (Direction dir : Direction.values()) {
            PartialModel partial;
            DuctEdgeType edge;
            BlockEntity dirBe;
            BlockState blockState = blockEntity.m_58900_();
            EnumProperty<DuctConnectionType> enumProperty = DuctBlock.Companion.getDIR_TO_CONNECTION().get(dir);
            Intrinsics.checkNotNull(enumProperty);
            if (!((DuctConnectionType)((Object)blockState.m_61143_((Property)enumProperty))).isConnected()) continue;
            SuperByteBuffer dirConnection = CachedBuffers.partialFacing((PartialModel)connection, (BlockState)blockEntity.m_58900_(), (Direction)dir.m_122424_());
            dirConnection.light(light).overlay(overlay).renderInto(ms, vertexConsumer);
            BlockState blockState2 = blockEntity.m_58900_();
            EnumProperty<DuctConnectionType> enumProperty2 = DuctBlock.Companion.getDIR_TO_CONNECTION().get(dir);
            Intrinsics.checkNotNull(enumProperty2);
            if (blockState2.m_61143_((Property)enumProperty2) == DuctConnectionType.LEAK) {
                SuperByteBuffer dirLeak = CachedBuffers.partialFacing((PartialModel)leak, (BlockState)blockEntity.m_58900_(), (Direction)dir.m_122424_());
                dirLeak.light(light).overlay(overlay).renderInto(ms, vertexConsumer);
            }
            Level level = blockEntity.m_58904_();
            BlockEntity blockEntity2 = dirBe = level != null ? level.m_7702_(blockEntity.m_58899_().m_121945_(dir)) : null;
            if (blockEntity.getDIR_TO_CONNECTION_TYPE().get(dir) == null) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[edge.ordinal()]) {
                case 1: {
                    Object object = ClockworkPartials.INSTANCE.getDUCT_SMART();
                    break;
                }
                case 2: {
                    Object object = ClockworkPartials.INSTANCE.getDUCT_COPPER();
                    break;
                }
                case 3: {
                    Object object;
                    if (dir.m_122421_().m_122540_() == -1) {
                        object = ClockworkPartials.INSTANCE.getDUCT_ONEWAY_FORWARD();
                        break;
                    }
                    object = ClockworkPartials.INSTANCE.getDUCT_ONEWAY_BACKWARD();
                    break;
                }
                case 4: {
                    Object object;
                    if (dir.m_122421_().m_122540_() == 1) {
                        object = ClockworkPartials.INSTANCE.getDUCT_ONEWAY_FORWARD();
                        break;
                    }
                    object = ClockworkPartials.INSTANCE.getDUCT_ONEWAY_BACKWARD();
                    break;
                }
                default: {
                    BlockEntity blockEntity3 = dirBe;
                    Object object = partial = (blockEntity3 != null && (blockEntity3 = blockEntity3.m_58900_()) != null ? blockEntity3.m_60734_() : null) instanceof IDuct ? null : ClockworkPartials.INSTANCE.getDUCT_RIM();
                }
            }
            if (partial == null) continue;
            CachedBuffers.partialFacing((PartialModel)partial, (BlockState)blockEntity.m_58900_(), (Direction)dir.m_122424_()).light(light).overlay(overlay).renderInto(ms, vertexConsumer);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DuctEdgeType.values().length];
            try {
                nArray[DuctEdgeType.FILTERED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DuctEdgeType.SMART.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DuctEdgeType.ONEWAY_FORWARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DuctEdgeType.ONEWAY_BACKWARD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

