/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.backtank;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkBlockEntities;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.backtank.GasBackTankItem;
import org.valkyrienskies.clockwork.content.logistics.gas.backtank.GasBacktankBlockEntity;
import org.valkyrienskies.clockwork.util.gui.IHaveDuctStats;
import org.valkyrienskies.kelvin.api.DuctNode;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.api.NodeBehaviorType;
import org.valkyrienskies.kelvin.api.nodes.TankDuctNode;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.kelvin.serialization.NodeNBTUtil;
import org.valkyrienskies.kelvin.util.INodeBlock;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005B\u000f\u0012\u0006\u0010V\u001a\u00020U\u00a2\u0006\u0004\bW\u0010XJ'\u0010\u000b\u001a\u00020\n2\u0016\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b$\u0010%J7\u0010*\u001a\u00020\n2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b*\u0010+J7\u0010-\u001a\u00020\n2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b-\u0010+J'\u00100\u001a\u00020/2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b0\u00101J?\u0010:\u001a\u0002092\u0006\u0010&\u001a\u00020\b2\u0006\u00102\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u00172\u0006\u00104\u001a\u0002032\u0006\u00106\u001a\u0002052\u0006\u00108\u001a\u000207H\u0016\u00a2\u0006\u0004\b:\u0010;J9\u0010@\u001a\u00020\n2\u0006\u0010<\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\b2\b\u0010>\u001a\u0004\u0018\u00010=2\u0006\u0010?\u001a\u00020/H\u0016\u00a2\u0006\u0004\b@\u0010AJ\u001d\u0010D\u001a\u00020\n2\u0006\u0010\"\u001a\u00020!2\u0006\u0010C\u001a\u00020B\u00a2\u0006\u0004\bD\u0010EJ\u000f\u0010G\u001a\u00020FH\u0016\u00a2\u0006\u0004\bG\u0010HJ\u0015\u0010K\u001a\b\u0012\u0004\u0012\u00020J0IH\u0016\u00a2\u0006\u0004\bK\u0010LJ/\u0010S\u001a\u00020R2\u0006\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u00172\u0006\u0010Q\u001a\u00020PH\u0016\u00a2\u0006\u0004\bS\u0010T\u00a8\u0006Y"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/backtank/GasBacktankBlock;", "Lnet/minecraft/world/level/block/HorizontalDirectionalBlock;", "Lcom/simibubi/create/foundation/block/IBE;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/backtank/GasBacktankBlockEntity;", "Lorg/valkyrienskies/kelvin/util/INodeBlock;", "Lorg/valkyrienskies/clockwork/util/gui/IHaveDuctStats;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "context", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Ljava/lang/Class;", "getBlockEntityClass", "()Ljava/lang/Class;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getBlockEntityType", "()Lnet/minecraft/world/level/block/entity/BlockEntityType;", "Lnet/minecraft/core/BlockPos;", "self", "other", "Lnet/minecraft/core/Direction;", "direction", "Lnet/minecraft/world/level/BlockGetter;", "level", "", "canConnectTo", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/BlockGetter;)Z", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "pos", "Lorg/valkyrienskies/kelvin/api/DuctNode;", "createNode", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;)Lorg/valkyrienskies/kelvin/api/DuctNode;", "state", "Lnet/minecraft/world/level/Level;", "oldState", "isMoving", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "newState", "onRemove", "blockGetter", "Lnet/minecraft/world/item/ItemStack;", "getCloneItemStack", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "use", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "worldIn", "Lnet/minecraft/world/entity/LivingEntity;", "placer", "stack", "setPlacedBy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "deserializeNode", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lnet/minecraft/nbt/CompoundTag;)V", "", "getInternalVolume", "()D", "", "Lnet/minecraft/network/chat/Component;", "getAdditionalInfoLines", "()Ljava/util/List;", "p_220053_1_", "p_220053_2_", "p_220053_3_", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "p_220053_4_", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "clockwork"})
public final class GasBacktankBlock
extends HorizontalDirectionalBlock
implements IBE<GasBacktankBlockEntity>,
INodeBlock,
IHaveDuctStats {
    public GasBacktankBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HorizontalKineticBlock.HORIZONTAL_FACING};
        builder.m_61104_(propertyArray);
        super.m_7926_(builder);
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.m_43723_();
        Intrinsics.checkNotNull((Object)player);
        if (player.m_6144_()) {
            Object object = this.m_49966_().m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            blockState = (BlockState)object;
        } else {
            Object object = this.m_49966_().m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)context.m_8125_());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            blockState = (BlockState)object;
        }
        return blockState;
    }

    @NotNull
    public Class<GasBacktankBlockEntity> getBlockEntityClass() {
        return GasBacktankBlockEntity.class;
    }

    @NotNull
    public BlockEntityType<? extends GasBacktankBlockEntity> getBlockEntityType() {
        Object object = ClockworkBlockEntities.GAS_BACKTANK.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (BlockEntityType)object;
    }

    public boolean canConnectTo(@NotNull BlockPos self, @NotNull BlockPos other, @NotNull Direction direction, @NotNull BlockGetter level) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (direction.m_122434_() != Direction.Axis.Y) {
            return false;
        }
        return INodeBlock.DefaultImpls.canConnectTo((INodeBlock)this, (BlockPos)self, (BlockPos)other, (Direction)direction, (BlockGetter)level);
    }

    @NotNull
    public DuctNode createNode(@NotNull DuctNodePos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return (DuctNode)new TankDuctNode(pos, NodeBehaviorType.TANK, null, 0.75, 1.6375049E7, 1478.0, 3.0, 4, null);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        super.m_6807_(state, level, pos, oldState, isMoving);
        this.nodePlace(state, level, pos, oldState, isMoving);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.nodeRemove(state, level, pos, newState, isMoving);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)blockGetter, (String)"blockGetter");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Item item = this.m_5456_();
        if (item instanceof BacktankItem.BacktankBlockItem) {
            item = ((BacktankItem.BacktankBlockItem)item).getActualItem();
        }
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        BlockEntity blockEntity = blockGetter.m_7702_(pos);
        if (blockEntity == null) {
            return stack;
        }
        BlockEntity be = blockEntity;
        CompoundTag tag = new CompoundTag();
        Level level = be.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        ResourceLocation resourceLocation = level.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        NodeNBTUtil.INSTANCE.serializeNodeServer(KelvinExtensions.INSTANCE.toDuctNodePos(pos, resourceLocation), tag);
        tag.m_128350_("Air", (float)(tag.m_128459_("kelvin:air") * GasBackTankItem.Companion.getAirKgsToAirTicks()));
        stack.m_41751_(tag);
        return stack;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (player.m_21205_().m_41720_() instanceof BlockItem) {
            return InteractionResult.PASS;
        }
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.75f, 1.0f);
            player.m_8061_(EquipmentSlot.CHEST, this.m_7397_((BlockGetter)world, pos, state));
            world.m_46961_(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        DuctNetworkServer network = ClockworkMod.getKelvin();
        HashMap hashMap = network.getNodeInfo();
        ResourceLocation resourceLocation = worldIn.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        if (hashMap.get(KelvinExtensions.INSTANCE.toDuctNodePos(pos, resourceLocation)) == null) {
            this.nodePlace(state, worldIn, pos, state, false);
        }
        ResourceLocation resourceLocation2 = worldIn.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        DuctNodePos ductNodePos = KelvinExtensions.INSTANCE.toDuctNodePos(pos, resourceLocation2);
        Intrinsics.checkNotNull((Object)tag);
        this.deserializeNode(ductNodePos, tag);
    }

    public final void deserializeNode(@NotNull DuctNodePos pos, @NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        DuctNetworkServer network = ClockworkMod.getKelvin();
        double temperature = tag.m_128459_("KelvinTemperature");
        for (String gasResourceLocation : tag.m_128431_()) {
            GasType gasType;
            Intrinsics.checkNotNull((Object)gasResourceLocation);
            if (!StringsKt.contains$default((CharSequence)gasResourceLocation, (CharSequence)":", (boolean)false, (int)2, null) || (GasType)GasTypeRegistry.INSTANCE.getGAS_TYPES().get(new ResourceLocation(gasResourceLocation)) == null) continue;
            network.addGasAtTemperature(pos, gasType, tag.m_128459_(gasResourceLocation), temperature);
        }
    }

    @Override
    public double getInternalVolume() {
        return 0.75;
    }

    @Override
    @NotNull
    public List<Component> getAdditionalInfoLines() {
        Object[] objectArray = new MutableComponent[]{Component.m_237115_((String)"vs_clockwork.gas_backtank.function1").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC), Component.m_237115_((String)"vs_clockwork.gas_backtank.function2").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState p_220053_1_, @NotNull BlockGetter p_220053_2_, @NotNull BlockPos p_220053_3_, @NotNull CollisionContext p_220053_4_) {
        Intrinsics.checkNotNullParameter((Object)p_220053_1_, (String)"p_220053_1_");
        Intrinsics.checkNotNullParameter((Object)p_220053_2_, (String)"p_220053_2_");
        Intrinsics.checkNotNullParameter((Object)p_220053_3_, (String)"p_220053_3_");
        Intrinsics.checkNotNullParameter((Object)p_220053_4_, (String)"p_220053_4_");
        VoxelShape voxelShape = AllShapes.BACKTANK;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"BACKTANK");
        return voxelShape;
    }

    public void nodePlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        INodeBlock.DefaultImpls.nodePlace((INodeBlock)this, (BlockState)state, (Level)level, (BlockPos)pos, (BlockState)oldState, (boolean)isMoving);
    }

    public void nodeAddClient(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        INodeBlock.DefaultImpls.nodeAddClient((INodeBlock)this, (BlockState)state, (Level)level, (BlockPos)pos);
    }

    public void nodeRemoveClient(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        INodeBlock.DefaultImpls.nodeRemoveClient((INodeBlock)this, (BlockState)state, (Level)level, (BlockPos)pos);
    }

    public void nodeRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        INodeBlock.DefaultImpls.nodeRemove((INodeBlock)this, (BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState, (boolean)isMoving);
    }
}

