/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.sequenced_seat;

import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.InputKey;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatBlockEntity;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatOperation;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatRule;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u001d\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001f\u0010 R\u001c\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatBlockEntity;", "be", "Lnet/minecraft/core/Direction;", "face", "", "currentModifier", "(Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatBlockEntity;Lnet/minecraft/core/Direction;)F", "", "index", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule;", "getRule", "(I)Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule;", "rule", "", "setRule", "(ILorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule;)V", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/InputKey;", "key", "addKey", "(ILorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/InputKey;)V", "removeKey", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatOperation;", "operation", "setOperation", "(ILorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatOperation;)V", "Lnet/minecraft/nbt/ListTag;", "serializeNBT", "()Lnet/minecraft/nbt/ListTag;", "tag", "deserializeNBT", "(Lnet/minecraft/nbt/ListTag;)V", "", "rules", "[Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule;", "<init>", "()V", "Companion", "clockwork"})
public final class SequencedSeatRuleList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SequencedSeatRule[] rules = new SequencedSeatRule[5];
    public static final int MAX_RULES = 5;

    public SequencedSeatRuleList() {
        for (int i = 0; i < 5; ++i) {
            this.rules[i] = SequencedSeatRule.Companion.empty();
        }
    }

    public final float currentModifier(@NotNull SequencedSeatBlockEntity be, @Nullable Direction face) {
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        SequencedSeatRule[] sequencedSeatRuleArray = this.rules;
        int n = sequencedSeatRuleArray.length;
        for (int i = 0; i < n; ++i) {
            SequencedSeatRule rule;
            SequencedSeatRule sequencedSeatRule = rule = sequencedSeatRuleArray[i];
            Intrinsics.checkNotNull((Object)sequencedSeatRule);
            Direction direction = face;
            Intrinsics.checkNotNull((Object)direction);
            float result = sequencedSeatRule.calculateModifier(be, direction, be.pressedKeys());
            if (result == 0.0f) continue;
            return result;
        }
        return 0.0f;
    }

    @Nonnull
    @Nullable
    public final SequencedSeatRule getRule(int index) {
        return this.rules[index];
    }

    public final void setRule(int index, @Nullable SequencedSeatRule rule) {
        this.rules[index] = rule;
    }

    public final void addKey(int index, @NotNull InputKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        SequencedSeatRule sequencedSeatRule = this.getRule(index);
        Intrinsics.checkNotNull((Object)sequencedSeatRule);
        sequencedSeatRule.getInputKeys().add(key);
    }

    public final void removeKey(int index, @NotNull InputKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        SequencedSeatRule sequencedSeatRule = this.getRule(index);
        Intrinsics.checkNotNull((Object)sequencedSeatRule);
        sequencedSeatRule.getInputKeys().remove((Object)key);
    }

    public final void setOperation(int index, @NotNull SequencedSeatOperation operation) {
        SequencedSeatRule rule;
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        SequencedSeatRule sequencedSeatRule = rule = this.getRule(index);
        Intrinsics.checkNotNull((Object)sequencedSeatRule);
        this.setRule(index, new SequencedSeatRule(sequencedSeatRule.getInputKeys(), operation, operation.defaultValue()));
    }

    @NotNull
    public final ListTag serializeNBT() {
        ListTag list = new ListTag();
        SequencedSeatRule[] sequencedSeatRuleArray = this.rules;
        int n = sequencedSeatRuleArray.length;
        for (int i = 0; i < n; ++i) {
            SequencedSeatRule rule;
            SequencedSeatRule sequencedSeatRule = rule = sequencedSeatRuleArray[i];
            Intrinsics.checkNotNull((Object)sequencedSeatRule);
            list.add((Object)sequencedSeatRule.serializeNBT());
        }
        return list;
    }

    public final void deserializeNBT(@NotNull ListTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        for (int i = 0; i < 5; ++i) {
            CompoundTag compoundTag = tag.m_128728_(i);
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            this.rules[i] = SequencedSeatRule.Companion.deserializeNBT(compoundTag);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList$Companion;", "", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "defaultList", "(Lnet/minecraft/world/level/block/Rotation;)Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "", "MAX_RULES", "I", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SequencedSeatRuleList defaultList(@NotNull Rotation rotation) {
            Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
            SequencedSeatRuleList list = new SequencedSeatRuleList();
            list.setOperation(1, SequencedSeatOperation.MULTIPLY);
            switch (WhenMappings.$EnumSwitchMapping$0[rotation.ordinal()]) {
                case 1: {
                    list.addKey(1, InputKey.FORWARD);
                    break;
                }
                case 2: {
                    list.addKey(1, InputKey.RIGHT);
                    break;
                }
                case 3: {
                    list.addKey(1, InputKey.BACKWARD);
                    break;
                }
                case 4: {
                    list.addKey(1, InputKey.LEFT);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Rotation.values().length];
                try {
                    nArray[Rotation.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rotation.CLOCKWISE_90.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rotation.CLOCKWISE_180.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rotation.COUNTERCLOCKWISE_90.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

