/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.resistor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.kinetics.resistor.RedstoneResistorBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity;", "te", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/createmod/catnip/render/SuperByteBuffer;", "Lnet/minecraft/world/level/block/state/BlockState;", "resistorState", "transform", "(Lnet/createmod/catnip/render/SuperByteBuffer;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/createmod/catnip/render/SuperByteBuffer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class RedstoneResistorRenderer
extends KineticBlockEntityRenderer<RedstoneResistorBlockEntity> {
    public RedstoneResistorRenderer(@Nullable BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(@NotNull RedstoneResistorBlockEntity te, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)te), (String)"te");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Block block = te.m_58900_().m_60734_();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type com.simibubi.create.content.kinetics.base.IRotate");
        Direction.Axis boxAxis = ((IRotate)block).getRotationAxis(te.m_58900_());
        BlockPos pos = te.m_58899_();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)((LevelAccessor)te.m_58904_()));
        RedstoneResistorBlockEntity resistor = te;
        Iterator iterator = ArrayIteratorKt.iterator((Object[])Iterate.directions);
        while (iterator.hasNext()) {
            Direction direction = (Direction)iterator.next();
            Direction.Axis axis = direction.m_122434_();
            if (boxAxis != axis) continue;
            float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition((KineticBlockEntity)((KineticBlockEntity)te), (BlockPos)pos, (Direction.Axis)axis);
            float angle = time * te.getSpeed() * 3.0f / (float)10 % (float)360;
            float modifier = 1.0f;
            Intrinsics.checkNotNull((Object)direction);
            modifier = resistor.getRotationSpeedModifier(direction);
            angle *= modifier;
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            SuperByteBuffer superByteBuffer = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)te.m_58900_(), (Direction)direction);
            KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)superByteBuffer, (KineticBlockEntity)((KineticBlockEntity)te), (Direction.Axis)axis, (float)angle, (int)light);
            superByteBuffer.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
        BlockState resistorState = te.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        int color = Color.mixColors((int)2884352, (int)0xCD0000, (float)((float)resistor.getState() / 15.0f));
        SuperByteBuffer superByteBuffer = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getRESISTOR_INDICATOR(), (BlockState)resistorState);
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partial(...)");
        Intrinsics.checkNotNull((Object)resistorState);
        SuperByteBuffer indicator = this.transform(superByteBuffer, resistorState);
        indicator.light(light).color(color).renderInto(ms, vb);
    }

    private final SuperByteBuffer transform(SuperByteBuffer buffer, BlockState resistorState) {
        SuperByteBuffer superByteBuffer;
        Direction.Axis axis;
        SuperByteBuffer buffer2 = null;
        buffer2 = buffer;
        Direction.Axis axis2 = axis = (Direction.Axis)resistorState.m_61143_((Property)BlockStateProperties.f_61365_);
        SuperByteBuffer it = superByteBuffer = (switch (axis2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[axis2.ordinal()]) {
            case 1 -> (SuperByteBuffer)buffer2.rotateCentered((float)Math.toRadians(90.0), Direction.NORTH);
            case 2 -> buffer2;
            case 3 -> (SuperByteBuffer)buffer2.rotateCentered((float)Math.toRadians(90.0), Direction.EAST);
            default -> throw new NoWhenBranchMatchedException();
        });
        boolean bl = false;
        buffer2 = it;
        SuperByteBuffer superByteBuffer2 = superByteBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer2, (String)"also(...)");
        return superByteBuffer2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.Axis.values().length];
            try {
                nArray[Direction.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

