/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBic;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandItem;
import org.valkyrienskies.clockwork.content.forces.BalloonController;
import org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle.LeakParticleData;
import org.valkyrienskies.clockwork.util.AABBHelper;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.kelvin.KelvinMod;
import org.valkyrienskies.kelvin.api.DuctNetwork;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u0007\u0018\u00002\u00020\u0001:\u0003\u007f\u0080\u0001B\t\b\u0017\u00a2\u0006\u0004\b}\u0010?B]\b\u0016\u0012\u0016\u0010D\u001a\u0012\u0012\u0004\u0012\u0002000:j\b\u0012\u0004\u0012\u000200`;\u0012\"\u0010K\u001a\u001e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\f0Hj\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\f`J\u0012\u0006\u0010O\u001a\u00020\f\u0012\u0006\u0010T\u001a\u00020\f\u0012\u0006\u0010W\u001a\u00020\u0006\u00a2\u0006\u0004\b}\u0010~J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0003\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\"2\u0006\u0010\u0003\u001a\u00020\u0016\u00a2\u0006\u0004\b#\u0010$J+\u0010'\u001a\u00020&2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019\u00a2\u0006\u0004\b'\u0010(J%\u0010,\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020&\u00a2\u0006\u0004\b,\u0010-J%\u0010.\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020&\u00a2\u0006\u0004\b.\u0010-J#\u00102\u001a\u00020\u00062\f\u00101\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010\u0003\u001a\u00020\u0016\u00a2\u0006\u0004\b2\u00103J#\u00104\u001a\u00020+2\f\u00101\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010\u0003\u001a\u00020\u0016\u00a2\u0006\u0004\b4\u00105J\u001d\u00107\u001a\u00020\"2\u0006\u00106\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0016\u00a2\u0006\u0004\b7\u00108J1\u0010<\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00000:j\b\u0012\u0004\u0012\u00020\u0000`;092\u0006\u0010\u0003\u001a\u00020\u0016\u00a2\u0006\u0004\b<\u0010=J\u000f\u0010>\u001a\u00020+H\u0002\u00a2\u0006\u0004\b>\u0010?J\u0013\u0010A\u001a\u00020@*\u000200H\u0002\u00a2\u0006\u0004\bA\u0010BJ\u0019\u0010A\u001a\u00020@*\b\u0012\u0004\u0012\u0002000/H\u0002\u00a2\u0006\u0004\bA\u0010CR'\u0010D\u001a\u0012\u0012\u0004\u0012\u0002000:j\b\u0012\u0004\u0012\u000200`;8\u0006\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010GR3\u0010K\u001a\u001e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\f0Hj\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\f`J8\u0006\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010NR\"\u0010O\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010\u000e\"\u0004\bR\u0010SR\"\u0010T\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bT\u0010P\u001a\u0004\bU\u0010\u000e\"\u0004\bV\u0010SR\"\u0010W\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bW\u0010Y\"\u0004\bZ\u0010[R\"\u0010\\\u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR2\u0010e\u001a\u0012\u0012\u0004\u0012\u00020c0bj\b\u0012\u0004\u0012\u00020c`d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\be\u0010f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR2\u0010k\u001a\u0012\u0012\u0004\u0012\u00020c0bj\b\u0012\u0004\u0012\u00020c`d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bk\u0010f\u001a\u0004\bl\u0010h\"\u0004\bm\u0010jR\"\u0010n\u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bn\u0010]\u001a\u0004\bo\u0010_\"\u0004\bp\u0010aR\"\u0010q\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bq\u0010X\u001a\u0004\br\u0010Y\"\u0004\bs\u0010[R\"\u0010t\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bt\u0010X\u001a\u0004\bu\u0010Y\"\u0004\bv\u0010[R\"\u0010w\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bw\u0010X\u001a\u0004\bx\u0010Y\"\u0004\by\u0010[R\"\u0010z\u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bz\u0010]\u001a\u0004\b{\u0010_\"\u0004\b|\u0010a\u00a8\u0006\u0081\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;", "", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "", "tick", "(Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Z", "Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$PhysBalloonData;", "makeForceData", "()Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$PhysBalloonData;", "", "recalculateVolume", "()D", "Lorg/joml/Vector3dc;", "getCenter", "()Lorg/joml/Vector3dc;", "Lnet/minecraft/core/BlockPos;", "pos", "containsPosition", "(Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/Level;", "getFirstValidExternalPosition", "(Lnet/minecraft/world/level/Level;)Lnet/minecraft/core/BlockPos;", "", "getExternalPositions", "()Ljava/util/Set;", "", "externalSize", "canLeak", "(I)Z", "isNearlyAtmospheric", "(Lnet/minecraft/server/level/ServerLevel;)Z", "Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$EnclosureStatus;", "validate", "(Lnet/minecraft/world/level/Level;)Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$EnclosureStatus;", "externals", "Lnet/minecraft/core/Direction;", "findDirectionToOutside", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/Set;)Lnet/minecraft/core/Direction;", "position", "dir", "", "sendInitialLeakParticleBurst", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)V", "sendLeakParticles", "", "Lorg/joml/primitives/AABBic;", "newRegions", "updateRegions", "(Ljava/util/List;Lnet/minecraft/world/level/Level;)Z", "updateRegionsNoValidation", "(Ljava/util/List;Lnet/minecraft/world/level/Level;)V", "other", "mergeWith", "(Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;Lnet/minecraft/world/level/Level;)Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$EnclosureStatus;", "Lkotlin/Pair;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "trySplit", "(Lnet/minecraft/world/level/Level;)Lkotlin/Pair;", "clear", "()V", "", "volume", "(Lorg/joml/primitives/AABBic;)J", "(Ljava/util/List;)J", "regions", "Ljava/util/ArrayList;", "getRegions", "()Ljava/util/ArrayList;", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "gasMasses", "Ljava/util/HashMap;", "getGasMasses", "()Ljava/util/HashMap;", "currentEnergy", "D", "getCurrentEnergy", "setCurrentEnergy", "(D)V", "currentVolume", "getCurrentVolume", "setCurrentVolume", "isLeaking", "Z", "()Z", "setLeaking", "(Z)V", "missingExternalPositions", "I", "getMissingExternalPositions", "()I", "setMissingExternalPositions", "(I)V", "Ljava/util/HashSet;", "Lorg/joml/Vector3ic;", "Lkotlin/collections/HashSet;", "leakPositions", "Ljava/util/HashSet;", "getLeakPositions", "()Ljava/util/HashSet;", "setLeakPositions", "(Ljava/util/HashSet;)V", "lastSentLeaks", "getLastSentLeaks", "setLastSentLeaks", "currentMaxLeaks", "getCurrentMaxLeaks", "setCurrentMaxLeaks", "shouldRemove", "getShouldRemove", "setShouldRemove", "shouldReScan", "getShouldReScan", "setShouldReScan", "shouldValidate", "getShouldValidate", "setShouldValidate", "timeSinceLeakSound", "getTimeSinceLeakSound", "setTimeSinceLeakSound", "<init>", "(Ljava/util/ArrayList;Ljava/util/HashMap;DDZ)V", "EnclosureStatus", "PhysBalloonData", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBalloonData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalloonData.kt\norg/valkyrienskies/clockwork/content/forces/data/BalloonData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,581:1\n1#2:582\n216#3,2:583\n216#3,2:585\n295#4,2:587\n1246#4,4:591\n1019#4,2:595\n477#5:589\n423#5:590\n*S KotlinDebug\n*F\n+ 1 BalloonData.kt\norg/valkyrienskies/clockwork/content/forces/data/BalloonData\n*L\n176#1:583,2\n215#1:585,2\n276#1:587,2\n323#1:591,4\n497#1:595,2\n323#1:589\n323#1:590\n*E\n"})
public final class BalloonData {
    @NotNull
    private final ArrayList<AABBic> regions;
    @NotNull
    private final HashMap<String, Double> gasMasses;
    private double currentEnergy;
    private double currentVolume;
    private boolean isLeaking;
    @JsonIgnore
    private int missingExternalPositions;
    @JsonIgnore
    @NotNull
    private HashSet<Vector3ic> leakPositions;
    @JsonIgnore
    @NotNull
    private HashSet<Vector3ic> lastSentLeaks;
    @JsonIgnore
    private int currentMaxLeaks;
    @JsonIgnore
    private boolean shouldRemove;
    @JsonIgnore
    private boolean shouldReScan;
    @JsonIgnore
    private boolean shouldValidate;
    @JsonIgnore
    private int timeSinceLeakSound;

    @NotNull
    public final ArrayList<AABBic> getRegions() {
        return this.regions;
    }

    @NotNull
    public final HashMap<String, Double> getGasMasses() {
        return this.gasMasses;
    }

    public final double getCurrentEnergy() {
        return this.currentEnergy;
    }

    public final void setCurrentEnergy(double d) {
        this.currentEnergy = d;
    }

    public final double getCurrentVolume() {
        return this.currentVolume;
    }

    public final void setCurrentVolume(double d) {
        this.currentVolume = d;
    }

    public final boolean isLeaking() {
        return this.isLeaking;
    }

    public final void setLeaking(boolean bl) {
        this.isLeaking = bl;
    }

    public final int getMissingExternalPositions() {
        return this.missingExternalPositions;
    }

    public final void setMissingExternalPositions(int n) {
        this.missingExternalPositions = n;
    }

    @NotNull
    public final HashSet<Vector3ic> getLeakPositions() {
        return this.leakPositions;
    }

    public final void setLeakPositions(@NotNull HashSet<Vector3ic> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.leakPositions = hashSet;
    }

    @NotNull
    public final HashSet<Vector3ic> getLastSentLeaks() {
        return this.lastSentLeaks;
    }

    public final void setLastSentLeaks(@NotNull HashSet<Vector3ic> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.lastSentLeaks = hashSet;
    }

    public final int getCurrentMaxLeaks() {
        return this.currentMaxLeaks;
    }

    public final void setCurrentMaxLeaks(int n) {
        this.currentMaxLeaks = n;
    }

    public final boolean getShouldRemove() {
        return this.shouldRemove;
    }

    public final void setShouldRemove(boolean bl) {
        this.shouldRemove = bl;
    }

    public final boolean getShouldReScan() {
        return this.shouldReScan;
    }

    public final void setShouldReScan(boolean bl) {
        this.shouldReScan = bl;
    }

    public final boolean getShouldValidate() {
        return this.shouldValidate;
    }

    public final void setShouldValidate(boolean bl) {
        this.shouldValidate = bl;
    }

    public final int getTimeSinceLeakSound() {
        return this.timeSinceLeakSound;
    }

    public final void setTimeSinceLeakSound(int n) {
        this.timeSinceLeakSound = n;
    }

    @Deprecated(message="")
    public BalloonData() {
        this.leakPositions = new HashSet();
        this.lastSentLeaks = new HashSet();
        this.currentMaxLeaks = 1;
        this.regions = new ArrayList();
        this.gasMasses = new HashMap();
        this.currentEnergy = 0.0;
        this.currentVolume = 0.0;
        this.isLeaking = false;
        this.missingExternalPositions = 0;
    }

    public BalloonData(@NotNull ArrayList<AABBic> regions, @NotNull HashMap<String, Double> gasMasses, double currentEnergy, double currentVolume, boolean isLeaking) {
        Intrinsics.checkNotNullParameter(regions, (String)"regions");
        Intrinsics.checkNotNullParameter(gasMasses, (String)"gasMasses");
        this.leakPositions = new HashSet();
        this.lastSentLeaks = new HashSet();
        this.currentMaxLeaks = 1;
        this.regions = regions;
        this.gasMasses = gasMasses;
        this.currentEnergy = currentEnergy;
        this.currentVolume = currentVolume;
        this.isLeaking = isLeaking;
        this.missingExternalPositions = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tick(@NotNull ServerLevel level, @NotNull LoadedServerShip ship) {
        double d;
        double d2;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        if (!Intrinsics.areEqual((Object)VSGameUtilsKt.getDimensionId((Level)((Level)level)), (Object)ship.getChunkClaimDimension())) {
            return false;
        }
        if (this.isLeaking && this.missingExternalPositions > 0) {
            Vector3i averageLeakPos = new Vector3i(0, 0, 0);
            Iterator<Vector3ic> iterator = this.leakPositions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Vector3ic> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Vector3ic pos;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                BlockPos blockPos = new BlockPos(pos.x(), pos.y(), pos.z());
                if (level.m_46749_(blockPos)) {
                    this.sendLeakParticles(level, blockPos, Direction.UP);
                }
                averageLeakPos.add(pos);
            }
            averageLeakPos.div(this.leakPositions.size());
            if (this.timeSinceLeakSound <= 0) {
                SoundEvent soundEvent;
                double d3 = averageLeakPos.x;
                double d4 = averageLeakPos.y;
                double d5 = averageLeakPos.z;
                if (this.missingExternalPositions >= this.currentMaxLeaks / 2) {
                    SoundEvent soundEvent2 = ClockworkSounds.INSTANCE.getBALLOON_LEAKING_HEAVY().getMainEvent();
                    soundEvent = soundEvent2;
                    Intrinsics.checkNotNull((Object)soundEvent2);
                } else {
                    SoundEvent soundEvent3 = ClockworkSounds.INSTANCE.getBALLOON_LEAKING_LIGHT().getMainEvent();
                    soundEvent = soundEvent3;
                    Intrinsics.checkNotNull((Object)soundEvent3);
                }
                level.m_6263_(null, d3, d4, d5, soundEvent, SoundSource.BLOCKS, 0.5f, 1.0f);
                this.timeSinceLeakSound = 120;
            }
        }
        if (this.timeSinceLeakSound > 0) {
            int averageLeakPos = this.timeSinceLeakSound;
            this.timeSinceLeakSound = averageLeakPos + -1;
        }
        Vector3dc root = this.getCenter();
        double rootYInWorld = ValkyrienSkies.positionToWorld((ShipTransform)ship.getTransform(), (Vector3d)new Vector3d((double)root.x(), (double)root.y(), (double)root.z())).y;
        double atmoDensity = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirDensityForY(rootYInWorld, VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        double atmoPressure = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirPressureForY(rootYInWorld, VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        double atmoTemperature = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirTemperatureForY(rootYInWorld, VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        double volume = this.currentVolume;
        double currentHeatEnergy = this.currentEnergy;
        HashMap currentGasMasses = null;
        currentGasMasses = new HashMap();
        for (Map.Entry entry : ((Map)this.gasMasses).entrySet()) {
            GasType gasType;
            String key = (String)entry.getKey();
            double value = ((Number)entry.getValue()).doubleValue();
            if (GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation(key)) == null) continue;
            Double d6 = value;
            ((Map)currentGasMasses).put(gasType, d6);
        }
        Collection collection = currentGasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double totalMass = CollectionsKt.sumOfDouble((Iterable)collection);
        if (Double.isNaN(currentHeatEnergy) || currentHeatEnergy <= 1.0E-9 || Double.isNaN(totalMass) || totalMass < 1.0E-9) {
            GasType gasType = GasTypeRegistry.INSTANCE.getGasType("kelvin", "air");
            Intrinsics.checkNotNull((Object)gasType);
            GasType air = gasType;
            ((Map)this.gasMasses).put(air.getResourceLocation().toString(), atmoDensity * volume);
            double capacity = (double)1000 * air.getSpecificHeatCapacity() / air.getAdiabaticIndex();
            this.currentEnergy = currentHeatEnergy = atmoTemperature * volume * atmoDensity * capacity;
            return false;
        }
        Set set = currentGasMasses.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable iterable = set;
        double d7 = 0.0;
        for (Object e : iterable) {
            void it;
            Map.Entry entry = (Map.Entry)e;
            d2 = d7;
            boolean bl = false;
            GasType gasType = (GasType)it.getKey();
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            d = gasType.massToMoles(((Number)v).doubleValue());
            d7 = d2 + d;
        }
        double moles = d7;
        DuctNetwork ductNetwork = KelvinMod.INSTANCE.getKelvin();
        Intrinsics.checkNotNull((Object)ductNetwork, (String)"null cannot be cast to non-null type org.valkyrienskies.kelvin.impl.DuctNetworkServer");
        double capacity = ((DuctNetworkServer)ductNetwork).mixtureCapacity((Map)currentGasMasses);
        double currentTemperature = currentHeatEnergy / capacity;
        double currentPressure = moles * 8.314 * currentTemperature / volume;
        Set set2 = currentGasMasses.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        Iterable iterable2 = set2;
        double d8 = 0.0;
        for (Object t : iterable2) {
            void it;
            Map.Entry entry = (Map.Entry)t;
            d2 = d8;
            boolean bl = false;
            double d9 = ((GasType)it.getKey()).getDensity() * 0.0224;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            d = d9 * ((Number)v).doubleValue();
            d8 = d2 + d;
        }
        double molarMass = d8 / totalMass;
        double estimatedSurfaceArea = 4.84 * Math.pow(volume, 0.6666666666666666);
        double gasExitRate = Math.max(0.0, currentPressure - atmoPressure) * estimatedSurfaceArea * ClockworkConfig.SERVER.getPermeabilityConstant() / Math.sqrt(currentTemperature * 8.314 / molarMass) * Math.max(1.0, (double)this.missingExternalPositions + 1.0);
        double exitGas = gasExitRate * 0.01;
        HashMap exitGasMasses = new HashMap();
        Map $this$forEach$iv = currentGasMasses;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            Map map = currentGasMasses;
            Object k = it.getKey();
            Object v = currentGasMasses.get(it.getKey());
            Intrinsics.checkNotNull(v);
            map.put(k, ((Number)v).doubleValue() - exitGas * ((Number)it.getValue()).doubleValue() / totalMass);
            ((Map)exitGasMasses).put(it.getKey(), exitGas * ((Number)it.getValue()).doubleValue() / totalMass);
        }
        double exitHeat = currentTemperature * ClockworkMod.getKelvin().mixtureCapacity((Map)exitGasMasses);
        DuctNetwork ductNetwork2 = KelvinMod.INSTANCE.getKelvin();
        Intrinsics.checkNotNull((Object)ductNetwork2, (String)"null cannot be cast to non-null type org.valkyrienskies.kelvin.impl.DuctNetworkServer");
        double newCapacity = ((DuctNetworkServer)ductNetwork2).mixtureCapacity((Map)currentGasMasses);
        currentTemperature = (currentHeatEnergy -= exitHeat) / newCapacity;
        double heatFlow = ClockworkConfig.SERVER.getHeatTransferCoefficient() * estimatedSurfaceArea * (atmoTemperature - currentTemperature) * Math.max(1.0, (double)this.missingExternalPositions * 2.0 + 1.0);
        double newHeatEnergy = currentHeatEnergy + heatFlow;
        double newTemperature = newHeatEnergy / newCapacity;
        Object v = GasTypeRegistry.INSTANCE.getGAS_TYPES().get(new ResourceLocation("kelvin", "air"));
        Intrinsics.checkNotNull(v);
        GasType air = (GasType)v;
        Set set3 = currentGasMasses.entrySet();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"<get-entries>(...)");
        Iterable iterable3 = set3;
        double d10 = 0.0;
        for (Object t : iterable3) {
            void it;
            Map.Entry entry = (Map.Entry)t;
            d2 = d10;
            boolean bl = false;
            GasType gasType = (GasType)it.getKey();
            Object v2 = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
            d = gasType.massToMoles(((Number)v2).doubleValue());
            d10 = d2 + d;
        }
        double newMoles = d10;
        double newPressure = newMoles * 8.314 * newTemperature / volume;
        double inPressureDelta = RangesKt.coerceAtLeast((double)(atmoPressure - newPressure), (double)0.0);
        if (inPressureDelta > 0.0) {
            double leakScale = Math.max(1.0, (double)this.missingExternalPositions * 2.0 + 1.0);
            double speedScale = Math.sqrt(atmoTemperature * 8.314 / molarMass);
            double gasEnterRate = inPressureDelta * estimatedSurfaceArea * ClockworkConfig.SERVER.getPermeabilityConstant() / speedScale * leakScale;
            double enterMass = gasEnterRate * 0.01;
            Map map = currentGasMasses;
            Double d11 = (Double)currentGasMasses.get(air);
            Double d12 = (d11 != null ? d11 : 0.0) + enterMass;
            map.put(air, d12);
            double airCpEff = air.getSpecificHeatCapacity() * 1000.0 / air.getAdiabaticIndex();
            newHeatEnergy += enterMass * atmoTemperature * airCpEff;
        }
        this.gasMasses.clear();
        Map $this$forEach$iv2 = currentGasMasses;
        boolean $i$f$forEach2 = false;
        Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator3.next();
            boolean bl = false;
            ((Map)this.gasMasses).put(((GasType)it.getKey()).getResourceLocation().toString(), it.getValue());
        }
        this.currentEnergy = newHeatEnergy;
        return true;
    }

    @NotNull
    public final PhysBalloonData makeForceData() {
        double d;
        if (this.currentVolume > 1.0E-9) {
            Collection<Double> collection = this.gasMasses.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            d = CollectionsKt.sumOfDouble((Iterable)collection) / this.currentVolume;
        } else {
            d = 0.0;
        }
        double internalDensity = d;
        Vector3dc center = this.getCenter();
        return new PhysBalloonData(center, internalDensity, this.currentVolume);
    }

    public final double recalculateVolume() {
        double totalVolume = 0.0;
        Iterator<AABBic> iterator = this.regions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<AABBic> iterator2 = iterator;
        while (iterator2.hasNext()) {
            AABBic region;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            totalVolume += (double)this.volume(region);
        }
        this.currentVolume = totalVolume;
        return totalVolume;
    }

    @NotNull
    public final Vector3dc getCenter() {
        Vector3d center = new Vector3d();
        if (this.regions.isEmpty()) {
            return (Vector3dc)center;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        Iterator<AABBic> iterator = this.regions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<AABBic> iterator2 = iterator;
        while (iterator2.hasNext()) {
            AABBic region;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            sumX += (double)(region.minX() + region.maxX()) / 2.0;
            sumY += (double)(region.minY() + region.maxY()) / 2.0;
            sumZ += (double)(region.minZ() + region.maxZ()) / 2.0;
        }
        int count = this.regions.size();
        center.x = sumX / (double)count;
        center.y = sumY / (double)count;
        center.z = sumZ / (double)count;
        return (Vector3dc)center;
    }

    public final boolean containsPosition(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Iterator<AABBic> iterator = this.regions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<AABBic> iterator2 = iterator;
        while (iterator2.hasNext()) {
            AABBic region;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (pos.m_123341_() < region.minX() || pos.m_123341_() >= region.maxX() || pos.m_123342_() < region.minY() || pos.m_123342_() >= region.maxY() || pos.m_123343_() < region.minZ() || pos.m_123343_() >= region.maxZ()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final BlockPos getFirstValidExternalPosition(@NotNull Level level) {
        Object element$iv;
        Object v0;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Iterable $this$firstOrNull$iv = this.getExternalPositions();
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            BlockPos pos = (BlockPos)element$iv;
            boolean bl2 = false;
            if (level.m_46749_(pos)) {
                BlockState blockState = level.m_8055_(pos);
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                if (BalloonController.Companion.isValidBalloonEnclosure(blockState, level, pos)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    @NotNull
    public final Set<BlockPos> getExternalPositions() {
        Set externalPositions = new LinkedHashSet();
        Object object = new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, -1.0)};
        Vector3d[] directions = object;
        Iterator<AABBic> iterator = this.regions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            AABBic region = (AABBic)e;
            int n = region.maxX();
            for (int x = region.minX(); x < n; ++x) {
                int n2 = region.maxY();
                for (int y = region.minY(); y < n2; ++y) {
                    int n3 = region.maxZ();
                    for (int z = region.minZ(); z < n3; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        for (Vector3d dir : directions) {
                            BlockPos neighborPos = currentPos.m_7918_((int)dir.x, (int)dir.y, (int)dir.z);
                            Intrinsics.checkNotNull((Object)neighborPos);
                            if (this.containsPosition(neighborPos)) continue;
                            externalPositions.add(neighborPos);
                        }
                    }
                }
            }
        }
        return externalPositions;
    }

    public final boolean canLeak(int externalSize) {
        this.currentMaxLeaks = Math.max(1, externalSize / 4);
        Collection<Double> collection = this.gasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.sumOfDouble((Iterable)collection) > 1.0E-9 && this.missingExternalPositions < this.currentMaxLeaks;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isNearlyAtmospheric(@NotNull ServerLevel level) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Object t2;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Vector3dc root = this.getCenter();
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)level, (Vec3i)((Vec3i)new BlockPos((int)root.x(), (int)root.y(), (int)root.z())));
        if (loadedServerShip == null) {
            return false;
        }
        LoadedServerShip ship = loadedServerShip;
        double rootYInWorld = ValkyrienSkies.positionToWorld((ShipTransform)ship.getTransform(), (Vector3d)new Vector3d((double)root.x(), (double)root.y(), (double)root.z())).y;
        double atmoPressure = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirPressureForY(rootYInWorld, VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        BalloonData $this$isNearlyAtmospheric_u24lambda_u248 = this;
        boolean bl = false;
        Set<Map.Entry<String, Double>> set = $this$isNearlyAtmospheric_u24lambda_u248.gasMasses.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable iterable = set;
        double d = 0.0;
        for (Object t2 : iterable) {
            void it;
            Map.Entry entry = (Map.Entry)t2;
            double d2 = d;
            boolean bl2 = false;
            GasType gasType = GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation((String)it.getKey()));
            Intrinsics.checkNotNull((Object)gasType);
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            double d3 = gasType.massToMoles(((Number)v).doubleValue());
            d = d2 + d3;
        }
        double moles = d;
        DuctNetwork ductNetwork = KelvinMod.INSTANCE.getKelvin();
        Intrinsics.checkNotNull((Object)ductNetwork, (String)"null cannot be cast to non-null type org.valkyrienskies.kelvin.impl.DuctNetworkServer");
        Map map = $this$isNearlyAtmospheric_u24lambda_u248.gasMasses;
        DuctNetworkServer ductNetworkServer = (DuctNetworkServer)ductNetwork;
        boolean $i$f$mapKeys = false;
        t2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            GasType gasType;
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation((String)it.getKey())));
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = map2;
            boolean bl4 = false;
            entry = it$iv$iv.getValue();
            map3.put(gasType, entry);
        }
        double capacity = ductNetworkServer.mixtureCapacity(destination$iv$iv);
        double temperature = $this$isNearlyAtmospheric_u24lambda_u248.currentEnergy / capacity;
        double internalPressure = moles * 8.314 * temperature / $this$isNearlyAtmospheric_u24lambda_u248.currentVolume;
        return Math.abs(internalPressure - atmoPressure) <= 1.0E-4;
    }

    @NotNull
    public final EnclosureStatus validate(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.regions.isEmpty()) {
            return EnclosureStatus.INVALID;
        }
        Set<BlockPos> externals = this.getExternalPositions();
        if (externals.isEmpty()) {
            return EnclosureStatus.INVALID;
        }
        EnclosureStatus currentStatus = EnclosureStatus.VALID;
        this.lastSentLeaks.clear();
        this.lastSentLeaks = new HashSet(this.leakPositions);
        this.missingExternalPositions = 0;
        this.leakPositions.clear();
        for (BlockPos pos : externals) {
            boolean isNew;
            if (!level.m_46749_(pos)) {
                return EnclosureStatus.UNKNOWN;
            }
            BlockState blockState = level.m_8055_(pos);
            Intrinsics.checkNotNull((Object)blockState);
            if (BalloonController.Companion.isValidBalloonEnclosure(blockState, level, pos)) continue;
            int n = this.missingExternalPositions;
            this.missingExternalPositions = n + 1;
            this.leakPositions.add((Vector3ic)new Vector3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
            EnclosureStatus enclosureStatus = currentStatus = this.canLeak(externals.size()) && !this.isNearlyAtmospheric((ServerLevel)level) ? EnclosureStatus.LEAKING : EnclosureStatus.INVALID;
            if (!(level instanceof ServerLevel) || !(isNew = !this.lastSentLeaks.contains(new Vector3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())))) continue;
            double d = pos.m_123341_();
            double d2 = pos.m_123342_();
            double d3 = pos.m_123343_();
            SoundEvent soundEvent = ClockworkSounds.INSTANCE.getBALLOON_RUPTURE().getMainEvent();
            Intrinsics.checkNotNull((Object)soundEvent);
            level.m_6263_(null, d, d2, d3, soundEvent, SoundSource.BLOCKS, 1.0f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            this.sendInitialLeakParticleBurst((ServerLevel)level, pos, Direction.UP);
        }
        this.isLeaking = currentStatus == EnclosureStatus.LEAKING;
        return currentStatus;
    }

    @NotNull
    public final Direction findDirectionToOutside(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Set<? extends BlockPos> externals) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(externals, (String)"externals");
        for (Direction dir : Direction.values()) {
            BlockPos check = pos.m_121945_(dir);
            Intrinsics.checkNotNull((Object)check);
            if (this.containsPosition(check) || externals.contains(check)) continue;
            BlockState blockState = level.m_8055_(check);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            if (BalloonController.Companion.isValidBalloonEnclosure(blockState, (Level)level, check)) continue;
            return dir;
        }
        return Direction.UP;
    }

    public final void sendInitialLeakParticleBurst(@NotNull ServerLevel level, @NotNull BlockPos position, @NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)level, (Vec3i)((Vec3i)position));
        if (loadedServerShip == null) {
            return;
        }
        LoadedServerShip thisShip = loadedServerShip;
        Vector3d center = this.getCenter().sub(0.5, 0.5, 0.5, new Vector3d());
        Vector3f realDir = new Vector3f((float)position.m_123341_(), (float)position.m_123342_(), (float)position.m_123343_()).sub((Vector3fc)new Vector3f((float)center.x(), (float)center.y(), (float)center.z())).normalize();
        Vector3f worldDirection = thisShip.getTransform().getShipToWorldRotation().transform(new Vector3f(realDir.x, realDir.y, realDir.z));
        Intrinsics.checkNotNull((Object)worldDirection);
        LeakParticleData leakParticle = new LeakParticleData(worldDirection, 0.1f + level.f_46441_.m_188501_() * 0.2f);
        level.m_8767_((ParticleOptions)leakParticle, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), level.f_46441_.m_216339_(50, 100), 0.5, 0.5, 0.5, 1.0);
    }

    public final void sendLeakParticles(@NotNull ServerLevel level, @NotNull BlockPos position, @NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)level, (Vec3i)((Vec3i)position));
        if (loadedServerShip == null) {
            return;
        }
        LoadedServerShip thisShip = loadedServerShip;
        Vector3d center = this.getCenter().sub(0.5, 0.5, 0.5, new Vector3d());
        Vector3f realDir = new Vector3f((float)position.m_123341_(), (float)position.m_123342_(), (float)position.m_123343_()).sub((Vector3fc)new Vector3f((float)center.x(), (float)center.y(), (float)center.z())).normalize();
        Vector3f worldDirection = thisShip.getTransform().getShipToWorldRotation().transform(new Vector3f(realDir.x, realDir.y, realDir.z));
        int i = 1;
        int n = RangesKt.coerceAtMost((int)this.missingExternalPositions, (int)4);
        if (i <= n) {
            while (true) {
                Intrinsics.checkNotNull((Object)worldDirection);
                LeakParticleData leakParticle = new LeakParticleData(worldDirection, 0.05f + level.f_46441_.m_188501_() * 0.5f);
                level.m_8767_((ParticleOptions)leakParticle, (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, this.missingExternalPositions >= this.currentMaxLeaks / 2 ? 2 : 1, 0.5, 0.5, 0.5, 1.0);
                if (i == n) break;
                ++i;
            }
        }
    }

    public final boolean updateRegions(@NotNull List<? extends AABBic> newRegions, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(newRegions, (String)"newRegions");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.regions.clear();
        this.regions.addAll((Collection<AABBic>)newRegions);
        this.recalculateVolume();
        EnclosureStatus result = this.validate(level);
        this.isLeaking = result == EnclosureStatus.LEAKING;
        this.shouldRemove = result == EnclosureStatus.INVALID;
        return result.isAtLeast(EnclosureStatus.UNKNOWN);
    }

    public final void updateRegionsNoValidation(@NotNull List<? extends AABBic> newRegions, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(newRegions, (String)"newRegions");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.regions.clear();
        this.regions.addAll((Collection<AABBic>)newRegions);
        this.recalculateVolume();
    }

    @NotNull
    public final EnclosureStatus mergeWith(@NotNull BalloonData other, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.regions.addAll((Collection<AABBic>)other.regions);
        List<AABBic> merged = AABBHelper.INSTANCE.mergeAdjacentFast((Iterable<? extends AABBic>)this.regions);
        this.regions.clear();
        this.regions.addAll((Collection<AABBic>)merged);
        for (Map.Entry entry : ((Map)other.gasMasses).entrySet()) {
            String gasType = (String)entry.getKey();
            double mass = ((Number)entry.getValue()).doubleValue();
            ((Map)this.gasMasses).put(gasType, ((Number)this.gasMasses.getOrDefault(gasType, 0.0)).doubleValue() + mass);
        }
        this.currentEnergy += other.currentEnergy;
        this.recalculateVolume();
        return this.validate(level);
    }

    @NotNull
    public final Pair<Boolean, ArrayList<BalloonData>> trySplit(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ArrayList<List<AABBic>> result = WanderwandItem.Companion.findIsolatedAABBComponents((List<? extends AABBic>)this.regions, level);
        if (result.size() == 1) {
            return new Pair((Object)false, new ArrayList());
        }
        if (result.size() == 0) {
            this.shouldRemove = true;
            return new Pair((Object)true, new ArrayList());
        }
        ArrayList<BalloonData> newBalloons = new ArrayList<BalloonData>();
        double totalVolume = this.currentVolume;
        List $this$sortByDescending$iv = result;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(this){
                final /* synthetic */ BalloonData this$0;
                {
                    this.this$0 = balloonData;
                }

                public final int compare(T a, T b) {
                    List it = (List)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(BalloonData.access$volume(this.this$0, it));
                    it = (List)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(BalloonData.access$volume(this.this$0, it)));
                }
            });
        }
        List<AABBic> list = result.get(0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        List<AABBic> thisBecomes = list;
        BalloonData newThis = null;
        Iterator<List<AABBic>> iterator = result.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<List<AABBic>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            List<AABBic> component;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
            BalloonData newBalloon = new BalloonData((ArrayList)component, new HashMap<String, Double>(), 0.0, 0.0, false);
            newBalloon.recalculateVolume();
            double volumeFraction = newBalloon.currentVolume / totalVolume;
            for (Map.Entry entry : ((Map)this.gasMasses).entrySet()) {
                String gasType = (String)entry.getKey();
                double mass = ((Number)entry.getValue()).doubleValue();
                ((Map)newBalloon.gasMasses).put(gasType, mass * volumeFraction);
            }
            newBalloon.currentEnergy = this.currentEnergy * volumeFraction;
            EnclosureStatus status = newBalloon.validate(level);
            if (!status.isAtLeast(EnclosureStatus.LEAKING)) continue;
            newBalloons.add(newBalloon);
            if (!Intrinsics.areEqual(component, thisBecomes)) continue;
            newThis = newBalloon;
        }
        this.clear();
        if (newThis != null) {
            this.regions.addAll((Collection<AABBic>)newThis.regions);
            this.gasMasses.putAll((Map<String, Double>)newThis.gasMasses);
            this.currentEnergy = newThis.currentEnergy;
            this.isLeaking = newThis.isLeaking;
            result.remove(thisBecomes);
        }
        this.recalculateVolume();
        return new Pair((Object)true, newBalloons);
    }

    private final void clear() {
        this.regions.clear();
        this.gasMasses.clear();
        this.currentEnergy = 0.0;
        this.currentVolume = 0.0;
        this.isLeaking = false;
        this.missingExternalPositions = 0;
    }

    private final long volume(AABBic $this$volume) {
        long dx = $this$volume.maxX() - $this$volume.minX();
        long dy = $this$volume.maxY() - $this$volume.minY();
        long dz = $this$volume.maxZ() - $this$volume.minZ();
        return dx * dy * dz;
    }

    private final long volume(List<? extends AABBic> $this$volume) {
        long total = 0L;
        for (AABBic aABBic : $this$volume) {
            total += this.volume(aABBic);
        }
        return total;
    }

    public static final /* synthetic */ long access$volume(BalloonData $this, List $receiver) {
        return $this.volume($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\bj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$EnclosureStatus;", "", "status", "", "isAtLeast", "(Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$EnclosureStatus;)Z", "other", "weakestOf", "(Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$EnclosureStatus;)Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$EnclosureStatus;", "<init>", "(Ljava/lang/String;I)V", "VALID", "LEAKING", "UNKNOWN", "INVALID", "clockwork"})
    public static final class EnclosureStatus
    extends Enum<EnclosureStatus> {
        public static final /* enum */ EnclosureStatus VALID = new EnclosureStatus();
        public static final /* enum */ EnclosureStatus LEAKING = new EnclosureStatus();
        public static final /* enum */ EnclosureStatus UNKNOWN = new EnclosureStatus();
        public static final /* enum */ EnclosureStatus INVALID = new EnclosureStatus();
        private static final /* synthetic */ EnclosureStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isAtLeast(@NotNull EnclosureStatus status) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return this.ordinal() >= status.ordinal();
        }

        @NotNull
        public final EnclosureStatus weakestOf(@NotNull EnclosureStatus other) {
            Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
            return this.ordinal() < other.ordinal() ? this : other;
        }

        public static EnclosureStatus[] values() {
            return (EnclosureStatus[])$VALUES.clone();
        }

        public static EnclosureStatus valueOf(String value) {
            return Enum.valueOf(EnclosureStatus.class, value);
        }

        @NotNull
        public static EnumEntries<EnclosureStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = enclosureStatusArray = new EnclosureStatus[]{EnclosureStatus.VALID, EnclosureStatus.LEAKING, EnclosureStatus.UNKNOWN, EnclosureStatus.INVALID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J.\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u0004R\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001a\u001a\u0004\b\u001b\u0010\u0007R\u0017\u0010\u000b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001a\u001a\u0004\b\u001c\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$PhysBalloonData;", "", "Lorg/joml/Vector3dc;", "component1", "()Lorg/joml/Vector3dc;", "", "component2", "()D", "component3", "center", "internalDensity", "volume", "copy", "(Lorg/joml/Vector3dc;DD)Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$PhysBalloonData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/joml/Vector3dc;", "getCenter", "D", "getInternalDensity", "getVolume", "<init>", "(Lorg/joml/Vector3dc;DD)V", "clockwork"})
    public static final class PhysBalloonData {
        @NotNull
        private final Vector3dc center;
        private final double internalDensity;
        private final double volume;

        public PhysBalloonData(@NotNull Vector3dc center, double internalDensity, double volume) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            this.center = center;
            this.internalDensity = internalDensity;
            this.volume = volume;
        }

        @NotNull
        public final Vector3dc getCenter() {
            return this.center;
        }

        public final double getInternalDensity() {
            return this.internalDensity;
        }

        public final double getVolume() {
            return this.volume;
        }

        @NotNull
        public final Vector3dc component1() {
            return this.center;
        }

        public final double component2() {
            return this.internalDensity;
        }

        public final double component3() {
            return this.volume;
        }

        @NotNull
        public final PhysBalloonData copy(@NotNull Vector3dc center, double internalDensity, double volume) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            return new PhysBalloonData(center, internalDensity, volume);
        }

        public static /* synthetic */ PhysBalloonData copy$default(PhysBalloonData physBalloonData, Vector3dc vector3dc, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                vector3dc = physBalloonData.center;
            }
            if ((n & 2) != 0) {
                d = physBalloonData.internalDensity;
            }
            if ((n & 4) != 0) {
                d2 = physBalloonData.volume;
            }
            return physBalloonData.copy(vector3dc, d, d2);
        }

        @NotNull
        public String toString() {
            return "PhysBalloonData(center=" + this.center + ", internalDensity=" + this.internalDensity + ", volume=" + this.volume + ")";
        }

        public int hashCode() {
            int result = this.center.hashCode();
            result = result * 31 + Double.hashCode(this.internalDensity);
            result = result * 31 + Double.hashCode(this.volume);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PhysBalloonData)) {
                return false;
            }
            PhysBalloonData physBalloonData = (PhysBalloonData)other;
            if (!Intrinsics.areEqual((Object)this.center, (Object)physBalloonData.center)) {
                return false;
            }
            if (Double.compare(this.internalDensity, physBalloonData.internalDensity) != 0) {
                return false;
            }
            return Double.compare(this.volume, physBalloonData.volume) == 0;
        }
    }
}

