/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.content.forces.MultiInstanceForceApplier;
import org.valkyrienskies.clockwork.content.physicalities.reactionwheel.data.ReactionWheelCreateData;
import org.valkyrienskies.clockwork.content.physicalities.reactionwheel.data.ReactionWheelData;
import org.valkyrienskies.clockwork.content.physicalities.reactionwheel.data.ReactionWheelUpdateData;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.world.PhysLevel;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 (2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001(B\u007f\u0012$\b\u0002\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00030\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0003`\u000e\u0012\u001a\b\u0002\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020\u00140\u0013\u0012\u001a\b\u0002\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u00140\u0013\u0012\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u0013\u0012\b\b\u0002\u0010\u001d\u001a\u00020\r\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR6\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00030\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0003`\u000e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R,\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020\u00140\u00138\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R,\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u00140\u00138\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u00138\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018R\"\u0010\u001d\u001a\u00020\r8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/ReactionWheelController;", "Lorg/valkyrienskies/clockwork/content/forces/MultiInstanceForceApplier;", "Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/data/ReactionWheelUpdateData;", "Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/data/ReactionWheelData;", "Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/data/ReactionWheelCreateData;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "appliers", "Ljava/util/HashMap;", "getAppliers", "()Ljava/util/HashMap;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "applierUpdateData", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getApplierUpdateData", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "createdAppliers", "getCreatedAppliers", "removedAppliers", "getRemovedAppliers", "nextApplierID", "I", "getNextApplierID", "()I", "setNextApplierID", "(I)V", "Lorg/joml/Vector3dc;", "previousTickShipOmega", "Lorg/joml/Vector3dc;", "<init>", "(Ljava/util/HashMap;Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/util/concurrent/ConcurrentLinkedQueue;I)V", "Companion", "clockwork"})
public final class ReactionWheelController
implements MultiInstanceForceApplier<ReactionWheelUpdateData, ReactionWheelData, ReactionWheelCreateData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Integer, ReactionWheelData> appliers;
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, ReactionWheelUpdateData>> applierUpdateData;
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, ReactionWheelCreateData>> createdAppliers;
    @NotNull
    private final ConcurrentLinkedQueue<Integer> removedAppliers;
    private int nextApplierID;
    @JsonIgnore
    @NotNull
    private Vector3dc previousTickShipOmega;

    public ReactionWheelController(@NotNull HashMap<Integer, ReactionWheelData> appliers, @NotNull ConcurrentLinkedQueue<Pair<Integer, ReactionWheelUpdateData>> applierUpdateData, @NotNull ConcurrentLinkedQueue<Pair<Integer, ReactionWheelCreateData>> createdAppliers, @NotNull ConcurrentLinkedQueue<Integer> removedAppliers, int nextApplierID) {
        Intrinsics.checkNotNullParameter(appliers, (String)"appliers");
        Intrinsics.checkNotNullParameter(applierUpdateData, (String)"applierUpdateData");
        Intrinsics.checkNotNullParameter(createdAppliers, (String)"createdAppliers");
        Intrinsics.checkNotNullParameter(removedAppliers, (String)"removedAppliers");
        this.appliers = appliers;
        this.applierUpdateData = applierUpdateData;
        this.createdAppliers = createdAppliers;
        this.removedAppliers = removedAppliers;
        this.nextApplierID = nextApplierID;
        this.previousTickShipOmega = (Vector3dc)new Vector3d();
    }

    public /* synthetic */ ReactionWheelController(HashMap hashMap, ConcurrentLinkedQueue concurrentLinkedQueue, ConcurrentLinkedQueue concurrentLinkedQueue2, ConcurrentLinkedQueue concurrentLinkedQueue3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            hashMap = new HashMap<Integer, ReactionWheelData>();
        }
        if ((n2 & 2) != 0) {
            concurrentLinkedQueue = new ConcurrentLinkedQueue<Pair<Integer, ReactionWheelUpdateData>>();
        }
        if ((n2 & 4) != 0) {
            concurrentLinkedQueue2 = new ConcurrentLinkedQueue<Pair<Integer, ReactionWheelCreateData>>();
        }
        if ((n2 & 8) != 0) {
            concurrentLinkedQueue3 = new ConcurrentLinkedQueue<Integer>();
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(hashMap, concurrentLinkedQueue, concurrentLinkedQueue2, concurrentLinkedQueue3, n);
    }

    @Override
    @NotNull
    public HashMap<Integer, ReactionWheelData> getAppliers() {
        return this.appliers;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Pair<Integer, ReactionWheelUpdateData>> getApplierUpdateData() {
        return this.applierUpdateData;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Pair<Integer, ReactionWheelCreateData>> getCreatedAppliers() {
        return this.createdAppliers;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Integer> getRemovedAppliers() {
        return this.removedAppliers;
    }

    @Override
    public int getNextApplierID() {
        return this.nextApplierID;
    }

    @Override
    public void setNextApplierID(int n) {
        this.nextApplierID = n;
    }

    @Override
    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        MultiInstanceForceApplier.super.physTick(physShip, physLevel);
        for (Integer n : this.getAppliers().keySet()) {
            ReactionWheelData data;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"next(...)");
            int wheelID = ((Number)n).intValue();
            Intrinsics.checkNotNull((Object)this.getAppliers().get(wheelID));
            double wheelMass = ClockworkConfig.SERVER.getReactionWheelEffectiveness() * 64.0;
            Vector3d vector3d = physShip.getTransform().getShipToWorld().transformDirection((Vector3dc)new Vector3d(data.getDirection()), new Vector3d()).normalize().mul(data.getCurrentRPM() * wheelMass);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            physShip.applyWorldTorque((Vector3dc)vector3d);
        }
        this.previousTickShipOmega = physShip.getOmega();
    }

    public ReactionWheelController() {
        this(null, null, null, null, 0, 31, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/ReactionWheelController$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/ReactionWheelController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/ReactionWheelController;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ReactionWheelController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(ReactionWheelController.class) == null) {
                ship.setAttachment((Object)new ReactionWheelController(null, null, null, null, 0, 31, null));
            }
            return (ReactionWheelController)ship.getAttachment(ReactionWheelController.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

