/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.events;

import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.core.api.events.CollisionEvent;
import org.valkyrienskies.core.api.physics.ContactPoint;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lorg/valkyrienskies/clockwork/content/events/CollisionSoundEffectHandler;", "", "Lorg/valkyrienskies/core/api/events/CollisionEvent;", "event", "", "onCollide", "(Lorg/valkyrienskies/core/api/events/CollisionEvent;)V", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lorg/joml/Vector3dc;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "getValidState", "(Lnet/minecraft/server/level/ServerLevel;Lorg/joml/Vector3dc;)Lnet/minecraft/world/level/block/state/BlockState;", "", "velocitySquared", "mass", "", "calculateVolume", "(DD)F", "tick", "(Lnet/minecraft/server/level/ServerLevel;)V", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "collisionQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getCollisionQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "<init>", "()V", "clockwork"})
public final class CollisionSoundEffectHandler {
    @NotNull
    public static final CollisionSoundEffectHandler INSTANCE = new CollisionSoundEffectHandler();
    @NotNull
    private static final ConcurrentLinkedQueue<CollisionEvent> collisionQueue = new ConcurrentLinkedQueue();

    private CollisionSoundEffectHandler() {
    }

    @NotNull
    public final ConcurrentLinkedQueue<CollisionEvent> getCollisionQueue() {
        return collisionQueue;
    }

    public final void onCollide(@NotNull CollisionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (ClockworkConfig.SERVER.getCollisionSoundEffects()) {
            collisionQueue.add(event);
        }
    }

    private final BlockState getValidState(ServerLevel level, Vector3dc pos) {
        BlockState blockState = level.m_8055_(BlockPos.m_274561_((double)pos.x(), (double)pos.y(), (double)pos.z()));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        return blockState;
    }

    private final float calculateVolume(double velocitySquared, double mass) {
        double energy = Math.exp(mass * Math.pow(velocitySquared, 0.083));
        return (float)energy / 100.0f;
    }

    public final void tick(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Long groundId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        if (collisionQueue.size() > ClockworkConfig.SERVER.getCollisionSoundEffectMax()) {
            collisionQueue.clear();
        }
        while (!collisionQueue.isEmpty()) {
            LoadedServerShip ship;
            CollisionEvent event = (CollisionEvent)CollectionsKt.first((Iterable)collisionQueue);
            if (!Intrinsics.areEqual((Object)event.getDimensionId(), (Object)VSGameUtilsKt.getDimensionId((Level)((Level)level)))) continue;
            collisionQueue.remove();
            ContactPoint contact = (ContactPoint)CollectionsKt.first((Iterable)event.getContactPoints());
            Vector3d posA = contact.getPosition().add((Vector3dc)contact.getNormal().mul(Math.abs((double)contact.getSeparation()), new Vector3d()), new Vector3d());
            Vector3d posB = contact.getPosition().sub((Vector3dc)contact.getNormal().mul(Math.abs((double)contact.getSeparation()), new Vector3d()), new Vector3d());
            double mass = 0.0;
            Long l = groundId;
            if ((l == null || event.getShipIdA() != l.longValue()) && (ship = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(event.getShipIdA())) != null) {
                posA = ship.getTransform().getWorldToShip().transformPosition((Vector3dc)posA, new Vector3d());
                mass += ship.getInertiaData().getMass();
            }
            Long l2 = groundId;
            if ((l2 == null || event.getShipIdB() != l2.longValue()) && (ship = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(event.getShipIdB())) != null) {
                posB = ship.getTransform().getWorldToShip().transformPosition((Vector3dc)posB, new Vector3d());
                mass += ship.getInertiaData().getMass();
            }
            Vector3d vector3d = posA;
            Intrinsics.checkNotNull((Object)vector3d);
            BlockState stateA = this.getValidState(level, (Vector3dc)vector3d);
            Vector3d vector3d2 = posB;
            Intrinsics.checkNotNull((Object)vector3d2);
            BlockState stateB = this.getValidState(level, (Vector3dc)vector3d2);
            Vector3dc pos = contact.getPosition();
            float volume = this.calculateVolume(contact.getVelocity().lengthSquared(), mass);
            level.m_6263_(null, pos.x(), pos.y(), pos.z(), stateA.m_60827_().m_56778_(), SoundSource.BLOCKS, volume, 1.0f);
            level.m_6263_(null, pos.x(), pos.y(), pos.z(), stateB.m_60827_().m_56778_(), SoundSource.BLOCKS, volume, 1.0f);
        }
    }
}

