/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllKeys;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkGuiTextures;
import org.valkyrienskies.clockwork.ClockworkLang;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.tool.ToolType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0017\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017\u00a2\u0006\u0004\b4\u00105J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\fJ\u000f\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u000f\u0010\u0012\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001a8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\"\u0010(\u001a\u00020\u00028\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010\u0006R\u0016\u0010-\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010!R\"\u0010.\u001a\u00020\u00028\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010)\u001a\u0004\b/\u0010+\"\u0004\b0\u0010\u0006R\"\u00101\u001a\u00020\u00028\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010)\u001a\u0004\b2\u0010+\"\u0004\b3\u0010\u0006\u00a8\u00066"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/WanderwandSelectionScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "", "direction", "", "cycle", "(I)V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "partialTicks", "draw", "(Lnet/minecraft/client/gui/GuiGraphics;F)V", "update", "()V", "poseStack", "renderPassive", "onClose", "init", "", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/tool/ToolType;", "tools", "Ljava/util/List;", "Ljava/util/function/Consumer;", "callback", "Ljava/util/function/Consumer;", "", "holdToFocus", "Ljava/lang/String;", "getHoldToFocus", "()Ljava/lang/String;", "", "focus", "Z", "getFocus", "()Z", "setFocus", "(Z)V", "yOffset", "F", "selection", "I", "getSelection", "()I", "setSelection", "initialized", "w", "getW", "setW", "h", "getH", "setH", "<init>", "(Ljava/util/List;Ljava/util/function/Consumer;)V", "clockwork"})
public final class WanderwandSelectionScreen
extends Screen {
    @NotNull
    private final List<ToolType> tools;
    @NotNull
    private final Consumer<ToolType> callback;
    @NotNull
    private final String holdToFocus;
    private boolean focus;
    private float yOffset;
    private int selection;
    private boolean initialized;
    private int w;
    private int h;

    public WanderwandSelectionScreen(@NotNull List<? extends ToolType> tools, @NotNull Consumer<ToolType> callback) {
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        super((Component)Component.m_237113_((String)"Tool Selection"));
        this.tools = tools;
        this.callback = callback;
        this.holdToFocus = "gui.toolmenu.focusKey";
        this.f_96541_ = Minecraft.m_91087_();
        this.focus = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        this.callback.accept(this.tools.get(this.selection));
        this.w = (int)Math.max((double)(this.tools.size() * 50 + 30), 220.0);
        this.h = 30;
    }

    @NotNull
    public final String getHoldToFocus() {
        return this.holdToFocus;
    }

    public final boolean getFocus() {
        return this.focus;
    }

    public final void setFocus(boolean bl) {
        this.focus = bl;
    }

    protected final int getSelection() {
        return this.selection;
    }

    protected final void setSelection(int n) {
        this.selection = n;
    }

    protected final int getW() {
        return this.w;
    }

    protected final void setW(int n) {
        this.w = n;
    }

    protected final int getH() {
        return this.h;
    }

    protected final void setH(int n) {
        this.h = n;
    }

    public final void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private final void draw(GuiGraphics guiGraphics, float partialTicks) {
        Minecraft minecraft = this.f_96541_;
        Intrinsics.checkNotNull((Object)minecraft);
        Window mainWindow = minecraft.m_91268_();
        if (!this.initialized) {
            Minecraft minecraft2 = this.f_96541_;
            Intrinsics.checkNotNull((Object)minecraft2);
            this.m_6575_(minecraft2, mainWindow.m_85445_(), mainWindow.m_85446_());
        }
        int x = (mainWindow.m_85445_() - this.w) / 2 + 15;
        int y = mainWindow.m_85446_() - this.h - 75;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 20.0 - (double)this.yOffset, this.focus ? 100.0 : 0.0);
        ClockworkGuiTextures gray = ClockworkGuiTextures.WANDER_TOOL_BACKGROUND;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.focus ? 0.875f : 0.5f));
        guiGraphics.m_280163_(gray.getLocation(), x - 15, y, (float)gray.getStartX(), (float)gray.getStartY(), this.w, this.h, gray.getWidth(), gray.getHeight());
        float toolTipAlpha = this.yOffset / (float)40;
        List<Component> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * (float)255) << 24;
        if (toolTipAlpha > 0.25f) {
            RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            guiGraphics.m_280163_(gray.getLocation(), x - 15, y + 33, (float)gray.getStartX(), (float)gray.getStartY(), this.w, this.h + 22, gray.getWidth(), gray.getHeight());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                guiGraphics.m_280430_(this.f_96547_, toolTip.get(0), x - 10, y + 38, 0xEEEEEE + stringAlphaComponent);
            }
            if (toolTip.size() > 1) {
                guiGraphics.m_280430_(this.f_96547_, toolTip.get(1), x - 10, y + 50, 0xDDCCFF + stringAlphaComponent);
            }
            if (toolTip.size() > 2) {
                guiGraphics.m_280430_(this.f_96547_, toolTip.get(2), x - 10, y + 60, 0xDDCCFF + stringAlphaComponent);
            }
            if (toolTip.size() > 3) {
                guiGraphics.m_280430_(this.f_96547_, toolTip.get(3), x - 10, y + 72, 0xCCCCDD + stringAlphaComponent);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String keyName = AllKeys.TOOL_MENU.getBoundKey();
        Minecraft minecraft3 = this.f_96541_;
        Intrinsics.checkNotNull((Object)minecraft3);
        int width = minecraft3.m_91268_().m_85445_();
        if (!this.focus) {
            Minecraft minecraft4 = this.f_96541_;
            Intrinsics.checkNotNull((Object)minecraft4);
            Object[] objectArray = new Object[]{keyName};
            guiGraphics.m_280653_(minecraft4.f_91062_, (Component)ClockworkLang.translateDirect(this.holdToFocus, objectArray), width / 2, y - 10, 0xDDCCFF);
        } else {
            Minecraft minecraft5 = this.f_96541_;
            Intrinsics.checkNotNull((Object)minecraft5);
            guiGraphics.m_280653_(minecraft5.f_91062_, (Component)ClockworkLang.translateDirect("gui.toolmenu.cycle", new Object[0]), width / 2, y - 10, 0xDDCCFF);
        }
        int n = ((Collection)this.tools).size();
        for (int i = 0; i < n; ++i) {
            float alpha;
            RenderSystem.enableBlend();
            poseStack.m_85836_();
            float f = alpha = this.focus ? 1.0f : 0.2f;
            if (i == this.selection) {
                poseStack.m_85837_(0.0, -10.0, 0.0);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft minecraft6 = this.f_96541_;
                Intrinsics.checkNotNull((Object)minecraft6);
                guiGraphics.m_280137_(minecraft6.f_91062_, this.tools.get(i).getDisplayName().getString(), x + i * 50 + 24, y + 28, 0xDDCCFF);
                alpha = 1.0f;
            }
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().render(guiGraphics, x + i * 50 + 16, y + 12);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().render(guiGraphics, x + i * 50 + 16, y + 11);
            poseStack.m_85849_();
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public final void update() {
        this.yOffset = this.focus ? (this.yOffset += ((float)40 - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public final void renderPassive(@NotNull GuiGraphics poseStack, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        this.draw(poseStack, partialTicks);
    }

    public void m_7379_() {
        this.callback.accept(this.tools.get(this.selection));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initialized = true;
    }
}

