/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandItem;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandRenderUpdatePacket;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.tool.IWanderwandTool;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.tool.SelectionToolBase;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.tool.ToolType;
import org.valkyrienskies.clockwork.platform.SharedValues;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\bX\u0010 J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J3\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00112\n\u0010\u001c\u001a\u00060\u001aj\u0002`\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R?\u0010.\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0+0*j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0+`-8\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\"\u00103\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b3\u00105\"\u0004\b6\u00107R*\u00108\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R'\u0010>\u001a\u0012\u0012\u0004\u0012\u00020\u00150*j\b\u0012\u0004\u0012\u00020\u0015`-8\u0006\u00a2\u0006\f\n\u0004\b>\u0010/\u001a\u0004\b?\u00101R$\u0010@\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER$\u0010F\u001a\u0004\u0018\u00010\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\"\u0010L\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR#\u0010T\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150S0R8\u0006\u00a2\u0006\f\n\u0004\bT\u0010U\u001a\u0004\bV\u0010W\u00a8\u0006Y"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/WanderwandEffectRenderer;", "", "Lnet/minecraft/client/multiplayer/ClientLevel;", "clientLevel", "", "clientTick", "(Lnet/minecraft/client/multiplayer/ClientLevel;)V", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/createmod/catnip/render/SuperRenderTypeBuffer;", "buffer", "Lnet/minecraft/world/phys/Vec3;", "camera", "", "partialTicks", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/createmod/catnip/render/SuperRenderTypeBuffer;Lnet/minecraft/world/phys/Vec3;F)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "updateClusters", "(Lnet/minecraft/nbt/CompoundTag;)V", "Lnet/minecraft/core/BlockPos;", "selPos", "Lnet/minecraft/core/Direction;", "selDir", "blocks", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId", "startWelding", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lnet/minecraft/nbt/CompoundTag;J)V", "stopWelding", "()V", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/WanderwandRenderUpdatePacket;", "packet", "handlePacket", "(Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/WanderwandRenderUpdatePacket;)V", "Lnet/minecraft/client/Minecraft;", "client", "Lnet/minecraft/client/Minecraft;", "getClient", "()Lnet/minecraft/client/Minecraft;", "Ljava/util/HashSet;", "Lkotlin/Pair;", "Lorg/joml/Vector3d;", "Lkotlin/collections/HashSet;", "attachments", "Ljava/util/HashSet;", "getAttachments", "()Ljava/util/HashSet;", "", "isWelding", "Z", "()Z", "setWelding", "(Z)V", "weldingShip", "Ljava/lang/Long;", "getWeldingShip", "()Ljava/lang/Long;", "setWeldingShip", "(Ljava/lang/Long;)V", "weld", "getWeld", "selectionPos", "Lnet/minecraft/core/BlockPos;", "getSelectionPos", "()Lnet/minecraft/core/BlockPos;", "setSelectionPos", "(Lnet/minecraft/core/BlockPos;)V", "selectionDir", "Lnet/minecraft/core/Direction;", "getSelectionDir", "()Lnet/minecraft/core/Direction;", "setSelectionDir", "(Lnet/minecraft/core/Direction;)V", "lastTargetPos", "Lnet/minecraft/world/phys/Vec3;", "getLastTargetPos", "()Lnet/minecraft/world/phys/Vec3;", "setLastTargetPos", "(Lnet/minecraft/world/phys/Vec3;)V", "Ljava/util/ArrayList;", "", "clusters", "Ljava/util/ArrayList;", "getClusters", "()Ljava/util/ArrayList;", "<init>", "clockwork"})
@OnlyIn(value=Dist.CLIENT)
public final class WanderwandEffectRenderer {
    @NotNull
    private final Minecraft client;
    @NotNull
    private final HashSet<Pair<Vector3d, Vector3d>> attachments;
    private boolean isWelding;
    @Nullable
    private Long weldingShip;
    @NotNull
    private final HashSet<BlockPos> weld;
    @Nullable
    private BlockPos selectionPos;
    @Nullable
    private Direction selectionDir;
    @NotNull
    private Vec3 lastTargetPos;
    @NotNull
    private final ArrayList<Set<BlockPos>> clusters;

    public WanderwandEffectRenderer() {
        Minecraft minecraft = Minecraft.m_91087_();
        Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance(...)");
        this.client = minecraft;
        this.attachments = new HashSet();
        this.weld = new HashSet();
        Vec3 vec3 = Vec3.f_82478_;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.lastTargetPos = vec3;
        this.clusters = new ArrayList();
    }

    @NotNull
    public final Minecraft getClient() {
        return this.client;
    }

    @NotNull
    public final HashSet<Pair<Vector3d, Vector3d>> getAttachments() {
        return this.attachments;
    }

    public final boolean isWelding() {
        return this.isWelding;
    }

    public final void setWelding(boolean bl) {
        this.isWelding = bl;
    }

    @Nullable
    public final Long getWeldingShip() {
        return this.weldingShip;
    }

    public final void setWeldingShip(@Nullable Long l) {
        this.weldingShip = l;
    }

    @NotNull
    public final HashSet<BlockPos> getWeld() {
        return this.weld;
    }

    @Nullable
    public final BlockPos getSelectionPos() {
        return this.selectionPos;
    }

    public final void setSelectionPos(@Nullable BlockPos blockPos) {
        this.selectionPos = blockPos;
    }

    @Nullable
    public final Direction getSelectionDir() {
        return this.selectionDir;
    }

    public final void setSelectionDir(@Nullable Direction direction) {
        this.selectionDir = direction;
    }

    @NotNull
    public final Vec3 getLastTargetPos() {
        return this.lastTargetPos;
    }

    public final void setLastTargetPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.lastTargetPos = vec3;
    }

    @NotNull
    public final ArrayList<Set<BlockPos>> getClusters() {
        return this.clusters;
    }

    public final void clientTick(@NotNull ClientLevel clientLevel) {
        Iterator<Set<BlockPos>> iterator;
        Intrinsics.checkNotNullParameter((Object)clientLevel, (String)"clientLevel");
        int count = 0;
        if (SharedValues.getWanderwandHandler().findWandInHand((Player)this.client.f_91074_) != null) {
            Iterator<Set<BlockPos>> iterator2 = this.clusters.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            iterator = iterator2;
            while (iterator.hasNext()) {
                Set<BlockPos> cluster;
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
                Outliner.getInstance().showCluster((Object)("cluster" + count), (Iterable)cluster).colored(0xFF55FF).lineWidth(0.1f).withFaceTextures((BindableTexture)AllSpecialTextures.THIN_CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED);
                ++count;
            }
        }
        count = 0;
        Iterator<Pair<Vector3d, Vector3d>> iterator3 = this.attachments.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator = iterator3;
        while (iterator.hasNext()) {
            Set<BlockPos> set = iterator.next();
            Intrinsics.checkNotNullExpressionValue(set, (String)"next(...)");
            Pair attachment = (Pair)set;
            Outliner.getInstance().showLine((Object)("attachment" + count), VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)attachment.getFirst())), VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)attachment.getSecond()))).lineWidth(0.1f).colored(0xFF55FF);
            ++count;
        }
    }

    public final void render(@NotNull PoseStack ms, @NotNull SuperRenderTypeBuffer buffer, @NotNull Vec3 camera, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        ClientLevel clientLevel = this.client.f_91073_;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        LocalPlayer localPlayer = this.client.f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (this.isWelding && this.weldingShip != null) {
            ms.m_85836_();
            MultiPlayerGameMode multiPlayerGameMode = this.client.f_91072_;
            double range = multiPlayerGameMode != null ? (double)multiPlayerGameMode.m_105286_() + 1.0 : 5.0;
            Vec3 traceOrigin = player.m_146892_();
            Vec3 traceTarget = RaycastHelper.getTraceTarget((Player)((Player)player), (double)range, (Vec3)traceOrigin);
            ClipContext clipContext = new ClipContext(traceOrigin, traceTarget, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            Level level2 = (Level)level;
            Long l = this.weldingShip;
            Intrinsics.checkNotNull((Object)l);
            BlockHitResult hit = RaycastUtilsKt.clipIncludeShips$default((Level)level2, (ClipContext)clipContext, (boolean)true, (Long)l, (boolean)false, (int)8, null);
            BlockPos blockPos = hit.m_82425_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos)).add(0.5, 0.5, 0.5);
            Vec3i vec3i = hit.m_82434_().m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
            Vector3d vector3d2 = vector3d.add((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i).mul(0.5));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"add(...)");
            Vec3 rawTargetPos = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d2));
            Vec3 targetPos = this.lastTargetPos.m_165921_(rawTargetPos, (double)partialTicks * 2.0);
            Quaternionf targetRotation = new Quaternionf();
            targetRotation.mul((Quaternionfc)hit.m_82434_().m_253075_());
            Direction direction = this.selectionDir;
            Intrinsics.checkNotNull((Object)direction);
            targetRotation.mul((Quaternionfc)direction.m_253075_());
            targetRotation.normalize();
            ms.m_252781_(targetRotation);
            Iterator<BlockPos> iterator = this.weld.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<BlockPos> iterator2 = iterator;
            while (iterator2.hasNext()) {
                BlockPos blockPos2;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                BlockState blockState = level.m_8055_(blockPos2);
                if (blockState.m_60795_()) continue;
                Vector3d vector3d3 = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos2));
                BlockPos blockPos3 = this.selectionPos;
                Intrinsics.checkNotNull((Object)blockPos3);
                Vector3d vector3d4 = vector3d3.sub((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos3)));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"sub(...)");
                Vec3 offset = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d4));
                Vec3 targetRenderPos = targetPos.m_82549_(offset);
                ms.m_85837_(targetRenderPos.f_82479_ - camera.f_82479_, targetRenderPos.f_82480_ - camera.f_82480_, targetRenderPos.f_82481_ - camera.f_82481_);
                BlockRenderDispatcher blockRenderDispatcher = this.client.m_91289_();
                blockRenderDispatcher.m_110937_().m_234379_((BlockAndTintGetter)level, blockRenderDispatcher.m_110910_(blockState), blockState, blockPos2, ms, buffer.m_6299_(ItemBlockRenderTypes.m_109293_((BlockState)blockState)), true, level.f_46441_, blockState.m_60726_(blockPos2), OverlayTexture.f_118083_);
                ms.m_85837_(-(targetRenderPos.f_82479_ - camera.f_82479_), -(targetRenderPos.f_82480_ - camera.f_82480_), -(targetRenderPos.f_82481_ - camera.f_82481_));
            }
            this.lastTargetPos = targetPos;
            ms.m_85849_();
        } else {
            ToolType tool = SharedValues.getWanderwandHandler().getCurrentTool();
            if (tool != ToolType.SELECT && tool != ToolType.DESELECT) {
                return;
            }
            IWanderwandTool iWanderwandTool = tool.getTool();
            Intrinsics.checkNotNull((Object)iWanderwandTool, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.tool.SelectionToolBase");
            SelectionToolBase selectionTool = (SelectionToolBase)iWanderwandTool;
            LocalPlayer localPlayer2 = Minecraft.m_91087_().f_91074_;
            if (localPlayer2 == null) {
                return;
            }
            LocalPlayer player2 = localPlayer2;
            ItemStack itemStack = player2.m_21205_();
            if (!(itemStack.m_41720_() instanceof WanderwandItem)) {
                Outliner.getInstance().remove((Object)"wandSelectionBox");
                return;
            }
            Item item = itemStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandItem");
            WanderwandItem wand = (WanderwandItem)item;
            Vec3 origin = player2.m_146892_();
            Vec3 target = RaycastHelper.getTraceTarget((Player)((Player)player2), (double)15.0, (Vec3)origin);
            BlockHitResult blockHitResult = level.m_45547_(new ClipContext(origin, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player2));
            if (blockHitResult == null) {
                return;
            }
            BlockHitResult trace = blockHitResult;
            BlockPos resultPos = trace.m_6662_() == HitResult.Type.BLOCK ? trace.m_82425_() : BlockPos.m_274446_((Position)((Position)RaycastHelper.getTraceTarget((Player)((Player)player2), (double)4.0, (Vec3)origin)));
            AABB aabb = null;
            if (selectionTool.getClickedPos() == null) {
                aabb = new AABB(resultPos);
            } else {
                BlockPos blockPos = selectionTool.getClickedPos();
                Intrinsics.checkNotNull((Object)blockPos);
                double minX = Math.min(blockPos.m_123341_(), resultPos.m_123341_());
                BlockPos blockPos4 = selectionTool.getClickedPos();
                Intrinsics.checkNotNull((Object)blockPos4);
                double minY = Math.min(blockPos4.m_123342_(), resultPos.m_123342_());
                BlockPos blockPos5 = selectionTool.getClickedPos();
                Intrinsics.checkNotNull((Object)blockPos5);
                double minZ = Math.min(blockPos5.m_123343_(), resultPos.m_123343_());
                BlockPos blockPos6 = selectionTool.getClickedPos();
                Intrinsics.checkNotNull((Object)blockPos6);
                double maxX = (double)Math.max(blockPos6.m_123341_(), resultPos.m_123341_()) + 1.0;
                BlockPos blockPos7 = selectionTool.getClickedPos();
                Intrinsics.checkNotNull((Object)blockPos7);
                double maxY = (double)Math.max(blockPos7.m_123342_(), resultPos.m_123342_()) + 1.0;
                BlockPos blockPos8 = selectionTool.getClickedPos();
                Intrinsics.checkNotNull((Object)blockPos8);
                double maxZ = (double)Math.max(blockPos8.m_123343_(), resultPos.m_123343_()) + 1.0;
                aabb = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
            }
            int color = tool == ToolType.SELECT ? 0xFF5FFF : 11737938;
            Outliner.getInstance().showAABB((Object)"wandSelectionBox", aabb).colored(color).lineWidth(0.05f);
        }
    }

    private final void updateClusters(CompoundTag tag) {
        this.clusters.clear();
        ArrayList<AABBic> deserialized = WanderwandItem.Companion.readAABBSetFromNBT(tag);
        ClientLevel clientLevel = this.client.f_91073_;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        this.clusters.addAll((Collection<Set<BlockPos>>)WanderwandItem.Companion.findIsolatedComponents((List<? extends AABBic>)deserialized, (Level)level));
    }

    private final void startWelding(BlockPos selPos, Direction selDir, CompoundTag blocks, long shipId) {
        this.isWelding = true;
        this.selectionPos = selPos;
        this.selectionDir = selDir;
        this.weld.clear();
        HashSet<BlockPos> deserialized = WanderwandItem.Companion.readBlockPosSetFromNBT(blocks);
        this.weld.addAll((Collection<BlockPos>)deserialized);
        this.weldingShip = shipId;
    }

    private final void stopWelding() {
        this.isWelding = false;
        this.selectionPos = null;
        this.selectionDir = null;
        this.weld.clear();
        this.weldingShip = null;
    }

    public final void handlePacket(@NotNull WanderwandRenderUpdatePacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (packet.getTool() == ToolType.SELECT || packet.getTool() == ToolType.DESELECT) {
            if (packet.getBlocks() != null) {
                this.updateClusters(packet.getBlocks());
            }
        } else if (packet.getTool() == ToolType.WELD) {
            if (packet.getBlocks() != null && packet.getOnOff()) {
                BlockPos blockPos = packet.getSelectionPos();
                Direction direction = packet.getSelectionDir();
                Intrinsics.checkNotNull((Object)direction);
                CompoundTag compoundTag = packet.getBlocks();
                Long l = packet.getShipId();
                Intrinsics.checkNotNull((Object)l);
                this.startWelding(blockPos, direction, compoundTag, l);
            } else {
                this.stopWelding();
            }
        } else if (packet.getTool() == ToolType.ATTACH) {
            if (packet.getOnOff()) {
                Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)packet.getSelectionPos()));
                BlockPos blockPos = packet.getSecondPos();
                Intrinsics.checkNotNull((Object)blockPos);
                v6 = this.attachments.add((Pair<Vector3d, Vector3d>)new Pair((Object)vector3d, (Object)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos))));
            } else {
                v6 = this.attachments.removeIf(arg_0 -> WanderwandEffectRenderer.handlePacket$lambda$1(arg_0 -> WanderwandEffectRenderer.handlePacket$lambda$0(packet, arg_0), arg_0));
            }
        }
    }

    private static final boolean handlePacket$lambda$0(WanderwandRenderUpdatePacket $packet, Pair it) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return Intrinsics.areEqual((Object)it.getFirst(), (Object)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)$packet.getSelectionPos())));
    }

    private static final boolean handlePacket$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

