/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.aeronaut;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.curiosities.aeronaut.AeronautGogglesRenderer;
import org.valkyrienskies.clockwork.content.curiosities.aeronaut.AeronautGogglesState;
import org.valkyrienskies.clockwork.content.curiosities.aeronaut.IAeronautEquipment;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.internal.world.VsiClientShipWorld;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001b*\b\b\u0000\u0010\u0002*\u00020\u0001*\u0010\b\u0001\u0010\u0004*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00032\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005:\u0001\u001bB\u001d\u0012\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ_\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/aeronaut/AeronautArmorLayer;", "Lnet/minecraft/world/entity/LivingEntity;", "T", "Lnet/minecraft/client/model/EntityModel;", "M", "Lnet/minecraft/client/renderer/entity/layers/RenderLayer;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "entity", "", "limbSwing", "limbSwingAmount", "partialTick", "ageInTicks", "netHeadYaw", "headPitch", "", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V", "Lnet/minecraft/client/renderer/entity/RenderLayerParent;", "renderer", "<init>", "(Lnet/minecraft/client/renderer/entity/RenderLayerParent;)V", "Companion", "clockwork"})
public class AeronautArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AeronautArmorLayer(@Nullable RenderLayerParent<T, M> renderer) {
        RenderLayerParent<T, M> renderLayerParent = renderer;
        Intrinsics.checkNotNull(renderLayerParent);
        super(renderLayerParent);
    }

    public void render(@NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        if (!IAeronautEquipment.Companion.isWearingAnyAeronaut((LivingEntity)entity)) {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        RenderType renderType = Sheets.m_110790_();
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        LocalPlayer player = localPlayer;
        float partialTicks = AnimationTickHolder.getPartialTicks();
        AeronautGogglesState goggleState = AeronautGogglesState.Companion.getState((Player)player);
        float maxFlapAngle = (float)Math.toRadians(75.0);
        Long l = ((IEntityDraggingInformationProvider)player).getDraggingInformation().getLastShipStoodOn();
        if (l == null) {
            Ship ship = ValkyrienSkies.api().getShipMountedTo((Entity)player);
            l = ship != null ? Long.valueOf(ship.getId()) : null;
            if (l == null) {
                Ship ship2 = ValkyrienSkies.getShipManagingEntity((Entity)((Entity)player));
                l = ship2 != null ? Long.valueOf(ship2.getId()) : null;
            }
        }
        Long shipOn = l;
        Vec3 vec3 = ((Entity)player).m_20184_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getDeltaMovement(...)");
        Vector3d velocity = ValkyrienSkies.toJOML((Vec3)vec3).mul(20.0);
        if (shipOn != null) {
            VsiClientShipWorld vsiClientShipWorld = VSGameUtilsKt.getShipObjectWorld((ClientLevel)player.f_108545_);
            Intrinsics.checkNotNull((Object)vsiClientShipWorld);
            ClientShip ship = (ClientShip)vsiClientShipWorld.getLoadedShips().getById(shipOn.longValue());
            if (ship != null) {
                Vec3 vec32 = player.m_20182_();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
                Vector3d playerPosInShip = ValkyrienSkies.toJOML((Vec3)vec32).sub(ship.getRenderTransform().getPositionInWorld());
                Vector3d velAtPlayerPos = ship.getAngularVelocity().cross((Vector3dc)playerPosInShip, new Vector3d()).add(ship.getVelocity());
                velocity.set((Vector3dc)velAtPlayerPos);
            }
        }
        double speed = velocity.length();
        goggleState.setFlapAngle(-Math.min(maxFlapAngle, (float)speed / 200.0f * maxFlapAngle));
        if (IAeronautEquipment.Companion.wearingAeronautInSlot((LivingEntity)player, EquipmentSlot.HEAD)) {
            ms.m_85836_();
            PartialModel hatBase = ClockworkPartials.INSTANCE.getHAT_BASE();
            BlockState air = Blocks.f_50016_.m_49966_();
            model.f_102808_.m_104299_(ms);
            hatBase.get().m_7442_().f_111791_.m_111763_(false, ms);
            Quaternionf quaternion = new Quaternionf();
            quaternion.setAngleAxis((float)Math.toRadians(180.0), 0.0f, 0.0f, 1.0f);
            ms.m_252781_(quaternion);
            ms.m_85837_(-0.325, 0.195, -0.325);
            ms.m_85836_();
            ms.m_85841_(0.65f, 0.65f, 0.65f);
            CachedBuffers.partial((PartialModel)hatBase, (BlockState)air).disableDiffuse().light(light).renderInto(ms, buffer.m_6299_(renderType));
            float flapAngle = goggleState.getFlapAngle();
            float prevFlapAngle = goggleState.getPrevFlapAngle();
            float interpolatedFlapAngle = prevFlapAngle + (flapAngle - prevFlapAngle) * partialTicks;
            goggleState.setPrevFlapAngle(interpolatedFlapAngle);
            ms.m_85836_();
            Vector3dc originLeft = AeronautGogglesRenderer.Companion.fromModelSpace(2.725, 10.0, 8.0);
            ms.m_85837_(0.0, 0.625, 0.0);
            ms.m_252781_(new Quaternionf().setAngleAxis(interpolatedFlapAngle, 0.0f, 0.0f, 1.0f));
            ms.m_85837_(0.0, -0.625, 0.0);
            PartialModel hatFlapLeft = ClockworkPartials.INSTANCE.getHAT_FLAP_LEFT();
            CachedBuffers.partial((PartialModel)hatFlapLeft, (BlockState)air).disableDiffuse().light(light).renderInto(ms, buffer.m_6299_(renderType));
            ms.m_85849_();
            ms.m_85836_();
            Vector3dc originRight = AeronautGogglesRenderer.Companion.fromModelSpace(13.275, 10.0, 8.0);
            ms.m_85837_(1.0, 0.625, 0.0);
            ms.m_252781_(new Quaternionf().setAngleAxis(interpolatedFlapAngle, 0.0f, 0.0f, -1.0f));
            ms.m_85837_(-1.0, -0.625, 0.0);
            PartialModel hatFlapRight = ClockworkPartials.INSTANCE.getHAT_FLAP_RIGHT();
            CachedBuffers.partial((PartialModel)hatFlapRight, (BlockState)air).disableDiffuse().light(light).renderInto(ms, buffer.m_6299_(renderType));
            ms.m_85849_();
            boolean wearingGoggles = AeronautGogglesState.Companion.getState((Player)player).getGogglesDown();
            ms.m_85836_();
            ms.m_85836_();
            if (!wearingGoggles) {
                ms.m_252781_(new Quaternionf().setAngleAxis((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f));
                ms.m_85837_(0.0, 0.1, -0.85);
            }
            PartialModel hatGoggles = ClockworkPartials.INSTANCE.getHAT_GOGGLES();
            CachedBuffers.partial((PartialModel)hatGoggles, (BlockState)air).disableDiffuse().light(light).renderInto(ms, buffer.m_6299_(renderType));
            ms.m_85849_();
            ms.m_85849_();
            ms.m_85849_();
            ms.m_85849_();
        }
    }

    @JvmStatic
    public static final void registerOn(@Nullable EntityRenderer<?> entityRenderer, @NotNull LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper helper) {
        Companion.registerOn(entityRenderer, helper);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0007\u001a\u00020\u00062\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/aeronaut/AeronautArmorLayer$Companion;", "", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "entityRenderer", "Lnet/fabricmc/fabric/api/client/rendering/v1/LivingEntityFeatureRendererRegistrationCallback$RegistrationHelper;", "helper", "", "registerOn", "(Lnet/minecraft/client/renderer/entity/EntityRenderer;Lnet/fabricmc/fabric/api/client/rendering/v1/LivingEntityFeatureRendererRegistrationCallback$RegistrationHelper;)V", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void registerOn(@Nullable EntityRenderer<?> entityRenderer, @NotNull LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper helper) {
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            if (!(entityRenderer instanceof LivingEntityRenderer)) {
                return;
            }
            if (!(((LivingEntityRenderer)entityRenderer).m_7200_() instanceof HumanoidModel)) {
                return;
            }
            AeronautArmorLayer layer = new AeronautArmorLayer((RenderLayerParent)entityRenderer);
            helper.register((RenderLayer)layer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

