/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.copter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.contraptions.propeller.copter.CopterBearingBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJO\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019JG\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u0014\u0010 \u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001eR\u0014\u0010\"\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001eR\u0014\u0010#\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\u001eR\u0016\u0010$\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/copter/CopterBearingRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/copter/CopterBearingBlockEntity;", "blockEntity", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/copter/CopterBearingBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/world/phys/Vec3;", "normal", "Lorg/joml/Quaternionf;", "tiltQuaternion", "Lnet/minecraft/core/Direction;", "facing", "renderTop", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/copter/CopterBearingBlockEntity;Lnet/minecraft/world/phys/Vec3;Lorg/joml/Quaternionf;Lnet/minecraft/core/Direction;FI)V", "renderPistons", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/copter/CopterBearingBlockEntity;I)V", "renderWafer", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/copter/CopterBearingBlockEntity;Lnet/minecraft/world/phys/Vec3;Lorg/joml/Quaternionf;Lnet/minecraft/core/Direction;I)V", "Ldev/engine_room/flywheel/lib/model/baked/PartialModel;", "pistonNW", "Ldev/engine_room/flywheel/lib/model/baked/PartialModel;", "pistonNE", "pistonSW", "pistonSE", "top", "wafer", "prevRotationQuat", "Lorg/joml/Quaternionf;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class CopterBearingRenderer
extends KineticBlockEntityRenderer<CopterBearingBlockEntity> {
    @NotNull
    private final PartialModel pistonNW;
    @NotNull
    private final PartialModel pistonNE;
    @NotNull
    private final PartialModel pistonSW;
    @NotNull
    private final PartialModel pistonSE;
    @NotNull
    private final PartialModel top;
    @NotNull
    private final PartialModel wafer;
    @NotNull
    private Quaternionf prevRotationQuat;

    public CopterBearingRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.pistonNW = ClockworkPartials.INSTANCE.getSMART_PROP_PISTON_NW();
        this.pistonNE = ClockworkPartials.INSTANCE.getSMART_PROP_PISTON_NE();
        this.pistonSW = ClockworkPartials.INSTANCE.getSMART_PROP_PISTON_SW();
        this.pistonSE = ClockworkPartials.INSTANCE.getSMART_PROP_PISTON_SE();
        this.top = ClockworkPartials.INSTANCE.getSMART_PROP_TOP();
        this.wafer = ClockworkPartials.INSTANCE.getSMART_PROP_WAFER();
        this.prevRotationQuat = new Quaternionf();
    }

    protected void renderSafe(@NotNull CopterBearingBlockEntity blockEntity, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Comparable comparable = blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        Direction facing = (Direction)comparable;
        Vec3 normal = new Vec3((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_());
        blockEntity.setClientTiltQuat(blockEntity.getClientTiltQuat().slerp((Quaternionfc)blockEntity.getClientTargetTiltQuat(), partialTicks / 2.0f));
        this.renderPistons(ms, buffer, blockEntity, light);
        this.renderTop(ms, buffer, blockEntity, normal, blockEntity.getClientTiltQuat(), facing, partialTicks, light);
        this.renderWafer(ms, buffer, blockEntity, normal, blockEntity.getClientTiltQuat(), facing, light);
    }

    private final void renderTop(PoseStack ms, MultiBufferSource buffer, CopterBearingBlockEntity blockEntity, Vec3 normal, Quaternionf tiltQuaternion, Direction facing, float partialTicks, int light) {
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)this.top, (BlockState)blockEntity.m_58900_());
        superBuffer.translate(normal.m_82490_(0.1));
        superBuffer.rotateCentered((Quaternionfc)tiltQuaternion);
        superBuffer.translate(normal.m_82490_(-0.1));
        float interpolatedAngle = blockEntity.getInterpolatedAngle(partialTicks - 1.0f);
        KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)blockEntity, (Direction.Axis)facing.m_122434_(), (float)((float)((double)(interpolatedAngle / (float)180) * Math.PI)), (int)light);
        if (facing.m_122434_().m_122479_()) {
            superBuffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())), Direction.UP);
        }
        superBuffer.rotateCentered(AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)facing))), Direction.EAST);
        superBuffer.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    private final void renderPistons(PoseStack ms, MultiBufferSource buffer, CopterBearingBlockEntity blockEntity, int light) {
        SuperByteBuffer superByteBuffer = CachedBuffers.partial((PartialModel)this.pistonNW, (BlockState)blockEntity.m_58900_());
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partial(...)");
        SuperByteBuffer superBuffer = superByteBuffer;
        if (blockEntity.getFacing().m_122434_().m_122479_()) {
            superBuffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)blockEntity.getFacing().m_122424_())), Direction.UP);
        }
        superBuffer.rotateCentered(AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)blockEntity.getFacing()))), Direction.EAST);
        superBuffer.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        superBuffer = CachedBuffers.partial((PartialModel)this.pistonNE, (BlockState)blockEntity.m_58900_());
        if (blockEntity.getFacing().m_122434_().m_122479_()) {
            superBuffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)blockEntity.getFacing().m_122424_())), Direction.UP);
        }
        superBuffer.rotateCentered(AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)blockEntity.getFacing()))), Direction.EAST);
        superBuffer.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        superBuffer = CachedBuffers.partial((PartialModel)this.pistonSW, (BlockState)blockEntity.m_58900_());
        if (blockEntity.getFacing().m_122434_().m_122479_()) {
            superBuffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)blockEntity.getFacing().m_122424_())), Direction.UP);
        }
        superBuffer.rotateCentered(AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)blockEntity.getFacing()))), Direction.EAST);
        superBuffer.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        superBuffer = CachedBuffers.partial((PartialModel)this.pistonSE, (BlockState)blockEntity.m_58900_());
        if (blockEntity.getFacing().m_122434_().m_122479_()) {
            superBuffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)blockEntity.getFacing().m_122424_())), Direction.UP);
        }
        superBuffer.rotateCentered(AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)blockEntity.getFacing()))), Direction.EAST);
        superBuffer.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    private final void renderWafer(PoseStack ms, MultiBufferSource buffer, CopterBearingBlockEntity blockEntity, Vec3 normal, Quaternionf tiltQuaternion, Direction facing, int light) {
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)this.wafer, (BlockState)blockEntity.m_58900_());
        superBuffer.translate(normal.m_82490_(0.1));
        superBuffer.rotateCentered((Quaternionfc)tiltQuaternion);
        superBuffer.translate(normal.m_82490_(-0.1));
        if (facing.m_122434_().m_122479_()) {
            superBuffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())), Direction.UP);
        }
        superBuffer.rotateCentered(AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)facing))), Direction.EAST);
        superBuffer.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }
}

