/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.blades;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.contraptions.propeller.blades.BladeControllerBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0011\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SmartBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerBlockEntity;", "blockEntity", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBladeControllerRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BladeControllerRenderer.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerRenderer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,170:1\n126#2:171\n153#2,3:172\n*S KotlinDebug\n*F\n+ 1 BladeControllerRenderer.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerRenderer\n*L\n44#1:171\n44#1:172,3\n*E\n"})
public final class BladeControllerRenderer
extends SmartBlockEntityRenderer<BladeControllerBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BladeControllerRenderer(@Nullable BlockEntityRendererProvider.Context context) {
        super(context);
    }

    /*
     * WARNING - void declaration
     */
    protected void renderSafe(@NotNull BladeControllerBlockEntity blockEntity, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        List<ItemStack> blades = blockEntity.getAllBlades();
        float bladeAngle = blockEntity.getClientBladeAngle().getValue(partialTicks);
        BlockState blockState = blockEntity.m_58900_();
        Map<Integer, LerpedFloat> $this$map$iv = blockEntity.getClientBladeRotation();
        boolean $i$f$map = false;
        Map<Integer, LerpedFloat> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(((LerpedFloat)it.getValue()).getValue(partialTicks)));
        }
        List bladeRotations = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)blockState);
        org.valkyrienskies.clockwork.content.contraptions.propeller.blades.BladeControllerRenderer$Companion.renderShared$default(Companion, blades, bladeAngle, blockState, partialTicks, ms, buffer, light, bladeRotations, false, null, null, 1792, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b+\u0010,J{\u0010\u0018\u001a\u00020\u00172\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001f\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J}\u0010)\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b)\u0010*\u00a8\u0006-"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerRenderer$Companion;", "", "", "Lnet/minecraft/world/item/ItemStack;", "blades", "", "bladeAngle", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "bladeRotations", "", "contraption", "Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;", "contraptionMatrices", "Lnet/minecraft/world/level/BlockAndTintGetter;", "tintGetter", "", "renderShared", "(Ljava/util/List;FLnet/minecraft/world/level/block/state/BlockState;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILjava/util/List;ZLcom/simibubi/create/content/contraptions/render/ContraptionMatrices;Lnet/minecraft/world/level/BlockAndTintGetter;)V", "Lnet/createmod/catnip/render/SuperByteBuffer;", "Lnet/minecraft/world/phys/Vec3;", "pivot", "", "rotation", "rotateByPivot", "(Lnet/createmod/catnip/render/SuperByteBuffer;Lnet/minecraft/world/phys/Vec3;D)V", "bladeBase", "bladeExtension", "bladeTip", "bladeLength", "bladeRotation", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "Lnet/minecraft/core/Direction;", "facing", "renderBlade", "(Lnet/createmod/catnip/render/SuperByteBuffer;Lnet/createmod/catnip/render/SuperByteBuffer;Lnet/createmod/catnip/render/SuperByteBuffer;FFFLcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;ILnet/minecraft/core/Direction;ZLcom/simibubi/create/content/contraptions/render/ContraptionMatrices;Lnet/minecraft/world/level/BlockAndTintGetter;)V", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public final void renderShared(@NotNull List<ItemStack> blades, float bladeAngle, @NotNull BlockState blockState, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, @NotNull List<Float> bladeRotations, boolean contraption, @Nullable ContraptionMatrices contraptionMatrices, @Nullable BlockAndTintGetter tintGetter) {
            Intrinsics.checkNotNullParameter(blades, (String)"blades");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter(bladeRotations, (String)"bladeRotations");
            VertexConsumer renderBuffer = buffer.m_6299_(RenderType.m_110463_());
            Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
            PoseTransformStack msr = TransformStack.of((PoseStack)ms);
            int n = ((Collection)blades).size();
            for (int i = 0; i < n; ++i) {
                if (bladeRotations.size() - 1 < i) continue;
                float bladeRotation = ((Number)bladeRotations.get(i)).floatValue();
                CompoundTag compoundTag = blades.get(i).m_41783_();
                float bladeLength = compoundTag != null ? (float)compoundTag.m_128459_("BladeLength") : 1.0f;
                boolean wide = blades.get(i).m_150930_((Item)ClockworkItems.WIDE_PROPELLER_BLADE.get());
                PartialModel bladeBasePartial = wide ? ClockworkPartials.INSTANCE.getWIDEBLADE_BASE() : ClockworkPartials.INSTANCE.getBLADE_BASE();
                PartialModel bladeExtensionPartial = wide ? ClockworkPartials.INSTANCE.getWIDEBLADE_EXTENSION() : ClockworkPartials.INSTANCE.getBLADE_EXTENSION();
                PartialModel bladeTipPartial = wide ? ClockworkPartials.INSTANCE.getWIDEBLADE_TIP() : ClockworkPartials.INSTANCE.getBLADE_TIP();
                SuperByteBuffer bladeBase = CachedBuffers.partial((PartialModel)bladeBasePartial, (BlockState)blockState);
                SuperByteBuffer bladeExtension = CachedBuffers.partial((PartialModel)bladeExtensionPartial, (BlockState)blockState);
                SuperByteBuffer bladeTip = CachedBuffers.partial((PartialModel)bladeTipPartial, (BlockState)blockState);
                if (contraptionMatrices != null) {
                    bladeBase.transform(contraptionMatrices.getModel());
                    bladeExtension.transform(contraptionMatrices.getModel());
                    bladeTip.transform(contraptionMatrices.getModel());
                }
                Intrinsics.checkNotNull((Object)bladeBase);
                Intrinsics.checkNotNull((Object)bladeExtension);
                Intrinsics.checkNotNull((Object)bladeTip);
                Intrinsics.checkNotNull((Object)renderBuffer);
                Intrinsics.checkNotNull((Object)facing);
                this.renderBlade(bladeBase, bladeExtension, bladeTip, bladeAngle, bladeLength, bladeRotation, ms, renderBuffer, light, facing, contraption, contraptionMatrices, tintGetter);
            }
        }

        public static /* synthetic */ void renderShared$default(Companion companion, List list, float f, BlockState blockState, float f2, PoseStack poseStack, MultiBufferSource multiBufferSource, int n, List list2, boolean bl, ContraptionMatrices contraptionMatrices, BlockAndTintGetter blockAndTintGetter, int n2, Object object) {
            if ((n2 & 0x100) != 0) {
                bl = false;
            }
            if ((n2 & 0x200) != 0) {
                contraptionMatrices = null;
            }
            if ((n2 & 0x400) != 0) {
                blockAndTintGetter = null;
            }
            companion.renderShared(list, f, blockState, f2, poseStack, multiBufferSource, n, list2, bl, contraptionMatrices, blockAndTintGetter);
        }

        public final void rotateByPivot(@NotNull SuperByteBuffer buffer, @NotNull Vec3 pivot, double rotation) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
            buffer.translate(pivot);
            buffer.rotateZDegrees((float)rotation);
            buffer.translateBack(pivot);
        }

        public final void renderBlade(@NotNull SuperByteBuffer bladeBase, @NotNull SuperByteBuffer bladeExtension, @NotNull SuperByteBuffer bladeTip, float bladeAngle, float bladeLength, float bladeRotation, @NotNull PoseStack ms, @NotNull VertexConsumer buffer, int light, @NotNull Direction facing, boolean contraption, @Nullable ContraptionMatrices contraptionMatrices, @Nullable BlockAndTintGetter tintGetter) {
            Intrinsics.checkNotNullParameter((Object)bladeBase, (String)"bladeBase");
            Intrinsics.checkNotNullParameter((Object)bladeExtension, (String)"bladeExtension");
            Intrinsics.checkNotNullParameter((Object)bladeTip, (String)"bladeTip");
            Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
            ms.m_85836_();
            ms.m_85837_(0.0, 0.0, 0.0);
            Vec3 pivot = new Vec3(0.5, 0.5, 0.5);
            ms.m_85849_();
            ms.m_85836_();
            if (facing.m_122434_().m_122479_()) {
                bladeBase.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())), Direction.UP);
                bladeExtension.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())), Direction.UP);
                bladeTip.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())), Direction.UP);
            }
            bladeBase.light(light);
            bladeExtension.light(light);
            bladeTip.light(light);
            if (tintGetter != null && contraptionMatrices != null) {
                bladeBase.useLevelLight(tintGetter, contraptionMatrices.getWorld());
                bladeExtension.useLevelLight(tintGetter, contraptionMatrices.getWorld());
                bladeTip.useLevelLight(tintGetter, contraptionMatrices.getWorld());
            }
            bladeBase.rotateCentered(AngleHelper.rad((double)(-90.0 - (double)AngleHelper.verticalAngle((Direction)facing))), Direction.EAST);
            bladeExtension.rotateCentered(AngleHelper.rad((double)(-90.0 - (double)AngleHelper.verticalAngle((Direction)facing))), Direction.EAST);
            bladeTip.rotateCentered(AngleHelper.rad((double)(-90.0 - (double)AngleHelper.verticalAngle((Direction)facing))), Direction.EAST);
            bladeBase.rotateCentered((float)Math.toRadians(bladeRotation), Direction.UP);
            bladeExtension.rotateCentered((float)Math.toRadians(bladeRotation), Direction.UP);
            bladeTip.rotateCentered((float)Math.toRadians(bladeRotation), Direction.UP);
            this.rotateByPivot(bladeBase, pivot, bladeAngle);
            this.rotateByPivot(bladeExtension, pivot, bladeAngle);
            this.rotateByPivot(bladeTip, pivot, bladeAngle);
            ms.m_85849_();
            ms.m_85836_();
            bladeExtension.translate(0.0, 0.0, (double)(bladeLength - 1.0f) * 0.3);
            bladeTip.translate(0.0, 0.0, (double)(bladeLength - 1.0f) * 0.5);
            bladeExtension.scale(1.0f, 1.0f, bladeLength);
            bladeTip.translate(0.0, 0.0, -((double)bladeLength) + 1.0);
            ms.m_85849_();
            ms.m_85836_();
            bladeBase.translate(0.0, 0.0, -0.3);
            bladeExtension.translate(0.0, 0.0, -0.3);
            bladeTip.translate(0.0, 0.0, -0.3);
            ms.m_85849_();
            ms.m_85836_();
            bladeBase.renderInto(ms, buffer);
            bladeExtension.renderInto(ms, buffer);
            bladeTip.renderInto(ms, buffer);
            ms.m_85849_();
        }

        public static /* synthetic */ void renderBlade$default(Companion companion, SuperByteBuffer superByteBuffer, SuperByteBuffer superByteBuffer2, SuperByteBuffer superByteBuffer3, float f, float f2, float f3, PoseStack poseStack, VertexConsumer vertexConsumer, int n, Direction direction, boolean bl, ContraptionMatrices contraptionMatrices, BlockAndTintGetter blockAndTintGetter, int n2, Object object) {
            if ((n2 & 0x800) != 0) {
                contraptionMatrices = null;
            }
            if ((n2 & 0x1000) != 0) {
                blockAndTintGetter = null;
            }
            companion.renderBlade(superByteBuffer, superByteBuffer2, superByteBuffer3, f, f2, f3, poseStack, vertexConsumer, n, direction, bl, contraptionMatrices, blockAndTintGetter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

