/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.flap;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.contraptions.flap.FlapBearingBlock;
import org.valkyrienskies.clockwork.content.contraptions.flap.contraption.FlapContraption;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B/\u0012\f\u0010X\u001a\b\u0012\u0002\b\u0003\u0018\u00010W\u0012\u0006\u0010Y\u001a\u00020)\u0012\u0006\u0010[\u001a\u00020Z\u0012\b\b\u0002\u00104\u001a\u000203\u00a2\u0006\u0004\b\\\u0010]J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0006J\r\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0006J\u000f\u0010\u0016\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0006J\u000f\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0006J\u000f\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0006J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b%\u0010#J\u000f\u0010&\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b&\u0010\u0006J\u000f\u0010'\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b,\u0010(J\u0019\u0010.\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0011\u00101\u001a\u0004\u0018\u000100H\u0016\u00a2\u0006\u0004\b1\u00102R\u0017\u00104\u001a\u0002038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R$\u00109\u001a\u00020\t2\u0006\u00108\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b9\u0010(R\"\u0010;\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010:\u001a\u0004\b<\u0010(\"\u0004\b=\u0010>R$\u0010?\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010\u001cR$\u0010D\u001a\u0004\u0018\u0001008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u00102\"\u0004\bG\u0010HR\u001e\u0010K\u001a\n J*\u0004\u0018\u00010I0I8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u001c\u0010N\u001a\n J*\u0004\u0018\u00010M0M8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u0016\u0010P\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0016\u0010R\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010QR\u0011\u0010V\u001a\u00020S8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\u00a8\u0006^"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/flap/FlapBearingBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "Lcom/simibubi/create/content/contraptions/bearing/IBearingBlockEntity;", "Lcom/simibubi/create/content/contraptions/IDisplayAssemblyExceptions;", "", "tick", "()V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "Lnet/minecraft/core/Direction;", "getPowerDirection", "()Lnet/minecraft/core/Direction;", "", "getPower", "()I", "assemble", "disassemble", "applyRotations", "remove", "lazyTick", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "contraption", "attach", "(Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;)V", "", "partialTicks", "getInterpolatedAngle", "(F)F", "prevSpeed", "onSpeedChanged", "(F)V", "forcedAngle", "setAngle", "onStall", "isValid", "()Z", "Lnet/minecraft/core/BlockPos;", "getBlockPosition", "()Lnet/minecraft/core/BlockPos;", "isWoodenTop", "Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;", "isAttachedTo", "(Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;)Z", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastAssemblyException", "()Lcom/simibubi/create/content/contraptions/AssemblyException;", "", "maxSize", "J", "getMaxSize", "()J", "value", "isRunning", "Z", "assembleNextTick", "getAssembleNextTick", "setAssembleNextTick", "(Z)V", "movedContraption", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "getMovedContraption", "()Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "setMovedContraption", "lastException", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastException", "setLastException", "(Lcom/simibubi/create/content/contraptions/AssemblyException;)V", "Lnet/createmod/catnip/animation/LerpedFloat;", "kotlin.jvm.PlatformType", "bearingAngle", "Lnet/createmod/catnip/animation/LerpedFloat;", "Lnet/createmod/catnip/animation/LerpedFloat$Chaser;", "chaser", "Lnet/createmod/catnip/animation/LerpedFloat$Chaser;", "lastPower", "I", "currentPower", "", "getAngularSpeed", "()D", "angularSpeed", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;J)V", "clockwork"})
public class FlapBearingBlockEntity
extends KineticBlockEntity
implements IBearingBlockEntity,
IDisplayAssemblyExceptions {
    private final long maxSize;
    private boolean isRunning;
    private boolean assembleNextTick;
    @Nullable
    private ControlledContraptionEntity movedContraption;
    @Nullable
    private AssemblyException lastException;
    private LerpedFloat bearingAngle;
    private final LerpedFloat.Chaser chaser;
    private int lastPower;
    private int currentPower;

    public FlapBearingBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.maxSize = maxSize;
        this.bearingAngle = LerpedFloat.linear();
        this.chaser = LerpedFloat.Chaser.LINEAR;
    }

    public /* synthetic */ FlapBearingBlockEntity(BlockEntityType blockEntityType, BlockPos blockPos, BlockState blockState, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = 16L;
        }
        this(blockEntityType, blockPos, blockState, l);
    }

    public final long getMaxSize() {
        return this.maxSize;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean getAssembleNextTick() {
        return this.assembleNextTick;
    }

    public final void setAssembleNextTick(boolean bl) {
        this.assembleNextTick = bl;
    }

    @Nullable
    public final ControlledContraptionEntity getMovedContraption() {
        return this.movedContraption;
    }

    public final void setMovedContraption(@Nullable ControlledContraptionEntity controlledContraptionEntity) {
        this.movedContraption = controlledContraptionEntity;
    }

    @Nullable
    public final AssemblyException getLastException() {
        return this.lastException;
    }

    public final void setLastException(@Nullable AssemblyException assemblyException) {
        this.lastException = assemblyException;
    }

    public final double getAngularSpeed() {
        float speed = Math.abs(this.getSpeed() * (float)3 / 10.0f);
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            speed *= ServerSpeedProvider.get();
        }
        return speed;
    }

    public void tick() {
        super.tick();
        this.bearingAngle.tickChaser();
        if (this.isRunning) {
            this.applyRotations();
        }
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            return;
        }
        ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
        if (controlledContraptionEntity != null) {
            controlledContraptionEntity.m_8119_();
        }
        if (this.assembleNextTick) {
            this.assembleNextTick = false;
            this.assemble();
        }
        this.lastPower = this.currentPower;
        this.currentPower = this.getPower();
        this.bearingAngle.chase((double)this.currentPower * 22.5 / (double)15, this.getAngularSpeed(), this.chaser);
        if (this.lastPower != this.currentPower) {
            this.sendData();
        }
    }

    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.read(tag, clientPacket);
        this.bearingAngle.setValue((double)tag.m_128457_("BearingAngle"));
        this.bearingAngle.chase((double)tag.m_128457_("TargetAngle"), tag.m_128459_("AngularSpeed"), this.chaser);
        this.isRunning = tag.m_128471_("IsRunning");
        this.lastException = AssemblyException.read((CompoundTag)tag);
    }

    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.write(tag, clientPacket);
        tag.m_128350_("BearingAngle", this.bearingAngle.getValue());
        tag.m_128350_("TargetAngle", this.bearingAngle.getChaseTarget());
        tag.m_128379_("IsRunning", this.isRunning);
        tag.m_128347_("AngularSpeed", this.getAngularSpeed());
        AssemblyException.write((CompoundTag)tag, (AssemblyException)this.getLastAssemblyException());
    }

    private final Direction getPowerDirection() {
        Direction direction;
        if (!this.m_58900_().m_61138_((Property)DirectionalAxisKineticBlock.FACING) || !this.m_58900_().m_61138_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) {
            ClockworkMod.INSTANCE.getLOGGER().error("Flap bearing block lacks FACING or AXIS_ALONG_FIRST_COORDINATE. Did the blockstate build incorrectly?");
            return Direction.UP;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)DirectionalAxisKineticBlock.FACING);
        Boolean axisAlong = (Boolean)this.m_58900_().m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
        if (facing.m_122434_() == Direction.Axis.Y) {
            return axisAlong != false ? Direction.WEST : Direction.NORTH;
        }
        if (facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            Direction direction2 = facing.m_122427_();
            Intrinsics.checkNotNull((Object)direction2);
            direction = direction2;
        } else {
            Direction direction3 = facing.m_122428_();
            Intrinsics.checkNotNull((Object)direction3);
            direction = direction3;
        }
        return direction;
    }

    protected int getPower() {
        int power = 0;
        Direction powerDirection = this.getPowerDirection();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        power += level.m_277185_(this.m_58899_().m_121945_(powerDirection), powerDirection);
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        return power -= level2.m_277185_(this.m_58899_().m_121945_(powerDirection.m_122424_()), powerDirection.m_122424_());
    }

    public final void assemble() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!(level.m_8055_(this.f_58858_).m_60734_() instanceof FlapBearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        FlapContraption contraption = null;
        try {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            Intrinsics.checkNotNull((Object)direction);
            contraption = FlapContraption.Companion.assembleFlap(level2, blockPos, direction);
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (contraption == null) {
            return;
        }
        if (contraption.getBlocks().isEmpty()) {
            return;
        }
        if ((long)contraption.getBlocks().size() > this.maxSize && this.maxSize != -1L) {
            this.lastException = AssemblyException.structureTooLarge();
            this.sendData();
            return;
        }
        BlockPos anchor = this.f_58858_.m_121945_(direction);
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        ControlledContraptionEntity controlledContraptionEntity = this.movedContraption = ControlledContraptionEntity.create((Level)this.f_58857_, (IControlContraption)((IControlContraption)this), (Contraption)contraption);
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        ControlledContraptionEntity controlledContraptionEntity2 = this.movedContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
        controlledContraptionEntity2.setRotationAxis(direction.m_122434_());
        Level level3 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        ControlledContraptionEntity controlledContraptionEntity3 = this.movedContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity3);
        level3.m_7967_((Entity)controlledContraptionEntity3);
        this.isRunning = true;
        this.bearingAngle.setValue(0.0);
        this.sendData();
    }

    public final void disassemble() {
        if (!this.isRunning && this.movedContraption == null) {
            return;
        }
        this.bearingAngle.setValue(0.0);
        this.applyRotations();
        if (this.movedContraption != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            controlledContraptionEntity.disassemble();
        }
        this.movedContraption = null;
        this.isRunning = false;
        this.sendData();
    }

    protected final void applyRotations() {
        if (this.movedContraption == null) {
            return;
        }
        Direction.Axis axis = Direction.Axis.X;
        if (this.m_58900_().m_61138_((Property)BlockStateProperties.f_61372_)) {
            axis = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        }
        ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.setAngle(this.bearingAngle.getValue());
        ControlledContraptionEntity controlledContraptionEntity2 = this.movedContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
        controlledContraptionEntity2.setRotationAxis(axis);
    }

    public void remove() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null) {
            Level level = this.f_58857_;
            boolean bl = level != null ? !level.f_46443_ : false;
            if (bl) {
                this.sendData();
            }
        }
    }

    public void attach(@NotNull ControlledContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        if (!(contraption.getContraption() instanceof FlapContraption)) {
            return;
        }
        if (!this.m_58900_().m_61138_((Property)BearingBlock.FACING)) {
            return;
        }
        this.movedContraption = contraption;
        this.m_6596_();
        BlockPos anchor = this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING));
        ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.isRunning = true;
            this.sendData();
        }
    }

    public float getInterpolatedAngle(float partialTicks) {
        return this.bearingAngle.getValue(partialTicks);
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
    }

    public void setAngle(float forcedAngle) {
        this.bearingAngle.setValue((double)forcedAngle);
        this.bearingAngle.updateChaseTarget(forcedAngle);
    }

    public void onStall() {
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    @NotNull
    public BlockPos getBlockPosition() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return blockPos;
    }

    public boolean isWoodenTop() {
        return false;
    }

    public boolean isAttachedTo(@Nullable AbstractContraptionEntity contraption) {
        return Intrinsics.areEqual((Object)this.movedContraption, (Object)contraption);
    }

    @Nullable
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }
}

