/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.client.render.airpocket;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.primitives.AABBic;
import org.valkyrienskies.clockwork.ClockworkPackets;
import org.valkyrienskies.clockwork.client.render.airpocket.AirpocketSyncPacket;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.world.ShipWorld;
import org.valkyrienskies.core.api.world.connectivity.ConnectionStatus;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b4\u00105J7\u0010\u0007\u001a\u00020\u0005*\u00020\u00022\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010JE\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010%\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020 2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#H\u0007\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010'\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b'\u0010(R(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001f\u0010\u0012\u001a\n 0*\u0004\u0018\u00010/0/8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u00101\u001a\u0004\b2\u00103\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00066"}, d2={"Lorg/valkyrienskies/clockwork/client/render/airpocket/AirpocketRenderer;", "", "Lorg/joml/primitives/AABBic;", "Lkotlin/Function3;", "", "", "fn", "forEachBlock", "(Lorg/joml/primitives/AABBic;Lkotlin/jvm/functions/Function3;)V", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "", "Lnet/minecraft/core/BlockPos;", "getEveryNode", "(Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/ships/Ship;)Ljava/util/Set;", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "buffer", "Lorg/joml/Matrix4f;", "matrix", "Lorg/valkyrienskies/core/api/ships/ClientShip;", "Lorg/joml/Vector3d;", "a", "b", "c", "d", "drawQuad", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Matrix4f;Lorg/valkyrienskies/core/api/ships/ClientShip;Lorg/joml/Vector3d;Lorg/joml/Vector3d;Lorg/joml/Vector3d;Lorg/joml/Vector3d;)V", "pos", "renderCube", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Matrix4f;Lorg/valkyrienskies/core/api/ships/ClientShip;Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/client/multiplayer/ClientLevel;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lnet/minecraft/client/Camera;", "camera", "render", "(Lnet/minecraft/client/multiplayer/ClientLevel;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;)V", "tick", "(Lnet/minecraft/server/level/ServerLevel;)V", "Nodes", "Ljava/util/Set;", "getNodes", "()Ljava/util/Set;", "setNodes", "(Ljava/util/Set;)V", "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "kotlin.jvm.PlatformType", "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "getBuffer", "()Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nAirpocketRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AirpocketRenderer.kt\norg/valkyrienskies/clockwork/client/render/airpocket/AirpocketRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n58#1,8:149\n1863#2,2:157\n*S KotlinDebug\n*F\n+ 1 AirpocketRenderer.kt\norg/valkyrienskies/clockwork/client/render/airpocket/AirpocketRenderer\n*L\n71#1:149,8\n132#1:157,2\n*E\n"})
public final class AirpocketRenderer {
    @NotNull
    public static final AirpocketRenderer INSTANCE = new AirpocketRenderer();
    @NotNull
    private static Set<BlockPos> Nodes = new LinkedHashSet();
    private static final MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();

    private AirpocketRenderer() {
    }

    @NotNull
    public final Set<BlockPos> getNodes() {
        return Nodes;
    }

    public final void setNodes(@NotNull Set<BlockPos> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        Nodes = set;
    }

    public final MultiBufferSource.BufferSource getBuffer() {
        return buffer;
    }

    public final void forEachBlock(@NotNull AABBic $this$forEachBlock, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Unit> fn) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        boolean $i$f$forEachBlock = false;
        int x = $this$forEachBlock.minX();
        int n = $this$forEachBlock.maxX() - 1;
        if (x <= n) {
            while (true) {
                int n2;
                int y;
                if ((y = $this$forEachBlock.minY()) <= (n2 = $this$forEachBlock.maxY() - 1)) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = $this$forEachBlock.minZ()) <= (n3 = $this$forEachBlock.maxZ() - 1)) {
                            while (true) {
                                fn.invoke((Object)x, (Object)y, (Object)z);
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<BlockPos> getEveryNode(@NotNull ServerLevel level, @NotNull Ship ship) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Set nodes = new LinkedHashSet();
        AirpocketRenderer airpocketRenderer = INSTANCE;
        AABBic aABBic = ship.getShipAABB();
        Intrinsics.checkNotNull((Object)aABBic);
        AABBic $this$forEachBlock$iv = aABBic;
        boolean $i$f$forEachBlock = false;
        int x$iv = $this$forEachBlock$iv.minX();
        int n = $this$forEachBlock$iv.maxX() - 1;
        if (x$iv <= n) {
            while (true) {
                int n2;
                int y$iv;
                if ((y$iv = $this$forEachBlock$iv.minY()) <= (n2 = $this$forEachBlock$iv.maxY() - 1)) {
                    while (true) {
                        int n3;
                        int z$iv;
                        if ((z$iv = $this$forEachBlock$iv.minZ()) <= (n3 = $this$forEachBlock$iv.maxZ() - 1)) {
                            do {
                                void z;
                                void y;
                                int n4 = ++z$iv;
                                int n5 = y$iv;
                                int x = x$iv;
                                boolean bl = false;
                                if (VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).isIsolatedAir(x, (int)y, (int)z, ValkyrienSkies.getDimensionIdNonnull((Level)((Level)level))) != ConnectionStatus.DISCONNECTED) continue;
                                nodes.add(new BlockPos(x, (int)y, (int)z));
                            } while (z$iv != n3);
                        }
                        if (y$iv == n2) break;
                        ++y$iv;
                    }
                }
                if (x$iv == n) break;
                ++x$iv;
            }
        }
        return nodes;
    }

    public final void drawQuad(@NotNull VertexConsumer buffer, @NotNull Matrix4f matrix, @NotNull ClientShip ship, @NotNull Vector3d a, @NotNull Vector3d b, @NotNull Vector3d c, @NotNull Vector3d d) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Vector3d vector3d = ship.getRenderTransform().getShipToWorld().transformPosition((Vector3dc)a, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
        Vector3f sA = ValkyrienSkies.toMinecraft((Vector3dc)((Vector3dc)vector3d)).m_252839_();
        Vector3d vector3d2 = ship.getRenderTransform().getShipToWorld().transformPosition((Vector3dc)b, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transformPosition(...)");
        Vector3f sB = ValkyrienSkies.toMinecraft((Vector3dc)((Vector3dc)vector3d2)).m_252839_();
        Vector3d vector3d3 = ship.getRenderTransform().getShipToWorld().transformPosition((Vector3dc)c, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"transformPosition(...)");
        Vector3f sC = ValkyrienSkies.toMinecraft((Vector3dc)((Vector3dc)vector3d3)).m_252839_();
        Vector3d vector3d4 = ship.getRenderTransform().getShipToWorld().transformPosition((Vector3dc)d, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"transformPosition(...)");
        Vector3f sD = ValkyrienSkies.toMinecraft((Vector3dc)((Vector3dc)vector3d4)).m_252839_();
        buffer.m_252986_(matrix, sA.x, sA.y, sA.z).m_6122_(0, 255, 0, 10).m_5752_();
        buffer.m_252986_(matrix, sB.x, sB.y, sB.z).m_6122_(0, 255, 0, 10).m_5752_();
        buffer.m_252986_(matrix, sC.x, sC.y, sC.z).m_6122_(0, 255, 0, 10).m_5752_();
        buffer.m_252986_(matrix, sD.x, sD.y, sD.z).m_6122_(0, 255, 0, 10).m_5752_();
    }

    public final void renderCube(@NotNull VertexConsumer buffer, @NotNull Matrix4f matrix, @NotNull ClientShip ship, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Vector3d start = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos));
        Vector3d vector3d = start.add(0.0, 1.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        Vector3d vector3d2 = start.add(1.0, 1.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"add(...)");
        Vector3d vector3d3 = start.add(1.0, 0.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"add(...)");
        this.drawQuad(buffer, matrix, ship, start, vector3d, vector3d2, vector3d3);
        Vector3d vector3d4 = start.add(0.0, 1.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"add(...)");
        Vector3d vector3d5 = start.add(0.0, 1.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"add(...)");
        Vector3d vector3d6 = start.add(0.0, 0.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"add(...)");
        this.drawQuad(buffer, matrix, ship, start, vector3d4, vector3d5, vector3d6);
        Vector3d vector3d7 = start.add(1.0, 0.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"add(...)");
        Vector3d vector3d8 = start.add(1.0, 0.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d8, (String)"add(...)");
        Vector3d vector3d9 = start.add(0.0, 0.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d9, (String)"add(...)");
        this.drawQuad(buffer, matrix, ship, start, vector3d7, vector3d8, vector3d9);
        Vector3d vector3d10 = start.add(0.0, 1.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d10, (String)"add(...)");
        Vector3d vector3d11 = start.add(1.0, 1.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d11, (String)"add(...)");
        Vector3d vector3d12 = start.add(1.0, 1.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d12, (String)"add(...)");
        Vector3d vector3d13 = start.add(0.0, 1.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d13, (String)"add(...)");
        this.drawQuad(buffer, matrix, ship, vector3d10, vector3d11, vector3d12, vector3d13);
        Vector3d vector3d14 = start.add(0.0, 0.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d14, (String)"add(...)");
        Vector3d vector3d15 = start.add(0.0, 1.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d15, (String)"add(...)");
        Vector3d vector3d16 = start.add(1.0, 1.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d16, (String)"add(...)");
        Vector3d vector3d17 = start.add(1.0, 0.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d17, (String)"add(...)");
        this.drawQuad(buffer, matrix, ship, vector3d14, vector3d15, vector3d16, vector3d17);
        Vector3d vector3d18 = start.add(1.0, 0.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d18, (String)"add(...)");
        Vector3d vector3d19 = start.add(1.0, 1.0, 0.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d19, (String)"add(...)");
        Vector3d vector3d20 = start.add(1.0, 1.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d20, (String)"add(...)");
        Vector3d vector3d21 = start.add(1.0, 0.0, 1.0, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d21, (String)"add(...)");
        this.drawQuad(buffer, matrix, ship, vector3d18, vector3d19, vector3d20, vector3d21);
    }

    @JvmStatic
    public static final void render(@NotNull ClientLevel level, @NotNull PoseStack poseStack, @NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer waterBuffer = buffer.m_6299_(RenderType.m_269166_());
        for (BlockPos node : Nodes) {
            ClientShip ship;
            Ship ship2 = VSGameUtilsKt.getShipManagingPos((Level)((Level)level), (BlockPos)node);
            if ((ship2 instanceof ClientShip ? (ClientShip)ship2 : null) == null) continue;
            ship = ship;
            Intrinsics.checkNotNull((Object)waterBuffer);
            Intrinsics.checkNotNull((Object)matrix);
            INSTANCE.renderCube(waterBuffer, matrix, ship, node);
        }
        poseStack.m_85849_();
    }

    public final void tick(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List list = level.m_6907_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_(), player.m_20189_());
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider");
            EntityDraggingInformation dragInfo = ((IEntityDraggingInformationProvider)player).getDraggingInformation();
            if (!dragInfo.isEntityBeingDraggedByAShip()) continue;
            ShipWorld shipWorld = ValkyrienSkies.getShipWorld((Level)((Level)level));
            Intrinsics.checkNotNull((Object)shipWorld);
            QueryableShipData queryableShipData = shipWorld.getLoadedShips();
            Long l = dragInfo.getLastShipStoodOn();
            Intrinsics.checkNotNull((Object)l);
            LoadedShip shipData = (LoadedShip)queryableShipData.getById(l.longValue());
            if (shipData == null) continue;
            Set<BlockPos> nodes = AirpocketRenderer.getEveryNode(level, (Ship)shipData);
            ClockworkPackets.Companion.sendToServer(new AirpocketSyncPacket(nodes));
        }
    }
}

