/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import edn.stratodonut.trackwork.client.TrackworkPartialModels;
import edn.stratodonut.trackwork.tracks.blocks.OleoWheelBlock;
import edn.stratodonut.trackwork.tracks.blocks.OleoWheelBlockEntity;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OleoWheelRenderer
extends SafeBlockEntityRenderer<OleoWheelBlockEntity> {
    public OleoWheelRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(OleoWheelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        boolean springFlip;
        BlockState state = be.m_58900_();
        float angleForBE = be.getFreeWheelAngle(partialTicks);
        Direction trackDir = (Direction)state.m_61143_(OleoWheelBlock.AXLE_FACING);
        float axisMult = trackDir.m_122434_() == Direction.Axis.X ? 1.0f : -1.0f;
        float horizontalOffset = be.getPointHorizontalOffset();
        float axialOffset = be.getPointAxialOffset();
        boolean bl = springFlip = trackDir.m_122421_() == Direction.AxisDirection.NEGATIVE;
        if (!springFlip) {
            angleForBE *= -1.0f;
        } else {
            horizontalOffset *= -1.0f;
            axialOffset *= -1.0f;
        }
        float wheelTravel = be.getWheelTravel(partialTicks) - be.getWheelRadius();
        Vector3f strutDir = ((Direction)state.m_61143_(OleoWheelBlock.STRUT_FACING)).m_253071_().negate();
        Vector3f axleDir = ((Direction)state.m_61143_(OleoWheelBlock.AXLE_FACING)).m_253071_();
        Vector3f crossDir = strutDir.cross((Vector3fc)axleDir, new Vector3f());
        Quaternionf quat = new Quaternionf().setFromNormalized((Matrix3fc)new Matrix3f((Vector3fc)crossDir, (Vector3fc)strutDir, (Vector3fc)axleDir)).normalize();
        OleoWheelBlock.VisualVariant v = (OleoWheelBlock.VisualVariant)((Object)state.m_61143_(OleoWheelBlock.VISUAL_VARIANT));
        float strutOffset = 0.0f;
        if (v == OleoWheelBlock.VisualVariant.single) {
            strutOffset = 0.375f;
        }
        SuperByteBuffer strut_upper = CachedBuffers.partial((PartialModel)TrackworkPartialModels.OLEO_STRUT_UPPER, (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)strut_upper.center()).rotate((Quaternionfc)quat)).translate(horizontalOffset * -axisMult, 0.0f, axialOffset + strutOffset)).uncenter();
        strut_upper.light(light).renderInto(ms, bufferSource.m_6299_(RenderType.m_110463_()));
        SuperByteBuffer strut_lower = CachedBuffers.partial((PartialModel)TrackworkPartialModels.OLEO_STRUT_LOWER, (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)strut_lower.center()).rotate((Quaternionfc)quat)).translate((double)(horizontalOffset * -axisMult), (double)(-wheelTravel) - 0.5 + 0.5, (double)(axialOffset + strutOffset))).uncenter();
        strut_lower.light(light).renderInto(ms, bufferSource.m_6299_(RenderType.m_110463_()));
        SuperByteBuffer wheels = CachedBuffers.partial((PartialModel)(v == OleoWheelBlock.VisualVariant.single ? TrackworkPartialModels.OLEO_WHEEL_SINGLE : TrackworkPartialModels.OLEO_WHEEL_TWIN), (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wheels.center()).rotate((Quaternionfc)quat)).translate((double)(horizontalOffset * -axisMult), (double)(-wheelTravel) - 0.5, (double)axialOffset)).rotateYDegrees(be.getSteeringValue() * 30.0f)).rotateZDegrees(-angleForBE)).uncenter();
        wheels.light(light).renderInto(ms, bufferSource.m_6299_(RenderType.m_110463_()));
    }
}

