/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import edn.stratodonut.trackwork.TrackworkUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.util.PhysTickOnly;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PhysTrackData {
    public final Long blockPos;
    public final Direction.Axis wheelAxis;
    public final float horizontalOffset;
    public final double wheelRadius;
    public final boolean inWater;
    @Nullable
    @PhysTickOnly
    public Vector3dc lastSuspensionForce;
    public final double effectiveSuspensionTravel;
    public final float trackRPM;
    @Deprecated
    public final Vector3dc trackOriginPosition;
    public float trackSU;

    private PhysTrackData() {
        this(BlockPos.f_121853_);
    }

    private PhysTrackData(BlockPos trackPos) {
        this.trackOriginPosition = new Vector3d();
        this.lastSuspensionForce = new Vector3d();
        this.blockPos = trackPos.m_121878_();
        this.wheelAxis = Direction.Axis.X;
        this.horizontalOffset = 0.0f;
        this.effectiveSuspensionTravel = 0.0;
        this.wheelRadius = 0.0;
        this.inWater = false;
        this.trackRPM = 0.0f;
    }

    public PhysTrackData(Vector3dc lastSuspensionForce, BlockPos pos, Direction.Axis wheelAxis, float horizontalOffset, double effectiveSuspensionTravel, double wheelRadius, boolean inWater, float trackRPM) {
        this.lastSuspensionForce = lastSuspensionForce;
        this.trackOriginPosition = new Vector3d();
        this.blockPos = pos.m_121878_();
        this.wheelAxis = wheelAxis;
        this.horizontalOffset = horizontalOffset;
        this.effectiveSuspensionTravel = effectiveSuspensionTravel;
        this.wheelRadius = wheelRadius;
        this.inWater = inWater;
        this.trackRPM = trackRPM;
    }

    public final PhysTrackData updateWith(PhysTrackUpdateData update) {
        if (!this.trackOriginPosition.equals(TrackworkUtil.ZERO)) {
            return new PhysTrackData(this.lastSuspensionForce, BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)this.trackOriginPosition)), update.wheelAxis, update.horizontalOffset, update.effectiveSuspensionTravel, update.wheelRadius, update.inWater, update.trackRPM);
        }
        return new PhysTrackData(this.lastSuspensionForce, BlockPos.m_122022_((long)this.blockPos), update.wheelAxis, update.horizontalOffset, update.effectiveSuspensionTravel, update.wheelRadius, update.inWater, update.trackRPM);
    }

    public static PhysTrackData from(PhysTrackCreateData data) {
        return new PhysTrackData(data.blockPos);
    }

    public record PhysTrackUpdateData(Direction.Axis wheelAxis, float horizontalOffset, double effectiveSuspensionTravel, double wheelRadius, boolean inWater, float trackRPM) {
    }

    public record PhysTrackCreateData(BlockPos blockPos) {
    }
}

