/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import edn.stratodonut.trackwork.TrackBlockEntityTypes;
import edn.stratodonut.trackwork.tracks.blocks.OleoWheelBlockEntity;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class OleoWheelBlock
extends Block
implements IBE<OleoWheelBlockEntity>,
TransformableBlock,
IWrenchable {
    public static final Property<Direction> AXLE_FACING = EnumProperty.m_61587_((String)"axle_facing", Direction.class);
    public static final Property<Direction> STRUT_FACING = EnumProperty.m_61587_((String)"strut_facing", Direction.class);
    public static final Property<VisualVariant> VISUAL_VARIANT = EnumProperty.m_61587_((String)"variant", VisualVariant.class);
    @Nonnull
    private final Supplier<BlockEntityType<OleoWheelBlockEntity>> wbet;

    public OleoWheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.wbet = TrackBlockEntityTypes.OLEO_WHEEL;
    }

    public OleoWheelBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<OleoWheelBlockEntity>> wbet) {
        super(properties);
        this.wbet = wbet;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AXLE_FACING}).m_61104_(new Property[]{STRUT_FACING}).m_61104_(new Property[]{VISUAL_VARIANT}));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        VisualVariant old = (VisualVariant)((Object)state.m_61143_(VISUAL_VARIANT));
        VisualVariant newVariant = switch (old) {
            case VisualVariant.twin -> VisualVariant.single;
            case VisualVariant.single -> VisualVariant.twin;
            default -> VisualVariant.twin;
        };
        context.m_43725_().m_46597_(context.m_8083_(), (BlockState)state.m_61124_(VISUAL_VARIANT, (Comparable)((Object)newVariant)));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Player p = context.m_43723_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_(AXLE_FACING, (Comparable)(p != null && p.m_6047_() ? context.m_8125_().m_122424_() : context.m_8125_()))).m_61124_(STRUT_FACING, (Comparable)Direction.DOWN);
    }

    protected BlockState rotate(BlockState initialState, StructureTransform transform) {
        Direction initialAxle = (Direction)initialState.m_61143_(AXLE_FACING);
        Direction initialStrut = (Direction)initialState.m_61143_(STRUT_FACING);
        if (transform.rotationAxis == initialStrut.m_122434_()) {
            return (BlockState)initialState.m_61124_(AXLE_FACING, (Comparable)transform.rotateFacing(initialAxle));
        }
        return (BlockState)((BlockState)initialState.m_61124_(STRUT_FACING, (Comparable)transform.rotateFacing(initialStrut))).m_61124_(AXLE_FACING, (Comparable)transform.rotateFacing(initialAxle));
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        return this.rotate(this.m_6943_(state, transform.mirror), transform);
    }

    public Class<OleoWheelBlockEntity> getBlockEntityClass() {
        return OleoWheelBlockEntity.class;
    }

    public BlockEntityType<? extends OleoWheelBlockEntity> getBlockEntityType() {
        return this.wbet.get();
    }

    public static enum VisualVariant implements StringRepresentable
    {
        twin,
        single;


        public String m_7912_() {
            return this.name();
        }
    }
}

