/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.blocks;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import edn.stratodonut.trackwork.blocks.HornBlock;
import edn.stratodonut.trackwork.client.HornSoundInstance;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class HornBlockEntity
extends SmartBlockEntity {
    public static final int PITCH_RANGE = 8;
    protected int note = 0;
    protected int playOverrideTicks = 0;
    @OnlyIn(value=Dist.CLIENT)
    protected HornSoundInstance soundInstance;

    public HornBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        this.playOverrideTicks = Math.max(--this.playOverrideTicks, 0);
        if (!this.f_58857_.f_46443_) {
            return;
        }
        boolean powered = this.getPowered();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.tickSound(this.note, powered));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickSound(int note, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.kill();
                this.soundInstance = null;
            }
            return;
        }
        float pitch = (float)note * 0.2f;
        if (this.soundInstance == null || this.soundInstance.m_7801_() || this.soundInstance.getNote() != note) {
            this.soundInstance = new HornSoundInstance(note, this.m_58899_(), (Ship)VSGameUtilsKt.getLoadedShipManagingPos((Level)this.f_58857_, (Vec3i)this.m_58899_()));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickSound() {
        this.playOverrideTicks = 7;
        this.tickSound(this.note, true);
    }

    public void cycleNote() {
        ++this.note;
        this.note %= 8;
    }

    public boolean getPowered() {
        return this.playOverrideTicks > 0 || this.m_58900_().m_61145_((Property)HornBlock.POWERED).orElse(false) != false;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("Note", this.note);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("Note")) {
            this.note = Mth.m_14045_((int)tag.m_128451_("Note"), (int)0, (int)7);
        }
    }
}

