/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.Pose;
import org.valkyrienskies.physics_api.PoseVel;

public class PoseVelEncoder {
    public static final int RIGID_BODY_TRANSFORM_BYTES_SIZE = 104;
    public static final int RIGID_BODY_POSE_ONLY_BYTES_SIZE = 56;

    public static void encodePoseVelToByteBuf(@NotNull PoseVel poseVel, @NotNull ByteBuffer outputBuffer) {
        outputBuffer.putDouble(poseVel.getPos().x());
        outputBuffer.putDouble(poseVel.getPos().y());
        outputBuffer.putDouble(poseVel.getPos().z());
        outputBuffer.putDouble(poseVel.getRot().x());
        outputBuffer.putDouble(poseVel.getRot().y());
        outputBuffer.putDouble(poseVel.getRot().z());
        outputBuffer.putDouble(poseVel.getRot().w());
        outputBuffer.putDouble(poseVel.getVel().x());
        outputBuffer.putDouble(poseVel.getVel().y());
        outputBuffer.putDouble(poseVel.getVel().z());
        outputBuffer.putDouble(poseVel.getOmega().x());
        outputBuffer.putDouble(poseVel.getOmega().y());
        outputBuffer.putDouble(poseVel.getOmega().z());
    }

    @NotNull
    public static byte[] encodePoseVel(@NotNull PoseVel poseVel) {
        ByteBuffer outputBuffer = ByteBuffer.allocate(104);
        outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        PoseVelEncoder.encodePoseVelToByteBuf(poseVel, outputBuffer);
        return outputBuffer.array();
    }

    public static PoseVel decodePoseVelFromByteBuf(@NotNull ByteBuffer byteBuffer) {
        double posX = byteBuffer.getDouble();
        double posY = byteBuffer.getDouble();
        double posZ = byteBuffer.getDouble();
        double rotX = byteBuffer.getDouble();
        double rotY = byteBuffer.getDouble();
        double rotZ = byteBuffer.getDouble();
        double rotW = byteBuffer.getDouble();
        double velX = byteBuffer.getDouble();
        double velY = byteBuffer.getDouble();
        double velZ = byteBuffer.getDouble();
        double omegaX = byteBuffer.getDouble();
        double omegaY = byteBuffer.getDouble();
        double omegaZ = byteBuffer.getDouble();
        Vector3d pos = new Vector3d(posX, posY, posZ);
        Quaterniond rot = new Quaterniond(rotX, rotY, rotZ, rotW);
        Vector3d vel = new Vector3d(velX, velY, velZ);
        Vector3d omega = new Vector3d(omegaX, omegaY, omegaZ);
        return new PoseVel((Vector3dc)pos, (Quaterniondc)rot, (Vector3dc)vel, (Vector3dc)omega);
    }

    @NotNull
    public static PoseVel decodePoseVel(@NotNull byte[] encoded) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encoded);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return PoseVelEncoder.decodePoseVelFromByteBuf(byteBuffer);
    }

    public static void encodePoseToByteBuf(@NotNull Pose pose, @NotNull ByteBuffer outputBuffer) {
        outputBuffer.putDouble(pose.getPos().x());
        outputBuffer.putDouble(pose.getPos().y());
        outputBuffer.putDouble(pose.getPos().z());
        outputBuffer.putDouble(pose.getRot().x());
        outputBuffer.putDouble(pose.getRot().y());
        outputBuffer.putDouble(pose.getRot().z());
        outputBuffer.putDouble(pose.getRot().w());
    }

    @NotNull
    public static byte[] encodePose(@NotNull Pose pose) {
        ByteBuffer outputBuffer = ByteBuffer.allocate(56);
        outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        PoseVelEncoder.encodePoseToByteBuf(pose, outputBuffer);
        return outputBuffer.array();
    }

    public static Pose decodePoseFromByteBuf(@NotNull ByteBuffer byteBuffer) {
        double posX = byteBuffer.getDouble();
        double posY = byteBuffer.getDouble();
        double posZ = byteBuffer.getDouble();
        double rotX = byteBuffer.getDouble();
        double rotY = byteBuffer.getDouble();
        double rotZ = byteBuffer.getDouble();
        double rotW = byteBuffer.getDouble();
        Vector3d pos = new Vector3d(posX, posY, posZ);
        Quaterniond rot = new Quaterniond(rotX, rotY, rotZ, rotW);
        return new Pose((Vector3dc)pos, (Quaterniondc)rot);
    }

    @NotNull
    public static Pose decodePose(@NotNull byte[] encoded) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encoded);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return PoseVelEncoder.decodePoseFromByteBuf(byteBuffer);
    }
}

