/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.util.BlockWalker;

public final class AdvancedBlockWalker
implements Iterator<BlockPosWithDistance> {
    private final Vec3 from;
    private final Vec3 to;
    private final boolean reversed;
    private final boolean useFurtherestClip;
    private final double maxDist;
    private final ArrayList<BlockWalkerWithShip> walkers = new ArrayList();

    public AdvancedBlockWalker(Level level, Vec3 from, Vec3 to2, boolean reversed, boolean useFurtherestClip) {
        if (reversed) {
            Vec3 tmp = from;
            from = to2;
            to2 = tmp;
        }
        this.from = from = VSGameUtilsKt.toWorldCoordinates(level, from);
        this.to = to2 = VSGameUtilsKt.toWorldCoordinates(level, to2);
        this.reversed = reversed;
        this.useFurtherestClip = useFurtherestClip;
        this.maxDist = from.m_82554_(to2);
        BlockWalkerWithShip walker = new BlockWalkerWithShip(new BlockWalker(from, to2), null);
        if (walker.value() != null) {
            this.walkers.add(walker);
        }
        AABB worldBox = new AABB(from, to2);
        AABBd tmpBox = new AABBd();
        AABBd tmpBox2 = new AABBd();
        Vector3d fromVec = new Vector3d();
        Vector3d toVec = new Vector3d();
        Vector2d tmp2d = new Vector2d();
        Iterator iterator = VSGameUtilsKt.getAllShips(level).iterator();
        while (iterator.hasNext()) {
            BlockWalkerWithShip walker2;
            AABBic shipBox2;
            Ship ship = (Ship)iterator.next();
            AABBdc shipBox1 = ship.getWorldAABB();
            if (!tmpBox2.setMin(shipBox1.minX() - 1.0, shipBox1.minY() - 1.0, shipBox1.minZ() - 1.0).setMax(shipBox1.maxX() + 1.0, shipBox1.maxY() + 1.0, shipBox1.maxZ() + 1.0).intersectsAABB(tmpBox.setMin(worldBox.f_82288_, worldBox.f_82289_, worldBox.f_82290_).setMax(worldBox.f_82291_, worldBox.f_82292_, worldBox.f_82293_)) || (shipBox2 = ship.getShipAABB()) == null) continue;
            ship.getWorldToShip().transformPosition(fromVec.set(from.f_82479_, from.f_82480_, from.f_82481_));
            ship.getWorldToShip().transformPosition(toVec.set(to2.f_82479_, to2.f_82480_, to2.f_82481_));
            int intersectResult = tmpBox.setMin((double)(shipBox2.minX() - 1), (double)(shipBox2.minY() - 1), (double)(shipBox2.minZ() - 1)).setMax((double)(shipBox2.maxX() + 2), (double)(shipBox2.maxY() + 2), (double)(shipBox2.maxZ() + 2)).intersectsLineSegment(fromVec.x, fromVec.y, fromVec.z, toVec.x, toVec.y, toVec.z, tmp2d);
            if (intersectResult == -1 || (walker2 = new BlockWalkerWithShip(new BlockWalker(new Vec3(fromVec.x, fromVec.y, fromVec.z), new Vec3(toVec.x, toVec.y, toVec.z)), ship)).value() == null) continue;
            this.walkers.add(walker2);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.walkers.isEmpty();
    }

    @Override
    public BlockPosWithDistance next() {
        int size = this.walkers.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        BlockWalkerWithShip walker = this.walkers.get(0);
        int walkerIndex = 0;
        double dist = this.calcDistance(walker.value(), walker.ship());
        for (int i2 = 1; i2 < size; ++i2) {
            BlockWalkerWithShip w2 = this.walkers.get(i2);
            double d2 = this.calcDistance(w2.value(), w2.ship());
            if (!(d2 < dist)) continue;
            walker = w2;
            walkerIndex = i2;
            dist = d2;
        }
        BlockPos pos = walker.value().m_7949_();
        if (!walker.next()) {
            int lastIndex = size - 1;
            this.walkers.set(walkerIndex, this.walkers.get(lastIndex));
            this.walkers.remove(lastIndex);
        }
        double dist0 = Math.sqrt(dist);
        return new BlockPosWithDistance(pos, this.reversed ? Math.max(this.maxDist - dist0, 0.0) : Math.min(dist0, this.maxDist));
    }

    private double calcDistance(BlockPos pos, Ship ship) {
        AABB block = new AABB(pos).m_82400_(1.0E-7);
        Vec3 from = this.from;
        Vec3 to2 = this.to;
        if (this.reversed != this.useFurtherestClip) {
            Vec3 tmp = from;
            from = to2;
            to2 = tmp;
        }
        if (ship != null) {
            Vector3d fromVec = ship.getWorldToShip().transformPosition(new Vector3d(from.f_82479_, from.f_82480_, from.f_82481_));
            Vector3d toVec = ship.getWorldToShip().transformPosition(new Vector3d(to2.f_82479_, to2.f_82480_, to2.f_82481_));
            from = new Vec3(fromVec.x, fromVec.y, fromVec.z);
            to2 = new Vec3(toVec.x, toVec.y, toVec.z);
        }
        if (block.m_82390_(from)) {
            return this.reversed ? 0.0 : this.maxDist * this.maxDist;
        }
        Vec3 point = block.m_82371_(from, to2).orElse(null);
        if (point == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (ship != null) {
            Vector3d pointVec = ship.getShipToWorld().transformPosition(new Vector3d(point.f_82479_, point.f_82480_, point.f_82481_));
            point = new Vec3(pointVec.x, pointVec.y, pointVec.z);
        }
        return point.m_82557_(this.from);
    }

    private record BlockWalkerWithShip(BlockWalker walker, Ship ship) {
        BlockWalkerWithShip {
            if (walker.value() != null) {
                while (!BlockWalkerWithShip.withinShipBorder(ship, walker.value()) && walker.next()) {
                }
            }
        }

        private boolean withinBorder(BlockPos pos) {
            return BlockWalkerWithShip.withinShipBorder(this.ship, pos);
        }

        private static boolean withinShipBorder(Ship ship, BlockPos pos) {
            if (ship == null) {
                return true;
            }
            AABBic shipBox = ship.getShipAABB();
            if (shipBox == null) {
                return false;
            }
            int x2 = pos.m_123341_();
            int y2 = pos.m_123342_();
            int z2 = pos.m_123343_();
            return shipBox.minX() - 1 <= x2 && x2 < shipBox.maxX() + 2 && shipBox.minY() - 1 <= y2 && y2 < shipBox.maxY() + 2 && shipBox.minZ() - 1 <= z2 && z2 < shipBox.maxZ() + 2;
        }

        public BlockPos value() {
            return this.walker.value();
        }

        public boolean next() {
            while (this.walker.next()) {
                if (!this.withinBorder(this.value())) continue;
                return true;
            }
            return false;
        }
    }

    public record BlockPosWithDistance(BlockPos pos, double distance) {
    }
}

