/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.world.level.chunk;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.VS2ChunkAllocator;

@Mixin(value={ChunkGenerator.class})
public class MixinChunkGenerator {
    @Inject(method={"findNearestMapStructure"}, at={@At(value="HEAD")}, cancellable=true)
    private void preFindNearestMapFeature(ServerLevel serverLevel, HolderSet<Structure> holderSet, BlockPos blockPos, int i2, boolean bl2, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir) {
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"applyBiomeDecoration"}, at={@At(value="HEAD")}, cancellable=true)
    private void preApplyBiomeDecoration(WorldGenLevel worldGenLevel, ChunkAccess chunkAccess, StructureManager structureManager, CallbackInfo callbackInfo) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"createStructures"}, at={@At(value="HEAD")}, cancellable=true)
    private void preCreateStructures(RegistryAccess registryAccess, ChunkGeneratorStructureState chunkGeneratorStructureState, StructureManager structureManager, ChunkAccess chunkAccess, StructureTemplateManager structureTemplateManager, CallbackInfo callbackInfo) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"createReferences"}, at={@At(value="HEAD")}, cancellable=true)
    private void preCreateReferences(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkAccess chunkAccess, CallbackInfo callbackInfo) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            callbackInfo.cancel();
        }
    }
}

