/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.world;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Wing;
import org.valkyrienskies.core.api.ships.WingManager;
import org.valkyrienskies.core.internal.world.VsiServerShipWorld;
import org.valkyrienskies.core.internal.world.chunks.VsiTerrainUpdate;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.block.WingBlock;
import org.valkyrienskies.mod.common.config.DimensionParametersResolver;
import org.valkyrienskies.mod.common.util.DragInfoReporter;
import org.valkyrienskies.mod.common.util.VSServerLevel;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.accessors.server.level.ChunkMapAccessor;
import org.valkyrienskies.mod.mixin.accessors.server.level.DistanceManagerAccessor;
import org.valkyrienskies.mod.mixinducks.world.OfLevel;
import org.valkyrienskies.mod.util.McMathUtilKt;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
implements IShipObjectWorldServerProvider,
VSServerLevel {
    @Shadow
    @Final
    private ServerChunkCache f_8547_;
    @Unique
    private final Map<ChunkPos, List<Vector3ic>> vs$knownChunks = new HashMap<ChunkPos, List<Vector3ic>>();
    @Unique
    private final Long2LongOpenHashMap vs$chunksToUnload = new Long2LongOpenHashMap();
    @Unique
    private static final long VS$CHUNK_UNLOAD_THRESHOLD = 100L;

    @Shadow
    @NotNull
    public abstract MinecraftServer m_7654_();

    @Shadow
    public abstract int m_8828_(SectionPos var1);

    @Override
    @Nullable
    public VsiServerShipWorld getShipObjectWorld() {
        return ((IShipObjectWorldServerProvider)this.m_7654_()).getShipObjectWorld();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    void onInit(CallbackInfo ci2) {
        if (this.getShipObjectWorld() != null) {
            DimensionParametersResolver.Parameters params = DimensionParametersResolver.INSTANCE.getDimensionMap().get(VSGameUtilsKt.getDimensionId((Level)((ServerLevel)this)));
            if (params != null) {
                this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((Level)((ServerLevel)this)), VSGameUtilsKt.getYRange((Level)((ServerLevel)this)), params.getGravity(), params.getSeaLevel(), params.getMaxY());
                return;
            }
            this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((Level)((ServerLevel)this)), VSGameUtilsKt.getYRange((Level)((ServerLevel)this)), McMathUtilKt.getDEFAULT_WORLD_GRAVITY(), 62.0, 962.0);
        }
    }

    @Inject(method={"getPoiManager"}, at={@At(value="HEAD")})
    void onGetPoiManager(CallbackInfoReturnable<PoiManager> cir) {
        PoiManager poiManager = this.f_8547_.m_8484_();
        if (poiManager instanceof OfLevel) {
            OfLevel levelProvider = (OfLevel)poiManager;
            levelProvider.setLevel((Level)((ServerLevel)this));
        }
    }

    @Inject(method={"isCloseToVillage"}, at={@At(value="HEAD")}, cancellable=true)
    void preIsCloseToVillage(BlockPos blockPos, int i2, CallbackInfoReturnable<Boolean> cir) {
        if (i2 <= 6) {
            boolean[] found = new boolean[]{false};
            VSGameUtilsKt.transformToNearbyShipsAndWorld((Level)ServerLevel.class.cast(this), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (double)i2 * 100.0, (x2, y2, z2) -> {
                found[0] = found[0] || this.m_8828_(SectionPos.m_123199_((BlockPos)BlockPos.m_274561_((double)x2, (double)y2, (double)z2))) <= i2;
            });
            if (found[0]) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @WrapOperation(method={"sendParticles(Lnet/minecraft/server/level/ServerPlayer;ZDDDLnet/minecraft/network/protocol/Packet;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;closerToCenterThan(Lnet/minecraft/core/Position;D)Z")})
    private boolean includeShipsInParticleDistanceCheck(BlockPos player, Position particle, double distance, Operation<Boolean> closerToCenterThan) {
        ServerLevel self = (ServerLevel)ServerLevel.class.cast(this);
        LoadedServerShip ship = VSGameUtilsKt.getLoadedShipManagingPos(self, (int)particle.m_7096_() >> 4, (int)particle.m_7094_() >> 4);
        if (ship == null) {
            return (Boolean)closerToCenterThan.call(new Object[]{player, particle, distance});
        }
        Vector3d posInWorld = ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(particle));
        return posInWorld.distanceSquared((double)player.m_123341_(), (double)player.m_123342_(), (double)player.m_123343_()) < distance * distance;
    }

    @Unique
    private void vs$loadChunk(@NotNull ChunkAccess worldChunk, List<VsiTerrainUpdate> voxelShapeUpdates) {
        this.vs$chunksToUnload.remove(worldChunk.m_7697_().m_45588_());
        if (!this.vs$knownChunks.containsKey(worldChunk.m_7697_())) {
            ArrayList<Vector3i> voxelChunkPositions = new ArrayList<Vector3i>();
            int chunkX = worldChunk.m_7697_().f_45578_;
            int chunkZ = worldChunk.m_7697_().f_45579_;
            LevelChunkSection[] chunkSections = worldChunk.m_7103_();
            for (int sectionY = 0; sectionY < chunkSections.length; ++sectionY) {
                LevelChunkSection chunkSection = chunkSections[sectionY];
                Vector3i chunkPos = new Vector3i(chunkX, worldChunk.m_151568_(sectionY), chunkZ);
                voxelChunkPositions.add(chunkPos);
                if (chunkSection != null && !chunkSection.m_188008_()) {
                    VsiTerrainUpdate voxelShapeUpdate = VSGameUtilsKt.toDenseVoxelUpdate(chunkSection, (Vector3ic)chunkPos);
                    voxelShapeUpdates.add(voxelShapeUpdate);
                    ServerLevel thisAsLevel = (ServerLevel)ServerLevel.class.cast(this);
                    LoadedServerShip ship = VSGameUtilsKt.getLoadedShipManagingPos(thisAsLevel, chunkX, chunkZ);
                    if (ship == null) continue;
                    WingManager shipAsWingManager = ship.getWingManager();
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                    for (int x2 = 0; x2 < 16; ++x2) {
                        for (int y2 = 0; y2 < 16; ++y2) {
                            for (int z2 = 0; z2 < 16; ++z2) {
                                BlockState blockState = chunkSection.m_62982_(x2, y2, z2);
                                int posX = (chunkX << 4) + x2;
                                int posY = worldChunk.m_141937_() + (sectionY << 4) + y2;
                                int posZ = (chunkZ << 4) + z2;
                                if (!(blockState.m_60734_() instanceof WingBlock)) continue;
                                mutableBlockPos.m_122178_(posX, posY, posZ);
                                Wing wing = ((WingBlock)blockState.m_60734_()).getWing((Level)thisAsLevel, (BlockPos)mutableBlockPos, blockState);
                                if (wing == null) continue;
                                shipAsWingManager.setWing(shipAsWingManager.getFirstWingGroupId(), posX, posY, posZ, wing);
                            }
                        }
                    }
                    continue;
                }
                VsiTerrainUpdate emptyVoxelShapeUpdate = ValkyrienSkiesMod.getVsCore().newEmptyVoxelShapeUpdate(chunkPos.x(), chunkPos.y(), chunkPos.z(), true);
                voxelShapeUpdates.add(emptyVoxelShapeUpdate);
            }
            this.vs$knownChunks.put(worldChunk.m_7697_(), voxelChunkPositions);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void postTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci2) {
        ServerLevel self = (ServerLevel)ServerLevel.class.cast(this);
        VsiServerShipWorld shipObjectWorld = VSGameUtilsKt.getShipObjectWorld(self);
        ChunkMapAccessor chunkMapAccessor = (ChunkMapAccessor)this.f_8547_.f_8325_;
        ArrayList<VsiTerrainUpdate> voxelShapeUpdates = new ArrayList<VsiTerrainUpdate>();
        DistanceManagerAccessor distanceManagerAccessor = (DistanceManagerAccessor)this.f_8547_.f_8325_.m_143145_();
        for (ChunkHolder chunkHolder : chunkMapAccessor.callGetChunks()) {
            Optional worldChunkOptional;
            if (this.vs$knownChunks.containsKey(chunkHolder.m_140092_()) || !distanceManagerAccessor.getTickets().containsKey(chunkHolder.m_140092_().m_45588_()) || !(worldChunkOptional = chunkHolder.m_140026_().getNow(ChunkHolder.f_139997_).left()).isPresent()) continue;
            LevelChunk worldChunk = (LevelChunk)worldChunkOptional.get();
            this.vs$loadChunk((ChunkAccess)worldChunk, voxelShapeUpdates);
        }
        Iterator<Map.Entry<ChunkPos, List<Vector3ic>>> knownChunkPosIterator = this.vs$knownChunks.entrySet().iterator();
        while (knownChunkPosIterator.hasNext()) {
            Map.Entry<ChunkPos, List<Vector3ic>> knownChunkPosEntry = knownChunkPosIterator.next();
            long chunkPos = knownChunkPosEntry.getKey().m_45588_();
            if (distanceManagerAccessor.getTickets().containsKey(chunkPos) && chunkMapAccessor.callGetVisibleChunkIfPresent(chunkPos) != null) continue;
            long ticksWaitingToUnload = this.vs$chunksToUnload.getOrDefault(chunkPos, 0L);
            if (ticksWaitingToUnload > 100L) {
                for (Vector3ic unloadedChunk : knownChunkPosEntry.getValue()) {
                    VsiTerrainUpdate deleteVoxelShapeUpdate = ValkyrienSkiesMod.getVsCore().newDeleteTerrainUpdate(unloadedChunk.x(), unloadedChunk.y(), unloadedChunk.z());
                    voxelShapeUpdates.add(deleteVoxelShapeUpdate);
                }
                knownChunkPosIterator.remove();
                this.vs$chunksToUnload.remove(chunkPos);
                continue;
            }
            this.vs$chunksToUnload.put(chunkPos, ticksWaitingToUnload + 1L);
        }
        shipObjectWorld.addTerrainUpdates(VSGameUtilsKt.getDimensionId((Level)self), voxelShapeUpdates);
        if (ValkyrienSkiesMod.getVsCore().getHooks().getEnableSplitting()) {
            ValkyrienSkiesMod.splitHandler.tick((ServerLevel)ServerLevel.class.cast(this));
        }
        DragInfoReporter.INSTANCE.tick((ServerLevel)this);
    }

    @Override
    public void removeChunk(int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        this.vs$knownChunks.remove(chunkPos);
    }

    @Redirect(method={"tickChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;"))
    private Holder<Biome> adjustForWorldPosition(ServerLevel instance, BlockPos blockPos) {
        ServerLevel level = (ServerLevel)ServerLevel.class.cast(this);
        ServerShip ship = VSGameUtilsKt.getShipManagingPos(level, blockPos);
        if (ship != null) {
            Vector3d vPosWorld = ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOMLD((Vec3i)blockPos));
            BlockPos blockPosWorld = BlockPos.m_274561_((double)vPosWorld.x, (double)vPosWorld.y, (double)vPosWorld.z);
            return level.m_204166_(blockPosWorld);
        }
        return level.m_204166_(blockPos);
    }
}

